/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about the associated AppIntegrations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrationAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrationAssociationSummary.Builder, IntegrationAssociationSummary> {
    private static final SdkField<String> INTEGRATION_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationAssociationId").getter(getter(IntegrationAssociationSummary::integrationAssociationId))
            .setter(setter(Builder::integrationAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationAssociationId").build())
            .build();

    private static final SdkField<String> INTEGRATION_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationAssociationArn").getter(getter(IntegrationAssociationSummary::integrationAssociationArn))
            .setter(setter(Builder::integrationAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationAssociationArn").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(IntegrationAssociationSummary::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationType").getter(getter(IntegrationAssociationSummary::integrationTypeAsString))
            .setter(setter(Builder::integrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationType").build()).build();

    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationArn").getter(getter(IntegrationAssociationSummary::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()).build();

    private static final SdkField<String> SOURCE_APPLICATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceApplicationUrl").getter(getter(IntegrationAssociationSummary::sourceApplicationUrl))
            .setter(setter(Builder::sourceApplicationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceApplicationUrl").build())
            .build();

    private static final SdkField<String> SOURCE_APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceApplicationName").getter(getter(IntegrationAssociationSummary::sourceApplicationName))
            .setter(setter(Builder::sourceApplicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceApplicationName").build())
            .build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(IntegrationAssociationSummary::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTEGRATION_ASSOCIATION_ID_FIELD, INTEGRATION_ASSOCIATION_ARN_FIELD, INSTANCE_ID_FIELD, INTEGRATION_TYPE_FIELD,
            INTEGRATION_ARN_FIELD, SOURCE_APPLICATION_URL_FIELD, SOURCE_APPLICATION_NAME_FIELD, SOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String integrationAssociationId;

    private final String integrationAssociationArn;

    private final String instanceId;

    private final String integrationType;

    private final String integrationArn;

    private final String sourceApplicationUrl;

    private final String sourceApplicationName;

    private final String sourceType;

    private IntegrationAssociationSummary(BuilderImpl builder) {
        this.integrationAssociationId = builder.integrationAssociationId;
        this.integrationAssociationArn = builder.integrationAssociationArn;
        this.instanceId = builder.instanceId;
        this.integrationType = builder.integrationType;
        this.integrationArn = builder.integrationArn;
        this.sourceApplicationUrl = builder.sourceApplicationUrl;
        this.sourceApplicationName = builder.sourceApplicationName;
        this.sourceType = builder.sourceType;
    }

    /**
     * <p>
     * The identifier for the AppIntegration association.
     * </p>
     * 
     * @return The identifier for the AppIntegration association.
     */
    public final String integrationAssociationId() {
        return integrationAssociationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the AppIntegration association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the AppIntegration association.
     */
    public final String integrationAssociationArn() {
        return integrationAssociationArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The integration type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The integration type.
     * @see IntegrationType
     */
    public final IntegrationType integrationType() {
        return IntegrationType.fromValue(integrationType);
    }

    /**
     * <p>
     * The integration type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The integration type.
     * @see IntegrationType
     */
    public final String integrationTypeAsString() {
        return integrationType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the AppIntegration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the AppIntegration.
     */
    public final String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The URL for the external application.
     * </p>
     * 
     * @return The URL for the external application.
     */
    public final String sourceApplicationUrl() {
        return sourceApplicationUrl;
    }

    /**
     * <p>
     * The user-provided, friendly name for the external application.
     * </p>
     * 
     * @return The user-provided, friendly name for the external application.
     */
    public final String sourceApplicationName() {
        return sourceApplicationName;
    }

    /**
     * <p>
     * The name of the source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The name of the source.
     * @see SourceType
     */
    public final SourceType sourceType() {
        return SourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The name of the source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The name of the source.
     * @see SourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integrationAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceApplicationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceApplicationName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationAssociationSummary)) {
            return false;
        }
        IntegrationAssociationSummary other = (IntegrationAssociationSummary) obj;
        return Objects.equals(integrationAssociationId(), other.integrationAssociationId())
                && Objects.equals(integrationAssociationArn(), other.integrationAssociationArn())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(integrationTypeAsString(), other.integrationTypeAsString())
                && Objects.equals(integrationArn(), other.integrationArn())
                && Objects.equals(sourceApplicationUrl(), other.sourceApplicationUrl())
                && Objects.equals(sourceApplicationName(), other.sourceApplicationName())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrationAssociationSummary").add("IntegrationAssociationId", integrationAssociationId())
                .add("IntegrationAssociationArn", integrationAssociationArn()).add("InstanceId", instanceId())
                .add("IntegrationType", integrationTypeAsString()).add("IntegrationArn", integrationArn())
                .add("SourceApplicationUrl", sourceApplicationUrl()).add("SourceApplicationName", sourceApplicationName())
                .add("SourceType", sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationAssociationId":
            return Optional.ofNullable(clazz.cast(integrationAssociationId()));
        case "IntegrationAssociationArn":
            return Optional.ofNullable(clazz.cast(integrationAssociationArn()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "IntegrationType":
            return Optional.ofNullable(clazz.cast(integrationTypeAsString()));
        case "IntegrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "SourceApplicationUrl":
            return Optional.ofNullable(clazz.cast(sourceApplicationUrl()));
        case "SourceApplicationName":
            return Optional.ofNullable(clazz.cast(sourceApplicationName()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntegrationAssociationSummary, T> g) {
        return obj -> g.apply((IntegrationAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrationAssociationSummary> {
        /**
         * <p>
         * The identifier for the AppIntegration association.
         * </p>
         * 
         * @param integrationAssociationId
         *        The identifier for the AppIntegration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationAssociationId(String integrationAssociationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the AppIntegration association.
         * </p>
         * 
         * @param integrationAssociationArn
         *        The Amazon Resource Name (ARN) for the AppIntegration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationAssociationArn(String integrationAssociationArn);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The integration type.
         * </p>
         * 
         * @param integrationType
         *        The integration type.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(String integrationType);

        /**
         * <p>
         * The integration type.
         * </p>
         * 
         * @param integrationType
         *        The integration type.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(IntegrationType integrationType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the AppIntegration.
         * </p>
         * 
         * @param integrationArn
         *        The Amazon Resource Name (ARN) for the AppIntegration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The URL for the external application.
         * </p>
         * 
         * @param sourceApplicationUrl
         *        The URL for the external application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApplicationUrl(String sourceApplicationUrl);

        /**
         * <p>
         * The user-provided, friendly name for the external application.
         * </p>
         * 
         * @param sourceApplicationName
         *        The user-provided, friendly name for the external application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApplicationName(String sourceApplicationName);

        /**
         * <p>
         * The name of the source.
         * </p>
         * 
         * @param sourceType
         *        The name of the source.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The name of the source.
         * </p>
         * 
         * @param sourceType
         *        The name of the source.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(SourceType sourceType);
    }

    static final class BuilderImpl implements Builder {
        private String integrationAssociationId;

        private String integrationAssociationArn;

        private String instanceId;

        private String integrationType;

        private String integrationArn;

        private String sourceApplicationUrl;

        private String sourceApplicationName;

        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationAssociationSummary model) {
            integrationAssociationId(model.integrationAssociationId);
            integrationAssociationArn(model.integrationAssociationArn);
            instanceId(model.instanceId);
            integrationType(model.integrationType);
            integrationArn(model.integrationArn);
            sourceApplicationUrl(model.sourceApplicationUrl);
            sourceApplicationName(model.sourceApplicationName);
            sourceType(model.sourceType);
        }

        public final String getIntegrationAssociationId() {
            return integrationAssociationId;
        }

        @Override
        public final Builder integrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
            return this;
        }

        public final void setIntegrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
        }

        public final String getIntegrationAssociationArn() {
            return integrationAssociationArn;
        }

        @Override
        public final Builder integrationAssociationArn(String integrationAssociationArn) {
            this.integrationAssociationArn = integrationAssociationArn;
            return this;
        }

        public final void setIntegrationAssociationArn(String integrationAssociationArn) {
            this.integrationAssociationArn = integrationAssociationArn;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getIntegrationType() {
            return integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        public final String getSourceApplicationUrl() {
            return sourceApplicationUrl;
        }

        @Override
        public final Builder sourceApplicationUrl(String sourceApplicationUrl) {
            this.sourceApplicationUrl = sourceApplicationUrl;
            return this;
        }

        public final void setSourceApplicationUrl(String sourceApplicationUrl) {
            this.sourceApplicationUrl = sourceApplicationUrl;
        }

        public final String getSourceApplicationName() {
            return sourceApplicationName;
        }

        @Override
        public final Builder sourceApplicationName(String sourceApplicationName) {
            this.sourceApplicationName = sourceApplicationName;
            return this;
        }

        public final void setSourceApplicationName(String sourceApplicationName) {
            this.sourceApplicationName = sourceApplicationName;
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public IntegrationAssociationSummary build() {
            return new IntegrationAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
