/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information of an Amazon Lex bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LexBot implements SdkPojo, Serializable, ToCopyableBuilder<LexBot.Builder, LexBot> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(LexBot::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> LEX_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LexRegion").getter(getter(LexBot::lexRegion)).setter(setter(Builder::lexRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LEX_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String lexRegion;

    private LexBot(BuilderImpl builder) {
        this.name = builder.name;
        this.lexRegion = builder.lexRegion;
    }

    /**
     * <p>
     * The name of the Amazon Lex bot.
     * </p>
     * 
     * @return The name of the Amazon Lex bot.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Region that the Amazon Lex bot was created in.
     * </p>
     * 
     * @return The Region that the Amazon Lex bot was created in.
     */
    public final String lexRegion() {
        return lexRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lexRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexBot)) {
            return false;
        }
        LexBot other = (LexBot) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(lexRegion(), other.lexRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LexBot").add("Name", name()).add("LexRegion", lexRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LexRegion":
            return Optional.ofNullable(clazz.cast(lexRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LexBot, T> g) {
        return obj -> g.apply((LexBot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LexBot> {
        /**
         * <p>
         * The name of the Amazon Lex bot.
         * </p>
         * 
         * @param name
         *        The name of the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Region that the Amazon Lex bot was created in.
         * </p>
         * 
         * @param lexRegion
         *        The Region that the Amazon Lex bot was created in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexRegion(String lexRegion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String lexRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(LexBot model) {
            name(model.name);
            lexRegion(model.lexRegion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLexRegion() {
            return lexRegion;
        }

        @Override
        public final Builder lexRegion(String lexRegion) {
            this.lexRegion = lexRegion;
            return this;
        }

        public final void setLexRegion(String lexRegion) {
            this.lexRegion = lexRegion;
        }

        @Override
        public LexBot build() {
            return new LexBot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
