/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRoutingProfileQueuesRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateRoutingProfileQueuesRequest.Builder, UpdateRoutingProfileQueuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateRoutingProfileQueuesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingProfileId").getter(getter(UpdateRoutingProfileQueuesRequest::routingProfileId))
            .setter(setter(Builder::routingProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RoutingProfileId").build()).build();

    private static final SdkField<List<RoutingProfileQueueConfig>> QUEUE_CONFIGS_FIELD = SdkField
            .<List<RoutingProfileQueueConfig>> builder(MarshallingType.LIST)
            .memberName("QueueConfigs")
            .getter(getter(UpdateRoutingProfileQueuesRequest::queueConfigs))
            .setter(setter(Builder::queueConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutingProfileQueueConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutingProfileQueueConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            ROUTING_PROFILE_ID_FIELD, QUEUE_CONFIGS_FIELD));

    private final String instanceId;

    private final String routingProfileId;

    private final List<RoutingProfileQueueConfig> queueConfigs;

    private UpdateRoutingProfileQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.routingProfileId = builder.routingProfileId;
        this.queueConfigs = builder.queueConfigs;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the routing profile.
     * </p>
     * 
     * @return The identifier of the routing profile.
     */
    public final String routingProfileId() {
        return routingProfileId;
    }

    /**
     * Returns true if the QueueConfigs property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasQueueConfigs() {
        return queueConfigs != null && !(queueConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The queues to be updated for this routing profile. Queues must first be associated to the routing profile. You
     * can do this using AssociateRoutingProfileQueues.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueueConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The queues to be updated for this routing profile. Queues must first be associated to the routing
     *         profile. You can do this using AssociateRoutingProfileQueues.
     */
    public final List<RoutingProfileQueueConfig> queueConfigs() {
        return queueConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueueConfigs() ? queueConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingProfileQueuesRequest)) {
            return false;
        }
        UpdateRoutingProfileQueuesRequest other = (UpdateRoutingProfileQueuesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(routingProfileId(), other.routingProfileId())
                && hasQueueConfigs() == other.hasQueueConfigs() && Objects.equals(queueConfigs(), other.queueConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRoutingProfileQueuesRequest").add("InstanceId", instanceId())
                .add("RoutingProfileId", routingProfileId()).add("QueueConfigs", hasQueueConfigs() ? queueConfigs() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "RoutingProfileId":
            return Optional.ofNullable(clazz.cast(routingProfileId()));
        case "QueueConfigs":
            return Optional.ofNullable(clazz.cast(queueConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingProfileQueuesRequest, T> g) {
        return obj -> g.apply((UpdateRoutingProfileQueuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRoutingProfileQueuesRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the routing profile.
         * </p>
         * 
         * @param routingProfileId
         *        The identifier of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileId(String routingProfileId);

        /**
         * <p>
         * The queues to be updated for this routing profile. Queues must first be associated to the routing profile.
         * You can do this using AssociateRoutingProfileQueues.
         * </p>
         * 
         * @param queueConfigs
         *        The queues to be updated for this routing profile. Queues must first be associated to the routing
         *        profile. You can do this using AssociateRoutingProfileQueues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfigs(Collection<RoutingProfileQueueConfig> queueConfigs);

        /**
         * <p>
         * The queues to be updated for this routing profile. Queues must first be associated to the routing profile.
         * You can do this using AssociateRoutingProfileQueues.
         * </p>
         * 
         * @param queueConfigs
         *        The queues to be updated for this routing profile. Queues must first be associated to the routing
         *        profile. You can do this using AssociateRoutingProfileQueues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfigs(RoutingProfileQueueConfig... queueConfigs);

        /**
         * <p>
         * The queues to be updated for this routing profile. Queues must first be associated to the routing profile.
         * You can do this using AssociateRoutingProfileQueues.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RoutingProfileQueueConfig>.Builder}
         * avoiding the need to create one manually via {@link List<RoutingProfileQueueConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RoutingProfileQueueConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #queueConfigs(List<RoutingProfileQueueConfig>)}.
         * 
         * @param queueConfigs
         *        a consumer that will call methods on {@link List<RoutingProfileQueueConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueConfigs(List<RoutingProfileQueueConfig>)
         */
        Builder queueConfigs(Consumer<RoutingProfileQueueConfig.Builder>... queueConfigs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String routingProfileId;

        private List<RoutingProfileQueueConfig> queueConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingProfileQueuesRequest model) {
            super(model);
            instanceId(model.instanceId);
            routingProfileId(model.routingProfileId);
            queueConfigs(model.queueConfigs);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getRoutingProfileId() {
            return routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        public final List<RoutingProfileQueueConfig.Builder> getQueueConfigs() {
            List<RoutingProfileQueueConfig.Builder> result = RoutingProfileQueueConfigListCopier.copyToBuilder(this.queueConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder queueConfigs(Collection<RoutingProfileQueueConfig> queueConfigs) {
            this.queueConfigs = RoutingProfileQueueConfigListCopier.copy(queueConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigs(RoutingProfileQueueConfig... queueConfigs) {
            queueConfigs(Arrays.asList(queueConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigs(Consumer<RoutingProfileQueueConfig.Builder>... queueConfigs) {
            queueConfigs(Stream.of(queueConfigs).map(c -> RoutingProfileQueueConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setQueueConfigs(Collection<RoutingProfileQueueConfig.BuilderImpl> queueConfigs) {
            this.queueConfigs = RoutingProfileQueueConfigListCopier.copyFromBuilder(queueConfigs);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoutingProfileQueuesRequest build() {
            return new UpdateRoutingProfileQueuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
