/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSecurityProfileResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateSecurityProfileResponse.Builder, CreateSecurityProfileResponse> {
    private static final SdkField<String> SECURITY_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityProfileId").getter(getter(CreateSecurityProfileResponse::securityProfileId))
            .setter(setter(Builder::securityProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileId").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityProfileArn").getter(getter(CreateSecurityProfileResponse::securityProfileArn))
            .setter(setter(Builder::securityProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_ID_FIELD,
            SECURITY_PROFILE_ARN_FIELD));

    private final String securityProfileId;

    private final String securityProfileArn;

    private CreateSecurityProfileResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileId = builder.securityProfileId;
        this.securityProfileArn = builder.securityProfileArn;
    }

    /**
     * <p>
     * The identifier for the security profle.
     * </p>
     * 
     * @return The identifier for the security profle.
     */
    public final String securityProfileId() {
        return securityProfileId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the security profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the security profile.
     */
    public final String securityProfileArn() {
        return securityProfileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityProfileResponse)) {
            return false;
        }
        CreateSecurityProfileResponse other = (CreateSecurityProfileResponse) obj;
        return Objects.equals(securityProfileId(), other.securityProfileId())
                && Objects.equals(securityProfileArn(), other.securityProfileArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSecurityProfileResponse").add("SecurityProfileId", securityProfileId())
                .add("SecurityProfileArn", securityProfileArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityProfileId":
            return Optional.ofNullable(clazz.cast(securityProfileId()));
        case "SecurityProfileArn":
            return Optional.ofNullable(clazz.cast(securityProfileArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSecurityProfileResponse, T> g) {
        return obj -> g.apply((CreateSecurityProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSecurityProfileResponse> {
        /**
         * <p>
         * The identifier for the security profle.
         * </p>
         * 
         * @param securityProfileId
         *        The identifier for the security profle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileId(String securityProfileId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the security profile.
         * </p>
         * 
         * @param securityProfileArn
         *        The Amazon Resource Name (ARN) for the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileArn(String securityProfileArn);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String securityProfileId;

        private String securityProfileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityProfileResponse model) {
            super(model);
            securityProfileId(model.securityProfileId);
            securityProfileArn(model.securityProfileArn);
        }

        public final String getSecurityProfileId() {
            return securityProfileId;
        }

        public final void setSecurityProfileId(String securityProfileId) {
            this.securityProfileId = securityProfileId;
        }

        @Override
        @Transient
        public final Builder securityProfileId(String securityProfileId) {
            this.securityProfileId = securityProfileId;
            return this;
        }

        public final String getSecurityProfileArn() {
            return securityProfileArn;
        }

        public final void setSecurityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
        }

        @Override
        @Transient
        public final Builder securityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
            return this;
        }

        @Override
        public CreateSecurityProfileResponse build() {
            return new CreateSecurityProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
