/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactReferencesRequest extends ConnectRequest implements
        ToCopyableBuilder<ListContactReferencesRequest.Builder, ListContactReferencesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ListContactReferencesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(ListContactReferencesRequest::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactId").build()).build();

    private static final SdkField<List<String>> REFERENCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReferenceTypes")
            .getter(getter(ListContactReferencesRequest::referenceTypesAsStrings))
            .setter(setter(Builder::referenceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("referenceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContactReferencesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_ID_FIELD, REFERENCE_TYPES_FIELD, NEXT_TOKEN_FIELD));

    private final String instanceId;

    private final String contactId;

    private final List<String> referenceTypes;

    private final String nextToken;

    private ListContactReferencesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.referenceTypes = builder.referenceTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the initial contact.
     * </p>
     * 
     * @return The identifier of the initial contact.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The type of reference.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceTypes} method.
     * </p>
     * 
     * @return The type of reference.
     */
    public final List<ReferenceType> referenceTypes() {
        return ReferenceTypesCopier.copyStringToEnum(referenceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceTypes() {
        return referenceTypes != null && !(referenceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of reference.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceTypes} method.
     * </p>
     * 
     * @return The type of reference.
     */
    public final List<String> referenceTypesAsStrings() {
        return referenceTypes;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * <important>
     * <p>
     * This is not expected to be set, because the value returned in the previous response is always null.
     * </p>
     * </important>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.</p> <important>
     *         <p>
     *         This is not expected to be set, because the value returned in the previous response is always null.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceTypes() ? referenceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactReferencesRequest)) {
            return false;
        }
        ListContactReferencesRequest other = (ListContactReferencesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(contactId(), other.contactId())
                && hasReferenceTypes() == other.hasReferenceTypes()
                && Objects.equals(referenceTypesAsStrings(), other.referenceTypesAsStrings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactReferencesRequest").add("InstanceId", instanceId()).add("ContactId", contactId())
                .add("ReferenceTypes", hasReferenceTypes() ? referenceTypesAsStrings() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "ReferenceTypes":
            return Optional.ofNullable(clazz.cast(referenceTypesAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactReferencesRequest, T> g) {
        return obj -> g.apply((ListContactReferencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListContactReferencesRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the initial contact.
         * </p>
         * 
         * @param contactId
         *        The identifier of the initial contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The type of reference.
         * </p>
         * 
         * @param referenceTypes
         *        The type of reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceTypesWithStrings(Collection<String> referenceTypes);

        /**
         * <p>
         * The type of reference.
         * </p>
         * 
         * @param referenceTypes
         *        The type of reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceTypesWithStrings(String... referenceTypes);

        /**
         * <p>
         * The type of reference.
         * </p>
         * 
         * @param referenceTypes
         *        The type of reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceTypes(Collection<ReferenceType> referenceTypes);

        /**
         * <p>
         * The type of reference.
         * </p>
         * 
         * @param referenceTypes
         *        The type of reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceTypes(ReferenceType... referenceTypes);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * <important>
         * <p>
         * This is not expected to be set, because the value returned in the previous response is always null.
         * </p>
         * </important>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.</p> <important>
         *        <p>
         *        This is not expected to be set, because the value returned in the previous response is always null.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactId;

        private List<String> referenceTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactReferencesRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactId(model.contactId);
            referenceTypesWithStrings(model.referenceTypes);
            nextToken(model.nextToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        @Transient
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final Collection<String> getReferenceTypes() {
            if (referenceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return referenceTypes;
        }

        public final void setReferenceTypes(Collection<String> referenceTypes) {
            this.referenceTypes = ReferenceTypesCopier.copy(referenceTypes);
        }

        @Override
        @Transient
        public final Builder referenceTypesWithStrings(Collection<String> referenceTypes) {
            this.referenceTypes = ReferenceTypesCopier.copy(referenceTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder referenceTypesWithStrings(String... referenceTypes) {
            referenceTypesWithStrings(Arrays.asList(referenceTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder referenceTypes(Collection<ReferenceType> referenceTypes) {
            this.referenceTypes = ReferenceTypesCopier.copyEnumToString(referenceTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder referenceTypes(ReferenceType... referenceTypes) {
            referenceTypes(Arrays.asList(referenceTypes));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContactReferencesRequest build() {
            return new ListContactReferencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
