/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPromptsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListPromptsResponse.Builder, ListPromptsResponse> {
    private static final SdkField<List<PromptSummary>> PROMPT_SUMMARY_LIST_FIELD = SdkField
            .<List<PromptSummary>> builder(MarshallingType.LIST)
            .memberName("PromptSummaryList")
            .getter(getter(ListPromptsResponse::promptSummaryList))
            .setter(setter(Builder::promptSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPromptsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PromptSummary> promptSummaryList;

    private final String nextToken;

    private ListPromptsResponse(BuilderImpl builder) {
        super(builder);
        this.promptSummaryList = builder.promptSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PromptSummaryList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPromptSummaryList() {
        return promptSummaryList != null && !(promptSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the prompts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPromptSummaryList} method.
     * </p>
     * 
     * @return Information about the prompts.
     */
    public final List<PromptSummary> promptSummaryList() {
        return promptSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPromptSummaryList() ? promptSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPromptsResponse)) {
            return false;
        }
        ListPromptsResponse other = (ListPromptsResponse) obj;
        return hasPromptSummaryList() == other.hasPromptSummaryList()
                && Objects.equals(promptSummaryList(), other.promptSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPromptsResponse")
                .add("PromptSummaryList", hasPromptSummaryList() ? promptSummaryList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PromptSummaryList":
            return Optional.ofNullable(clazz.cast(promptSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPromptsResponse, T> g) {
        return obj -> g.apply((ListPromptsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPromptsResponse> {
        /**
         * <p>
         * Information about the prompts.
         * </p>
         * 
         * @param promptSummaryList
         *        Information about the prompts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptSummaryList(Collection<PromptSummary> promptSummaryList);

        /**
         * <p>
         * Information about the prompts.
         * </p>
         * 
         * @param promptSummaryList
         *        Information about the prompts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptSummaryList(PromptSummary... promptSummaryList);

        /**
         * <p>
         * Information about the prompts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PromptSummary>.Builder} avoiding the need
         * to create one manually via {@link List<PromptSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PromptSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #promptSummaryList(List<PromptSummary>)}.
         * 
         * @param promptSummaryList
         *        a consumer that will call methods on {@link List<PromptSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptSummaryList(List<PromptSummary>)
         */
        Builder promptSummaryList(Consumer<PromptSummary.Builder>... promptSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<PromptSummary> promptSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPromptsResponse model) {
            super(model);
            promptSummaryList(model.promptSummaryList);
            nextToken(model.nextToken);
        }

        public final List<PromptSummary.Builder> getPromptSummaryList() {
            List<PromptSummary.Builder> result = PromptSummaryListCopier.copyToBuilder(this.promptSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPromptSummaryList(Collection<PromptSummary.BuilderImpl> promptSummaryList) {
            this.promptSummaryList = PromptSummaryListCopier.copyFromBuilder(promptSummaryList);
        }

        @Override
        @Transient
        public final Builder promptSummaryList(Collection<PromptSummary> promptSummaryList) {
            this.promptSummaryList = PromptSummaryListCopier.copy(promptSummaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder promptSummaryList(PromptSummary... promptSummaryList) {
            promptSummaryList(Arrays.asList(promptSummaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder promptSummaryList(Consumer<PromptSummary.Builder>... promptSummaryList) {
            promptSummaryList(Stream.of(promptSummaryList).map(c -> PromptSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPromptsResponse build() {
            return new ListPromptsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
