/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueueInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueueInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(QueueInfo.getter(QueueInfo::id)).setter(QueueInfo.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> ENQUEUE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EnqueueTimestamp").getter(QueueInfo.getter(QueueInfo::enqueueTimestamp)).setter(QueueInfo.setter(Builder::enqueueTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnqueueTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ENQUEUE_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Instant enqueueTimestamp;

    private QueueInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.enqueueTimestamp = builder.enqueueTimestamp;
    }

    public final String id() {
        return this.id;
    }

    public final Instant enqueueTimestamp() {
        return this.enqueueTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.enqueueTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueInfo)) {
            return false;
        }
        QueueInfo other = (QueueInfo)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.enqueueTimestamp(), other.enqueueTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"QueueInfo").add("Id", (Object)this.id()).add("EnqueueTimestamp", (Object)this.enqueueTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "EnqueueTimestamp": {
                return Optional.ofNullable(clazz.cast(this.enqueueTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueInfo, T> g) {
        return obj -> g.apply((QueueInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Instant enqueueTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueInfo model) {
            this.id(model.id);
            this.enqueueTimestamp(model.enqueueTimestamp);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getEnqueueTimestamp() {
            return this.enqueueTimestamp;
        }

        public final void setEnqueueTimestamp(Instant enqueueTimestamp) {
            this.enqueueTimestamp = enqueueTimestamp;
        }

        @Override
        @Transient
        public final Builder enqueueTimestamp(Instant enqueueTimestamp) {
            this.enqueueTimestamp = enqueueTimestamp;
            return this;
        }

        public QueueInfo build() {
            return new QueueInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueueInfo> {
        public Builder id(String var1);

        public Builder enqueueTimestamp(Instant var1);
    }
}

