/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AttachmentReference;
import software.amazon.awssdk.services.connect.model.UrlReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceSummary> {
    private static final SdkField<UrlReference> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Url").getter(ReferenceSummary.getter(ReferenceSummary::url)).setter(ReferenceSummary.setter(Builder::url)).constructor(UrlReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<AttachmentReference> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(ReferenceSummary.getter(ReferenceSummary::attachment)).setter(ReferenceSummary.setter(Builder::attachment)).constructor(AttachmentReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, ATTACHMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final UrlReference url;
    private final AttachmentReference attachment;

    private ReferenceSummary(BuilderImpl builder) {
        this.url = builder.url;
        this.attachment = builder.attachment;
    }

    public final UrlReference url() {
        return this.url;
    }

    public final AttachmentReference attachment() {
        return this.attachment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceSummary)) {
            return false;
        }
        ReferenceSummary other = (ReferenceSummary)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.attachment(), other.attachment());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceSummary").add("Url", (Object)this.url()).add("Attachment", (Object)this.attachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceSummary, T> g) {
        return obj -> g.apply((ReferenceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UrlReference url;
        private AttachmentReference attachment;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceSummary model) {
            this.url(model.url);
            this.attachment(model.attachment);
        }

        public final UrlReference.Builder getUrl() {
            return this.url != null ? this.url.toBuilder() : null;
        }

        public final void setUrl(UrlReference.BuilderImpl url) {
            this.url = url != null ? url.build() : null;
        }

        @Override
        @Transient
        public final Builder url(UrlReference url) {
            this.url = url;
            return this;
        }

        public final AttachmentReference.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(AttachmentReference.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        @Transient
        public final Builder attachment(AttachmentReference attachment) {
            this.attachment = attachment;
            return this;
        }

        public ReferenceSummary build() {
            return new ReferenceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceSummary> {
        public Builder url(UrlReference var1);

        default public Builder url(Consumer<UrlReference.Builder> url) {
            return this.url((UrlReference)((UrlReference.Builder)UrlReference.builder().applyMutation(url)).build());
        }

        public Builder attachment(AttachmentReference var1);

        default public Builder attachment(Consumer<AttachmentReference.Builder> attachment) {
            return this.attachment((AttachmentReference)((AttachmentReference.Builder)AttachmentReference.builder().applyMutation(attachment)).build());
        }
    }
}

