/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactFlowModulesRequest extends ConnectRequest implements
        ToCopyableBuilder<ListContactFlowModulesRequest.Builder, ListContactFlowModulesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ListContactFlowModulesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContactFlowModulesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListContactFlowModulesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> CONTACT_FLOW_MODULE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowModuleState").getter(getter(ListContactFlowModulesRequest::contactFlowModuleStateAsString))
            .setter(setter(Builder::contactFlowModuleState))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CONTACT_FLOW_MODULE_STATE_FIELD));

    private final String instanceId;

    private final String nextToken;

    private final Integer maxResults;

    private final String contactFlowModuleState;

    private ListContactFlowModulesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.contactFlowModuleState = builder.contactFlowModuleState;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The state of the contact flow module.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contactFlowModuleState} will return {@link ContactFlowModuleState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contactFlowModuleStateAsString}.
     * </p>
     * 
     * @return The state of the contact flow module.
     * @see ContactFlowModuleState
     */
    public final ContactFlowModuleState contactFlowModuleState() {
        return ContactFlowModuleState.fromValue(contactFlowModuleState);
    }

    /**
     * <p>
     * The state of the contact flow module.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contactFlowModuleState} will return {@link ContactFlowModuleState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contactFlowModuleStateAsString}.
     * </p>
     * 
     * @return The state of the contact flow module.
     * @see ContactFlowModuleState
     */
    public final String contactFlowModuleStateAsString() {
        return contactFlowModuleState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactFlowModulesRequest)) {
            return false;
        }
        ListContactFlowModulesRequest other = (ListContactFlowModulesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(contactFlowModuleStateAsString(), other.contactFlowModuleStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactFlowModulesRequest").add("InstanceId", instanceId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("ContactFlowModuleState", contactFlowModuleStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ContactFlowModuleState":
            return Optional.ofNullable(clazz.cast(contactFlowModuleStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactFlowModulesRequest, T> g) {
        return obj -> g.apply((ListContactFlowModulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListContactFlowModulesRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The state of the contact flow module.
         * </p>
         * 
         * @param contactFlowModuleState
         *        The state of the contact flow module.
         * @see ContactFlowModuleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowModuleState
         */
        Builder contactFlowModuleState(String contactFlowModuleState);

        /**
         * <p>
         * The state of the contact flow module.
         * </p>
         * 
         * @param contactFlowModuleState
         *        The state of the contact flow module.
         * @see ContactFlowModuleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowModuleState
         */
        Builder contactFlowModuleState(ContactFlowModuleState contactFlowModuleState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String nextToken;

        private Integer maxResults;

        private String contactFlowModuleState;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactFlowModulesRequest model) {
            super(model);
            instanceId(model.instanceId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            contactFlowModuleState(model.contactFlowModuleState);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getContactFlowModuleState() {
            return contactFlowModuleState;
        }

        public final void setContactFlowModuleState(String contactFlowModuleState) {
            this.contactFlowModuleState = contactFlowModuleState;
        }

        @Override
        public final Builder contactFlowModuleState(String contactFlowModuleState) {
            this.contactFlowModuleState = contactFlowModuleState;
            return this;
        }

        @Override
        public final Builder contactFlowModuleState(ContactFlowModuleState contactFlowModuleState) {
            this.contactFlowModuleState(contactFlowModuleState == null ? null : contactFlowModuleState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContactFlowModulesRequest build() {
            return new ListContactFlowModulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
