/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration settings for a quick connect.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuickConnectConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<QuickConnectConfig.Builder, QuickConnectConfig> {
    private static final SdkField<String> QUICK_CONNECT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuickConnectType").getter(getter(QuickConnectConfig::quickConnectTypeAsString))
            .setter(setter(Builder::quickConnectType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectType").build()).build();

    private static final SdkField<UserQuickConnectConfig> USER_CONFIG_FIELD = SdkField
            .<UserQuickConnectConfig> builder(MarshallingType.SDK_POJO).memberName("UserConfig")
            .getter(getter(QuickConnectConfig::userConfig)).setter(setter(Builder::userConfig))
            .constructor(UserQuickConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserConfig").build()).build();

    private static final SdkField<QueueQuickConnectConfig> QUEUE_CONFIG_FIELD = SdkField
            .<QueueQuickConnectConfig> builder(MarshallingType.SDK_POJO).memberName("QueueConfig")
            .getter(getter(QuickConnectConfig::queueConfig)).setter(setter(Builder::queueConfig))
            .constructor(QueueQuickConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueConfig").build()).build();

    private static final SdkField<PhoneNumberQuickConnectConfig> PHONE_CONFIG_FIELD = SdkField
            .<PhoneNumberQuickConnectConfig> builder(MarshallingType.SDK_POJO).memberName("PhoneConfig")
            .getter(getter(QuickConnectConfig::phoneConfig)).setter(setter(Builder::phoneConfig))
            .constructor(PhoneNumberQuickConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUICK_CONNECT_TYPE_FIELD,
            USER_CONFIG_FIELD, QUEUE_CONFIG_FIELD, PHONE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String quickConnectType;

    private final UserQuickConnectConfig userConfig;

    private final QueueQuickConnectConfig queueConfig;

    private final PhoneNumberQuickConnectConfig phoneConfig;

    private QuickConnectConfig(BuilderImpl builder) {
        this.quickConnectType = builder.quickConnectType;
        this.userConfig = builder.userConfig;
        this.queueConfig = builder.queueConfig;
        this.phoneConfig = builder.phoneConfig;
    }

    /**
     * <p>
     * The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to
     * assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #quickConnectType}
     * will return {@link QuickConnectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #quickConnectTypeAsString}.
     * </p>
     * 
     * @return The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
     *         prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
     * @see QuickConnectType
     */
    public final QuickConnectType quickConnectType() {
        return QuickConnectType.fromValue(quickConnectType);
    }

    /**
     * <p>
     * The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to
     * assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #quickConnectType}
     * will return {@link QuickConnectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #quickConnectTypeAsString}.
     * </p>
     * 
     * @return The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
     *         prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
     * @see QuickConnectType
     */
    public final String quickConnectTypeAsString() {
        return quickConnectType;
    }

    /**
     * <p>
     * The user configuration. This is required only if QuickConnectType is USER.
     * </p>
     * 
     * @return The user configuration. This is required only if QuickConnectType is USER.
     */
    public final UserQuickConnectConfig userConfig() {
        return userConfig;
    }

    /**
     * <p>
     * The queue configuration. This is required only if QuickConnectType is QUEUE.
     * </p>
     * 
     * @return The queue configuration. This is required only if QuickConnectType is QUEUE.
     */
    public final QueueQuickConnectConfig queueConfig() {
        return queueConfig;
    }

    /**
     * <p>
     * The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
     * </p>
     * 
     * @return The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
     */
    public final PhoneNumberQuickConnectConfig phoneConfig() {
        return phoneConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quickConnectTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userConfig());
        hashCode = 31 * hashCode + Objects.hashCode(queueConfig());
        hashCode = 31 * hashCode + Objects.hashCode(phoneConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickConnectConfig)) {
            return false;
        }
        QuickConnectConfig other = (QuickConnectConfig) obj;
        return Objects.equals(quickConnectTypeAsString(), other.quickConnectTypeAsString())
                && Objects.equals(userConfig(), other.userConfig()) && Objects.equals(queueConfig(), other.queueConfig())
                && Objects.equals(phoneConfig(), other.phoneConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuickConnectConfig").add("QuickConnectType", quickConnectTypeAsString())
                .add("UserConfig", userConfig()).add("QueueConfig", queueConfig()).add("PhoneConfig", phoneConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuickConnectType":
            return Optional.ofNullable(clazz.cast(quickConnectTypeAsString()));
        case "UserConfig":
            return Optional.ofNullable(clazz.cast(userConfig()));
        case "QueueConfig":
            return Optional.ofNullable(clazz.cast(queueConfig()));
        case "PhoneConfig":
            return Optional.ofNullable(clazz.cast(phoneConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuickConnectConfig, T> g) {
        return obj -> g.apply((QuickConnectConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuickConnectConfig> {
        /**
         * <p>
         * The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted
         * to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
         * </p>
         * 
         * @param quickConnectType
         *        The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
         *        prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue
         *        (QUEUE).
         * @see QuickConnectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuickConnectType
         */
        Builder quickConnectType(String quickConnectType);

        /**
         * <p>
         * The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted
         * to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
         * </p>
         * 
         * @param quickConnectType
         *        The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
         *        prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue
         *        (QUEUE).
         * @see QuickConnectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuickConnectType
         */
        Builder quickConnectType(QuickConnectType quickConnectType);

        /**
         * <p>
         * The user configuration. This is required only if QuickConnectType is USER.
         * </p>
         * 
         * @param userConfig
         *        The user configuration. This is required only if QuickConnectType is USER.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userConfig(UserQuickConnectConfig userConfig);

        /**
         * <p>
         * The user configuration. This is required only if QuickConnectType is USER.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserQuickConnectConfig.Builder} avoiding
         * the need to create one manually via {@link UserQuickConnectConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserQuickConnectConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #userConfig(UserQuickConnectConfig)}.
         * 
         * @param userConfig
         *        a consumer that will call methods on {@link UserQuickConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userConfig(UserQuickConnectConfig)
         */
        default Builder userConfig(Consumer<UserQuickConnectConfig.Builder> userConfig) {
            return userConfig(UserQuickConnectConfig.builder().applyMutation(userConfig).build());
        }

        /**
         * <p>
         * The queue configuration. This is required only if QuickConnectType is QUEUE.
         * </p>
         * 
         * @param queueConfig
         *        The queue configuration. This is required only if QuickConnectType is QUEUE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfig(QueueQuickConnectConfig queueConfig);

        /**
         * <p>
         * The queue configuration. This is required only if QuickConnectType is QUEUE.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueueQuickConnectConfig.Builder} avoiding
         * the need to create one manually via {@link QueueQuickConnectConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueueQuickConnectConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #queueConfig(QueueQuickConnectConfig)}.
         * 
         * @param queueConfig
         *        a consumer that will call methods on {@link QueueQuickConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueConfig(QueueQuickConnectConfig)
         */
        default Builder queueConfig(Consumer<QueueQuickConnectConfig.Builder> queueConfig) {
            return queueConfig(QueueQuickConnectConfig.builder().applyMutation(queueConfig).build());
        }

        /**
         * <p>
         * The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
         * </p>
         * 
         * @param phoneConfig
         *        The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneConfig(PhoneNumberQuickConnectConfig phoneConfig);

        /**
         * <p>
         * The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhoneNumberQuickConnectConfig.Builder}
         * avoiding the need to create one manually via {@link PhoneNumberQuickConnectConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PhoneNumberQuickConnectConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #phoneConfig(PhoneNumberQuickConnectConfig)}.
         * 
         * @param phoneConfig
         *        a consumer that will call methods on {@link PhoneNumberQuickConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneConfig(PhoneNumberQuickConnectConfig)
         */
        default Builder phoneConfig(Consumer<PhoneNumberQuickConnectConfig.Builder> phoneConfig) {
            return phoneConfig(PhoneNumberQuickConnectConfig.builder().applyMutation(phoneConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String quickConnectType;

        private UserQuickConnectConfig userConfig;

        private QueueQuickConnectConfig queueConfig;

        private PhoneNumberQuickConnectConfig phoneConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(QuickConnectConfig model) {
            quickConnectType(model.quickConnectType);
            userConfig(model.userConfig);
            queueConfig(model.queueConfig);
            phoneConfig(model.phoneConfig);
        }

        public final String getQuickConnectType() {
            return quickConnectType;
        }

        public final void setQuickConnectType(String quickConnectType) {
            this.quickConnectType = quickConnectType;
        }

        @Override
        public final Builder quickConnectType(String quickConnectType) {
            this.quickConnectType = quickConnectType;
            return this;
        }

        @Override
        public final Builder quickConnectType(QuickConnectType quickConnectType) {
            this.quickConnectType(quickConnectType == null ? null : quickConnectType.toString());
            return this;
        }

        public final UserQuickConnectConfig.Builder getUserConfig() {
            return userConfig != null ? userConfig.toBuilder() : null;
        }

        public final void setUserConfig(UserQuickConnectConfig.BuilderImpl userConfig) {
            this.userConfig = userConfig != null ? userConfig.build() : null;
        }

        @Override
        public final Builder userConfig(UserQuickConnectConfig userConfig) {
            this.userConfig = userConfig;
            return this;
        }

        public final QueueQuickConnectConfig.Builder getQueueConfig() {
            return queueConfig != null ? queueConfig.toBuilder() : null;
        }

        public final void setQueueConfig(QueueQuickConnectConfig.BuilderImpl queueConfig) {
            this.queueConfig = queueConfig != null ? queueConfig.build() : null;
        }

        @Override
        public final Builder queueConfig(QueueQuickConnectConfig queueConfig) {
            this.queueConfig = queueConfig;
            return this;
        }

        public final PhoneNumberQuickConnectConfig.Builder getPhoneConfig() {
            return phoneConfig != null ? phoneConfig.toBuilder() : null;
        }

        public final void setPhoneConfig(PhoneNumberQuickConnectConfig.BuilderImpl phoneConfig) {
            this.phoneConfig = phoneConfig != null ? phoneConfig.build() : null;
        }

        @Override
        public final Builder phoneConfig(PhoneNumberQuickConnectConfig phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        @Override
        public QuickConnectConfig build() {
            return new QuickConnectConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
