/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a reference. <code>ReferenceSummary</code> contains only one non null field
 * between the URL and attachment based on the reference type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceSummary.Builder, ReferenceSummary> {
    private static final SdkField<UrlReference> URL_FIELD = SdkField.<UrlReference> builder(MarshallingType.SDK_POJO)
            .memberName("Url").getter(getter(ReferenceSummary::url)).setter(setter(Builder::url))
            .constructor(UrlReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<AttachmentReference> ATTACHMENT_FIELD = SdkField
            .<AttachmentReference> builder(MarshallingType.SDK_POJO).memberName("Attachment")
            .getter(getter(ReferenceSummary::attachment)).setter(setter(Builder::attachment))
            .constructor(AttachmentReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, ATTACHMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final UrlReference url;

    private final AttachmentReference attachment;

    private final Type type;

    private ReferenceSummary(BuilderImpl builder) {
        this.url = builder.url;
        this.attachment = builder.attachment;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about the URL reference if the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
     * </p>
     * 
     * @return Information about the URL reference if the <code>referenceType</code> is <code>URL</code>. Otherwise,
     *         null.
     */
    public final UrlReference url() {
        return url;
    }

    /**
     * <p>
     * Information about the attachment reference if the <code>referenceType</code> is <code>ATTACHMENT</code>.
     * Otherwise, null.
     * </p>
     * 
     * @return Information about the attachment reference if the <code>referenceType</code> is <code>ATTACHMENT</code>.
     *         Otherwise, null.
     */
    public final AttachmentReference attachment() {
        return attachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceSummary)) {
            return false;
        }
        ReferenceSummary other = (ReferenceSummary) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(attachment(), other.attachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceSummary").add("Url", url()).add("Attachment", attachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #url()} initialized to the given value.
     *
     * <p>
     * Information about the URL reference if the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
     * </p>
     * 
     * @param url
     *        Information about the URL reference if the <code>referenceType</code> is <code>URL</code>. Otherwise,
     *        null.
     */
    public static ReferenceSummary fromUrl(UrlReference url) {
        return builder().url(url).build();
    }

    /**
     * Create an instance of this class with {@link #url()} initialized to the given value.
     *
     * <p>
     * Information about the URL reference if the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
     * </p>
     * 
     * @param url
     *        Information about the URL reference if the <code>referenceType</code> is <code>URL</code>. Otherwise,
     *        null.
     */
    public static ReferenceSummary fromUrl(Consumer<UrlReference.Builder> url) {
        UrlReference.Builder builder = UrlReference.builder();
        url.accept(builder);
        return fromUrl(builder.build());
    }

    /**
     * Create an instance of this class with {@link #attachment()} initialized to the given value.
     *
     * <p>
     * Information about the attachment reference if the <code>referenceType</code> is <code>ATTACHMENT</code>.
     * Otherwise, null.
     * </p>
     * 
     * @param attachment
     *        Information about the attachment reference if the <code>referenceType</code> is <code>ATTACHMENT</code>.
     *        Otherwise, null.
     */
    public static ReferenceSummary fromAttachment(AttachmentReference attachment) {
        return builder().attachment(attachment).build();
    }

    /**
     * Create an instance of this class with {@link #attachment()} initialized to the given value.
     *
     * <p>
     * Information about the attachment reference if the <code>referenceType</code> is <code>ATTACHMENT</code>.
     * Otherwise, null.
     * </p>
     * 
     * @param attachment
     *        Information about the attachment reference if the <code>referenceType</code> is <code>ATTACHMENT</code>.
     *        Otherwise, null.
     */
    public static ReferenceSummary fromAttachment(Consumer<AttachmentReference.Builder> attachment) {
        AttachmentReference.Builder builder = AttachmentReference.builder();
        attachment.accept(builder);
        return fromAttachment(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceSummary, T> g) {
        return obj -> g.apply((ReferenceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceSummary> {
        /**
         * <p>
         * Information about the URL reference if the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
         * </p>
         * 
         * @param url
         *        Information about the URL reference if the <code>referenceType</code> is <code>URL</code>. Otherwise,
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(UrlReference url);

        /**
         * <p>
         * Information about the URL reference if the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
         * </p>
         * This is a convenience method that creates an instance of the {@link UrlReference.Builder} avoiding the need
         * to create one manually via {@link UrlReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link UrlReference.Builder#build()} is called immediately and its
         * result is passed to {@link #url(UrlReference)}.
         * 
         * @param url
         *        a consumer that will call methods on {@link UrlReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #url(UrlReference)
         */
        default Builder url(Consumer<UrlReference.Builder> url) {
            return url(UrlReference.builder().applyMutation(url).build());
        }

        /**
         * <p>
         * Information about the attachment reference if the <code>referenceType</code> is <code>ATTACHMENT</code>.
         * Otherwise, null.
         * </p>
         * 
         * @param attachment
         *        Information about the attachment reference if the <code>referenceType</code> is
         *        <code>ATTACHMENT</code>. Otherwise, null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(AttachmentReference attachment);

        /**
         * <p>
         * Information about the attachment reference if the <code>referenceType</code> is <code>ATTACHMENT</code>.
         * Otherwise, null.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttachmentReference.Builder} avoiding the
         * need to create one manually via {@link AttachmentReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttachmentReference.Builder#build()} is called immediately and
         * its result is passed to {@link #attachment(AttachmentReference)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link AttachmentReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(AttachmentReference)
         */
        default Builder attachment(Consumer<AttachmentReference.Builder> attachment) {
            return attachment(AttachmentReference.builder().applyMutation(attachment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UrlReference url;

        private AttachmentReference attachment;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceSummary model) {
            url(model.url);
            attachment(model.attachment);
        }

        public final UrlReference.Builder getUrl() {
            return url != null ? url.toBuilder() : null;
        }

        public final void setUrl(UrlReference.BuilderImpl url) {
            Object oldValue = this.url;
            this.url = url != null ? url.build() : null;
            handleUnionValueChange(Type.URL, oldValue, this.url);
        }

        @Override
        public final Builder url(UrlReference url) {
            Object oldValue = this.url;
            this.url = url;
            handleUnionValueChange(Type.URL, oldValue, this.url);
            return this;
        }

        public final AttachmentReference.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(AttachmentReference.BuilderImpl attachment) {
            Object oldValue = this.attachment;
            this.attachment = attachment != null ? attachment.build() : null;
            handleUnionValueChange(Type.ATTACHMENT, oldValue, this.attachment);
        }

        @Override
        public final Builder attachment(AttachmentReference attachment) {
            Object oldValue = this.attachment;
            this.attachment = attachment;
            handleUnionValueChange(Type.ATTACHMENT, oldValue, this.attachment);
            return this;
        }

        @Override
        public ReferenceSummary build() {
            return new ReferenceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ReferenceSummary#type()
     */
    public enum Type {
        URL,

        ATTACHMENT,

        UNKNOWN_TO_SDK_VERSION
    }
}
