/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAgentStatusesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListAgentStatusesResponse.Builder, ListAgentStatusesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAgentStatusesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<AgentStatusSummary>> AGENT_STATUS_SUMMARY_LIST_FIELD = SdkField
            .<List<AgentStatusSummary>> builder(MarshallingType.LIST)
            .memberName("AgentStatusSummaryList")
            .getter(getter(ListAgentStatusesResponse::agentStatusSummaryList))
            .setter(setter(Builder::agentStatusSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatusSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentStatusSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentStatusSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            AGENT_STATUS_SUMMARY_LIST_FIELD));

    private final String nextToken;

    private final List<AgentStatusSummary> agentStatusSummaryList;

    private ListAgentStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.agentStatusSummaryList = builder.agentStatusSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentStatusSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAgentStatusSummaryList() {
        return agentStatusSummaryList != null && !(agentStatusSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of agent statuses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentStatusSummaryList} method.
     * </p>
     * 
     * @return A summary of agent statuses.
     */
    public final List<AgentStatusSummary> agentStatusSummaryList() {
        return agentStatusSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentStatusSummaryList() ? agentStatusSummaryList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentStatusesResponse)) {
            return false;
        }
        ListAgentStatusesResponse other = (ListAgentStatusesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasAgentStatusSummaryList() == other.hasAgentStatusSummaryList()
                && Objects.equals(agentStatusSummaryList(), other.agentStatusSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAgentStatusesResponse").add("NextToken", nextToken())
                .add("AgentStatusSummaryList", hasAgentStatusSummaryList() ? agentStatusSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "AgentStatusSummaryList":
            return Optional.ofNullable(clazz.cast(agentStatusSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAgentStatusesResponse, T> g) {
        return obj -> g.apply((ListAgentStatusesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAgentStatusesResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A summary of agent statuses.
         * </p>
         * 
         * @param agentStatusSummaryList
         *        A summary of agent statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentStatusSummaryList(Collection<AgentStatusSummary> agentStatusSummaryList);

        /**
         * <p>
         * A summary of agent statuses.
         * </p>
         * 
         * @param agentStatusSummaryList
         *        A summary of agent statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentStatusSummaryList(AgentStatusSummary... agentStatusSummaryList);

        /**
         * <p>
         * A summary of agent statuses.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AgentStatusSummary>.Builder}
         * avoiding the need to create one manually via {@link List<AgentStatusSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AgentStatusSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #agentStatusSummaryList(List<AgentStatusSummary>)}.
         * 
         * @param agentStatusSummaryList
         *        a consumer that will call methods on {@link List<AgentStatusSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentStatusSummaryList(List<AgentStatusSummary>)
         */
        Builder agentStatusSummaryList(Consumer<AgentStatusSummary.Builder>... agentStatusSummaryList);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<AgentStatusSummary> agentStatusSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentStatusesResponse model) {
            super(model);
            nextToken(model.nextToken);
            agentStatusSummaryList(model.agentStatusSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AgentStatusSummary.Builder> getAgentStatusSummaryList() {
            List<AgentStatusSummary.Builder> result = AgentStatusSummaryListCopier.copyToBuilder(this.agentStatusSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentStatusSummaryList(Collection<AgentStatusSummary.BuilderImpl> agentStatusSummaryList) {
            this.agentStatusSummaryList = AgentStatusSummaryListCopier.copyFromBuilder(agentStatusSummaryList);
        }

        @Override
        public final Builder agentStatusSummaryList(Collection<AgentStatusSummary> agentStatusSummaryList) {
            this.agentStatusSummaryList = AgentStatusSummaryListCopier.copy(agentStatusSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentStatusSummaryList(AgentStatusSummary... agentStatusSummaryList) {
            agentStatusSummaryList(Arrays.asList(agentStatusSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentStatusSummaryList(Consumer<AgentStatusSummary.Builder>... agentStatusSummaryList) {
            agentStatusSummaryList(Stream.of(agentStatusSummaryList)
                    .map(c -> AgentStatusSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAgentStatusesResponse build() {
            return new ListAgentStatusesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
