/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.connect.model.AccessDeniedException;
import software.amazon.awssdk.services.connect.model.AssociateApprovedOriginRequest;
import software.amazon.awssdk.services.connect.model.AssociateApprovedOriginResponse;
import software.amazon.awssdk.services.connect.model.AssociateBotRequest;
import software.amazon.awssdk.services.connect.model.AssociateBotResponse;
import software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest;
import software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyResponse;
import software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest;
import software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionResponse;
import software.amazon.awssdk.services.connect.model.AssociateLexBotRequest;
import software.amazon.awssdk.services.connect.model.AssociateLexBotResponse;
import software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest;
import software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowResponse;
import software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest;
import software.amazon.awssdk.services.connect.model.AssociateSecurityKeyResponse;
import software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ClaimPhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.ConnectException;
import software.amazon.awssdk.services.connect.model.ContactFlowNotPublishedException;
import software.amazon.awssdk.services.connect.model.ContactNotFoundException;
import software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.CreateAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowResponse;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.CreateInstanceRequest;
import software.amazon.awssdk.services.connect.model.CreateInstanceResponse;
import software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest;
import software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationResponse;
import software.amazon.awssdk.services.connect.model.CreateQueueRequest;
import software.amazon.awssdk.services.connect.model.CreateQueueResponse;
import software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.CreateQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.CreateRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.CreateSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.CreateUseCaseRequest;
import software.amazon.awssdk.services.connect.model.CreateUseCaseResponse;
import software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.CreateUserRequest;
import software.amazon.awssdk.services.connect.model.CreateUserResponse;
import software.amazon.awssdk.services.connect.model.CreateVocabularyRequest;
import software.amazon.awssdk.services.connect.model.CreateVocabularyResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.connect.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest;
import software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationResponse;
import software.amazon.awssdk.services.connect.model.DeleteQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.DeleteQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.DeleteSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest;
import software.amazon.awssdk.services.connect.model.DeleteUseCaseResponse;
import software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.DeleteUserRequest;
import software.amazon.awssdk.services.connect.model.DeleteUserResponse;
import software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest;
import software.amazon.awssdk.services.connect.model.DeleteVocabularyResponse;
import software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.DescribeAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactResponse;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.DescribePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.DescribeQueueRequest;
import software.amazon.awssdk.services.connect.model.DescribeQueueResponse;
import software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.DescribeQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.DescribeRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.DescribeRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.DescribeSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserResponse;
import software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest;
import software.amazon.awssdk.services.connect.model.DescribeVocabularyResponse;
import software.amazon.awssdk.services.connect.model.DestinationNotAllowedException;
import software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest;
import software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginResponse;
import software.amazon.awssdk.services.connect.model.DisassociateBotRequest;
import software.amazon.awssdk.services.connect.model.DisassociateBotResponse;
import software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest;
import software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionResponse;
import software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest;
import software.amazon.awssdk.services.connect.model.DisassociateLexBotResponse;
import software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyResponse;
import software.amazon.awssdk.services.connect.model.DuplicateResourceException;
import software.amazon.awssdk.services.connect.model.GetContactAttributesRequest;
import software.amazon.awssdk.services.connect.model.GetContactAttributesResponse;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse;
import software.amazon.awssdk.services.connect.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.connect.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.connect.model.GetMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetMetricDataResponse;
import software.amazon.awssdk.services.connect.model.IdempotencyException;
import software.amazon.awssdk.services.connect.model.InternalServiceException;
import software.amazon.awssdk.services.connect.model.InvalidContactFlowException;
import software.amazon.awssdk.services.connect.model.InvalidContactFlowModuleException;
import software.amazon.awssdk.services.connect.model.InvalidParameterException;
import software.amazon.awssdk.services.connect.model.InvalidRequestException;
import software.amazon.awssdk.services.connect.model.LimitExceededException;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse;
import software.amazon.awssdk.services.connect.model.ListBotsRequest;
import software.amazon.awssdk.services.connect.model.ListBotsResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowsResponse;
import software.amazon.awssdk.services.connect.model.ListContactReferencesRequest;
import software.amazon.awssdk.services.connect.model.ListContactReferencesResponse;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse;
import software.amazon.awssdk.services.connect.model.ListInstancesRequest;
import software.amazon.awssdk.services.connect.model.ListInstancesResponse;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse;
import software.amazon.awssdk.services.connect.model.ListLexBotsRequest;
import software.amazon.awssdk.services.connect.model.ListLexBotsResponse;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response;
import software.amazon.awssdk.services.connect.model.ListPromptsRequest;
import software.amazon.awssdk.services.connect.model.ListPromptsResponse;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.ListQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connect.model.ListUseCasesRequest;
import software.amazon.awssdk.services.connect.model.ListUseCasesResponse;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse;
import software.amazon.awssdk.services.connect.model.ListUsersRequest;
import software.amazon.awssdk.services.connect.model.ListUsersResponse;
import software.amazon.awssdk.services.connect.model.OutboundContactNotPermittedException;
import software.amazon.awssdk.services.connect.model.PutUserStatusRequest;
import software.amazon.awssdk.services.connect.model.PutUserStatusResponse;
import software.amazon.awssdk.services.connect.model.ReleasePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ReleasePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.ResourceConflictException;
import software.amazon.awssdk.services.connect.model.ResourceInUseException;
import software.amazon.awssdk.services.connect.model.ResourceNotFoundException;
import software.amazon.awssdk.services.connect.model.ResumeContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.ResumeContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.SearchUsersRequest;
import software.amazon.awssdk.services.connect.model.SearchUsersResponse;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse;
import software.amazon.awssdk.services.connect.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.connect.model.StartChatContactRequest;
import software.amazon.awssdk.services.connect.model.StartChatContactResponse;
import software.amazon.awssdk.services.connect.model.StartContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.StartContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.StartContactStreamingRequest;
import software.amazon.awssdk.services.connect.model.StartContactStreamingResponse;
import software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest;
import software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactResponse;
import software.amazon.awssdk.services.connect.model.StartTaskContactRequest;
import software.amazon.awssdk.services.connect.model.StartTaskContactResponse;
import software.amazon.awssdk.services.connect.model.StopContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.StopContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.StopContactRequest;
import software.amazon.awssdk.services.connect.model.StopContactResponse;
import software.amazon.awssdk.services.connect.model.StopContactStreamingRequest;
import software.amazon.awssdk.services.connect.model.StopContactStreamingResponse;
import software.amazon.awssdk.services.connect.model.SuspendContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.SuspendContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.TagResourceRequest;
import software.amazon.awssdk.services.connect.model.TagResourceResponse;
import software.amazon.awssdk.services.connect.model.ThrottlingException;
import software.amazon.awssdk.services.connect.model.UntagResourceRequest;
import software.amazon.awssdk.services.connect.model.UntagResourceResponse;
import software.amazon.awssdk.services.connect.model.UpdateAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.UpdateAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactAttributesResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactScheduleRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactScheduleResponse;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeRequest;
import software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeResponse;
import software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueStatusRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueStatusResponse;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.UserNotFoundException;
import software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable;
import software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable;
import software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable;
import software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable;
import software.amazon.awssdk.services.connect.paginators.ListBotsIterable;
import software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable;
import software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable;
import software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable;
import software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable;
import software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable;
import software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable;
import software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable;
import software.amazon.awssdk.services.connect.paginators.ListInstancesIterable;
import software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable;
import software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable;
import software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable;
import software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable;
import software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable;
import software.amazon.awssdk.services.connect.paginators.ListPromptsIterable;
import software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable;
import software.amazon.awssdk.services.connect.paginators.ListQueuesIterable;
import software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable;
import software.amazon.awssdk.services.connect.paginators.ListRoutingProfileQueuesIterable;
import software.amazon.awssdk.services.connect.paginators.ListRoutingProfilesIterable;
import software.amazon.awssdk.services.connect.paginators.ListSecurityKeysIterable;
import software.amazon.awssdk.services.connect.paginators.ListSecurityProfilePermissionsIterable;
import software.amazon.awssdk.services.connect.paginators.ListSecurityProfilesIterable;
import software.amazon.awssdk.services.connect.paginators.ListUseCasesIterable;
import software.amazon.awssdk.services.connect.paginators.ListUserHierarchyGroupsIterable;
import software.amazon.awssdk.services.connect.paginators.ListUsersIterable;
import software.amazon.awssdk.services.connect.paginators.SearchAvailablePhoneNumbersIterable;
import software.amazon.awssdk.services.connect.paginators.SearchUsersIterable;
import software.amazon.awssdk.services.connect.paginators.SearchVocabulariesIterable;

/**
 * Service client for accessing Amazon Connect. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Connect is a cloud-based contact center solution that you use to set up and manage a customer contact center
 * and provide reliable customer engagement at any scale.
 * </p>
 * <p>
 * Amazon Connect provides metrics and real-time reporting that enable you to optimize contact routing. You can also
 * resolve customer issues more efficiently by getting customers in touch with the appropriate agents.
 * </p>
 * <p>
 * There are limits to the number of Amazon Connect resources that you can create. There are also limits to the number
 * of requests that you can make per second. For more information, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect
 * Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.
 * </p>
 * <p>
 * You can connect programmatically to an Amazon Web Services service by using an endpoint. For a list of Amazon Connect
 * endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
 * Endpoints</a>.
 * </p>
 * <note>
 * <p>
 * Working with contact flows? Check out the <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ConnectClient extends SdkClient {
    String SERVICE_NAME = "connect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "connect";

    /**
     * Create a {@link ConnectClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ConnectClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ConnectClient}.
     */
    static ConnectClientBuilder builder() {
        return new DefaultConnectClientBuilder();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates an approved origin to an Amazon Connect instance.
     * </p>
     *
     * @param associateApprovedOriginRequest
     * @return Result of the AssociateApprovedOrigin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateApprovedOriginResponse associateApprovedOrigin(AssociateApprovedOriginRequest associateApprovedOriginRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates an approved origin to an Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateApprovedOriginRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateApprovedOriginRequest#builder()}
     * </p>
     *
     * @param associateApprovedOriginRequest
     *        A {@link Consumer} that will call methods on {@link AssociateApprovedOriginRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateApprovedOrigin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateApprovedOriginResponse associateApprovedOrigin(
            Consumer<AssociateApprovedOriginRequest.Builder> associateApprovedOriginRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return associateApprovedOrigin(AssociateApprovedOriginRequest.builder().applyMutation(associateApprovedOriginRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     *
     * @param associateBotRequest
     * @return Result of the AssociateBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateBotResponse associateBot(AssociateBotRequest associateBotRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, LimitExceededException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateBotRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateBotRequest#builder()}
     * </p>
     *
     * @param associateBotRequest
     *        A {@link Consumer} that will call methods on {@link AssociateBotRequest.Builder} to create a request.
     * @return Result of the AssociateBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateBotResponse associateBot(Consumer<AssociateBotRequest.Builder> associateBotRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            LimitExceededException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        return associateBot(AssociateBotRequest.builder().applyMutation(associateBotRequest).build());
    }

    /**
     * <p>
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in
     * post-call and real-time analysis sessions for the given language.
     * </p>
     *
     * @param associateDefaultVocabularyRequest
     * @return Result of the AssociateDefaultVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateDefaultVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateDefaultVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDefaultVocabularyResponse associateDefaultVocabulary(
            AssociateDefaultVocabularyRequest associateDefaultVocabularyRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in
     * post-call and real-time analysis sessions for the given language.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDefaultVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateDefaultVocabularyRequest#builder()}
     * </p>
     *
     * @param associateDefaultVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDefaultVocabularyRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateDefaultVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateDefaultVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateDefaultVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDefaultVocabularyResponse associateDefaultVocabulary(
            Consumer<AssociateDefaultVocabularyRequest.Builder> associateDefaultVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return associateDefaultVocabulary(AssociateDefaultVocabularyRequest.builder()
                .applyMutation(associateDefaultVocabularyRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration
     * in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing
     * chat transcripts.
     * </p>
     * <p>
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the
     * resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     * </p>
     *
     * @param associateInstanceStorageConfigRequest
     * @return Result of the AssociateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateInstanceStorageConfigResponse associateInstanceStorageConfig(
            AssociateInstanceStorageConfigRequest associateInstanceStorageConfigRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration
     * in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing
     * chat transcripts.
     * </p>
     * <p>
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the
     * resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateInstanceStorageConfigRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateInstanceStorageConfigRequest#builder()}
     * </p>
     *
     * @param associateInstanceStorageConfigRequest
     *        A {@link Consumer} that will call methods on {@link AssociateInstanceStorageConfigRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateInstanceStorageConfigResponse associateInstanceStorageConfig(
            Consumer<AssociateInstanceStorageConfigRequest.Builder> associateInstanceStorageConfigRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return associateInstanceStorageConfig(AssociateInstanceStorageConfigRequest.builder()
                .applyMutation(associateInstanceStorageConfigRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     * </p>
     *
     * @param associateLambdaFunctionRequest
     * @return Result of the AssociateLambdaFunction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateLambdaFunctionResponse associateLambdaFunction(AssociateLambdaFunctionRequest associateLambdaFunctionRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLambdaFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateLambdaFunctionRequest#builder()}
     * </p>
     *
     * @param associateLambdaFunctionRequest
     *        A {@link Consumer} that will call methods on {@link AssociateLambdaFunctionRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateLambdaFunction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateLambdaFunctionResponse associateLambdaFunction(
            Consumer<AssociateLambdaFunctionRequest.Builder> associateLambdaFunctionRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return associateLambdaFunction(AssociateLambdaFunctionRequest.builder().applyMutation(associateLambdaFunctionRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex bot.
     * </p>
     *
     * @param associateLexBotRequest
     * @return Result of the AssociateLexBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLexBot" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateLexBotResponse associateLexBot(AssociateLexBotRequest associateLexBotRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLexBotRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateLexBotRequest#builder()}
     * </p>
     *
     * @param associateLexBotRequest
     *        A {@link Consumer} that will call methods on {@link AssociateLexBotRequest.Builder} to create a request.
     * @return Result of the AssociateLexBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLexBot" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateLexBotResponse associateLexBot(Consumer<AssociateLexBotRequest.Builder> associateLexBotRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        return associateLexBot(AssociateLexBotRequest.builder().applyMutation(associateLexBotRequest).build());
    }

    /**
     * <p>
     * Associates a contact flow with a phone number claimed to your Amazon Connect instance.
     * </p>
     *
     * @param associatePhoneNumberContactFlowRequest
     * @return Result of the AssociatePhoneNumberContactFlow operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociatePhoneNumberContactFlowResponse associatePhoneNumberContactFlow(
            AssociatePhoneNumberContactFlowRequest associatePhoneNumberContactFlowRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a contact flow with a phone number claimed to your Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePhoneNumberContactFlowRequest.Builder}
     * avoiding the need to create one manually via {@link AssociatePhoneNumberContactFlowRequest#builder()}
     * </p>
     *
     * @param associatePhoneNumberContactFlowRequest
     *        A {@link Consumer} that will call methods on {@link AssociatePhoneNumberContactFlowRequest.Builder} to
     *        create a request.
     * @return Result of the AssociatePhoneNumberContactFlow operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociatePhoneNumberContactFlowResponse associatePhoneNumberContactFlow(
            Consumer<AssociatePhoneNumberContactFlowRequest.Builder> associatePhoneNumberContactFlowRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return associatePhoneNumberContactFlow(AssociatePhoneNumberContactFlowRequest.builder()
                .applyMutation(associatePhoneNumberContactFlowRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a set of quick connects with a queue.
     * </p>
     *
     * @param associateQueueQuickConnectsRequest
     * @return Result of the AssociateQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateQueueQuickConnectsResponse associateQueueQuickConnects(
            AssociateQueueQuickConnectsRequest associateQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a set of quick connects with a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateQueueQuickConnectsRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateQueueQuickConnectsRequest#builder()}
     * </p>
     *
     * @param associateQueueQuickConnectsRequest
     *        A {@link Consumer} that will call methods on {@link AssociateQueueQuickConnectsRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateQueueQuickConnectsResponse associateQueueQuickConnects(
            Consumer<AssociateQueueQuickConnectsRequest.Builder> associateQueueQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return associateQueueQuickConnects(AssociateQueueQuickConnectsRequest.builder()
                .applyMutation(associateQueueQuickConnectsRequest).build());
    }

    /**
     * <p>
     * Associates a set of queues with a routing profile.
     * </p>
     *
     * @param associateRoutingProfileQueuesRequest
     * @return Result of the AssociateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateRoutingProfileQueuesResponse associateRoutingProfileQueues(
            AssociateRoutingProfileQueuesRequest associateRoutingProfileQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of queues with a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateRoutingProfileQueuesRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateRoutingProfileQueuesRequest#builder()}
     * </p>
     *
     * @param associateRoutingProfileQueuesRequest
     *        A {@link Consumer} that will call methods on {@link AssociateRoutingProfileQueuesRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateRoutingProfileQueuesResponse associateRoutingProfileQueues(
            Consumer<AssociateRoutingProfileQueuesRequest.Builder> associateRoutingProfileQueuesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return associateRoutingProfileQueues(AssociateRoutingProfileQueuesRequest.builder()
                .applyMutation(associateRoutingProfileQueuesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a security key to the instance.
     * </p>
     *
     * @param associateSecurityKeyRequest
     * @return Result of the AssociateSecurityKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityKey" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSecurityKeyResponse associateSecurityKey(AssociateSecurityKeyRequest associateSecurityKeyRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a security key to the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSecurityKeyRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateSecurityKeyRequest#builder()}
     * </p>
     *
     * @param associateSecurityKeyRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSecurityKeyRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateSecurityKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityKey" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSecurityKeyResponse associateSecurityKey(
            Consumer<AssociateSecurityKeyRequest.Builder> associateSecurityKeyRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return associateSecurityKey(AssociateSecurityKeyRequest.builder().applyMutation(associateSecurityKeyRequest).build());
    }

    /**
     * <p>
     * Claims an available phone number to your Amazon Connect instance.
     * </p>
     *
     * @param claimPhoneNumberRequest
     * @return Result of the ClaimPhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ClaimPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ClaimPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default ClaimPhoneNumberResponse claimPhoneNumber(ClaimPhoneNumberRequest claimPhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Claims an available phone number to your Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClaimPhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link ClaimPhoneNumberRequest#builder()}
     * </p>
     *
     * @param claimPhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link ClaimPhoneNumberRequest.Builder} to create a request.
     * @return Result of the ClaimPhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ClaimPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ClaimPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default ClaimPhoneNumberResponse claimPhoneNumber(Consumer<ClaimPhoneNumberRequest.Builder> claimPhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return claimPhoneNumber(ClaimPhoneNumberRequest.builder().applyMutation(claimPhoneNumberRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates an agent status for the specified Amazon Connect instance.
     * </p>
     *
     * @param createAgentStatusRequest
     * @return Result of the CreateAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateAgentStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAgentStatusResponse createAgentStatus(CreateAgentStatusRequest createAgentStatusRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates an agent status for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentStatusRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAgentStatusRequest#builder()}
     * </p>
     *
     * @param createAgentStatusRequest
     *        A {@link Consumer} that will call methods on {@link CreateAgentStatusRequest.Builder} to create a request.
     * @return Result of the CreateAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateAgentStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAgentStatusResponse createAgentStatus(Consumer<CreateAgentStatusRequest.Builder> createAgentStatusRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return createAgentStatus(CreateAgentStatusRequest.builder().applyMutation(createAgentStatusRequest).build());
    }

    /**
     * <p>
     * Creates a contact flow for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     *
     * @param createContactFlowRequest
     * @return Result of the CreateContactFlow operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowException
     *         The contact flow is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContactFlowResponse createContactFlow(CreateContactFlowRequest createContactFlowRequest)
            throws InvalidRequestException, InvalidContactFlowException, InvalidParameterException, DuplicateResourceException,
            LimitExceededException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a contact flow for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactFlowRequest.Builder} avoiding the need
     * to create one manually via {@link CreateContactFlowRequest#builder()}
     * </p>
     *
     * @param createContactFlowRequest
     *        A {@link Consumer} that will call methods on {@link CreateContactFlowRequest.Builder} to create a request.
     * @return Result of the CreateContactFlow operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowException
     *         The contact flow is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContactFlowResponse createContactFlow(Consumer<CreateContactFlowRequest.Builder> createContactFlowRequest)
            throws InvalidRequestException, InvalidContactFlowException, InvalidParameterException, DuplicateResourceException,
            LimitExceededException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return createContactFlow(CreateContactFlowRequest.builder().applyMutation(createContactFlowRequest).build());
    }

    /**
     * <p>
     * Creates a contact flow module for the specified Amazon Connect instance.
     * </p>
     *
     * @param createContactFlowModuleRequest
     * @return Result of the CreateContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowModuleException
     *         The problems with the module. Please fix before trying again.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContactFlowModuleResponse createContactFlowModule(CreateContactFlowModuleRequest createContactFlowModuleRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidContactFlowModuleException, InvalidParameterException,
            DuplicateResourceException, LimitExceededException, ResourceNotFoundException, ThrottlingException,
            IdempotencyException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a contact flow module for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactFlowModuleRequest.Builder} avoiding
     * the need to create one manually via {@link CreateContactFlowModuleRequest#builder()}
     * </p>
     *
     * @param createContactFlowModuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateContactFlowModuleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowModuleException
     *         The problems with the module. Please fix before trying again.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContactFlowModuleResponse createContactFlowModule(
            Consumer<CreateContactFlowModuleRequest.Builder> createContactFlowModuleRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidContactFlowModuleException, InvalidParameterException, DuplicateResourceException,
            LimitExceededException, ResourceNotFoundException, ThrottlingException, IdempotencyException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createContactFlowModule(CreateContactFlowModuleRequest.builder().applyMutation(createContactFlowModuleRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates hours of operation.
     * </p>
     *
     * @param createHoursOfOperationRequest
     * @return Result of the CreateHoursOfOperation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHoursOfOperationResponse createHoursOfOperation(CreateHoursOfOperationRequest createHoursOfOperationRequest)
            throws DuplicateResourceException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates hours of operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHoursOfOperationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param createHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on {@link CreateHoursOfOperationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateHoursOfOperation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHoursOfOperationResponse createHoursOfOperation(
            Consumer<CreateHoursOfOperationRequest.Builder> createHoursOfOperationRequest) throws DuplicateResourceException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createHoursOfOperation(CreateHoursOfOperationRequest.builder().applyMutation(createHoursOfOperationRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage,
     * such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any
     * configurations on features, such as Contact Lens for Amazon Connect.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     *
     * @param createInstanceRequest
     * @return Result of the CreateInstance operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInstanceResponse createInstance(CreateInstanceRequest createInstanceRequest) throws InvalidRequestException,
            ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage,
     * such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any
     * configurations on features, such as Contact Lens for Amazon Connect.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInstanceRequest#builder()}
     * </p>
     *
     * @param createInstanceRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstanceRequest.Builder} to create a request.
     * @return Result of the CreateInstance operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInstanceResponse createInstance(Consumer<CreateInstanceRequest.Builder> createInstanceRequest)
            throws InvalidRequestException, ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createInstance(CreateInstanceRequest.builder().applyMutation(createInstanceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     * </p>
     *
     * @param createIntegrationAssociationRequest
     * @return Result of the CreateIntegrationAssociation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIntegrationAssociationResponse createIntegrationAssociation(
            CreateIntegrationAssociationRequest createIntegrationAssociationRequest) throws DuplicateResourceException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateIntegrationAssociationRequest#builder()}
     * </p>
     *
     * @param createIntegrationAssociationRequest
     *        A {@link Consumer} that will call methods on {@link CreateIntegrationAssociationRequest.Builder} to create
     *        a request.
     * @return Result of the CreateIntegrationAssociation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIntegrationAssociationResponse createIntegrationAssociation(
            Consumer<CreateIntegrationAssociationRequest.Builder> createIntegrationAssociationRequest)
            throws DuplicateResourceException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return createIntegrationAssociation(CreateIntegrationAssociationRequest.builder()
                .applyMutation(createIntegrationAssociationRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates a new queue for the specified Amazon Connect instance.
     * </p>
     *
     * @param createQueueRequest
     * @return Result of the CreateQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates a new queue for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link CreateQueueRequest#builder()}
     * </p>
     *
     * @param createQueueRequest
     *        A {@link Consumer} that will call methods on {@link CreateQueueRequest.Builder} to create a request.
     * @return Result of the CreateQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQueueResponse createQueue(Consumer<CreateQueueRequest.Builder> createQueueRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return createQueue(CreateQueueRequest.builder().applyMutation(createQueueRequest).build());
    }

    /**
     * <p>
     * Creates a quick connect for the specified Amazon Connect instance.
     * </p>
     *
     * @param createQuickConnectRequest
     * @return Result of the CreateQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateQuickConnectResponse createQuickConnect(CreateQuickConnectRequest createQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a quick connect for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQuickConnectRequest.Builder} avoiding the
     * need to create one manually via {@link CreateQuickConnectRequest#builder()}
     * </p>
     *
     * @param createQuickConnectRequest
     *        A {@link Consumer} that will call methods on {@link CreateQuickConnectRequest.Builder} to create a
     *        request.
     * @return Result of the CreateQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateQuickConnectResponse createQuickConnect(Consumer<CreateQuickConnectRequest.Builder> createQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return createQuickConnect(CreateQuickConnectRequest.builder().applyMutation(createQuickConnectRequest).build());
    }

    /**
     * <p>
     * Creates a new routing profile.
     * </p>
     *
     * @param createRoutingProfileRequest
     * @return Result of the CreateRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRoutingProfileResponse createRoutingProfile(CreateRoutingProfileRequest createRoutingProfileRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoutingProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRoutingProfileRequest#builder()}
     * </p>
     *
     * @param createRoutingProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateRoutingProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRoutingProfileResponse createRoutingProfile(
            Consumer<CreateRoutingProfileRequest.Builder> createRoutingProfileRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createRoutingProfile(CreateRoutingProfileRequest.builder().applyMutation(createRoutingProfileRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates a security profile.
     * </p>
     *
     * @param createSecurityProfileRequest
     * @return Result of the CreateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSecurityProfileResponse createSecurityProfile(CreateSecurityProfileRequest createSecurityProfileRequest)
            throws InvalidRequestException, InvalidParameterException, LimitExceededException, DuplicateResourceException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates a security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityProfileRequest#builder()}
     * </p>
     *
     * @param createSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSecurityProfileResponse createSecurityProfile(
            Consumer<CreateSecurityProfileRequest.Builder> createSecurityProfileRequest) throws InvalidRequestException,
            InvalidParameterException, LimitExceededException, DuplicateResourceException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createSecurityProfile(CreateSecurityProfileRequest.builder().applyMutation(createSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Creates a use case for an integration association.
     * </p>
     *
     * @param createUseCaseRequest
     * @return Result of the CreateUseCase operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUseCaseResponse createUseCase(CreateUseCaseRequest createUseCaseRequest) throws DuplicateResourceException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a use case for an integration association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUseCaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUseCaseRequest#builder()}
     * </p>
     *
     * @param createUseCaseRequest
     *        A {@link Consumer} that will call methods on {@link CreateUseCaseRequest.Builder} to create a request.
     * @return Result of the CreateUseCase operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUseCaseResponse createUseCase(Consumer<CreateUseCaseRequest.Builder> createUseCaseRequest)
            throws DuplicateResourceException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return createUseCase(CreateUseCaseRequest.builder().applyMutation(createUseCaseRequest).build());
    }

    /**
     * <p>
     * Creates a user account for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For information about how to create user accounts using the Amazon Connect console, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws InvalidRequestException,
            InvalidParameterException, LimitExceededException, DuplicateResourceException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user account for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For information about how to create user accounts using the Amazon Connect console, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return Result of the CreateUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest) throws InvalidRequestException,
            InvalidParameterException, LimitExceededException, DuplicateResourceException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Creates a new user hierarchy group.
     * </p>
     *
     * @param createUserHierarchyGroupRequest
     * @return Result of the CreateUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserHierarchyGroupResponse createUserHierarchyGroup(
            CreateUserHierarchyGroupRequest createUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, LimitExceededException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new user hierarchy group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserHierarchyGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateUserHierarchyGroupRequest#builder()}
     * </p>
     *
     * @param createUserHierarchyGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserHierarchyGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserHierarchyGroupResponse createUserHierarchyGroup(
            Consumer<CreateUserHierarchyGroupRequest.Builder> createUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, LimitExceededException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createUserHierarchyGroup(CreateUserHierarchyGroupRequest.builder().applyMutation(createUserHierarchyGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be
     * your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in
     * post-call and real-time contact analysis sessions for that language.
     * </p>
     *
     * @param createVocabularyRequest
     * @return Result of the CreateVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVocabularyResponse createVocabulary(CreateVocabularyRequest createVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, ResourceConflictException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be
     * your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in
     * post-call and real-time contact analysis sessions for that language.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVocabularyRequest#builder()}
     * </p>
     *
     * @param createVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link CreateVocabularyRequest.Builder} to create a request.
     * @return Result of the CreateVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVocabularyResponse createVocabulary(Consumer<CreateVocabularyRequest.Builder> createVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, ResourceConflictException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ConnectException {
        return createVocabulary(CreateVocabularyRequest.builder().applyMutation(createVocabularyRequest).build());
    }

    /**
     * <p>
     * Deletes a contact flow for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteContactFlowRequest
     * @return Result of the DeleteContactFlow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContactFlowResponse deleteContactFlow(DeleteContactFlowRequest deleteContactFlowRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a contact flow for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactFlowRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteContactFlowRequest#builder()}
     * </p>
     *
     * @param deleteContactFlowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContactFlowRequest.Builder} to create a request.
     * @return Result of the DeleteContactFlow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContactFlowResponse deleteContactFlow(Consumer<DeleteContactFlowRequest.Builder> deleteContactFlowRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return deleteContactFlow(DeleteContactFlowRequest.builder().applyMutation(deleteContactFlowRequest).build());
    }

    /**
     * <p>
     * Deletes the specified contact flow module.
     * </p>
     *
     * @param deleteContactFlowModuleRequest
     * @return Result of the DeleteContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContactFlowModuleResponse deleteContactFlowModule(DeleteContactFlowModuleRequest deleteContactFlowModuleRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified contact flow module.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactFlowModuleRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteContactFlowModuleRequest#builder()}
     * </p>
     *
     * @param deleteContactFlowModuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContactFlowModuleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContactFlowModuleResponse deleteContactFlowModule(
            Consumer<DeleteContactFlowModuleRequest.Builder> deleteContactFlowModuleRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deleteContactFlowModule(DeleteContactFlowModuleRequest.builder().applyMutation(deleteContactFlowModuleRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes an hours of operation.
     * </p>
     *
     * @param deleteHoursOfOperationRequest
     * @return Result of the DeleteHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHoursOfOperationResponse deleteHoursOfOperation(DeleteHoursOfOperationRequest deleteHoursOfOperationRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes an hours of operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHoursOfOperationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param deleteHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHoursOfOperationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHoursOfOperationResponse deleteHoursOfOperation(
            Consumer<DeleteHoursOfOperationRequest.Builder> deleteHoursOfOperationRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return deleteHoursOfOperation(DeleteHoursOfOperationRequest.builder().applyMutation(deleteHoursOfOperationRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the Amazon Connect instance.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     *
     * @param deleteInstanceRequest
     * @return Result of the DeleteInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInstanceResponse deleteInstance(DeleteInstanceRequest deleteInstanceRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the Amazon Connect instance.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInstanceRequest#builder()}
     * </p>
     *
     * @param deleteInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInstanceRequest.Builder} to create a request.
     * @return Result of the DeleteInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInstanceResponse deleteInstance(Consumer<DeleteInstanceRequest.Builder> deleteInstanceRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, AwsServiceException,
            SdkClientException, ConnectException {
        return deleteInstance(DeleteInstanceRequest.builder().applyMutation(deleteInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not
     * have any use cases associated with it.
     * </p>
     *
     * @param deleteIntegrationAssociationRequest
     * @return Result of the DeleteIntegrationAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIntegrationAssociationResponse deleteIntegrationAssociation(
            DeleteIntegrationAssociationRequest deleteIntegrationAssociationRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not
     * have any use cases associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteIntegrationAssociationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationAssociationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIntegrationAssociationRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteIntegrationAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIntegrationAssociationResponse deleteIntegrationAssociation(
            Consumer<DeleteIntegrationAssociationRequest.Builder> deleteIntegrationAssociationRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return deleteIntegrationAssociation(DeleteIntegrationAssociationRequest.builder()
                .applyMutation(deleteIntegrationAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a quick connect.
     * </p>
     *
     * @param deleteQuickConnectRequest
     * @return Result of the DeleteQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteQuickConnectResponse deleteQuickConnect(DeleteQuickConnectRequest deleteQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a quick connect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQuickConnectRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteQuickConnectRequest#builder()}
     * </p>
     *
     * @param deleteQuickConnectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteQuickConnectRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteQuickConnectResponse deleteQuickConnect(Consumer<DeleteQuickConnectRequest.Builder> deleteQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deleteQuickConnect(DeleteQuickConnectRequest.builder().applyMutation(deleteQuickConnectRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes a security profile.
     * </p>
     *
     * @param deleteSecurityProfileRequest
     * @return Result of the DeleteSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSecurityProfileResponse deleteSecurityProfile(DeleteSecurityProfileRequest deleteSecurityProfileRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AccessDeniedException, ResourceInUseException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes a security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityProfileRequest#builder()}
     * </p>
     *
     * @param deleteSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSecurityProfileResponse deleteSecurityProfile(
            Consumer<DeleteSecurityProfileRequest.Builder> deleteSecurityProfileRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, ResourceInUseException, AwsServiceException, SdkClientException, ConnectException {
        return deleteSecurityProfile(DeleteSecurityProfileRequest.builder().applyMutation(deleteSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a use case from an integration association.
     * </p>
     *
     * @param deleteUseCaseRequest
     * @return Result of the DeleteUseCase operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUseCaseResponse deleteUseCase(DeleteUseCaseRequest deleteUseCaseRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a use case from an integration association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUseCaseRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUseCaseRequest#builder()}
     * </p>
     *
     * @param deleteUseCaseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUseCaseRequest.Builder} to create a request.
     * @return Result of the DeleteUseCase operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUseCaseResponse deleteUseCase(Consumer<DeleteUseCaseRequest.Builder> deleteUseCaseRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return deleteUseCase(DeleteUseCaseRequest.builder().applyMutation(deleteUseCaseRequest).build());
    }

    /**
     * <p>
     * Deletes a user account from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For information about what happens to a user's data when their account is deleted, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html">Delete Users from Your Amazon
     * Connect Instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user account from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For information about what happens to a user's data when their account is deleted, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html">Delete Users from Your Amazon
     * Connect Instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child
     * groups.
     * </p>
     *
     * @param deleteUserHierarchyGroupRequest
     * @return Result of the DeleteUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserHierarchyGroupResponse deleteUserHierarchyGroup(
            DeleteUserHierarchyGroupRequest deleteUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child
     * groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserHierarchyGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteUserHierarchyGroupRequest#builder()}
     * </p>
     *
     * @param deleteUserHierarchyGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserHierarchyGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserHierarchyGroupResponse deleteUserHierarchyGroup(
            Consumer<DeleteUserHierarchyGroupRequest.Builder> deleteUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deleteUserHierarchyGroup(DeleteUserHierarchyGroupRequest.builder().applyMutation(deleteUserHierarchyGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the vocabulary that has the given identifier.
     * </p>
     *
     * @param deleteVocabularyRequest
     * @return Result of the DeleteVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVocabularyResponse deleteVocabulary(DeleteVocabularyRequest deleteVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, ResourceInUseException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the vocabulary that has the given identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVocabularyRequest.Builder} to create a request.
     * @return Result of the DeleteVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVocabularyResponse deleteVocabulary(Consumer<DeleteVocabularyRequest.Builder> deleteVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, ResourceInUseException, AwsServiceException, SdkClientException, ConnectException {
        return deleteVocabulary(DeleteVocabularyRequest.builder().applyMutation(deleteVocabularyRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes an agent status.
     * </p>
     *
     * @param describeAgentStatusRequest
     * @return Result of the DescribeAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeAgentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAgentStatusResponse describeAgentStatus(DescribeAgentStatusRequest describeAgentStatusRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes an agent status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAgentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAgentStatusRequest#builder()}
     * </p>
     *
     * @param describeAgentStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAgentStatusRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeAgentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAgentStatusResponse describeAgentStatus(
            Consumer<DescribeAgentStatusRequest.Builder> describeAgentStatusRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeAgentStatus(DescribeAgentStatusRequest.builder().applyMutation(describeAgentStatusRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified contact.
     * </p>
     * <important>
     * <p>
     * Contact information remains available in Amazon Connect for 24 months, and then it is deleted.
     * </p>
     * </important>
     *
     * @param describeContactRequest
     * @return Result of the DescribeContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContact" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeContactResponse describeContact(DescribeContactRequest describeContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified contact.
     * </p>
     * <important>
     * <p>
     * Contact information remains available in Amazon Connect for 24 months, and then it is deleted.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeContactRequest#builder()}
     * </p>
     *
     * @param describeContactRequest
     *        A {@link Consumer} that will call methods on {@link DescribeContactRequest.Builder} to create a request.
     * @return Result of the DescribeContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContact" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeContactResponse describeContact(Consumer<DescribeContactRequest.Builder> describeContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return describeContact(DescribeContactRequest.builder().applyMutation(describeContactRequest).build());
    }

    /**
     * <p>
     * Describes the specified contact flow.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     *
     * @param describeContactFlowRequest
     * @return Result of the DescribeContactFlow operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ContactFlowNotPublishedException
     *         The contact flow has not been published.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlow" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeContactFlowResponse describeContactFlow(DescribeContactFlowRequest describeContactFlowRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ContactFlowNotPublishedException, ThrottlingException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified contact flow.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactFlowRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeContactFlowRequest#builder()}
     * </p>
     *
     * @param describeContactFlowRequest
     *        A {@link Consumer} that will call methods on {@link DescribeContactFlowRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeContactFlow operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ContactFlowNotPublishedException
     *         The contact flow has not been published.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlow" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeContactFlowResponse describeContactFlow(
            Consumer<DescribeContactFlowRequest.Builder> describeContactFlowRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ContactFlowNotPublishedException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeContactFlow(DescribeContactFlowRequest.builder().applyMutation(describeContactFlowRequest).build());
    }

    /**
     * <p>
     * Describes the specified contact flow module.
     * </p>
     *
     * @param describeContactFlowModuleRequest
     * @return Result of the DescribeContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeContactFlowModuleResponse describeContactFlowModule(
            DescribeContactFlowModuleRequest describeContactFlowModuleRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified contact flow module.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactFlowModuleRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContactFlowModuleRequest#builder()}
     * </p>
     *
     * @param describeContactFlowModuleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeContactFlowModuleRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeContactFlowModuleResponse describeContactFlowModule(
            Consumer<DescribeContactFlowModuleRequest.Builder> describeContactFlowModuleRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeContactFlowModule(DescribeContactFlowModuleRequest.builder()
                .applyMutation(describeContactFlowModuleRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the hours of operation.
     * </p>
     *
     * @param describeHoursOfOperationRequest
     * @return Result of the DescribeHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHoursOfOperationResponse describeHoursOfOperation(
            DescribeHoursOfOperationRequest describeHoursOfOperationRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the hours of operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHoursOfOperationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param describeHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHoursOfOperationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHoursOfOperationResponse describeHoursOfOperation(
            Consumer<DescribeHoursOfOperationRequest.Builder> describeHoursOfOperationRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeHoursOfOperation(DescribeHoursOfOperationRequest.builder().applyMutation(describeHoursOfOperationRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created
     * and returns an error status, if applicable.
     * </p>
     * <p>
     * If an instance is not created successfully, the instance status reason field returns details relevant to the
     * reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     * </p>
     *
     * @param describeInstanceRequest
     * @return Result of the DescribeInstance operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeInstanceResponse describeInstance(DescribeInstanceRequest describeInstanceRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created
     * and returns an error status, if applicable.
     * </p>
     * <p>
     * If an instance is not created successfully, the instance status reason field returns details relevant to the
     * reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeInstanceRequest#builder()}
     * </p>
     *
     * @param describeInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceRequest.Builder} to create a request.
     * @return Result of the DescribeInstance operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeInstanceResponse describeInstance(Consumer<DescribeInstanceRequest.Builder> describeInstanceRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        return describeInstance(DescribeInstanceRequest.builder().applyMutation(describeInstanceRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified instance attribute.
     * </p>
     *
     * @param describeInstanceAttributeRequest
     * @return Result of the DescribeInstanceAttribute operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstanceAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAttributeResponse describeInstanceAttribute(
            DescribeInstanceAttributeRequest describeInstanceAttributeRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified instance attribute.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceAttributeRequest#builder()}
     * </p>
     *
     * @param describeInstanceAttributeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceAttributeRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeInstanceAttribute operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstanceAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAttributeResponse describeInstanceAttribute(
            Consumer<DescribeInstanceAttributeRequest.Builder> describeInstanceAttributeRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return describeInstanceAttribute(DescribeInstanceAttributeRequest.builder()
                .applyMutation(describeInstanceAttributeRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     * </p>
     *
     * @param describeInstanceStorageConfigRequest
     * @return Result of the DescribeInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceStorageConfigResponse describeInstanceStorageConfig(
            DescribeInstanceStorageConfigRequest describeInstanceStorageConfigRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceStorageConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceStorageConfigRequest#builder()}
     * </p>
     *
     * @param describeInstanceStorageConfigRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceStorageConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceStorageConfigResponse describeInstanceStorageConfig(
            Consumer<DescribeInstanceStorageConfigRequest.Builder> describeInstanceStorageConfigRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return describeInstanceStorageConfig(DescribeInstanceStorageConfigRequest.builder()
                .applyMutation(describeInstanceStorageConfigRequest).build());
    }

    /**
     * <p>
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance
     * </p>
     *
     * @param describePhoneNumberRequest
     * @return Result of the DescribePhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePhoneNumberResponse describePhoneNumber(DescribePhoneNumberRequest describePhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePhoneNumberRequest#builder()}
     * </p>
     *
     * @param describePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link DescribePhoneNumberRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePhoneNumberResponse describePhoneNumber(
            Consumer<DescribePhoneNumberRequest.Builder> describePhoneNumberRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        return describePhoneNumber(DescribePhoneNumberRequest.builder().applyMutation(describePhoneNumberRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified queue.
     * </p>
     *
     * @param describeQueueRequest
     * @return Result of the DescribeQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeQueueResponse describeQueue(DescribeQueueRequest describeQueueRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeQueueRequest#builder()}
     * </p>
     *
     * @param describeQueueRequest
     *        A {@link Consumer} that will call methods on {@link DescribeQueueRequest.Builder} to create a request.
     * @return Result of the DescribeQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeQueueResponse describeQueue(Consumer<DescribeQueueRequest.Builder> describeQueueRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeQueue(DescribeQueueRequest.builder().applyMutation(describeQueueRequest).build());
    }

    /**
     * <p>
     * Describes the quick connect.
     * </p>
     *
     * @param describeQuickConnectRequest
     * @return Result of the DescribeQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeQuickConnectResponse describeQuickConnect(DescribeQuickConnectRequest describeQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the quick connect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQuickConnectRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeQuickConnectRequest#builder()}
     * </p>
     *
     * @param describeQuickConnectRequest
     *        A {@link Consumer} that will call methods on {@link DescribeQuickConnectRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeQuickConnectResponse describeQuickConnect(
            Consumer<DescribeQuickConnectRequest.Builder> describeQuickConnectRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeQuickConnect(DescribeQuickConnectRequest.builder().applyMutation(describeQuickConnectRequest).build());
    }

    /**
     * <p>
     * Describes the specified routing profile.
     * </p>
     *
     * @param describeRoutingProfileRequest
     * @return Result of the DescribeRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRoutingProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRoutingProfileResponse describeRoutingProfile(DescribeRoutingProfileRequest describeRoutingProfileRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRoutingProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRoutingProfileRequest#builder()}
     * </p>
     *
     * @param describeRoutingProfileRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRoutingProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRoutingProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRoutingProfileResponse describeRoutingProfile(
            Consumer<DescribeRoutingProfileRequest.Builder> describeRoutingProfileRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeRoutingProfile(DescribeRoutingProfileRequest.builder().applyMutation(describeRoutingProfileRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Gets basic information about the security profle.
     * </p>
     *
     * @param describeSecurityProfileRequest
     * @return Result of the DescribeSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeSecurityProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSecurityProfileResponse describeSecurityProfile(DescribeSecurityProfileRequest describeSecurityProfileRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Gets basic information about the security profle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecurityProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSecurityProfileRequest#builder()}
     * </p>
     *
     * @param describeSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeSecurityProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSecurityProfileResponse describeSecurityProfile(
            Consumer<DescribeSecurityProfileRequest.Builder> describeSecurityProfileRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeSecurityProfile(DescribeSecurityProfileRequest.builder().applyMutation(describeSecurityProfileRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified user account. You can find the instance ID in the console (it’s the final part of the
     * ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.
     * </p>
     *
     * @param describeUserRequest
     * @return Result of the DescribeUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified user account. You can find the instance ID in the console (it’s the final part of the
     * ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserRequest.Builder} to create a request.
     * @return Result of the DescribeUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Describes the specified hierarchy group.
     * </p>
     *
     * @param describeUserHierarchyGroupRequest
     * @return Result of the DescribeUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserHierarchyGroupResponse describeUserHierarchyGroup(
            DescribeUserHierarchyGroupRequest describeUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified hierarchy group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserHierarchyGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeUserHierarchyGroupRequest#builder()}
     * </p>
     *
     * @param describeUserHierarchyGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserHierarchyGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserHierarchyGroupResponse describeUserHierarchyGroup(
            Consumer<DescribeUserHierarchyGroupRequest.Builder> describeUserHierarchyGroupRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeUserHierarchyGroup(DescribeUserHierarchyGroupRequest.builder()
                .applyMutation(describeUserHierarchyGroupRequest).build());
    }

    /**
     * <p>
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     * </p>
     *
     * @param describeUserHierarchyStructureRequest
     * @return Result of the DescribeUserHierarchyStructure operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUserHierarchyStructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserHierarchyStructureResponse describeUserHierarchyStructure(
            DescribeUserHierarchyStructureRequest describeUserHierarchyStructureRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserHierarchyStructureRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeUserHierarchyStructureRequest#builder()}
     * </p>
     *
     * @param describeUserHierarchyStructureRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserHierarchyStructureRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeUserHierarchyStructure operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUserHierarchyStructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserHierarchyStructureResponse describeUserHierarchyStructure(
            Consumer<DescribeUserHierarchyStructureRequest.Builder> describeUserHierarchyStructureRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeUserHierarchyStructure(DescribeUserHierarchyStructureRequest.builder()
                .applyMutation(describeUserHierarchyStructureRequest).build());
    }

    /**
     * <p>
     * Describes the specified vocabulary.
     * </p>
     *
     * @param describeVocabularyRequest
     * @return Result of the DescribeVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVocabularyResponse describeVocabulary(DescribeVocabularyRequest describeVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVocabularyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVocabularyRequest#builder()}
     * </p>
     *
     * @param describeVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVocabularyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVocabularyResponse describeVocabulary(Consumer<DescribeVocabularyRequest.Builder> describeVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return describeVocabulary(DescribeVocabularyRequest.builder().applyMutation(describeVocabularyRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes access to integrated applications from Amazon Connect.
     * </p>
     *
     * @param disassociateApprovedOriginRequest
     * @return Result of the DisassociateApprovedOrigin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateApprovedOriginResponse disassociateApprovedOrigin(
            DisassociateApprovedOriginRequest disassociateApprovedOriginRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes access to integrated applications from Amazon Connect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateApprovedOriginRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateApprovedOriginRequest#builder()}
     * </p>
     *
     * @param disassociateApprovedOriginRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateApprovedOriginRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateApprovedOrigin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateApprovedOriginResponse disassociateApprovedOrigin(
            Consumer<DisassociateApprovedOriginRequest.Builder> disassociateApprovedOriginRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateApprovedOrigin(DisassociateApprovedOriginRequest.builder()
                .applyMutation(disassociateApprovedOriginRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     *
     * @param disassociateBotRequest
     * @return Result of the DisassociateBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateBotResponse disassociateBot(DisassociateBotRequest disassociateBotRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateBotRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateBotRequest#builder()}
     * </p>
     *
     * @param disassociateBotRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateBotRequest.Builder} to create a request.
     * @return Result of the DisassociateBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateBotResponse disassociateBot(Consumer<DisassociateBotRequest.Builder> disassociateBotRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return disassociateBot(DisassociateBotRequest.builder().applyMutation(disassociateBotRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Removes the storage type configurations for the specified resource type and association ID.
     * </p>
     *
     * @param disassociateInstanceStorageConfigRequest
     * @return Result of the DisassociateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateInstanceStorageConfigResponse disassociateInstanceStorageConfig(
            DisassociateInstanceStorageConfigRequest disassociateInstanceStorageConfigRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Removes the storage type configurations for the specified resource type and association ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateInstanceStorageConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateInstanceStorageConfigRequest#builder()}
     * </p>
     *
     * @param disassociateInstanceStorageConfigRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateInstanceStorageConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateInstanceStorageConfigResponse disassociateInstanceStorageConfig(
            Consumer<DisassociateInstanceStorageConfigRequest.Builder> disassociateInstanceStorageConfigRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateInstanceStorageConfig(DisassociateInstanceStorageConfigRequest.builder()
                .applyMutation(disassociateInstanceStorageConfigRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Remove the Lambda function from the dropdown options available in the relevant contact flow blocks.
     * </p>
     *
     * @param disassociateLambdaFunctionRequest
     * @return Result of the DisassociateLambdaFunction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateLambdaFunctionResponse disassociateLambdaFunction(
            DisassociateLambdaFunctionRequest disassociateLambdaFunctionRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Remove the Lambda function from the dropdown options available in the relevant contact flow blocks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLambdaFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateLambdaFunctionRequest#builder()}
     * </p>
     *
     * @param disassociateLambdaFunctionRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateLambdaFunctionRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateLambdaFunction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateLambdaFunctionResponse disassociateLambdaFunction(
            Consumer<DisassociateLambdaFunctionRequest.Builder> disassociateLambdaFunctionRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateLambdaFunction(DisassociateLambdaFunctionRequest.builder()
                .applyMutation(disassociateLambdaFunctionRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     * </p>
     *
     * @param disassociateLexBotRequest
     * @return Result of the DisassociateLexBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLexBot" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateLexBotResponse disassociateLexBot(DisassociateLexBotRequest disassociateLexBotRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLexBotRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateLexBotRequest#builder()}
     * </p>
     *
     * @param disassociateLexBotRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateLexBotRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateLexBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLexBot" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateLexBotResponse disassociateLexBot(Consumer<DisassociateLexBotRequest.Builder> disassociateLexBotRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateLexBot(DisassociateLexBotRequest.builder().applyMutation(disassociateLexBotRequest).build());
    }

    /**
     * <p>
     * Removes the contact flow association from a phone number claimed to your Amazon Connect instance, if a contact
     * flow association exists.
     * </p>
     *
     * @param disassociatePhoneNumberContactFlowRequest
     * @return Result of the DisassociatePhoneNumberContactFlow operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociatePhoneNumberContactFlowResponse disassociatePhoneNumberContactFlow(
            DisassociatePhoneNumberContactFlowRequest disassociatePhoneNumberContactFlowRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the contact flow association from a phone number claimed to your Amazon Connect instance, if a contact
     * flow association exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePhoneNumberContactFlowRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociatePhoneNumberContactFlowRequest#builder()}
     * </p>
     *
     * @param disassociatePhoneNumberContactFlowRequest
     *        A {@link Consumer} that will call methods on {@link DisassociatePhoneNumberContactFlowRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociatePhoneNumberContactFlow operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociatePhoneNumberContactFlowResponse disassociatePhoneNumberContactFlow(
            Consumer<DisassociatePhoneNumberContactFlowRequest.Builder> disassociatePhoneNumberContactFlowRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return disassociatePhoneNumberContactFlow(DisassociatePhoneNumberContactFlowRequest.builder()
                .applyMutation(disassociatePhoneNumberContactFlowRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Disassociates a set of quick connects from a queue.
     * </p>
     *
     * @param disassociateQueueQuickConnectsRequest
     * @return Result of the DisassociateQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateQueueQuickConnectsResponse disassociateQueueQuickConnects(
            DisassociateQueueQuickConnectsRequest disassociateQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Disassociates a set of quick connects from a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateQueueQuickConnectsRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateQueueQuickConnectsRequest#builder()}
     * </p>
     *
     * @param disassociateQueueQuickConnectsRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateQueueQuickConnectsRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateQueueQuickConnectsResponse disassociateQueueQuickConnects(
            Consumer<DisassociateQueueQuickConnectsRequest.Builder> disassociateQueueQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateQueueQuickConnects(DisassociateQueueQuickConnectsRequest.builder()
                .applyMutation(disassociateQueueQuickConnectsRequest).build());
    }

    /**
     * <p>
     * Disassociates a set of queues from a routing profile.
     * </p>
     *
     * @param disassociateRoutingProfileQueuesRequest
     * @return Result of the DisassociateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateRoutingProfileQueuesResponse disassociateRoutingProfileQueues(
            DisassociateRoutingProfileQueuesRequest disassociateRoutingProfileQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a set of queues from a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateRoutingProfileQueuesRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateRoutingProfileQueuesRequest#builder()}
     * </p>
     *
     * @param disassociateRoutingProfileQueuesRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateRoutingProfileQueuesRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateRoutingProfileQueuesResponse disassociateRoutingProfileQueues(
            Consumer<DisassociateRoutingProfileQueuesRequest.Builder> disassociateRoutingProfileQueuesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateRoutingProfileQueues(DisassociateRoutingProfileQueuesRequest.builder()
                .applyMutation(disassociateRoutingProfileQueuesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the specified security key.
     * </p>
     *
     * @param disassociateSecurityKeyRequest
     * @return Result of the DisassociateSecurityKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateSecurityKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSecurityKeyResponse disassociateSecurityKey(DisassociateSecurityKeyRequest disassociateSecurityKeyRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the specified security key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSecurityKeyRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateSecurityKeyRequest#builder()}
     * </p>
     *
     * @param disassociateSecurityKeyRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateSecurityKeyRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateSecurityKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateSecurityKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSecurityKeyResponse disassociateSecurityKey(
            Consumer<DisassociateSecurityKeyRequest.Builder> disassociateSecurityKeyRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return disassociateSecurityKey(DisassociateSecurityKeyRequest.builder().applyMutation(disassociateSecurityKeyRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the contact attributes for the specified contact.
     * </p>
     *
     * @param getContactAttributesRequest
     * @return Result of the GetContactAttributes operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetContactAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContactAttributesResponse getContactAttributes(GetContactAttributesRequest getContactAttributesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the contact attributes for the specified contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link GetContactAttributesRequest#builder()}
     * </p>
     *
     * @param getContactAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetContactAttributesRequest.Builder} to create a
     *        request.
     * @return Result of the GetContactAttributes operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetContactAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContactAttributesResponse getContactAttributes(
            Consumer<GetContactAttributesRequest.Builder> getContactAttributesRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return getContactAttributes(GetContactAttributesRequest.builder().applyMutation(getContactAttributesRequest).build());
    }

    /**
     * <p>
     * Gets the real-time metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
     * Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param getCurrentMetricDataRequest
     * @return Result of the GetCurrentMetricData operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentMetricDataResponse getCurrentMetricData(GetCurrentMetricDataRequest getCurrentMetricDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the real-time metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
     * Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetCurrentMetricDataRequest#builder()}
     * </p>
     *
     * @param getCurrentMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetCurrentMetricDataRequest.Builder} to create a
     *        request.
     * @return Result of the GetCurrentMetricData operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentMetricDataResponse getCurrentMetricData(
            Consumer<GetCurrentMetricDataRequest.Builder> getCurrentMetricDataRequest) throws InvalidRequestException,
            InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ConnectException {
        return getCurrentMetricData(GetCurrentMetricDataRequest.builder().applyMutation(getCurrentMetricDataRequest).build());
    }

    /**
     * <p>
     * Gets the real-time metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
     * Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client.getCurrentMetricDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client
     *             .getCurrentMetricDataPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client.getCurrentMetricDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCurrentMetricDataRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentMetricDataIterable getCurrentMetricDataPaginator(GetCurrentMetricDataRequest getCurrentMetricDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the real-time metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
     * Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client.getCurrentMetricDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client
     *             .getCurrentMetricDataPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client.getCurrentMetricDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetCurrentMetricDataRequest#builder()}
     * </p>
     *
     * @param getCurrentMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetCurrentMetricDataRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentMetricDataIterable getCurrentMetricDataPaginator(
            Consumer<GetCurrentMetricDataRequest.Builder> getCurrentMetricDataRequest) throws InvalidRequestException,
            InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ConnectException {
        return getCurrentMetricDataPaginator(GetCurrentMetricDataRequest.builder().applyMutation(getCurrentMetricDataRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a token for federation.
     * </p>
     * <note>
     * <p>
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error
     * message similar to the following one appears:
     * </p>
     * <p>
     * <code>Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect</code>
     * </p>
     * </note>
     *
     * @param getFederationTokenRequest
     * @return Result of the GetFederationToken operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws UserNotFoundException
     *         No user with the specified credentials was found in the Amazon Connect instance.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetFederationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFederationTokenResponse getFederationToken(GetFederationTokenRequest getFederationTokenRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, UserNotFoundException,
            InternalServiceException, DuplicateResourceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a token for federation.
     * </p>
     * <note>
     * <p>
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error
     * message similar to the following one appears:
     * </p>
     * <p>
     * <code>Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect</code>
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFederationTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetFederationTokenRequest#builder()}
     * </p>
     *
     * @param getFederationTokenRequest
     *        A {@link Consumer} that will call methods on {@link GetFederationTokenRequest.Builder} to create a
     *        request.
     * @return Result of the GetFederationToken operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws UserNotFoundException
     *         No user with the specified credentials was found in the Amazon Connect instance.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetFederationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFederationTokenResponse getFederationToken(Consumer<GetFederationTokenRequest.Builder> getFederationTokenRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, UserNotFoundException,
            InternalServiceException, DuplicateResourceException, AwsServiceException, SdkClientException, ConnectException {
        return getFederationToken(GetFederationTokenRequest.builder().applyMutation(getFederationTokenRequest).build());
    }

    /**
     * <p>
     * Gets historical metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each historical metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param getMetricDataRequest
     * @return Result of the GetMetricData operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataResponse getMetricData(GetMetricDataRequest getMetricDataRequest) throws InvalidRequestException,
            InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets historical metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each historical metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetMetricDataRequest#builder()}
     * </p>
     *
     * @param getMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetMetricDataRequest.Builder} to create a request.
     * @return Result of the GetMetricData operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataResponse getMetricData(Consumer<GetMetricDataRequest.Builder> getMetricDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return getMetricData(GetMetricDataRequest.builder().applyMutation(getMetricDataRequest).build());
    }

    /**
     * <p>
     * Gets historical metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each historical metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetMetricDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)} operation.</b>
     * </p>
     *
     * @param getMetricDataRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataIterable getMetricDataPaginator(GetMetricDataRequest getMetricDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets historical metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each historical metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetMetricDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetMetricDataRequest#builder()}
     * </p>
     *
     * @param getMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link GetMetricDataRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataIterable getMetricDataPaginator(Consumer<GetMetricDataRequest.Builder> getMetricDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return getMetricDataPaginator(GetMetricDataRequest.builder().applyMutation(getMetricDataRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists agent statuses.
     * </p>
     *
     * @param listAgentStatusesRequest
     * @return Result of the ListAgentStatuses operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListAgentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAgentStatuses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentStatusesResponse listAgentStatuses(ListAgentStatusesRequest listAgentStatusesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists agent statuses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentStatusesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentStatusesRequest#builder()}
     * </p>
     *
     * @param listAgentStatusesRequest
     *        A {@link Consumer} that will call methods on {@link ListAgentStatusRequest.Builder} to create a request.
     * @return Result of the ListAgentStatuses operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListAgentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAgentStatuses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentStatusesResponse listAgentStatuses(Consumer<ListAgentStatusesRequest.Builder> listAgentStatusesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listAgentStatuses(ListAgentStatusesRequest.builder().applyMutation(listAgentStatusesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists agent statuses.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgentStatuses(software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client.listAgentStatusesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client
     *             .listAgentStatusesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client.listAgentStatusesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentStatuses(software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest)} operation.</b>
     * </p>
     *
     * @param listAgentStatusesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListAgentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAgentStatuses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentStatusesIterable listAgentStatusesPaginator(ListAgentStatusesRequest listAgentStatusesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists agent statuses.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgentStatuses(software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client.listAgentStatusesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client
     *             .listAgentStatusesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client.listAgentStatusesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentStatuses(software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentStatusesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentStatusesRequest#builder()}
     * </p>
     *
     * @param listAgentStatusesRequest
     *        A {@link Consumer} that will call methods on {@link ListAgentStatusRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListAgentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAgentStatuses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentStatusesIterable listAgentStatusesPaginator(
            Consumer<ListAgentStatusesRequest.Builder> listAgentStatusesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listAgentStatusesPaginator(ListAgentStatusesRequest.builder().applyMutation(listAgentStatusesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all approved origins associated with the instance.
     * </p>
     *
     * @param listApprovedOriginsRequest
     * @return Result of the ListApprovedOrigins operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListApprovedOrigins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListApprovedOrigins" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApprovedOriginsResponse listApprovedOrigins(ListApprovedOriginsRequest listApprovedOriginsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all approved origins associated with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApprovedOriginsRequest.Builder} avoiding the
     * need to create one manually via {@link ListApprovedOriginsRequest#builder()}
     * </p>
     *
     * @param listApprovedOriginsRequest
     *        A {@link Consumer} that will call methods on {@link ListApprovedOriginsRequest.Builder} to create a
     *        request.
     * @return Result of the ListApprovedOrigins operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListApprovedOrigins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListApprovedOrigins" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApprovedOriginsResponse listApprovedOrigins(
            Consumer<ListApprovedOriginsRequest.Builder> listApprovedOriginsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listApprovedOrigins(ListApprovedOriginsRequest.builder().applyMutation(listApprovedOriginsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all approved origins associated with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApprovedOrigins(software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client.listApprovedOriginsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client
     *             .listApprovedOriginsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client.listApprovedOriginsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApprovedOrigins(software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApprovedOriginsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListApprovedOrigins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListApprovedOrigins" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApprovedOriginsIterable listApprovedOriginsPaginator(ListApprovedOriginsRequest listApprovedOriginsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all approved origins associated with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApprovedOrigins(software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client.listApprovedOriginsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client
     *             .listApprovedOriginsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client.listApprovedOriginsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApprovedOrigins(software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApprovedOriginsRequest.Builder} avoiding the
     * need to create one manually via {@link ListApprovedOriginsRequest#builder()}
     * </p>
     *
     * @param listApprovedOriginsRequest
     *        A {@link Consumer} that will call methods on {@link ListApprovedOriginsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListApprovedOrigins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListApprovedOrigins" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApprovedOriginsIterable listApprovedOriginsPaginator(
            Consumer<ListApprovedOriginsRequest.Builder> listApprovedOriginsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listApprovedOriginsPaginator(ListApprovedOriginsRequest.builder().applyMutation(listApprovedOriginsRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated
     * with the instance.
     * </p>
     *
     * @param listBotsRequest
     * @return Result of the ListBots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsResponse listBots(ListBotsRequest listBotsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated
     * with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotsRequest.Builder} to create a request.
     * @return Result of the ListBots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsResponse listBots(Consumer<ListBotsRequest.Builder> listBotsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        return listBots(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated
     * with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.connect.model.ListBotsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.connect.model.ListBotsRequest)} operation.</b>
     * </p>
     *
     * @param listBotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsIterable listBotsPaginator(ListBotsRequest listBotsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated
     * with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.connect.model.ListBotsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.connect.model.ListBotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsIterable listBotsPaginator(Consumer<ListBotsRequest.Builder> listBotsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listBotsPaginator(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Provides information about the contact flow modules for the specified Amazon Connect instance.
     * </p>
     *
     * @param listContactFlowModulesRequest
     * @return Result of the ListContactFlowModules operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlowModules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlowModules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactFlowModulesResponse listContactFlowModules(ListContactFlowModulesRequest listContactFlowModulesRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the contact flow modules for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactFlowModulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactFlowModulesRequest#builder()}
     * </p>
     *
     * @param listContactFlowModulesRequest
     *        A {@link Consumer} that will call methods on {@link ListContactFlowModulesRequest.Builder} to create a
     *        request.
     * @return Result of the ListContactFlowModules operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlowModules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlowModules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactFlowModulesResponse listContactFlowModules(
            Consumer<ListContactFlowModulesRequest.Builder> listContactFlowModulesRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listContactFlowModules(ListContactFlowModulesRequest.builder().applyMutation(listContactFlowModulesRequest)
                .build());
    }

    /**
     * <p>
     * Provides information about the contact flow modules for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContactFlowModules(software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client.listContactFlowModulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client
     *             .listContactFlowModulesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client.listContactFlowModulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactFlowModules(software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContactFlowModulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlowModules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlowModules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactFlowModulesIterable listContactFlowModulesPaginator(
            ListContactFlowModulesRequest listContactFlowModulesRequest) throws AccessDeniedException, InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the contact flow modules for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContactFlowModules(software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client.listContactFlowModulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client
     *             .listContactFlowModulesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client.listContactFlowModulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactFlowModules(software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactFlowModulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactFlowModulesRequest#builder()}
     * </p>
     *
     * @param listContactFlowModulesRequest
     *        A {@link Consumer} that will call methods on {@link ListContactFlowModulesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlowModules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlowModules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactFlowModulesIterable listContactFlowModulesPaginator(
            Consumer<ListContactFlowModulesRequest.Builder> listContactFlowModulesRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listContactFlowModulesPaginator(ListContactFlowModulesRequest.builder()
                .applyMutation(listContactFlowModulesRequest).build());
    }

    /**
     * <p>
     * Provides information about the contact flows for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     * <p>
     * For more information about contact flows, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html">Contact Flows</a> in the
     * <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listContactFlowsRequest
     * @return Result of the ListContactFlows operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactFlowsResponse listContactFlows(ListContactFlowsRequest listContactFlowsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the contact flows for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     * <p>
     * For more information about contact flows, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html">Contact Flows</a> in the
     * <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactFlowsRequest.Builder} avoiding the need
     * to create one manually via {@link ListContactFlowsRequest#builder()}
     * </p>
     *
     * @param listContactFlowsRequest
     *        A {@link Consumer} that will call methods on {@link ListContactFlowsRequest.Builder} to create a request.
     * @return Result of the ListContactFlows operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactFlowsResponse listContactFlows(Consumer<ListContactFlowsRequest.Builder> listContactFlowsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listContactFlows(ListContactFlowsRequest.builder().applyMutation(listContactFlowsRequest).build());
    }

    /**
     * <p>
     * Provides information about the contact flows for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     * <p>
     * For more information about contact flows, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html">Contact Flows</a> in the
     * <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContactFlows(software.amazon.awssdk.services.connect.model.ListContactFlowsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client.listContactFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client
     *             .listContactFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client.listContactFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactFlows(software.amazon.awssdk.services.connect.model.ListContactFlowsRequest)} operation.</b>
     * </p>
     *
     * @param listContactFlowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactFlowsIterable listContactFlowsPaginator(ListContactFlowsRequest listContactFlowsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the contact flows for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     * <p>
     * For more information about contact flows, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html">Contact Flows</a> in the
     * <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContactFlows(software.amazon.awssdk.services.connect.model.ListContactFlowsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client.listContactFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client
     *             .listContactFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client.listContactFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactFlows(software.amazon.awssdk.services.connect.model.ListContactFlowsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactFlowsRequest.Builder} avoiding the need
     * to create one manually via {@link ListContactFlowsRequest#builder()}
     * </p>
     *
     * @param listContactFlowsRequest
     *        A {@link Consumer} that will call methods on {@link ListContactFlowsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactFlowsIterable listContactFlowsPaginator(Consumer<ListContactFlowsRequest.Builder> listContactFlowsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listContactFlowsPaginator(ListContactFlowsRequest.builder().applyMutation(listContactFlowsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified <code>referenceTypes</code>, returns a list of references associated with the contact.
     * </p>
     *
     * @param listContactReferencesRequest
     * @return Result of the ListContactReferences operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactReferences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactReferencesResponse listContactReferences(ListContactReferencesRequest listContactReferencesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified <code>referenceTypes</code>, returns a list of references associated with the contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactReferencesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactReferencesRequest#builder()}
     * </p>
     *
     * @param listContactReferencesRequest
     *        A {@link Consumer} that will call methods on {@link ListContactReferencesRequest.Builder} to create a
     *        request.
     * @return Result of the ListContactReferences operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactReferences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactReferencesResponse listContactReferences(
            Consumer<ListContactReferencesRequest.Builder> listContactReferencesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listContactReferences(ListContactReferencesRequest.builder().applyMutation(listContactReferencesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified <code>referenceTypes</code>, returns a list of references associated with the contact.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContactReferences(software.amazon.awssdk.services.connect.model.ListContactReferencesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client.listContactReferencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client
     *             .listContactReferencesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactReferencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client.listContactReferencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactReferences(software.amazon.awssdk.services.connect.model.ListContactReferencesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContactReferencesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactReferences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactReferencesIterable listContactReferencesPaginator(ListContactReferencesRequest listContactReferencesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified <code>referenceTypes</code>, returns a list of references associated with the contact.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContactReferences(software.amazon.awssdk.services.connect.model.ListContactReferencesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client.listContactReferencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client
     *             .listContactReferencesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactReferencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client.listContactReferencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactReferences(software.amazon.awssdk.services.connect.model.ListContactReferencesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactReferencesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactReferencesRequest#builder()}
     * </p>
     *
     * @param listContactReferencesRequest
     *        A {@link Consumer} that will call methods on {@link ListContactReferencesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactReferences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactReferencesIterable listContactReferencesPaginator(
            Consumer<ListContactReferencesRequest.Builder> listContactReferencesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listContactReferencesPaginator(ListContactReferencesRequest.builder().applyMutation(listContactReferencesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the default vocabularies for the specified Amazon Connect instance.
     * </p>
     *
     * @param listDefaultVocabulariesRequest
     * @return Result of the ListDefaultVocabularies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListDefaultVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDefaultVocabulariesResponse listDefaultVocabularies(ListDefaultVocabulariesRequest listDefaultVocabulariesRequest)
            throws InvalidRequestException, InternalServiceException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the default vocabularies for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDefaultVocabulariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDefaultVocabulariesRequest#builder()}
     * </p>
     *
     * @param listDefaultVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListDefaultVocabulariesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDefaultVocabularies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListDefaultVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDefaultVocabulariesResponse listDefaultVocabularies(
            Consumer<ListDefaultVocabulariesRequest.Builder> listDefaultVocabulariesRequest) throws InvalidRequestException,
            InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        return listDefaultVocabularies(ListDefaultVocabulariesRequest.builder().applyMutation(listDefaultVocabulariesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the default vocabularies for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDefaultVocabularies(software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client.listDefaultVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client
     *             .listDefaultVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client.listDefaultVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDefaultVocabularies(software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDefaultVocabulariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListDefaultVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDefaultVocabulariesIterable listDefaultVocabulariesPaginator(
            ListDefaultVocabulariesRequest listDefaultVocabulariesRequest) throws InvalidRequestException,
            InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the default vocabularies for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDefaultVocabularies(software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client.listDefaultVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client
     *             .listDefaultVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client.listDefaultVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDefaultVocabularies(software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDefaultVocabulariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDefaultVocabulariesRequest#builder()}
     * </p>
     *
     * @param listDefaultVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListDefaultVocabulariesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListDefaultVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDefaultVocabulariesIterable listDefaultVocabulariesPaginator(
            Consumer<ListDefaultVocabulariesRequest.Builder> listDefaultVocabulariesRequest) throws InvalidRequestException,
            InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        return listDefaultVocabulariesPaginator(ListDefaultVocabulariesRequest.builder()
                .applyMutation(listDefaultVocabulariesRequest).build());
    }

    /**
     * <p>
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about hours of operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html">Set the Hours of Operation
     * for a Queue</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listHoursOfOperationsRequest
     * @return Result of the ListHoursOfOperations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListHoursOfOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListHoursOfOperationsResponse listHoursOfOperations(ListHoursOfOperationsRequest listHoursOfOperationsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about hours of operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html">Set the Hours of Operation
     * for a Queue</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHoursOfOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListHoursOfOperationsRequest#builder()}
     * </p>
     *
     * @param listHoursOfOperationsRequest
     *        A {@link Consumer} that will call methods on {@link ListHoursOfOperationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListHoursOfOperations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListHoursOfOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListHoursOfOperationsResponse listHoursOfOperations(
            Consumer<ListHoursOfOperationsRequest.Builder> listHoursOfOperationsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listHoursOfOperations(ListHoursOfOperationsRequest.builder().applyMutation(listHoursOfOperationsRequest).build());
    }

    /**
     * <p>
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about hours of operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html">Set the Hours of Operation
     * for a Queue</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHoursOfOperations(software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client.listHoursOfOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client
     *             .listHoursOfOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client.listHoursOfOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHoursOfOperations(software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHoursOfOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListHoursOfOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListHoursOfOperationsIterable listHoursOfOperationsPaginator(ListHoursOfOperationsRequest listHoursOfOperationsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about hours of operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html">Set the Hours of Operation
     * for a Queue</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHoursOfOperations(software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client.listHoursOfOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client
     *             .listHoursOfOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client.listHoursOfOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHoursOfOperations(software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHoursOfOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListHoursOfOperationsRequest#builder()}
     * </p>
     *
     * @param listHoursOfOperationsRequest
     *        A {@link Consumer} that will call methods on {@link ListHoursOfOperationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListHoursOfOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListHoursOfOperationsIterable listHoursOfOperationsPaginator(
            Consumer<ListHoursOfOperationsRequest.Builder> listHoursOfOperationsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listHoursOfOperationsPaginator(ListHoursOfOperationsRequest.builder().applyMutation(listHoursOfOperationsRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all attribute types for the given instance.
     * </p>
     *
     * @param listInstanceAttributesRequest
     * @return Result of the ListInstanceAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceAttributesResponse listInstanceAttributes(ListInstanceAttributesRequest listInstanceAttributesRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all attribute types for the given instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceAttributesRequest#builder()}
     * </p>
     *
     * @param listInstanceAttributesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceAttributesRequest.Builder} to create a
     *        request.
     * @return Result of the ListInstanceAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceAttributesResponse listInstanceAttributes(
            Consumer<ListInstanceAttributesRequest.Builder> listInstanceAttributesRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listInstanceAttributes(ListInstanceAttributesRequest.builder().applyMutation(listInstanceAttributesRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all attribute types for the given instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceAttributes(software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client.listInstanceAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client
     *             .listInstanceAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client.listInstanceAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceAttributes(software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceAttributesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceAttributesIterable listInstanceAttributesPaginator(
            ListInstanceAttributesRequest listInstanceAttributesRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all attribute types for the given instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceAttributes(software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client.listInstanceAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client
     *             .listInstanceAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client.listInstanceAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceAttributes(software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceAttributesRequest#builder()}
     * </p>
     *
     * @param listInstanceAttributesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceAttributesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceAttributesIterable listInstanceAttributesPaginator(
            Consumer<ListInstanceAttributesRequest.Builder> listInstanceAttributesRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listInstanceAttributesPaginator(ListInstanceAttributesRequest.builder()
                .applyMutation(listInstanceAttributesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of storage configs for the identified instance and resource type.
     * </p>
     *
     * @param listInstanceStorageConfigsRequest
     * @return Result of the ListInstanceStorageConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceStorageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceStorageConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceStorageConfigsResponse listInstanceStorageConfigs(
            ListInstanceStorageConfigsRequest listInstanceStorageConfigsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of storage configs for the identified instance and resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceStorageConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceStorageConfigsRequest#builder()}
     * </p>
     *
     * @param listInstanceStorageConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceStorageConfigsRequest.Builder} to create a
     *        request.
     * @return Result of the ListInstanceStorageConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceStorageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceStorageConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceStorageConfigsResponse listInstanceStorageConfigs(
            Consumer<ListInstanceStorageConfigsRequest.Builder> listInstanceStorageConfigsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listInstanceStorageConfigs(ListInstanceStorageConfigsRequest.builder()
                .applyMutation(listInstanceStorageConfigsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of storage configs for the identified instance and resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceStorageConfigs(software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client.listInstanceStorageConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client
     *             .listInstanceStorageConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client.listInstanceStorageConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceStorageConfigs(software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceStorageConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceStorageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceStorageConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceStorageConfigsIterable listInstanceStorageConfigsPaginator(
            ListInstanceStorageConfigsRequest listInstanceStorageConfigsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of storage configs for the identified instance and resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceStorageConfigs(software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client.listInstanceStorageConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client
     *             .listInstanceStorageConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client.listInstanceStorageConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceStorageConfigs(software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceStorageConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceStorageConfigsRequest#builder()}
     * </p>
     *
     * @param listInstanceStorageConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceStorageConfigsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceStorageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceStorageConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceStorageConfigsIterable listInstanceStorageConfigsPaginator(
            Consumer<ListInstanceStorageConfigsRequest.Builder> listInstanceStorageConfigsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listInstanceStorageConfigsPaginator(ListInstanceStorageConfigsRequest.builder()
                .applyMutation(listInstanceStorageConfigsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances
     * that aren't successfully created (they are in a failed state) are returned only for 24 hours after the
     * CreateInstance API was invoked.
     * </p>
     *
     * @param listInstancesRequest
     * @return Result of the ListInstances operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws InvalidRequestException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances
     * that aren't successfully created (they are in a failed state) are returned only for 24 hours after the
     * CreateInstance API was invoked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstancesRequest.Builder} to create a request.
     * @return Result of the ListInstances operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesResponse listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances
     * that aren't successfully created (they are in a failed state) are returned only for 24 hours after the
     * CreateInstance API was invoked.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.connect.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.connect.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(ListInstancesRequest listInstancesRequest)
            throws InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances
     * that aren't successfully created (they are in a failed state) are returned only for 24 hours after the
     * CreateInstance API was invoked.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.connect.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.connect.model.ListInstancesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstancesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect
     * instance.
     * </p>
     *
     * @param listIntegrationAssociationsRequest
     * @return Result of the ListIntegrationAssociations operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationAssociationsResponse listIntegrationAssociations(
            ListIntegrationAssociationsRequest listIntegrationAssociationsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect
     * instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListIntegrationAssociationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListIntegrationAssociations operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationAssociationsResponse listIntegrationAssociations(
            Consumer<ListIntegrationAssociationsRequest.Builder> listIntegrationAssociationsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listIntegrationAssociations(ListIntegrationAssociationsRequest.builder()
                .applyMutation(listIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect
     * instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIntegrationAssociations(software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client.listIntegrationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client
     *             .listIntegrationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client.listIntegrationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntegrationAssociations(software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIntegrationAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationAssociationsIterable listIntegrationAssociationsPaginator(
            ListIntegrationAssociationsRequest listIntegrationAssociationsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect
     * instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIntegrationAssociations(software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client.listIntegrationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client
     *             .listIntegrationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client.listIntegrationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntegrationAssociations(software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListIntegrationAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationAssociationsIterable listIntegrationAssociationsPaginator(
            Consumer<ListIntegrationAssociationsRequest.Builder> listIntegrationAssociationsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listIntegrationAssociationsPaginator(ListIntegrationAssociationsRequest.builder()
                .applyMutation(listIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant contact
     * flow blocks.
     * </p>
     *
     * @param listLambdaFunctionsRequest
     * @return Result of the ListLambdaFunctions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLambdaFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLambdaFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLambdaFunctionsResponse listLambdaFunctions(ListLambdaFunctionsRequest listLambdaFunctionsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant contact
     * flow blocks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLambdaFunctionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLambdaFunctionsRequest#builder()}
     * </p>
     *
     * @param listLambdaFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLambdaFunctionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListLambdaFunctions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLambdaFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLambdaFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLambdaFunctionsResponse listLambdaFunctions(
            Consumer<ListLambdaFunctionsRequest.Builder> listLambdaFunctionsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listLambdaFunctions(ListLambdaFunctionsRequest.builder().applyMutation(listLambdaFunctionsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant contact
     * flow blocks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLambdaFunctions(software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client.listLambdaFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client
     *             .listLambdaFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client.listLambdaFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLambdaFunctions(software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLambdaFunctionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLambdaFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLambdaFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLambdaFunctionsIterable listLambdaFunctionsPaginator(ListLambdaFunctionsRequest listLambdaFunctionsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant contact
     * flow blocks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLambdaFunctions(software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client.listLambdaFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client
     *             .listLambdaFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client.listLambdaFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLambdaFunctions(software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLambdaFunctionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLambdaFunctionsRequest#builder()}
     * </p>
     *
     * @param listLambdaFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLambdaFunctionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLambdaFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLambdaFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLambdaFunctionsIterable listLambdaFunctionsPaginator(
            Consumer<ListLambdaFunctionsRequest.Builder> listLambdaFunctionsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listLambdaFunctionsPaginator(ListLambdaFunctionsRequest.builder().applyMutation(listLambdaFunctionsRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all the Amazon Lex bots currently associated with the instance.
     * </p>
     *
     * @param listLexBotsRequest
     * @return Result of the ListLexBots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLexBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLexBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexBotsResponse listLexBots(ListLexBotsRequest listLexBotsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all the Amazon Lex bots currently associated with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLexBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLexBotsRequest#builder()}
     * </p>
     *
     * @param listLexBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListLexBotsRequest.Builder} to create a request.
     * @return Result of the ListLexBots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLexBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLexBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexBotsResponse listLexBots(Consumer<ListLexBotsRequest.Builder> listLexBotsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listLexBots(ListLexBotsRequest.builder().applyMutation(listLexBotsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all the Amazon Lex bots currently associated with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLexBots(software.amazon.awssdk.services.connect.model.ListLexBotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListLexBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLexBots(software.amazon.awssdk.services.connect.model.ListLexBotsRequest)} operation.</b>
     * </p>
     *
     * @param listLexBotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLexBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLexBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexBotsIterable listLexBotsPaginator(ListLexBotsRequest listLexBotsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all the Amazon Lex bots currently associated with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLexBots(software.amazon.awssdk.services.connect.model.ListLexBotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListLexBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLexBots(software.amazon.awssdk.services.connect.model.ListLexBotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLexBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLexBotsRequest#builder()}
     * </p>
     *
     * @param listLexBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListLexBotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLexBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLexBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexBotsIterable listLexBotsPaginator(Consumer<ListLexBotsRequest.Builder> listLexBotsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listLexBotsPaginator(ListLexBotsRequest.builder().applyMutation(listLexBotsRequest).build());
    }

    /**
     * <p>
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listPhoneNumbersRequest
     * @return Result of the ListPhoneNumbers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPhoneNumbersResponse listPhoneNumbers(ListPhoneNumbersRequest listPhoneNumbersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersRequest.Builder} avoiding the need
     * to create one manually via {@link ListPhoneNumbersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumbersRequest.Builder} to create a request.
     * @return Result of the ListPhoneNumbers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPhoneNumbersResponse listPhoneNumbers(Consumer<ListPhoneNumbersRequest.Builder> listPhoneNumbersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listPhoneNumbers(ListPhoneNumbersRequest.builder().applyMutation(listPhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client.listPhoneNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client
     *             .listPhoneNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client.listPhoneNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest)} operation.</b>
     * </p>
     *
     * @param listPhoneNumbersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPhoneNumbersIterable listPhoneNumbersPaginator(ListPhoneNumbersRequest listPhoneNumbersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client.listPhoneNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client
     *             .listPhoneNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client.listPhoneNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersRequest.Builder} avoiding the need
     * to create one manually via {@link ListPhoneNumbersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumbersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPhoneNumbersIterable listPhoneNumbersPaginator(Consumer<ListPhoneNumbersRequest.Builder> listPhoneNumbersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listPhoneNumbersPaginator(ListPhoneNumbersRequest.builder().applyMutation(listPhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Lists phone numbers claimed to your Amazon Connect instance.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listPhoneNumbersV2Request
     * @return Result of the ListPhoneNumbersV2 operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbersV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPhoneNumbersV2Response listPhoneNumbersV2(ListPhoneNumbersV2Request listPhoneNumbersV2Request)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists phone numbers claimed to your Amazon Connect instance.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersV2Request.Builder} avoiding the
     * need to create one manually via {@link ListPhoneNumbersV2Request#builder()}
     * </p>
     *
     * @param listPhoneNumbersV2Request
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumbersV2Request.Builder} to create a
     *        request.
     * @return Result of the ListPhoneNumbersV2 operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbersV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPhoneNumbersV2Response listPhoneNumbersV2(Consumer<ListPhoneNumbersV2Request.Builder> listPhoneNumbersV2Request)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return listPhoneNumbersV2(ListPhoneNumbersV2Request.builder().applyMutation(listPhoneNumbersV2Request).build());
    }

    /**
     * <p>
     * Lists phone numbers claimed to your Amazon Connect instance.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbersV2(software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client.listPhoneNumbersV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client
     *             .listPhoneNumbersV2Paginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client.listPhoneNumbersV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbersV2(software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request)}
     * operation.</b>
     * </p>
     *
     * @param listPhoneNumbersV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbersV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPhoneNumbersV2Iterable listPhoneNumbersV2Paginator(ListPhoneNumbersV2Request listPhoneNumbersV2Request)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists phone numbers claimed to your Amazon Connect instance.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbersV2(software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client.listPhoneNumbersV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client
     *             .listPhoneNumbersV2Paginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client.listPhoneNumbersV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbersV2(software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersV2Request.Builder} avoiding the
     * need to create one manually via {@link ListPhoneNumbersV2Request#builder()}
     * </p>
     *
     * @param listPhoneNumbersV2Request
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumbersV2Request.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbersV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPhoneNumbersV2Iterable listPhoneNumbersV2Paginator(
            Consumer<ListPhoneNumbersV2Request.Builder> listPhoneNumbersV2Request) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        return listPhoneNumbersV2Paginator(ListPhoneNumbersV2Request.builder().applyMutation(listPhoneNumbersV2Request).build());
    }

    /**
     * <p>
     * Provides information about the prompts for the specified Amazon Connect instance.
     * </p>
     *
     * @param listPromptsRequest
     * @return Result of the ListPrompts operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPromptsResponse listPrompts(ListPromptsRequest listPromptsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the prompts for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPromptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPromptsRequest#builder()}
     * </p>
     *
     * @param listPromptsRequest
     *        A {@link Consumer} that will call methods on {@link ListPromptsRequest.Builder} to create a request.
     * @return Result of the ListPrompts operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPromptsResponse listPrompts(Consumer<ListPromptsRequest.Builder> listPromptsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listPrompts(ListPromptsRequest.builder().applyMutation(listPromptsRequest).build());
    }

    /**
     * <p>
     * Provides information about the prompts for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPrompts(software.amazon.awssdk.services.connect.model.ListPromptsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPromptsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrompts(software.amazon.awssdk.services.connect.model.ListPromptsRequest)} operation.</b>
     * </p>
     *
     * @param listPromptsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPromptsIterable listPromptsPaginator(ListPromptsRequest listPromptsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the prompts for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPrompts(software.amazon.awssdk.services.connect.model.ListPromptsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPromptsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrompts(software.amazon.awssdk.services.connect.model.ListPromptsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPromptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPromptsRequest#builder()}
     * </p>
     *
     * @param listPromptsRequest
     *        A {@link Consumer} that will call methods on {@link ListPromptsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPromptsIterable listPromptsPaginator(Consumer<ListPromptsRequest.Builder> listPromptsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listPromptsPaginator(ListPromptsRequest.builder().applyMutation(listPromptsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the quick connects associated with a queue.
     * </p>
     *
     * @param listQueueQuickConnectsRequest
     * @return Result of the ListQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueQuickConnectsResponse listQueueQuickConnects(ListQueueQuickConnectsRequest listQueueQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the quick connects associated with a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueQuickConnectsRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueueQuickConnectsRequest#builder()}
     * </p>
     *
     * @param listQueueQuickConnectsRequest
     *        A {@link Consumer} that will call methods on {@link ListQueueQuickConnectsRequest.Builder} to create a
     *        request.
     * @return Result of the ListQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueQuickConnectsResponse listQueueQuickConnects(
            Consumer<ListQueueQuickConnectsRequest.Builder> listQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listQueueQuickConnects(ListQueueQuickConnectsRequest.builder().applyMutation(listQueueQuickConnectsRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the quick connects associated with a queue.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQueueQuickConnects(software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client.listQueueQuickConnectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client
     *             .listQueueQuickConnectsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client.listQueueQuickConnectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueQuickConnects(software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQueueQuickConnectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueQuickConnectsIterable listQueueQuickConnectsPaginator(
            ListQueueQuickConnectsRequest listQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the quick connects associated with a queue.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQueueQuickConnects(software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client.listQueueQuickConnectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client
     *             .listQueueQuickConnectsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client.listQueueQuickConnectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueQuickConnects(software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueQuickConnectsRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueueQuickConnectsRequest#builder()}
     * </p>
     *
     * @param listQueueQuickConnectsRequest
     *        A {@link Consumer} that will call methods on {@link ListQueueQuickConnectsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueQuickConnectsIterable listQueueQuickConnectsPaginator(
            Consumer<ListQueueQuickConnectsRequest.Builder> listQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listQueueQuickConnectsPaginator(ListQueueQuickConnectsRequest.builder()
                .applyMutation(listQueueQuickConnectsRequest).build());
    }

    /**
     * <p>
     * Provides information about the queues for the specified Amazon Connect instance.
     * </p>
     * <p>
     * If you do not specify a <code>QueueTypes</code> parameter, both standard and agent queues are returned. This
     * might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of
     * results of the API call in code.
     * </p>
     * <p>
     * For more information about queues, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html">Queues:
     * Standard and Agent</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listQueuesRequest
     * @return Result of the ListQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesResponse listQueues(ListQueuesRequest listQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the queues for the specified Amazon Connect instance.
     * </p>
     * <p>
     * If you do not specify a <code>QueueTypes</code> parameter, both standard and agent queues are returned. This
     * might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of
     * results of the API call in code.
     * </p>
     * <p>
     * For more information about queues, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html">Queues:
     * Standard and Agent</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on {@link ListQueuesRequest.Builder} to create a request.
     * @return Result of the ListQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesResponse listQueues(Consumer<ListQueuesRequest.Builder> listQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listQueues(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * Provides information about the queues for the specified Amazon Connect instance.
     * </p>
     * <p>
     * If you do not specify a <code>QueueTypes</code> parameter, both standard and agent queues are returned. This
     * might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of
     * results of the API call in code.
     * </p>
     * <p>
     * For more information about queues, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html">Queues:
     * Standard and Agent</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.connect.model.ListQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.connect.model.ListQueuesRequest)} operation.</b>
     * </p>
     *
     * @param listQueuesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesIterable listQueuesPaginator(ListQueuesRequest listQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the queues for the specified Amazon Connect instance.
     * </p>
     * <p>
     * If you do not specify a <code>QueueTypes</code> parameter, both standard and agent queues are returned. This
     * might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of
     * results of the API call in code.
     * </p>
     * <p>
     * For more information about queues, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html">Queues:
     * Standard and Agent</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.connect.model.ListQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.connect.model.ListQueuesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on {@link ListQueuesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesIterable listQueuesPaginator(Consumer<ListQueuesRequest.Builder> listQueuesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listQueuesPaginator(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * Provides information about the quick connects for the specified Amazon Connect instance.
     * </p>
     *
     * @param listQuickConnectsRequest
     * @return Result of the ListQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQuickConnects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQuickConnectsResponse listQuickConnects(ListQuickConnectsRequest listQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the quick connects for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuickConnectsRequest.Builder} avoiding the need
     * to create one manually via {@link ListQuickConnectsRequest#builder()}
     * </p>
     *
     * @param listQuickConnectsRequest
     *        A {@link Consumer} that will call methods on {@link ListQuickConnectsRequest.Builder} to create a request.
     * @return Result of the ListQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQuickConnects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQuickConnectsResponse listQuickConnects(Consumer<ListQuickConnectsRequest.Builder> listQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listQuickConnects(ListQuickConnectsRequest.builder().applyMutation(listQuickConnectsRequest).build());
    }

    /**
     * <p>
     * Provides information about the quick connects for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQuickConnects(software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client.listQuickConnectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client
     *             .listQuickConnectsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client.listQuickConnectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQuickConnects(software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest)} operation.</b>
     * </p>
     *
     * @param listQuickConnectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQuickConnects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQuickConnectsIterable listQuickConnectsPaginator(ListQuickConnectsRequest listQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the quick connects for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listQuickConnects(software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client.listQuickConnectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client
     *             .listQuickConnectsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client.listQuickConnectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQuickConnects(software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuickConnectsRequest.Builder} avoiding the need
     * to create one manually via {@link ListQuickConnectsRequest#builder()}
     * </p>
     *
     * @param listQuickConnectsRequest
     *        A {@link Consumer} that will call methods on {@link ListQuickConnectsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQuickConnects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQuickConnectsIterable listQuickConnectsPaginator(
            Consumer<ListQuickConnectsRequest.Builder> listQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listQuickConnectsPaginator(ListQuickConnectsRequest.builder().applyMutation(listQuickConnectsRequest).build());
    }

    /**
     * <p>
     * Lists the queues associated with a routing profile.
     * </p>
     *
     * @param listRoutingProfileQueuesRequest
     * @return Result of the ListRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRoutingProfileQueuesResponse listRoutingProfileQueues(
            ListRoutingProfileQueuesRequest listRoutingProfileQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the queues associated with a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoutingProfileQueuesRequest.Builder} avoiding
     * the need to create one manually via {@link ListRoutingProfileQueuesRequest#builder()}
     * </p>
     *
     * @param listRoutingProfileQueuesRequest
     *        A {@link Consumer} that will call methods on {@link ListRoutingProfileQueuesRequest.Builder} to create a
     *        request.
     * @return Result of the ListRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRoutingProfileQueuesResponse listRoutingProfileQueues(
            Consumer<ListRoutingProfileQueuesRequest.Builder> listRoutingProfileQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listRoutingProfileQueues(ListRoutingProfileQueuesRequest.builder().applyMutation(listRoutingProfileQueuesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the queues associated with a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRoutingProfileQueues(software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListRoutingProfileQueuesIterable responses = client.listRoutingProfileQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListRoutingProfileQueuesIterable responses = client
     *             .listRoutingProfileQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListRoutingProfileQueuesIterable responses = client.listRoutingProfileQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoutingProfileQueues(software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRoutingProfileQueuesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRoutingProfileQueuesIterable listRoutingProfileQueuesPaginator(
            ListRoutingProfileQueuesRequest listRoutingProfileQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the queues associated with a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRoutingProfileQueues(software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListRoutingProfileQueuesIterable responses = client.listRoutingProfileQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListRoutingProfileQueuesIterable responses = client
     *             .listRoutingProfileQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListRoutingProfileQueuesIterable responses = client.listRoutingProfileQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoutingProfileQueues(software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoutingProfileQueuesRequest.Builder} avoiding
     * the need to create one manually via {@link ListRoutingProfileQueuesRequest#builder()}
     * </p>
     *
     * @param listRoutingProfileQueuesRequest
     *        A {@link Consumer} that will call methods on {@link ListRoutingProfileQueuesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRoutingProfileQueuesIterable listRoutingProfileQueuesPaginator(
            Consumer<ListRoutingProfileQueuesRequest.Builder> listRoutingProfileQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listRoutingProfileQueuesPaginator(ListRoutingProfileQueuesRequest.builder()
                .applyMutation(listRoutingProfileQueuesRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the routing profiles for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about routing profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html">Routing Profiles</a> and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html">Create a Routing Profile</a>
     * in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listRoutingProfilesRequest
     * @return Result of the ListRoutingProfiles operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListRoutingProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRoutingProfilesResponse listRoutingProfiles(ListRoutingProfilesRequest listRoutingProfilesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the routing profiles for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about routing profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html">Routing Profiles</a> and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html">Create a Routing Profile</a>
     * in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoutingProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListRoutingProfilesRequest#builder()}
     * </p>
     *
     * @param listRoutingProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListRoutingProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListRoutingProfiles operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListRoutingProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRoutingProfilesResponse listRoutingProfiles(
            Consumer<ListRoutingProfilesRequest.Builder> listRoutingProfilesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listRoutingProfiles(ListRoutingProfilesRequest.builder().applyMutation(listRoutingProfilesRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the routing profiles for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about routing profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html">Routing Profiles</a> and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html">Create a Routing Profile</a>
     * in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRoutingProfiles(software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListRoutingProfilesIterable responses = client.listRoutingProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListRoutingProfilesIterable responses = client
     *             .listRoutingProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListRoutingProfilesIterable responses = client.listRoutingProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoutingProfiles(software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRoutingProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListRoutingProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRoutingProfilesIterable listRoutingProfilesPaginator(ListRoutingProfilesRequest listRoutingProfilesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the routing profiles for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about routing profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html">Routing Profiles</a> and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html">Create a Routing Profile</a>
     * in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRoutingProfiles(software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListRoutingProfilesIterable responses = client.listRoutingProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListRoutingProfilesIterable responses = client
     *             .listRoutingProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListRoutingProfilesIterable responses = client.listRoutingProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoutingProfiles(software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoutingProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListRoutingProfilesRequest#builder()}
     * </p>
     *
     * @param listRoutingProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListRoutingProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListRoutingProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRoutingProfilesIterable listRoutingProfilesPaginator(
            Consumer<ListRoutingProfilesRequest.Builder> listRoutingProfilesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listRoutingProfilesPaginator(ListRoutingProfilesRequest.builder().applyMutation(listRoutingProfilesRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all security keys associated with the instance.
     * </p>
     *
     * @param listSecurityKeysRequest
     * @return Result of the ListSecurityKeys operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSecurityKeysResponse listSecurityKeys(ListSecurityKeysRequest listSecurityKeysRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all security keys associated with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityKeysRequest.Builder} avoiding the need
     * to create one manually via {@link ListSecurityKeysRequest#builder()}
     * </p>
     *
     * @param listSecurityKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityKeysRequest.Builder} to create a request.
     * @return Result of the ListSecurityKeys operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSecurityKeysResponse listSecurityKeys(Consumer<ListSecurityKeysRequest.Builder> listSecurityKeysRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listSecurityKeys(ListSecurityKeysRequest.builder().applyMutation(listSecurityKeysRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all security keys associated with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityKeys(software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityKeysIterable responses = client.listSecurityKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListSecurityKeysIterable responses = client
     *             .listSecurityKeysPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityKeysIterable responses = client.listSecurityKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityKeys(software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest)} operation.</b>
     * </p>
     *
     * @param listSecurityKeysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSecurityKeysIterable listSecurityKeysPaginator(ListSecurityKeysRequest listSecurityKeysRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all security keys associated with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityKeys(software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityKeysIterable responses = client.listSecurityKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListSecurityKeysIterable responses = client
     *             .listSecurityKeysPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityKeysIterable responses = client.listSecurityKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityKeys(software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityKeysRequest.Builder} avoiding the need
     * to create one manually via {@link ListSecurityKeysRequest#builder()}
     * </p>
     *
     * @param listSecurityKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityKeysRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSecurityKeysIterable listSecurityKeysPaginator(Consumer<ListSecurityKeysRequest.Builder> listSecurityKeysRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listSecurityKeysPaginator(ListSecurityKeysRequest.builder().applyMutation(listSecurityKeysRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the permissions granted to a security profile.
     * </p>
     *
     * @param listSecurityProfilePermissionsRequest
     * @return Result of the ListSecurityProfilePermissions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityProfilePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfilePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityProfilePermissionsResponse listSecurityProfilePermissions(
            ListSecurityProfilePermissionsRequest listSecurityProfilePermissionsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the permissions granted to a security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityProfilePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSecurityProfilePermissionsRequest#builder()}
     * </p>
     *
     * @param listSecurityProfilePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityProfilePermissionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListSecurityProfilePermissions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityProfilePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfilePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityProfilePermissionsResponse listSecurityProfilePermissions(
            Consumer<ListSecurityProfilePermissionsRequest.Builder> listSecurityProfilePermissionsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listSecurityProfilePermissions(ListSecurityProfilePermissionsRequest.builder()
                .applyMutation(listSecurityProfilePermissionsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the permissions granted to a security profile.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityProfilePermissions(software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityProfilePermissionsIterable responses = client.listSecurityProfilePermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListSecurityProfilePermissionsIterable responses = client
     *             .listSecurityProfilePermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityProfilePermissionsIterable responses = client.listSecurityProfilePermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityProfilePermissions(software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityProfilePermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityProfilePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfilePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityProfilePermissionsIterable listSecurityProfilePermissionsPaginator(
            ListSecurityProfilePermissionsRequest listSecurityProfilePermissionsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the permissions granted to a security profile.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityProfilePermissions(software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityProfilePermissionsIterable responses = client.listSecurityProfilePermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListSecurityProfilePermissionsIterable responses = client
     *             .listSecurityProfilePermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityProfilePermissionsIterable responses = client.listSecurityProfilePermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityProfilePermissions(software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityProfilePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSecurityProfilePermissionsRequest#builder()}
     * </p>
     *
     * @param listSecurityProfilePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityProfilePermissionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityProfilePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfilePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityProfilePermissionsIterable listSecurityProfilePermissionsPaginator(
            Consumer<ListSecurityProfilePermissionsRequest.Builder> listSecurityProfilePermissionsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listSecurityProfilePermissionsPaginator(ListSecurityProfilePermissionsRequest.builder()
                .applyMutation(listSecurityProfilePermissionsRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the security profiles for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about security profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a>
     * in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listSecurityProfilesRequest
     * @return Result of the ListSecurityProfiles operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecurityProfilesResponse listSecurityProfiles(ListSecurityProfilesRequest listSecurityProfilesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the security profiles for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about security profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a>
     * in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityProfilesRequest#builder()}
     * </p>
     *
     * @param listSecurityProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListSecurityProfiles operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecurityProfilesResponse listSecurityProfiles(
            Consumer<ListSecurityProfilesRequest.Builder> listSecurityProfilesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listSecurityProfiles(ListSecurityProfilesRequest.builder().applyMutation(listSecurityProfilesRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the security profiles for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about security profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a>
     * in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityProfiles(software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityProfilesIterable responses = client.listSecurityProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListSecurityProfilesIterable responses = client
     *             .listSecurityProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityProfilesIterable responses = client.listSecurityProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityProfiles(software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecurityProfilesIterable listSecurityProfilesPaginator(ListSecurityProfilesRequest listSecurityProfilesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the security profiles for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about security profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a>
     * in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityProfiles(software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityProfilesIterable responses = client.listSecurityProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListSecurityProfilesIterable responses = client
     *             .listSecurityProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListSecurityProfilesIterable responses = client.listSecurityProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityProfiles(software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityProfilesRequest#builder()}
     * </p>
     *
     * @param listSecurityProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecurityProfilesIterable listSecurityProfilesPaginator(
            Consumer<ListSecurityProfilesRequest.Builder> listSecurityProfilesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listSecurityProfilesPaginator(ListSecurityProfilesRequest.builder().applyMutation(listSecurityProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <p>
     * For sample policies that use tags, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon
     * Connect Identity-Based Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <p>
     * For sample policies that use tags, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon
     * Connect Identity-Based Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            InvalidParameterException, InternalServiceException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the use cases for the integration association.
     * </p>
     *
     * @param listUseCasesRequest
     *        Provides summary information about the use cases for the specified integration association.
     * @return Result of the ListUseCases operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUseCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUseCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUseCasesResponse listUseCases(ListUseCasesRequest listUseCasesRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the use cases for the integration association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUseCasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListUseCasesRequest#builder()}
     * </p>
     *
     * @param listUseCasesRequest
     *        A {@link Consumer} that will call methods on {@link ListUseCasesRequest.Builder} to create a request.
     *        Provides summary information about the use cases for the specified integration association.
     * @return Result of the ListUseCases operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUseCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUseCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUseCasesResponse listUseCases(Consumer<ListUseCasesRequest.Builder> listUseCasesRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listUseCases(ListUseCasesRequest.builder().applyMutation(listUseCasesRequest).build());
    }

    /**
     * <p>
     * Lists the use cases for the integration association.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUseCases(software.amazon.awssdk.services.connect.model.ListUseCasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUseCasesIterable responses = client.listUseCasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListUseCasesIterable responses = client.listUseCasesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListUseCasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUseCasesIterable responses = client.listUseCasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUseCases(software.amazon.awssdk.services.connect.model.ListUseCasesRequest)} operation.</b>
     * </p>
     *
     * @param listUseCasesRequest
     *        Provides summary information about the use cases for the specified integration association.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUseCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUseCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUseCasesIterable listUseCasesPaginator(ListUseCasesRequest listUseCasesRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the use cases for the integration association.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUseCases(software.amazon.awssdk.services.connect.model.ListUseCasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUseCasesIterable responses = client.listUseCasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListUseCasesIterable responses = client.listUseCasesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListUseCasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUseCasesIterable responses = client.listUseCasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUseCases(software.amazon.awssdk.services.connect.model.ListUseCasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUseCasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListUseCasesRequest#builder()}
     * </p>
     *
     * @param listUseCasesRequest
     *        A {@link Consumer} that will call methods on {@link ListUseCasesRequest.Builder} to create a request.
     *        Provides summary information about the use cases for the specified integration association.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUseCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUseCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUseCasesIterable listUseCasesPaginator(Consumer<ListUseCasesRequest.Builder> listUseCasesRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listUseCasesPaginator(ListUseCasesRequest.builder().applyMutation(listUseCasesRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about agent hierarchies, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html">Set Up Agent Hierarchies</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listUserHierarchyGroupsRequest
     * @return Result of the ListUserHierarchyGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUserHierarchyGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUserHierarchyGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserHierarchyGroupsResponse listUserHierarchyGroups(ListUserHierarchyGroupsRequest listUserHierarchyGroupsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about agent hierarchies, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html">Set Up Agent Hierarchies</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserHierarchyGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListUserHierarchyGroupsRequest#builder()}
     * </p>
     *
     * @param listUserHierarchyGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserHierarchyGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListUserHierarchyGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUserHierarchyGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUserHierarchyGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserHierarchyGroupsResponse listUserHierarchyGroups(
            Consumer<ListUserHierarchyGroupsRequest.Builder> listUserHierarchyGroupsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listUserHierarchyGroups(ListUserHierarchyGroupsRequest.builder().applyMutation(listUserHierarchyGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about agent hierarchies, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html">Set Up Agent Hierarchies</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUserHierarchyGroups(software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUserHierarchyGroupsIterable responses = client.listUserHierarchyGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListUserHierarchyGroupsIterable responses = client
     *             .listUserHierarchyGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUserHierarchyGroupsIterable responses = client.listUserHierarchyGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserHierarchyGroups(software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserHierarchyGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUserHierarchyGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUserHierarchyGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserHierarchyGroupsIterable listUserHierarchyGroupsPaginator(
            ListUserHierarchyGroupsRequest listUserHierarchyGroupsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about agent hierarchies, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html">Set Up Agent Hierarchies</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUserHierarchyGroups(software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUserHierarchyGroupsIterable responses = client.listUserHierarchyGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListUserHierarchyGroupsIterable responses = client
     *             .listUserHierarchyGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUserHierarchyGroupsIterable responses = client.listUserHierarchyGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserHierarchyGroups(software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserHierarchyGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListUserHierarchyGroupsRequest#builder()}
     * </p>
     *
     * @param listUserHierarchyGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserHierarchyGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUserHierarchyGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUserHierarchyGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserHierarchyGroupsIterable listUserHierarchyGroupsPaginator(
            Consumer<ListUserHierarchyGroupsRequest.Builder> listUserHierarchyGroupsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listUserHierarchyGroupsPaginator(ListUserHierarchyGroupsRequest.builder()
                .applyMutation(listUserHierarchyGroupsRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the users for the specified Amazon Connect instance.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the users for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return Result of the ListUsers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the users for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.connect.model.ListUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.connect.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the users for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.connect.model.ListUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.connect.model.ListUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Changes the current status of a user or agent in Amazon Connect. If the agent is currently handling a contact,
     * this sets the agent's next status.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html">Agent status</a> and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-next-status.html">Set your next status</a> in the
     * <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param putUserStatusRequest
     * @return Result of the PutUserStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.PutUserStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/PutUserStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default PutUserStatusResponse putUserStatus(PutUserStatusRequest putUserStatusRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the current status of a user or agent in Amazon Connect. If the agent is currently handling a contact,
     * this sets the agent's next status.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html">Agent status</a> and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-next-status.html">Set your next status</a> in the
     * <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutUserStatusRequest.Builder} avoiding the need to
     * create one manually via {@link PutUserStatusRequest#builder()}
     * </p>
     *
     * @param putUserStatusRequest
     *        A {@link Consumer} that will call methods on {@link PutUserStatusRequest.Builder} to create a request.
     * @return Result of the PutUserStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.PutUserStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/PutUserStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default PutUserStatusResponse putUserStatus(Consumer<PutUserStatusRequest.Builder> putUserStatusRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return putUserStatus(PutUserStatusRequest.builder().applyMutation(putUserStatusRequest).build());
    }

    /**
     * <p>
     * Releases a phone number previously claimed to an Amazon Connect instance.
     * </p>
     *
     * @param releasePhoneNumberRequest
     * @return Result of the ReleasePhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ReleasePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ReleasePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default ReleasePhoneNumberResponse releasePhoneNumber(ReleasePhoneNumberRequest releasePhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            ResourceInUseException, IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Releases a phone number previously claimed to an Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReleasePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link ReleasePhoneNumberRequest#builder()}
     * </p>
     *
     * @param releasePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link ReleasePhoneNumberRequest.Builder} to create a
     *        request.
     * @return Result of the ReleasePhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ReleasePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ReleasePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default ReleasePhoneNumberResponse releasePhoneNumber(Consumer<ReleasePhoneNumberRequest.Builder> releasePhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            ResourceInUseException, IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        return releasePhoneNumber(ReleasePhoneNumberRequest.builder().applyMutation(releasePhoneNumberRequest).build());
    }

    /**
     * <p>
     * When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API
     * resumes recording the call.
     * </p>
     * <p>
     * Only voice recordings are supported at this time.
     * </p>
     *
     * @param resumeContactRecordingRequest
     * @return Result of the ResumeContactRecording operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ResumeContactRecording
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ResumeContactRecording"
     *      target="_top">AWS API Documentation</a>
     */
    default ResumeContactRecordingResponse resumeContactRecording(ResumeContactRecordingRequest resumeContactRecordingRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API
     * resumes recording the call.
     * </p>
     * <p>
     * Only voice recordings are supported at this time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeContactRecordingRequest.Builder} avoiding the
     * need to create one manually via {@link ResumeContactRecordingRequest#builder()}
     * </p>
     *
     * @param resumeContactRecordingRequest
     *        A {@link Consumer} that will call methods on {@link ResumeContactRecordingRequest.Builder} to create a
     *        request.
     * @return Result of the ResumeContactRecording operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ResumeContactRecording
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ResumeContactRecording"
     *      target="_top">AWS API Documentation</a>
     */
    default ResumeContactRecordingResponse resumeContactRecording(
            Consumer<ResumeContactRecordingRequest.Builder> resumeContactRecordingRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return resumeContactRecording(ResumeContactRecordingRequest.builder().applyMutation(resumeContactRecordingRequest)
                .build());
    }

    /**
     * <p>
     * Searches for available phone numbers that you can claim to your Amazon Connect instance.
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     * @return Result of the SearchAvailablePhoneNumbers operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchAvailablePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAvailablePhoneNumbersResponse searchAvailablePhoneNumbers(
            SearchAvailablePhoneNumbersRequest searchAvailablePhoneNumbersRequest) throws InvalidParameterException,
            ThrottlingException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for available phone numbers that you can claim to your Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAvailablePhoneNumbersRequest.Builder}
     * avoiding the need to create one manually via {@link SearchAvailablePhoneNumbersRequest#builder()}
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link SearchAvailablePhoneNumbersRequest.Builder} to create
     *        a request.
     * @return Result of the SearchAvailablePhoneNumbers operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchAvailablePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAvailablePhoneNumbersResponse searchAvailablePhoneNumbers(
            Consumer<SearchAvailablePhoneNumbersRequest.Builder> searchAvailablePhoneNumbersRequest)
            throws InvalidParameterException, ThrottlingException, InternalServiceException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectException {
        return searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest.builder()
                .applyMutation(searchAvailablePhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Searches for available phone numbers that you can claim to your Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAvailablePhoneNumbers(software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchAvailablePhoneNumbersIterable responses = client.searchAvailablePhoneNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.SearchAvailablePhoneNumbersIterable responses = client
     *             .searchAvailablePhoneNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchAvailablePhoneNumbersIterable responses = client.searchAvailablePhoneNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAvailablePhoneNumbers(software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchAvailablePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAvailablePhoneNumbersIterable searchAvailablePhoneNumbersPaginator(
            SearchAvailablePhoneNumbersRequest searchAvailablePhoneNumbersRequest) throws InvalidParameterException,
            ThrottlingException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for available phone numbers that you can claim to your Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAvailablePhoneNumbers(software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchAvailablePhoneNumbersIterable responses = client.searchAvailablePhoneNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.SearchAvailablePhoneNumbersIterable responses = client
     *             .searchAvailablePhoneNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchAvailablePhoneNumbersIterable responses = client.searchAvailablePhoneNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAvailablePhoneNumbers(software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAvailablePhoneNumbersRequest.Builder}
     * avoiding the need to create one manually via {@link SearchAvailablePhoneNumbersRequest#builder()}
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link SearchAvailablePhoneNumbersRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchAvailablePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAvailablePhoneNumbersIterable searchAvailablePhoneNumbersPaginator(
            Consumer<SearchAvailablePhoneNumbersRequest.Builder> searchAvailablePhoneNumbersRequest)
            throws InvalidParameterException, ThrottlingException, InternalServiceException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectException {
        return searchAvailablePhoneNumbersPaginator(SearchAvailablePhoneNumbersRequest.builder()
                .applyMutation(searchAvailablePhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Searches users in an Amazon Connect instance, with optional filtering.
     * </p>
     *
     * @param searchUsersRequest
     * @return Result of the SearchUsers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchUsersResponse searchUsers(SearchUsersRequest searchUsersRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches users in an Amazon Connect instance, with optional filtering.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUsersRequest.Builder} avoiding the need to
     * create one manually via {@link SearchUsersRequest#builder()}
     * </p>
     *
     * @param searchUsersRequest
     *        A {@link Consumer} that will call methods on {@link SearchUsersRequest.Builder} to create a request.
     * @return Result of the SearchUsers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchUsersResponse searchUsers(Consumer<SearchUsersRequest.Builder> searchUsersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return searchUsers(SearchUsersRequest.builder().applyMutation(searchUsersRequest).build());
    }

    /**
     * <p>
     * Searches users in an Amazon Connect instance, with optional filtering.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #searchUsers(software.amazon.awssdk.services.connect.model.SearchUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.SearchUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.connect.model.SearchUsersRequest)} operation.</b>
     * </p>
     *
     * @param searchUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchUsersIterable searchUsersPaginator(SearchUsersRequest searchUsersRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches users in an Amazon Connect instance, with optional filtering.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #searchUsers(software.amazon.awssdk.services.connect.model.SearchUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.SearchUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.connect.model.SearchUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUsersRequest.Builder} avoiding the need to
     * create one manually via {@link SearchUsersRequest#builder()}
     * </p>
     *
     * @param searchUsersRequest
     *        A {@link Consumer} that will call methods on {@link SearchUsersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchUsersIterable searchUsersPaginator(Consumer<SearchUsersRequest.Builder> searchUsersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return searchUsersPaginator(SearchUsersRequest.builder().applyMutation(searchUsersRequest).build());
    }

    /**
     * <p>
     * Searches for vocabularies within a specific Amazon Connect instance using <code>State</code>,
     * <code>NameStartsWith</code>, and <code>LanguageCode</code>.
     * </p>
     *
     * @param searchVocabulariesRequest
     * @return Result of the SearchVocabularies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchVocabulariesResponse searchVocabularies(SearchVocabulariesRequest searchVocabulariesRequest)
            throws InvalidRequestException, InternalServiceException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for vocabularies within a specific Amazon Connect instance using <code>State</code>,
     * <code>NameStartsWith</code>, and <code>LanguageCode</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchVocabulariesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchVocabulariesRequest#builder()}
     * </p>
     *
     * @param searchVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link SearchVocabulariesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchVocabularies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchVocabulariesResponse searchVocabularies(Consumer<SearchVocabulariesRequest.Builder> searchVocabulariesRequest)
            throws InvalidRequestException, InternalServiceException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectException {
        return searchVocabularies(SearchVocabulariesRequest.builder().applyMutation(searchVocabulariesRequest).build());
    }

    /**
     * <p>
     * Searches for vocabularies within a specific Amazon Connect instance using <code>State</code>,
     * <code>NameStartsWith</code>, and <code>LanguageCode</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchVocabularies(software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchVocabulariesIterable responses = client.searchVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.SearchVocabulariesIterable responses = client
     *             .searchVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchVocabulariesIterable responses = client.searchVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchVocabularies(software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchVocabulariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchVocabulariesIterable searchVocabulariesPaginator(SearchVocabulariesRequest searchVocabulariesRequest)
            throws InvalidRequestException, InternalServiceException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for vocabularies within a specific Amazon Connect instance using <code>State</code>,
     * <code>NameStartsWith</code>, and <code>LanguageCode</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchVocabularies(software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchVocabulariesIterable responses = client.searchVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.SearchVocabulariesIterable responses = client
     *             .searchVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.SearchVocabulariesIterable responses = client.searchVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchVocabularies(software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchVocabulariesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchVocabulariesRequest#builder()}
     * </p>
     *
     * @param searchVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link SearchVocabulariesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SearchVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchVocabulariesIterable searchVocabulariesPaginator(
            Consumer<SearchVocabulariesRequest.Builder> searchVocabulariesRequest) throws InvalidRequestException,
            InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        return searchVocabulariesPaginator(SearchVocabulariesRequest.builder().applyMutation(searchVocabulariesRequest).build());
    }

    /**
     * <p>
     * Initiates a contact flow to start a new chat for the customer. Response of this API provides a token required to
     * obtain credentials from the <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     * >CreateParticipantConnection</a> API in the Amazon Connect Participant Service.
     * </p>
     * <p>
     * When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the
     * created chat within 5 minutes. This is achieved by invoking <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     * >CreateParticipantConnection</a> with WEBSOCKET and CONNECTION_CREDENTIALS.
     * </p>
     * <p>
     * A 429 error occurs in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * API rate limit is exceeded. API TPS throttling returns a <code>TooManyRequests</code> exception.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">quota for
     * concurrent active chats</a> is exceeded. Active chat throttling returns a <code>LimitExceededException</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you use the <code>ChatDurationInMinutes</code> parameter and receive a 400 error, your account may not support
     * the ability to configure custom chat durations. For more information, contact Amazon Web Services Support.
     * </p>
     * <p>
     * For more information about chat, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat.html">Chat</a> in the <i>Amazon Connect
     * Administrator Guide</i>.
     * </p>
     *
     * @param startChatContactRequest
     * @return Result of the StartChatContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StartChatContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartChatContact" target="_top">AWS API
     *      Documentation</a>
     */
    default StartChatContactResponse startChatContact(StartChatContactRequest startChatContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            LimitExceededException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a contact flow to start a new chat for the customer. Response of this API provides a token required to
     * obtain credentials from the <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     * >CreateParticipantConnection</a> API in the Amazon Connect Participant Service.
     * </p>
     * <p>
     * When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the
     * created chat within 5 minutes. This is achieved by invoking <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     * >CreateParticipantConnection</a> with WEBSOCKET and CONNECTION_CREDENTIALS.
     * </p>
     * <p>
     * A 429 error occurs in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * API rate limit is exceeded. API TPS throttling returns a <code>TooManyRequests</code> exception.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">quota for
     * concurrent active chats</a> is exceeded. Active chat throttling returns a <code>LimitExceededException</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you use the <code>ChatDurationInMinutes</code> parameter and receive a 400 error, your account may not support
     * the ability to configure custom chat durations. For more information, contact Amazon Web Services Support.
     * </p>
     * <p>
     * For more information about chat, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat.html">Chat</a> in the <i>Amazon Connect
     * Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartChatContactRequest.Builder} avoiding the need
     * to create one manually via {@link StartChatContactRequest#builder()}
     * </p>
     *
     * @param startChatContactRequest
     *        A {@link Consumer} that will call methods on {@link StartChatContactRequest.Builder} to create a request.
     * @return Result of the StartChatContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StartChatContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartChatContact" target="_top">AWS API
     *      Documentation</a>
     */
    default StartChatContactResponse startChatContact(Consumer<StartChatContactRequest.Builder> startChatContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            LimitExceededException, AwsServiceException, SdkClientException, ConnectException {
        return startChatContact(StartChatContactRequest.builder().applyMutation(startChatContactRequest).build());
    }

    /**
     * <p>
     * Starts recording the contact:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the API is called <i>before</i> the agent joins the call, recording starts when the agent joins the call.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the API is called <i>after</i> the agent joins the call, recording starts at the time of the API call.
     * </p>
     * </li>
     * </ul>
     * <p>
     * StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an
     * ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started
     * and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card
     * number), use SuspendContactRecording and ResumeContactRecording.
     * </p>
     * <p>
     * You can use this API to override the recording behavior configured in the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html">Set recording
     * behavior</a> block.
     * </p>
     * <p>
     * Only voice recordings are supported at this time.
     * </p>
     *
     * @param startContactRecordingRequest
     * @return Result of the StartContactRecording operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StartContactRecording
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactRecording" target="_top">AWS
     *      API Documentation</a>
     */
    default StartContactRecordingResponse startContactRecording(StartContactRecordingRequest startContactRecordingRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts recording the contact:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the API is called <i>before</i> the agent joins the call, recording starts when the agent joins the call.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the API is called <i>after</i> the agent joins the call, recording starts at the time of the API call.
     * </p>
     * </li>
     * </ul>
     * <p>
     * StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an
     * ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started
     * and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card
     * number), use SuspendContactRecording and ResumeContactRecording.
     * </p>
     * <p>
     * You can use this API to override the recording behavior configured in the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html">Set recording
     * behavior</a> block.
     * </p>
     * <p>
     * Only voice recordings are supported at this time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartContactRecordingRequest.Builder} avoiding the
     * need to create one manually via {@link StartContactRecordingRequest#builder()}
     * </p>
     *
     * @param startContactRecordingRequest
     *        A {@link Consumer} that will call methods on {@link StartContactRecordingRequest.Builder} to create a
     *        request.
     * @return Result of the StartContactRecording operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StartContactRecording
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactRecording" target="_top">AWS
     *      API Documentation</a>
     */
    default StartContactRecordingResponse startContactRecording(
            Consumer<StartContactRecordingRequest.Builder> startContactRecordingRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        return startContactRecording(StartContactRecordingRequest.builder().applyMutation(startContactRecordingRequest).build());
    }

    /**
     * <p>
     * Initiates real-time message streaming for a new chat contact.
     * </p>
     * <p>
     * For more information about message streaming, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html">Enable real-time chat
     * message streaming</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param startContactStreamingRequest
     * @return Result of the StartContactStreaming operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StartContactStreaming
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactStreaming" target="_top">AWS
     *      API Documentation</a>
     */
    default StartContactStreamingResponse startContactStreaming(StartContactStreamingRequest startContactStreamingRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            LimitExceededException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates real-time message streaming for a new chat contact.
     * </p>
     * <p>
     * For more information about message streaming, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html">Enable real-time chat
     * message streaming</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartContactStreamingRequest.Builder} avoiding the
     * need to create one manually via {@link StartContactStreamingRequest#builder()}
     * </p>
     *
     * @param startContactStreamingRequest
     *        A {@link Consumer} that will call methods on {@link StartContactStreamingRequest.Builder} to create a
     *        request.
     * @return Result of the StartContactStreaming operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StartContactStreaming
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactStreaming" target="_top">AWS
     *      API Documentation</a>
     */
    default StartContactStreamingResponse startContactStreaming(
            Consumer<StartContactStreamingRequest.Builder> startContactStreamingRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, LimitExceededException,
            AwsServiceException, SdkClientException, ConnectException {
        return startContactStreaming(StartContactStreamingRequest.builder().applyMutation(startContactStreamingRequest).build());
    }

    /**
     * <p>
     * Places an outbound call to a contact, and then initiates the contact flow. It performs the actions in the contact
     * flow that's specified (in <code>ContactFlowId</code>).
     * </p>
     * <p>
     * Agents do not initiate the outbound API, which means that they do not dial the contact. If the contact flow
     * places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent,
     * like any other inbound case.
     * </p>
     * <p>
     * There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.
     * </p>
     * <note>
     * <p>
     * UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must
     * submit a service quota increase request. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect
     * Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Campaign calls are not allowed by default. Before you can make a call with <code>TrafficType</code> =
     * <code>CAMPAIGN</code>, you must submit a service quota increase request. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect
     * Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </note>
     *
     * @param startOutboundVoiceContactRequest
     * @return Result of the StartOutboundVoiceContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DestinationNotAllowedException
     *         Outbound calls to the destination number are not allowed.
     * @throws OutboundContactNotPermittedException
     *         The contact is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StartOutboundVoiceContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartOutboundVoiceContact"
     *      target="_top">AWS API Documentation</a>
     */
    default StartOutboundVoiceContactResponse startOutboundVoiceContact(
            StartOutboundVoiceContactRequest startOutboundVoiceContactRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, LimitExceededException,
            DestinationNotAllowedException, OutboundContactNotPermittedException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Places an outbound call to a contact, and then initiates the contact flow. It performs the actions in the contact
     * flow that's specified (in <code>ContactFlowId</code>).
     * </p>
     * <p>
     * Agents do not initiate the outbound API, which means that they do not dial the contact. If the contact flow
     * places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent,
     * like any other inbound case.
     * </p>
     * <p>
     * There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.
     * </p>
     * <note>
     * <p>
     * UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must
     * submit a service quota increase request. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect
     * Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Campaign calls are not allowed by default. Before you can make a call with <code>TrafficType</code> =
     * <code>CAMPAIGN</code>, you must submit a service quota increase request. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect
     * Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartOutboundVoiceContactRequest.Builder} avoiding
     * the need to create one manually via {@link StartOutboundVoiceContactRequest#builder()}
     * </p>
     *
     * @param startOutboundVoiceContactRequest
     *        A {@link Consumer} that will call methods on {@link StartOutboundVoiceContactRequest.Builder} to create a
     *        request.
     * @return Result of the StartOutboundVoiceContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DestinationNotAllowedException
     *         Outbound calls to the destination number are not allowed.
     * @throws OutboundContactNotPermittedException
     *         The contact is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StartOutboundVoiceContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartOutboundVoiceContact"
     *      target="_top">AWS API Documentation</a>
     */
    default StartOutboundVoiceContactResponse startOutboundVoiceContact(
            Consumer<StartOutboundVoiceContactRequest.Builder> startOutboundVoiceContactRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, LimitExceededException,
            DestinationNotAllowedException, OutboundContactNotPermittedException, AwsServiceException, SdkClientException,
            ConnectException {
        return startOutboundVoiceContact(StartOutboundVoiceContactRequest.builder()
                .applyMutation(startOutboundVoiceContactRequest).build());
    }

    /**
     * <p>
     * Initiates a contact flow to start a new task.
     * </p>
     *
     * @param startTaskContactRequest
     * @return Result of the StartTaskContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StartTaskContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartTaskContact" target="_top">AWS API
     *      Documentation</a>
     */
    default StartTaskContactResponse startTaskContact(StartTaskContactRequest startTaskContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a contact flow to start a new task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTaskContactRequest.Builder} avoiding the need
     * to create one manually via {@link StartTaskContactRequest#builder()}
     * </p>
     *
     * @param startTaskContactRequest
     *        A {@link Consumer} that will call methods on {@link StartTaskContactRequest.Builder} to create a request.
     * @return Result of the StartTaskContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StartTaskContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartTaskContact" target="_top">AWS API
     *      Documentation</a>
     */
    default StartTaskContactResponse startTaskContact(Consumer<StartTaskContactRequest.Builder> startTaskContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return startTaskContact(StartTaskContactRequest.builder().applyMutation(startTaskContactRequest).build());
    }

    /**
     * <p>
     * Ends the specified contact. This call does not work for the following initiation methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISCONNECT
     * </p>
     * </li>
     * <li>
     * <p>
     * TRANSFER
     * </p>
     * </li>
     * <li>
     * <p>
     * QUEUE_TRANSFER
     * </p>
     * </li>
     * </ul>
     *
     * @param stopContactRequest
     * @return Result of the StopContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ContactNotFoundException
     *         The contact with the specified ID is not active or does not exist.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StopContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContact" target="_top">AWS API
     *      Documentation</a>
     */
    default StopContactResponse stopContact(StopContactRequest stopContactRequest) throws InvalidRequestException,
            ContactNotFoundException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ends the specified contact. This call does not work for the following initiation methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISCONNECT
     * </p>
     * </li>
     * <li>
     * <p>
     * TRANSFER
     * </p>
     * </li>
     * <li>
     * <p>
     * QUEUE_TRANSFER
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopContactRequest.Builder} avoiding the need to
     * create one manually via {@link StopContactRequest#builder()}
     * </p>
     *
     * @param stopContactRequest
     *        A {@link Consumer} that will call methods on {@link StopContactRequest.Builder} to create a request.
     * @return Result of the StopContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ContactNotFoundException
     *         The contact with the specified ID is not active or does not exist.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StopContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContact" target="_top">AWS API
     *      Documentation</a>
     */
    default StopContactResponse stopContact(Consumer<StopContactRequest.Builder> stopContactRequest)
            throws InvalidRequestException, ContactNotFoundException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return stopContact(StopContactRequest.builder().applyMutation(stopContactRequest).build());
    }

    /**
     * <p>
     * Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use
     * StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For
     * scenarios where the recording has started and you want to suspend it for sensitive information (for example, to
     * collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.
     * </p>
     * <p>
     * Only voice recordings are supported at this time.
     * </p>
     *
     * @param stopContactRecordingRequest
     * @return Result of the StopContactRecording operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StopContactRecording
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContactRecording" target="_top">AWS
     *      API Documentation</a>
     */
    default StopContactRecordingResponse stopContactRecording(StopContactRecordingRequest stopContactRecordingRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use
     * StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For
     * scenarios where the recording has started and you want to suspend it for sensitive information (for example, to
     * collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.
     * </p>
     * <p>
     * Only voice recordings are supported at this time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopContactRecordingRequest.Builder} avoiding the
     * need to create one manually via {@link StopContactRecordingRequest#builder()}
     * </p>
     *
     * @param stopContactRecordingRequest
     *        A {@link Consumer} that will call methods on {@link StopContactRecordingRequest.Builder} to create a
     *        request.
     * @return Result of the StopContactRecording operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StopContactRecording
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContactRecording" target="_top">AWS
     *      API Documentation</a>
     */
    default StopContactRecordingResponse stopContactRecording(
            Consumer<StopContactRecordingRequest.Builder> stopContactRecordingRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return stopContactRecording(StopContactRecordingRequest.builder().applyMutation(stopContactRecordingRequest).build());
    }

    /**
     * <p>
     * Ends message streaming on a specified contact. To restart message streaming on that contact, call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html"
     * >StartContactStreaming</a> API.
     * </p>
     *
     * @param stopContactStreamingRequest
     * @return Result of the StopContactStreaming operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StopContactStreaming
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContactStreaming" target="_top">AWS
     *      API Documentation</a>
     */
    default StopContactStreamingResponse stopContactStreaming(StopContactStreamingRequest stopContactStreamingRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ends message streaming on a specified contact. To restart message streaming on that contact, call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html"
     * >StartContactStreaming</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopContactStreamingRequest.Builder} avoiding the
     * need to create one manually via {@link StopContactStreamingRequest#builder()}
     * </p>
     *
     * @param stopContactStreamingRequest
     *        A {@link Consumer} that will call methods on {@link StopContactStreamingRequest.Builder} to create a
     *        request.
     * @return Result of the StopContactStreaming operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.StopContactStreaming
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContactStreaming" target="_top">AWS
     *      API Documentation</a>
     */
    default StopContactStreamingResponse stopContactStreaming(
            Consumer<StopContactStreamingRequest.Builder> stopContactStreamingRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        return stopContactStreaming(StopContactStreamingRequest.builder().applyMutation(stopContactStreamingRequest).build());
    }

    /**
     * <p>
     * When a contact is being recorded, this API suspends recording the call. For example, you might suspend the call
     * recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording
     * to restart recording.
     * </p>
     * <p>
     * The period of time that the recording is suspended is filled with silence in the final recording.
     * </p>
     * <p>
     * Only voice recordings are supported at this time.
     * </p>
     *
     * @param suspendContactRecordingRequest
     * @return Result of the SuspendContactRecording operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SuspendContactRecording
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SuspendContactRecording"
     *      target="_top">AWS API Documentation</a>
     */
    default SuspendContactRecordingResponse suspendContactRecording(SuspendContactRecordingRequest suspendContactRecordingRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When a contact is being recorded, this API suspends recording the call. For example, you might suspend the call
     * recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording
     * to restart recording.
     * </p>
     * <p>
     * The period of time that the recording is suspended is filled with silence in the final recording.
     * </p>
     * <p>
     * Only voice recordings are supported at this time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SuspendContactRecordingRequest.Builder} avoiding
     * the need to create one manually via {@link SuspendContactRecordingRequest#builder()}
     * </p>
     *
     * @param suspendContactRecordingRequest
     *        A {@link Consumer} that will call methods on {@link SuspendContactRecordingRequest.Builder} to create a
     *        request.
     * @return Result of the SuspendContactRecording operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.SuspendContactRecording
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SuspendContactRecording"
     *      target="_top">AWS API Documentation</a>
     */
    default SuspendContactRecordingResponse suspendContactRecording(
            Consumer<SuspendContactRecordingRequest.Builder> suspendContactRecordingRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return suspendContactRecording(SuspendContactRecordingRequest.builder().applyMutation(suspendContactRecordingRequest)
                .build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <p>
     * The supported resource types are users, routing profiles, queues, quick connects, contact flows, agent status,
     * hours of operation, and phone number.
     * </p>
     * <p>
     * For sample policies that use tags, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon
     * Connect Identity-Based Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            InvalidParameterException, InternalServiceException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <p>
     * The supported resource types are users, routing profiles, queues, quick connects, contact flows, agent status,
     * hours of operation, and phone number.
     * </p>
     * <p>
     * For sample policies that use tags, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon
     * Connect Identity-Based Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException,
            InvalidParameterException, InternalServiceException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates agent status.
     * </p>
     *
     * @param updateAgentStatusRequest
     * @return Result of the UpdateAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateAgentStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAgentStatusResponse updateAgentStatus(UpdateAgentStatusRequest updateAgentStatusRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates agent status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentStatusRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAgentStatusRequest#builder()}
     * </p>
     *
     * @param updateAgentStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAgentStatusRequest.Builder} to create a request.
     * @return Result of the UpdateAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateAgentStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAgentStatusResponse updateAgentStatus(Consumer<UpdateAgentStatusRequest.Builder> updateAgentStatusRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return updateAgentStatus(UpdateAgentStatusRequest.builder().applyMutation(updateAgentStatusRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Adds or updates user-defined contact information associated with the specified contact. At least one field to be
     * updated must be present in the request.
     * </p>
     * <important>
     * <p>
     * You can add or update user-defined contact information for both ongoing and completed contacts.
     * </p>
     * </important>
     *
     * @param updateContactRequest
     * @return Result of the UpdateContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateContactResponse updateContact(UpdateContactRequest updateContactRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Adds or updates user-defined contact information associated with the specified contact. At least one field to be
     * updated must be present in the request.
     * </p>
     * <important>
     * <p>
     * You can add or update user-defined contact information for both ongoing and completed contacts.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateContactRequest#builder()}
     * </p>
     *
     * @param updateContactRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactRequest.Builder} to create a request.
     * @return Result of the UpdateContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContact" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateContactResponse updateContact(Consumer<UpdateContactRequest.Builder> updateContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return updateContact(UpdateContactRequest.builder().applyMutation(updateContactRequest).build());
    }

    /**
     * <p>
     * Creates or updates user-defined contact attributes associated with the specified contact.
     * </p>
     * <p>
     * You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the
     * call is active, you can update the customer's name or the reason the customer called. You can add notes about
     * steps that the agent took during the call that display to the next agent that takes the call. You can also update
     * attributes for a contact using data from your CRM application and save the data with the contact in Amazon
     * Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.
     * </p>
     * <p>
     * Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about CTR
     * retention and the maximum size of the CTR attributes section, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits"
     * >Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * <b>Important:</b> You cannot use the operation to update attributes for contacts that occurred prior to the
     * release of the API, which was September 12, 2018. You can update attributes only for contacts that started after
     * the release of the API. If you attempt to update attributes for a contact that occurred prior to the release of
     * the API, a 400 error is returned. This applies also to queued callbacks that were initiated prior to the release
     * of the API but are still active in your instance.
     * </p>
     *
     * @param updateContactAttributesRequest
     * @return Result of the UpdateContactAttributes operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactAttributesResponse updateContactAttributes(UpdateContactAttributesRequest updateContactAttributesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates user-defined contact attributes associated with the specified contact.
     * </p>
     * <p>
     * You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the
     * call is active, you can update the customer's name or the reason the customer called. You can add notes about
     * steps that the agent took during the call that display to the next agent that takes the call. You can also update
     * attributes for a contact using data from your CRM application and save the data with the contact in Amazon
     * Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.
     * </p>
     * <p>
     * Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about CTR
     * retention and the maximum size of the CTR attributes section, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits"
     * >Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * <b>Important:</b> You cannot use the operation to update attributes for contacts that occurred prior to the
     * release of the API, which was September 12, 2018. You can update attributes only for contacts that started after
     * the release of the API. If you attempt to update attributes for a contact that occurred prior to the release of
     * the API, a 400 error is returned. This applies also to queued callbacks that were initiated prior to the release
     * of the API but are still active in your instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateContactAttributesRequest#builder()}
     * </p>
     *
     * @param updateContactAttributesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactAttributesRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateContactAttributes operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactAttributesResponse updateContactAttributes(
            Consumer<UpdateContactAttributesRequest.Builder> updateContactAttributesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        return updateContactAttributes(UpdateContactAttributesRequest.builder().applyMutation(updateContactAttributesRequest)
                .build());
    }

    /**
     * <p>
     * Updates the specified contact flow.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     *
     * @param updateContactFlowContentRequest
     * @return Result of the UpdateContactFlowContent operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowException
     *         The contact flow is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactFlowContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowContent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactFlowContentResponse updateContactFlowContent(
            UpdateContactFlowContentRequest updateContactFlowContentRequest) throws InvalidRequestException,
            InvalidContactFlowException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified contact flow.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactFlowContentRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateContactFlowContentRequest#builder()}
     * </p>
     *
     * @param updateContactFlowContentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactFlowContentRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateContactFlowContent operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowException
     *         The contact flow is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactFlowContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowContent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactFlowContentResponse updateContactFlowContent(
            Consumer<UpdateContactFlowContentRequest.Builder> updateContactFlowContentRequest) throws InvalidRequestException,
            InvalidContactFlowException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateContactFlowContent(UpdateContactFlowContentRequest.builder().applyMutation(updateContactFlowContentRequest)
                .build());
    }

    /**
     * <p>
     * Updates metadata about specified contact flow.
     * </p>
     *
     * @param updateContactFlowMetadataRequest
     * @return Result of the UpdateContactFlowMetadata operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactFlowMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactFlowMetadataResponse updateContactFlowMetadata(
            UpdateContactFlowMetadataRequest updateContactFlowMetadataRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates metadata about specified contact flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactFlowMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateContactFlowMetadataRequest#builder()}
     * </p>
     *
     * @param updateContactFlowMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactFlowMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateContactFlowMetadata operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactFlowMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactFlowMetadataResponse updateContactFlowMetadata(
            Consumer<UpdateContactFlowMetadataRequest.Builder> updateContactFlowMetadataRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateContactFlowMetadata(UpdateContactFlowMetadataRequest.builder()
                .applyMutation(updateContactFlowMetadataRequest).build());
    }

    /**
     * <p>
     * Updates specified contact flow module for the specified Amazon Connect instance.
     * </p>
     *
     * @param updateContactFlowModuleContentRequest
     * @return Result of the UpdateContactFlowModuleContent operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowModuleException
     *         The problems with the module. Please fix before trying again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactFlowModuleContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowModuleContent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactFlowModuleContentResponse updateContactFlowModuleContent(
            UpdateContactFlowModuleContentRequest updateContactFlowModuleContentRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidContactFlowModuleException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates specified contact flow module for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactFlowModuleContentRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateContactFlowModuleContentRequest#builder()}
     * </p>
     *
     * @param updateContactFlowModuleContentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactFlowModuleContentRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateContactFlowModuleContent operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowModuleException
     *         The problems with the module. Please fix before trying again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactFlowModuleContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowModuleContent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactFlowModuleContentResponse updateContactFlowModuleContent(
            Consumer<UpdateContactFlowModuleContentRequest.Builder> updateContactFlowModuleContentRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidContactFlowModuleException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateContactFlowModuleContent(UpdateContactFlowModuleContentRequest.builder()
                .applyMutation(updateContactFlowModuleContentRequest).build());
    }

    /**
     * <p>
     * Updates metadata about specified contact flow module.
     * </p>
     *
     * @param updateContactFlowModuleMetadataRequest
     * @return Result of the UpdateContactFlowModuleMetadata operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactFlowModuleMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowModuleMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactFlowModuleMetadataResponse updateContactFlowModuleMetadata(
            UpdateContactFlowModuleMetadataRequest updateContactFlowModuleMetadataRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates metadata about specified contact flow module.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactFlowModuleMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateContactFlowModuleMetadataRequest#builder()}
     * </p>
     *
     * @param updateContactFlowModuleMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactFlowModuleMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateContactFlowModuleMetadata operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactFlowModuleMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowModuleMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactFlowModuleMetadataResponse updateContactFlowModuleMetadata(
            Consumer<UpdateContactFlowModuleMetadataRequest.Builder> updateContactFlowModuleMetadataRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, DuplicateResourceException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return updateContactFlowModuleMetadata(UpdateContactFlowModuleMetadataRequest.builder()
                .applyMutation(updateContactFlowModuleMetadataRequest).build());
    }

    /**
     * <p>
     * The name of the contact flow.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     *
     * @param updateContactFlowNameRequest
     * @return Result of the UpdateContactFlowName operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactFlowName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowName" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateContactFlowNameResponse updateContactFlowName(UpdateContactFlowNameRequest updateContactFlowNameRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The name of the contact flow.
     * </p>
     * <p>
     * You can also create and update contact flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactFlowNameRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateContactFlowNameRequest#builder()}
     * </p>
     *
     * @param updateContactFlowNameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactFlowNameRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateContactFlowName operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactFlowName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowName" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateContactFlowNameResponse updateContactFlowName(
            Consumer<UpdateContactFlowNameRequest.Builder> updateContactFlowNameRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateContactFlowName(UpdateContactFlowNameRequest.builder().applyMutation(updateContactFlowNameRequest).build());
    }

    /**
     * <p>
     * Updates the scheduled time of a task contact that is already scheduled.
     * </p>
     *
     * @param updateContactScheduleRequest
     * @return Result of the UpdateContactSchedule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateContactScheduleResponse updateContactSchedule(UpdateContactScheduleRequest updateContactScheduleRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            LimitExceededException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the scheduled time of a task contact that is already scheduled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateContactScheduleRequest#builder()}
     * </p>
     *
     * @param updateContactScheduleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateContactSchedule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateContactSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateContactScheduleResponse updateContactSchedule(
            Consumer<UpdateContactScheduleRequest.Builder> updateContactScheduleRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateContactSchedule(UpdateContactScheduleRequest.builder().applyMutation(updateContactScheduleRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the hours of operation.
     * </p>
     *
     * @param updateHoursOfOperationRequest
     * @return Result of the UpdateHoursOfOperation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateHoursOfOperationResponse updateHoursOfOperation(UpdateHoursOfOperationRequest updateHoursOfOperationRequest)
            throws DuplicateResourceException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the hours of operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHoursOfOperationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param updateHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateHoursOfOperationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateHoursOfOperation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateHoursOfOperationResponse updateHoursOfOperation(
            Consumer<UpdateHoursOfOperationRequest.Builder> updateHoursOfOperationRequest) throws DuplicateResourceException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateHoursOfOperation(UpdateHoursOfOperationRequest.builder().applyMutation(updateHoursOfOperationRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the value for the specified attribute type.
     * </p>
     *
     * @param updateInstanceAttributeRequest
     * @return Result of the UpdateInstanceAttribute operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateInstanceAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateInstanceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInstanceAttributeResponse updateInstanceAttribute(UpdateInstanceAttributeRequest updateInstanceAttributeRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the value for the specified attribute type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInstanceAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateInstanceAttributeRequest#builder()}
     * </p>
     *
     * @param updateInstanceAttributeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInstanceAttributeRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateInstanceAttribute operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateInstanceAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateInstanceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInstanceAttributeResponse updateInstanceAttribute(
            Consumer<UpdateInstanceAttributeRequest.Builder> updateInstanceAttributeRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return updateInstanceAttribute(UpdateInstanceAttributeRequest.builder().applyMutation(updateInstanceAttributeRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates an existing configuration for a resource type. This API is idempotent.
     * </p>
     *
     * @param updateInstanceStorageConfigRequest
     * @return Result of the UpdateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInstanceStorageConfigResponse updateInstanceStorageConfig(
            UpdateInstanceStorageConfigRequest updateInstanceStorageConfigRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates an existing configuration for a resource type. This API is idempotent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInstanceStorageConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateInstanceStorageConfigRequest#builder()}
     * </p>
     *
     * @param updateInstanceStorageConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInstanceStorageConfigRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInstanceStorageConfigResponse updateInstanceStorageConfig(
            Consumer<UpdateInstanceStorageConfigRequest.Builder> updateInstanceStorageConfigRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return updateInstanceStorageConfig(UpdateInstanceStorageConfigRequest.builder()
                .applyMutation(updateInstanceStorageConfigRequest).build());
    }

    /**
     * <p>
     * Updates your claimed phone number from its current Amazon Connect instance to another Amazon Connect instance in
     * the same Region.
     * </p>
     *
     * @param updatePhoneNumberRequest
     * @return Result of the UpdatePhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdatePhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePhoneNumberResponse updatePhoneNumber(UpdatePhoneNumberRequest updatePhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            ResourceInUseException, IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates your claimed phone number from its current Amazon Connect instance to another Amazon Connect instance in
     * the same Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePhoneNumberRequest#builder()}
     * </p>
     *
     * @param updatePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePhoneNumberRequest.Builder} to create a request.
     * @return Result of the UpdatePhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdatePhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePhoneNumberResponse updatePhoneNumber(Consumer<UpdatePhoneNumberRequest.Builder> updatePhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            ResourceInUseException, IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        return updatePhoneNumber(UpdatePhoneNumberRequest.builder().applyMutation(updatePhoneNumberRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the hours of operation for the specified queue.
     * </p>
     *
     * @param updateQueueHoursOfOperationRequest
     * @return Result of the UpdateQueueHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQueueHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQueueHoursOfOperationResponse updateQueueHoursOfOperation(
            UpdateQueueHoursOfOperationRequest updateQueueHoursOfOperationRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the hours of operation for the specified queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueHoursOfOperationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateQueueHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param updateQueueHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQueueHoursOfOperationRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateQueueHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQueueHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQueueHoursOfOperationResponse updateQueueHoursOfOperation(
            Consumer<UpdateQueueHoursOfOperationRequest.Builder> updateQueueHoursOfOperationRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateQueueHoursOfOperation(UpdateQueueHoursOfOperationRequest.builder()
                .applyMutation(updateQueueHoursOfOperationRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the maximum number of contacts allowed in a queue before it is considered full.
     * </p>
     *
     * @param updateQueueMaxContactsRequest
     * @return Result of the UpdateQueueMaxContacts operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQueueMaxContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueMaxContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQueueMaxContactsResponse updateQueueMaxContacts(UpdateQueueMaxContactsRequest updateQueueMaxContactsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the maximum number of contacts allowed in a queue before it is considered full.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueMaxContactsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateQueueMaxContactsRequest#builder()}
     * </p>
     *
     * @param updateQueueMaxContactsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQueueMaxContactsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateQueueMaxContacts operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQueueMaxContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueMaxContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQueueMaxContactsResponse updateQueueMaxContacts(
            Consumer<UpdateQueueMaxContactsRequest.Builder> updateQueueMaxContactsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return updateQueueMaxContacts(UpdateQueueMaxContactsRequest.builder().applyMutation(updateQueueMaxContactsRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the name and description of a queue. At least <code>Name</code> or <code>Description</code> must be
     * provided.
     * </p>
     *
     * @param updateQueueNameRequest
     * @return Result of the UpdateQueueName operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQueueName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueName" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQueueNameResponse updateQueueName(UpdateQueueNameRequest updateQueueNameRequest)
            throws DuplicateResourceException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the name and description of a queue. At least <code>Name</code> or <code>Description</code> must be
     * provided.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueNameRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateQueueNameRequest#builder()}
     * </p>
     *
     * @param updateQueueNameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQueueNameRequest.Builder} to create a request.
     * @return Result of the UpdateQueueName operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQueueName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueName" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQueueNameResponse updateQueueName(Consumer<UpdateQueueNameRequest.Builder> updateQueueNameRequest)
            throws DuplicateResourceException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateQueueName(UpdateQueueNameRequest.builder().applyMutation(updateQueueNameRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.
     * </p>
     *
     * @param updateQueueOutboundCallerConfigRequest
     * @return Result of the UpdateQueueOutboundCallerConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQueueOutboundCallerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueOutboundCallerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQueueOutboundCallerConfigResponse updateQueueOutboundCallerConfig(
            UpdateQueueOutboundCallerConfigRequest updateQueueOutboundCallerConfigRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueOutboundCallerConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateQueueOutboundCallerConfigRequest#builder()}
     * </p>
     *
     * @param updateQueueOutboundCallerConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQueueOutboundCallerConfigRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateQueueOutboundCallerConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQueueOutboundCallerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueOutboundCallerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQueueOutboundCallerConfigResponse updateQueueOutboundCallerConfig(
            Consumer<UpdateQueueOutboundCallerConfigRequest.Builder> updateQueueOutboundCallerConfigRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateQueueOutboundCallerConfig(UpdateQueueOutboundCallerConfigRequest.builder()
                .applyMutation(updateQueueOutboundCallerConfigRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the status of the queue.
     * </p>
     *
     * @param updateQueueStatusRequest
     * @return Result of the UpdateQueueStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQueueStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQueueStatusResponse updateQueueStatus(UpdateQueueStatusRequest updateQueueStatusRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates the status of the queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueStatusRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateQueueStatusRequest#builder()}
     * </p>
     *
     * @param updateQueueStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQueueStatusRequest.Builder} to create a request.
     * @return Result of the UpdateQueueStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQueueStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQueueStatusResponse updateQueueStatus(Consumer<UpdateQueueStatusRequest.Builder> updateQueueStatusRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateQueueStatus(UpdateQueueStatusRequest.builder().applyMutation(updateQueueStatusRequest).build());
    }

    /**
     * <p>
     * Updates the configuration settings for the specified quick connect.
     * </p>
     *
     * @param updateQuickConnectConfigRequest
     * @return Result of the UpdateQuickConnectConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQuickConnectConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQuickConnectConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQuickConnectConfigResponse updateQuickConnectConfig(
            UpdateQuickConnectConfigRequest updateQuickConnectConfigRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration settings for the specified quick connect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQuickConnectConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateQuickConnectConfigRequest#builder()}
     * </p>
     *
     * @param updateQuickConnectConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQuickConnectConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateQuickConnectConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQuickConnectConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQuickConnectConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQuickConnectConfigResponse updateQuickConnectConfig(
            Consumer<UpdateQuickConnectConfigRequest.Builder> updateQuickConnectConfigRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return updateQuickConnectConfig(UpdateQuickConnectConfigRequest.builder().applyMutation(updateQuickConnectConfigRequest)
                .build());
    }

    /**
     * <p>
     * Updates the name and description of a quick connect. The request accepts the following data in JSON format. At
     * least <code>Name</code> or <code>Description</code> must be provided.
     * </p>
     *
     * @param updateQuickConnectNameRequest
     * @return Result of the UpdateQuickConnectName operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQuickConnectName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQuickConnectName"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQuickConnectNameResponse updateQuickConnectName(UpdateQuickConnectNameRequest updateQuickConnectNameRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name and description of a quick connect. The request accepts the following data in JSON format. At
     * least <code>Name</code> or <code>Description</code> must be provided.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQuickConnectNameRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateQuickConnectNameRequest#builder()}
     * </p>
     *
     * @param updateQuickConnectNameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQuickConnectNameRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateQuickConnectName operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateQuickConnectName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQuickConnectName"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQuickConnectNameResponse updateQuickConnectName(
            Consumer<UpdateQuickConnectNameRequest.Builder> updateQuickConnectNameRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return updateQuickConnectName(UpdateQuickConnectNameRequest.builder().applyMutation(updateQuickConnectNameRequest)
                .build());
    }

    /**
     * <p>
     * Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.
     * </p>
     *
     * @param updateRoutingProfileConcurrencyRequest
     * @return Result of the UpdateRoutingProfileConcurrency operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateRoutingProfileConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRoutingProfileConcurrencyResponse updateRoutingProfileConcurrency(
            UpdateRoutingProfileConcurrencyRequest updateRoutingProfileConcurrencyRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoutingProfileConcurrencyRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRoutingProfileConcurrencyRequest#builder()}
     * </p>
     *
     * @param updateRoutingProfileConcurrencyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoutingProfileConcurrencyRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateRoutingProfileConcurrency operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateRoutingProfileConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRoutingProfileConcurrencyResponse updateRoutingProfileConcurrency(
            Consumer<UpdateRoutingProfileConcurrencyRequest.Builder> updateRoutingProfileConcurrencyRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateRoutingProfileConcurrency(UpdateRoutingProfileConcurrencyRequest.builder()
                .applyMutation(updateRoutingProfileConcurrencyRequest).build());
    }

    /**
     * <p>
     * Updates the default outbound queue of a routing profile.
     * </p>
     *
     * @param updateRoutingProfileDefaultOutboundQueueRequest
     * @return Result of the UpdateRoutingProfileDefaultOutboundQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateRoutingProfileDefaultOutboundQueue
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileDefaultOutboundQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRoutingProfileDefaultOutboundQueueResponse updateRoutingProfileDefaultOutboundQueue(
            UpdateRoutingProfileDefaultOutboundQueueRequest updateRoutingProfileDefaultOutboundQueueRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the default outbound queue of a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateRoutingProfileDefaultOutboundQueueRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateRoutingProfileDefaultOutboundQueueRequest#builder()}
     * </p>
     *
     * @param updateRoutingProfileDefaultOutboundQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateRoutingProfileDefaultOutboundQueueRequest.Builder} to create a request.
     * @return Result of the UpdateRoutingProfileDefaultOutboundQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateRoutingProfileDefaultOutboundQueue
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileDefaultOutboundQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRoutingProfileDefaultOutboundQueueResponse updateRoutingProfileDefaultOutboundQueue(
            Consumer<UpdateRoutingProfileDefaultOutboundQueueRequest.Builder> updateRoutingProfileDefaultOutboundQueueRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateRoutingProfileDefaultOutboundQueue(UpdateRoutingProfileDefaultOutboundQueueRequest.builder()
                .applyMutation(updateRoutingProfileDefaultOutboundQueueRequest).build());
    }

    /**
     * <p>
     * Updates the name and description of a routing profile. The request accepts the following data in JSON format. At
     * least <code>Name</code> or <code>Description</code> must be provided.
     * </p>
     *
     * @param updateRoutingProfileNameRequest
     * @return Result of the UpdateRoutingProfileName operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateRoutingProfileName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileName"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRoutingProfileNameResponse updateRoutingProfileName(
            UpdateRoutingProfileNameRequest updateRoutingProfileNameRequest) throws DuplicateResourceException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name and description of a routing profile. The request accepts the following data in JSON format. At
     * least <code>Name</code> or <code>Description</code> must be provided.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoutingProfileNameRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateRoutingProfileNameRequest#builder()}
     * </p>
     *
     * @param updateRoutingProfileNameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoutingProfileNameRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRoutingProfileName operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateRoutingProfileName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileName"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRoutingProfileNameResponse updateRoutingProfileName(
            Consumer<UpdateRoutingProfileNameRequest.Builder> updateRoutingProfileNameRequest) throws DuplicateResourceException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateRoutingProfileName(UpdateRoutingProfileNameRequest.builder().applyMutation(updateRoutingProfileNameRequest)
                .build());
    }

    /**
     * <p>
     * Updates the properties associated with a set of queues for a routing profile.
     * </p>
     *
     * @param updateRoutingProfileQueuesRequest
     * @return Result of the UpdateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRoutingProfileQueuesResponse updateRoutingProfileQueues(
            UpdateRoutingProfileQueuesRequest updateRoutingProfileQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties associated with a set of queues for a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoutingProfileQueuesRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateRoutingProfileQueuesRequest#builder()}
     * </p>
     *
     * @param updateRoutingProfileQueuesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoutingProfileQueuesRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRoutingProfileQueuesResponse updateRoutingProfileQueues(
            Consumer<UpdateRoutingProfileQueuesRequest.Builder> updateRoutingProfileQueuesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateRoutingProfileQueues(UpdateRoutingProfileQueuesRequest.builder()
                .applyMutation(updateRoutingProfileQueuesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates a security profile.
     * </p>
     *
     * @param updateSecurityProfileRequest
     * @return Result of the UpdateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSecurityProfileResponse updateSecurityProfile(UpdateSecurityProfileRequest updateSecurityProfileRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Updates a security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSecurityProfileRequest#builder()}
     * </p>
     *
     * @param updateSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSecurityProfileResponse updateSecurityProfile(
            Consumer<UpdateSecurityProfileRequest.Builder> updateSecurityProfileRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return updateSecurityProfile(UpdateSecurityProfileRequest.builder().applyMutation(updateSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Assigns the specified hierarchy group to the specified user.
     * </p>
     *
     * @param updateUserHierarchyRequest
     * @return Result of the UpdateUserHierarchy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserHierarchy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchy" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateUserHierarchyResponse updateUserHierarchy(UpdateUserHierarchyRequest updateUserHierarchyRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns the specified hierarchy group to the specified user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserHierarchyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserHierarchyRequest#builder()}
     * </p>
     *
     * @param updateUserHierarchyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserHierarchyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateUserHierarchy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserHierarchy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchy" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateUserHierarchyResponse updateUserHierarchy(
            Consumer<UpdateUserHierarchyRequest.Builder> updateUserHierarchyRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return updateUserHierarchy(UpdateUserHierarchyRequest.builder().applyMutation(updateUserHierarchyRequest).build());
    }

    /**
     * <p>
     * Updates the name of the user hierarchy group.
     * </p>
     *
     * @param updateUserHierarchyGroupNameRequest
     * @return Result of the UpdateUserHierarchyGroupName operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserHierarchyGroupName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchyGroupName"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserHierarchyGroupNameResponse updateUserHierarchyGroupName(
            UpdateUserHierarchyGroupNameRequest updateUserHierarchyGroupNameRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name of the user hierarchy group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserHierarchyGroupNameRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateUserHierarchyGroupNameRequest#builder()}
     * </p>
     *
     * @param updateUserHierarchyGroupNameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserHierarchyGroupNameRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateUserHierarchyGroupName operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserHierarchyGroupName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchyGroupName"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserHierarchyGroupNameResponse updateUserHierarchyGroupName(
            Consumer<UpdateUserHierarchyGroupNameRequest.Builder> updateUserHierarchyGroupNameRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateUserHierarchyGroupName(UpdateUserHierarchyGroupNameRequest.builder()
                .applyMutation(updateUserHierarchyGroupNameRequest).build());
    }

    /**
     * <p>
     * Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.
     * </p>
     *
     * @param updateUserHierarchyStructureRequest
     * @return Result of the UpdateUserHierarchyStructure operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserHierarchyStructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchyStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserHierarchyStructureResponse updateUserHierarchyStructure(
            UpdateUserHierarchyStructureRequest updateUserHierarchyStructureRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserHierarchyStructureRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateUserHierarchyStructureRequest#builder()}
     * </p>
     *
     * @param updateUserHierarchyStructureRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserHierarchyStructureRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateUserHierarchyStructure operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserHierarchyStructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchyStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserHierarchyStructureResponse updateUserHierarchyStructure(
            Consumer<UpdateUserHierarchyStructureRequest.Builder> updateUserHierarchyStructureRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateUserHierarchyStructure(UpdateUserHierarchyStructureRequest.builder()
                .applyMutation(updateUserHierarchyStructureRequest).build());
    }

    /**
     * <p>
     * Updates the identity information for the specified user.
     * </p>
     * <important>
     * <p>
     * We strongly recommend limiting who has the ability to invoke <code>UpdateUserIdentityInfo</code>. Someone with
     * that ability can change the login credentials of other users by changing their email address. This poses a
     * security risk to your organization. They can change the email address of a user to the attacker's email address,
     * and then reset the password through email. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html">Best Practices
     * for Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </important>
     *
     * @param updateUserIdentityInfoRequest
     * @return Result of the UpdateUserIdentityInfo operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserIdentityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserIdentityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserIdentityInfoResponse updateUserIdentityInfo(UpdateUserIdentityInfoRequest updateUserIdentityInfoRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the identity information for the specified user.
     * </p>
     * <important>
     * <p>
     * We strongly recommend limiting who has the ability to invoke <code>UpdateUserIdentityInfo</code>. Someone with
     * that ability can change the login credentials of other users by changing their email address. This poses a
     * security risk to your organization. They can change the email address of a user to the attacker's email address,
     * and then reset the password through email. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html">Best Practices
     * for Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserIdentityInfoRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserIdentityInfoRequest#builder()}
     * </p>
     *
     * @param updateUserIdentityInfoRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserIdentityInfoRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateUserIdentityInfo operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserIdentityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserIdentityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserIdentityInfoResponse updateUserIdentityInfo(
            Consumer<UpdateUserIdentityInfoRequest.Builder> updateUserIdentityInfoRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return updateUserIdentityInfo(UpdateUserIdentityInfoRequest.builder().applyMutation(updateUserIdentityInfoRequest)
                .build());
    }

    /**
     * <p>
     * Updates the phone configuration settings for the specified user.
     * </p>
     *
     * @param updateUserPhoneConfigRequest
     * @return Result of the UpdateUserPhoneConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserPhoneConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserPhoneConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateUserPhoneConfigResponse updateUserPhoneConfig(UpdateUserPhoneConfigRequest updateUserPhoneConfigRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the phone configuration settings for the specified user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserPhoneConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserPhoneConfigRequest#builder()}
     * </p>
     *
     * @param updateUserPhoneConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserPhoneConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateUserPhoneConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserPhoneConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserPhoneConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateUserPhoneConfigResponse updateUserPhoneConfig(
            Consumer<UpdateUserPhoneConfigRequest.Builder> updateUserPhoneConfigRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return updateUserPhoneConfig(UpdateUserPhoneConfigRequest.builder().applyMutation(updateUserPhoneConfigRequest).build());
    }

    /**
     * <p>
     * Assigns the specified routing profile to the specified user.
     * </p>
     *
     * @param updateUserRoutingProfileRequest
     * @return Result of the UpdateUserRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserRoutingProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserRoutingProfileResponse updateUserRoutingProfile(
            UpdateUserRoutingProfileRequest updateUserRoutingProfileRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns the specified routing profile to the specified user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRoutingProfileRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateUserRoutingProfileRequest#builder()}
     * </p>
     *
     * @param updateUserRoutingProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRoutingProfileRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateUserRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserRoutingProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserRoutingProfileResponse updateUserRoutingProfile(
            Consumer<UpdateUserRoutingProfileRequest.Builder> updateUserRoutingProfileRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return updateUserRoutingProfile(UpdateUserRoutingProfileRequest.builder().applyMutation(updateUserRoutingProfileRequest)
                .build());
    }

    /**
     * <p>
     * Assigns the specified security profiles to the specified user.
     * </p>
     *
     * @param updateUserSecurityProfilesRequest
     * @return Result of the UpdateUserSecurityProfiles operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserSecurityProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserSecurityProfilesResponse updateUserSecurityProfiles(
            UpdateUserSecurityProfilesRequest updateUserSecurityProfilesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns the specified security profiles to the specified user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserSecurityProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateUserSecurityProfilesRequest#builder()}
     * </p>
     *
     * @param updateUserSecurityProfilesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserSecurityProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateUserSecurityProfiles operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.UpdateUserSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserSecurityProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserSecurityProfilesResponse updateUserSecurityProfiles(
            Consumer<UpdateUserSecurityProfilesRequest.Builder> updateUserSecurityProfilesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return updateUserSecurityProfiles(UpdateUserSecurityProfilesRequest.builder()
                .applyMutation(updateUserSecurityProfilesRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
