/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Connect instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Instance::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Instance::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> IDENTITY_MANAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityManagementType").getter(getter(Instance::identityManagementTypeAsString))
            .setter(setter(Builder::identityManagementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityManagementType").build())
            .build();

    private static final SdkField<String> INSTANCE_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceAlias").getter(getter(Instance::instanceAlias)).setter(setter(Builder::instanceAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAlias").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Instance::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(Instance::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<String> INSTANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceStatus").getter(getter(Instance::instanceStatusAsString))
            .setter(setter(Builder::instanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()).build();

    private static final SdkField<InstanceStatusReason> STATUS_REASON_FIELD = SdkField
            .<InstanceStatusReason> builder(MarshallingType.SDK_POJO).memberName("StatusReason")
            .getter(getter(Instance::statusReason)).setter(setter(Builder::statusReason))
            .constructor(InstanceStatusReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Boolean> INBOUND_CALLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InboundCallsEnabled").getter(getter(Instance::inboundCallsEnabled))
            .setter(setter(Builder::inboundCallsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundCallsEnabled").build())
            .build();

    private static final SdkField<Boolean> OUTBOUND_CALLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OutboundCallsEnabled").getter(getter(Instance::outboundCallsEnabled))
            .setter(setter(Builder::outboundCallsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallsEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            IDENTITY_MANAGEMENT_TYPE_FIELD, INSTANCE_ALIAS_FIELD, CREATED_TIME_FIELD, SERVICE_ROLE_FIELD, INSTANCE_STATUS_FIELD,
            STATUS_REASON_FIELD, INBOUND_CALLS_ENABLED_FIELD, OUTBOUND_CALLS_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String identityManagementType;

    private final String instanceAlias;

    private final Instant createdTime;

    private final String serviceRole;

    private final String instanceStatus;

    private final InstanceStatusReason statusReason;

    private final Boolean inboundCallsEnabled;

    private final Boolean outboundCallsEnabled;

    private Instance(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.identityManagementType = builder.identityManagementType;
        this.instanceAlias = builder.instanceAlias;
        this.createdTime = builder.createdTime;
        this.serviceRole = builder.serviceRole;
        this.instanceStatus = builder.instanceStatus;
        this.statusReason = builder.statusReason;
        this.inboundCallsEnabled = builder.inboundCallsEnabled;
        this.outboundCallsEnabled = builder.outboundCallsEnabled;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the instance.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The identity management type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityManagementType} will return {@link DirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identityManagementTypeAsString}.
     * </p>
     * 
     * @return The identity management type.
     * @see DirectoryType
     */
    public final DirectoryType identityManagementType() {
        return DirectoryType.fromValue(identityManagementType);
    }

    /**
     * <p>
     * The identity management type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityManagementType} will return {@link DirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identityManagementTypeAsString}.
     * </p>
     * 
     * @return The identity management type.
     * @see DirectoryType
     */
    public final String identityManagementTypeAsString() {
        return identityManagementType;
    }

    /**
     * <p>
     * The alias of instance.
     * </p>
     * 
     * @return The alias of instance.
     */
    public final String instanceAlias() {
        return instanceAlias;
    }

    /**
     * <p>
     * When the instance was created.
     * </p>
     * 
     * @return When the instance was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The service role of the instance.
     * </p>
     * 
     * @return The service role of the instance.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceStatus}
     * will return {@link InstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceStatusAsString}.
     * </p>
     * 
     * @return The state of the instance.
     * @see InstanceStatus
     */
    public final InstanceStatus instanceStatus() {
        return InstanceStatus.fromValue(instanceStatus);
    }

    /**
     * <p>
     * The state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceStatus}
     * will return {@link InstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceStatusAsString}.
     * </p>
     * 
     * @return The state of the instance.
     * @see InstanceStatus
     */
    public final String instanceStatusAsString() {
        return instanceStatus;
    }

    /**
     * <p>
     * Relevant details why the instance was not successfully created.
     * </p>
     * 
     * @return Relevant details why the instance was not successfully created.
     */
    public final InstanceStatusReason statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Whether inbound calls are enabled.
     * </p>
     * 
     * @return Whether inbound calls are enabled.
     */
    public final Boolean inboundCallsEnabled() {
        return inboundCallsEnabled;
    }

    /**
     * <p>
     * Whether outbound calls are enabled.
     * </p>
     * 
     * @return Whether outbound calls are enabled.
     */
    public final Boolean outboundCallsEnabled() {
        return outboundCallsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(identityManagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceAlias());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(inboundCallsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(outboundCallsEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(identityManagementTypeAsString(), other.identityManagementTypeAsString())
                && Objects.equals(instanceAlias(), other.instanceAlias()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(serviceRole(), other.serviceRole())
                && Objects.equals(instanceStatusAsString(), other.instanceStatusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(inboundCallsEnabled(), other.inboundCallsEnabled())
                && Objects.equals(outboundCallsEnabled(), other.outboundCallsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Instance").add("Id", id()).add("Arn", arn())
                .add("IdentityManagementType", identityManagementTypeAsString())
                .add("InstanceAlias", instanceAlias() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedTime", createdTime()).add("ServiceRole", serviceRole())
                .add("InstanceStatus", instanceStatusAsString()).add("StatusReason", statusReason())
                .add("InboundCallsEnabled", inboundCallsEnabled()).add("OutboundCallsEnabled", outboundCallsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "IdentityManagementType":
            return Optional.ofNullable(clazz.cast(identityManagementTypeAsString()));
        case "InstanceAlias":
            return Optional.ofNullable(clazz.cast(instanceAlias()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "InstanceStatus":
            return Optional.ofNullable(clazz.cast(instanceStatusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "InboundCallsEnabled":
            return Optional.ofNullable(clazz.cast(inboundCallsEnabled()));
        case "OutboundCallsEnabled":
            return Optional.ofNullable(clazz.cast(outboundCallsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param id
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The identity management type.
         * </p>
         * 
         * @param identityManagementType
         *        The identity management type.
         * @see DirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryType
         */
        Builder identityManagementType(String identityManagementType);

        /**
         * <p>
         * The identity management type.
         * </p>
         * 
         * @param identityManagementType
         *        The identity management type.
         * @see DirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryType
         */
        Builder identityManagementType(DirectoryType identityManagementType);

        /**
         * <p>
         * The alias of instance.
         * </p>
         * 
         * @param instanceAlias
         *        The alias of instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAlias(String instanceAlias);

        /**
         * <p>
         * When the instance was created.
         * </p>
         * 
         * @param createdTime
         *        When the instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The service role of the instance.
         * </p>
         * 
         * @param serviceRole
         *        The service role of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The state of the instance.
         * </p>
         * 
         * @param instanceStatus
         *        The state of the instance.
         * @see InstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder instanceStatus(String instanceStatus);

        /**
         * <p>
         * The state of the instance.
         * </p>
         * 
         * @param instanceStatus
         *        The state of the instance.
         * @see InstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStatus
         */
        Builder instanceStatus(InstanceStatus instanceStatus);

        /**
         * <p>
         * Relevant details why the instance was not successfully created.
         * </p>
         * 
         * @param statusReason
         *        Relevant details why the instance was not successfully created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(InstanceStatusReason statusReason);

        /**
         * <p>
         * Relevant details why the instance was not successfully created.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceStatusReason.Builder} avoiding
         * the need to create one manually via {@link InstanceStatusReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceStatusReason.Builder#build()} is called immediately and
         * its result is passed to {@link #statusReason(InstanceStatusReason)}.
         * 
         * @param statusReason
         *        a consumer that will call methods on {@link InstanceStatusReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusReason(InstanceStatusReason)
         */
        default Builder statusReason(Consumer<InstanceStatusReason.Builder> statusReason) {
            return statusReason(InstanceStatusReason.builder().applyMutation(statusReason).build());
        }

        /**
         * <p>
         * Whether inbound calls are enabled.
         * </p>
         * 
         * @param inboundCallsEnabled
         *        Whether inbound calls are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundCallsEnabled(Boolean inboundCallsEnabled);

        /**
         * <p>
         * Whether outbound calls are enabled.
         * </p>
         * 
         * @param outboundCallsEnabled
         *        Whether outbound calls are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCallsEnabled(Boolean outboundCallsEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String identityManagementType;

        private String instanceAlias;

        private Instant createdTime;

        private String serviceRole;

        private String instanceStatus;

        private InstanceStatusReason statusReason;

        private Boolean inboundCallsEnabled;

        private Boolean outboundCallsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            id(model.id);
            arn(model.arn);
            identityManagementType(model.identityManagementType);
            instanceAlias(model.instanceAlias);
            createdTime(model.createdTime);
            serviceRole(model.serviceRole);
            instanceStatus(model.instanceStatus);
            statusReason(model.statusReason);
            inboundCallsEnabled(model.inboundCallsEnabled);
            outboundCallsEnabled(model.outboundCallsEnabled);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getIdentityManagementType() {
            return identityManagementType;
        }

        public final void setIdentityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
        }

        @Override
        public final Builder identityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
            return this;
        }

        @Override
        public final Builder identityManagementType(DirectoryType identityManagementType) {
            this.identityManagementType(identityManagementType == null ? null : identityManagementType.toString());
            return this;
        }

        public final String getInstanceAlias() {
            return instanceAlias;
        }

        public final void setInstanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
        }

        @Override
        public final Builder instanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getInstanceStatus() {
            return instanceStatus;
        }

        public final void setInstanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
        }

        @Override
        public final Builder instanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        @Override
        public final Builder instanceStatus(InstanceStatus instanceStatus) {
            this.instanceStatus(instanceStatus == null ? null : instanceStatus.toString());
            return this;
        }

        public final InstanceStatusReason.Builder getStatusReason() {
            return statusReason != null ? statusReason.toBuilder() : null;
        }

        public final void setStatusReason(InstanceStatusReason.BuilderImpl statusReason) {
            this.statusReason = statusReason != null ? statusReason.build() : null;
        }

        @Override
        public final Builder statusReason(InstanceStatusReason statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Boolean getInboundCallsEnabled() {
            return inboundCallsEnabled;
        }

        public final void setInboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
        }

        @Override
        public final Builder inboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
            return this;
        }

        public final Boolean getOutboundCallsEnabled() {
            return outboundCallsEnabled;
        }

        public final void setOutboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
        }

        @Override
        public final Builder outboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
