/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactFlowsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListContactFlowsResponse.Builder, ListContactFlowsResponse> {
    private static final SdkField<List<ContactFlowSummary>> CONTACT_FLOW_SUMMARY_LIST_FIELD = SdkField
            .<List<ContactFlowSummary>> builder(MarshallingType.LIST)
            .memberName("ContactFlowSummaryList")
            .getter(getter(ListContactFlowsResponse::contactFlowSummaryList))
            .setter(setter(Builder::contactFlowSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactFlowSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactFlowSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContactFlowsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTACT_FLOW_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ContactFlowSummary> contactFlowSummaryList;

    private final String nextToken;

    private ListContactFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.contactFlowSummaryList = builder.contactFlowSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactFlowSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContactFlowSummaryList() {
        return contactFlowSummaryList != null && !(contactFlowSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the contact flows.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactFlowSummaryList} method.
     * </p>
     * 
     * @return Information about the contact flows.
     */
    public final List<ContactFlowSummary> contactFlowSummaryList() {
        return contactFlowSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContactFlowSummaryList() ? contactFlowSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactFlowsResponse)) {
            return false;
        }
        ListContactFlowsResponse other = (ListContactFlowsResponse) obj;
        return hasContactFlowSummaryList() == other.hasContactFlowSummaryList()
                && Objects.equals(contactFlowSummaryList(), other.contactFlowSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactFlowsResponse")
                .add("ContactFlowSummaryList", hasContactFlowSummaryList() ? contactFlowSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactFlowSummaryList":
            return Optional.ofNullable(clazz.cast(contactFlowSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactFlowsResponse, T> g) {
        return obj -> g.apply((ListContactFlowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListContactFlowsResponse> {
        /**
         * <p>
         * Information about the contact flows.
         * </p>
         * 
         * @param contactFlowSummaryList
         *        Information about the contact flows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowSummaryList(Collection<ContactFlowSummary> contactFlowSummaryList);

        /**
         * <p>
         * Information about the contact flows.
         * </p>
         * 
         * @param contactFlowSummaryList
         *        Information about the contact flows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowSummaryList(ContactFlowSummary... contactFlowSummaryList);

        /**
         * <p>
         * Information about the contact flows.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ContactFlowSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ContactFlowSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContactFlowSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #contactFlowSummaryList(List<ContactFlowSummary>)}.
         * 
         * @param contactFlowSummaryList
         *        a consumer that will call methods on {@link List<ContactFlowSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactFlowSummaryList(List<ContactFlowSummary>)
         */
        Builder contactFlowSummaryList(Consumer<ContactFlowSummary.Builder>... contactFlowSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<ContactFlowSummary> contactFlowSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactFlowsResponse model) {
            super(model);
            contactFlowSummaryList(model.contactFlowSummaryList);
            nextToken(model.nextToken);
        }

        public final List<ContactFlowSummary.Builder> getContactFlowSummaryList() {
            List<ContactFlowSummary.Builder> result = ContactFlowSummaryListCopier.copyToBuilder(this.contactFlowSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactFlowSummaryList(Collection<ContactFlowSummary.BuilderImpl> contactFlowSummaryList) {
            this.contactFlowSummaryList = ContactFlowSummaryListCopier.copyFromBuilder(contactFlowSummaryList);
        }

        @Override
        public final Builder contactFlowSummaryList(Collection<ContactFlowSummary> contactFlowSummaryList) {
            this.contactFlowSummaryList = ContactFlowSummaryListCopier.copy(contactFlowSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlowSummaryList(ContactFlowSummary... contactFlowSummaryList) {
            contactFlowSummaryList(Arrays.asList(contactFlowSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlowSummaryList(Consumer<ContactFlowSummary.Builder>... contactFlowSummaryList) {
            contactFlowSummaryList(Stream.of(contactFlowSummaryList)
                    .map(c -> ContactFlowSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContactFlowsResponse build() {
            return new ListContactFlowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
