/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateInstanceStorageConfigRequest extends ConnectRequest implements
        ToCopyableBuilder<AssociateInstanceStorageConfigRequest.Builder, AssociateInstanceStorageConfigRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(AssociateInstanceStorageConfigRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(AssociateInstanceStorageConfigRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<InstanceStorageConfig> STORAGE_CONFIG_FIELD = SdkField
            .<InstanceStorageConfig> builder(MarshallingType.SDK_POJO).memberName("StorageConfig")
            .getter(getter(AssociateInstanceStorageConfigRequest::storageConfig)).setter(setter(Builder::storageConfig))
            .constructor(InstanceStorageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            RESOURCE_TYPE_FIELD, STORAGE_CONFIG_FIELD));

    private final String instanceId;

    private final String resourceType;

    private final InstanceStorageConfig storageConfig;

    private AssociateInstanceStorageConfigRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.resourceType = builder.resourceType;
        this.storageConfig = builder.storageConfig;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A valid resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link InstanceStorageResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return A valid resource type.
     * @see InstanceStorageResourceType
     */
    public final InstanceStorageResourceType resourceType() {
        return InstanceStorageResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * A valid resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link InstanceStorageResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return A valid resource type.
     * @see InstanceStorageResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * A valid storage type.
     * </p>
     * 
     * @return A valid storage type.
     */
    public final InstanceStorageConfig storageConfig() {
        return storageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateInstanceStorageConfigRequest)) {
            return false;
        }
        AssociateInstanceStorageConfigRequest other = (AssociateInstanceStorageConfigRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(storageConfig(), other.storageConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateInstanceStorageConfigRequest").add("InstanceId", instanceId())
                .add("ResourceType", resourceTypeAsString()).add("StorageConfig", storageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "StorageConfig":
            return Optional.ofNullable(clazz.cast(storageConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateInstanceStorageConfigRequest, T> g) {
        return obj -> g.apply((AssociateInstanceStorageConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateInstanceStorageConfigRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A valid resource type.
         * </p>
         * 
         * @param resourceType
         *        A valid resource type.
         * @see InstanceStorageResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStorageResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * A valid resource type.
         * </p>
         * 
         * @param resourceType
         *        A valid resource type.
         * @see InstanceStorageResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStorageResourceType
         */
        Builder resourceType(InstanceStorageResourceType resourceType);

        /**
         * <p>
         * A valid storage type.
         * </p>
         * 
         * @param storageConfig
         *        A valid storage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfig(InstanceStorageConfig storageConfig);

        /**
         * <p>
         * A valid storage type.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceStorageConfig.Builder} avoiding
         * the need to create one manually via {@link InstanceStorageConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceStorageConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConfig(InstanceStorageConfig)}.
         * 
         * @param storageConfig
         *        a consumer that will call methods on {@link InstanceStorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfig(InstanceStorageConfig)
         */
        default Builder storageConfig(Consumer<InstanceStorageConfig.Builder> storageConfig) {
            return storageConfig(InstanceStorageConfig.builder().applyMutation(storageConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String resourceType;

        private InstanceStorageConfig storageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateInstanceStorageConfigRequest model) {
            super(model);
            instanceId(model.instanceId);
            resourceType(model.resourceType);
            storageConfig(model.storageConfig);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(InstanceStorageResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final InstanceStorageConfig.Builder getStorageConfig() {
            return storageConfig != null ? storageConfig.toBuilder() : null;
        }

        public final void setStorageConfig(InstanceStorageConfig.BuilderImpl storageConfig) {
            this.storageConfig = storageConfig != null ? storageConfig.build() : null;
        }

        @Override
        public final Builder storageConfig(InstanceStorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateInstanceStorageConfigRequest build() {
            return new AssociateInstanceStorageConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
