/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserPhoneConfigRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateUserPhoneConfigRequest.Builder, UpdateUserPhoneConfigRequest> {
    private static final SdkField<UserPhoneConfig> PHONE_CONFIG_FIELD = SdkField
            .<UserPhoneConfig> builder(MarshallingType.SDK_POJO).memberName("PhoneConfig")
            .getter(getter(UpdateUserPhoneConfigRequest::phoneConfig)).setter(setter(Builder::phoneConfig))
            .constructor(UserPhoneConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneConfig").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(UpdateUserPhoneConfigRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateUserPhoneConfigRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_CONFIG_FIELD,
            USER_ID_FIELD, INSTANCE_ID_FIELD));

    private final UserPhoneConfig phoneConfig;

    private final String userId;

    private final String instanceId;

    private UpdateUserPhoneConfigRequest(BuilderImpl builder) {
        super(builder);
        this.phoneConfig = builder.phoneConfig;
        this.userId = builder.userId;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * Information about phone configuration settings for the user.
     * </p>
     * 
     * @return Information about phone configuration settings for the user.
     */
    public final UserPhoneConfig phoneConfig() {
        return phoneConfig;
    }

    /**
     * <p>
     * The identifier of the user account.
     * </p>
     * 
     * @return The identifier of the user account.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPhoneConfigRequest)) {
            return false;
        }
        UpdateUserPhoneConfigRequest other = (UpdateUserPhoneConfigRequest) obj;
        return Objects.equals(phoneConfig(), other.phoneConfig()) && Objects.equals(userId(), other.userId())
                && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserPhoneConfigRequest").add("PhoneConfig", phoneConfig()).add("UserId", userId())
                .add("InstanceId", instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneConfig":
            return Optional.ofNullable(clazz.cast(phoneConfig()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserPhoneConfigRequest, T> g) {
        return obj -> g.apply((UpdateUserPhoneConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserPhoneConfigRequest> {
        /**
         * <p>
         * Information about phone configuration settings for the user.
         * </p>
         * 
         * @param phoneConfig
         *        Information about phone configuration settings for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneConfig(UserPhoneConfig phoneConfig);

        /**
         * <p>
         * Information about phone configuration settings for the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserPhoneConfig.Builder} avoiding the
         * need to create one manually via {@link UserPhoneConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPhoneConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #phoneConfig(UserPhoneConfig)}.
         * 
         * @param phoneConfig
         *        a consumer that will call methods on {@link UserPhoneConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneConfig(UserPhoneConfig)
         */
        default Builder phoneConfig(Consumer<UserPhoneConfig.Builder> phoneConfig) {
            return phoneConfig(UserPhoneConfig.builder().applyMutation(phoneConfig).build());
        }

        /**
         * <p>
         * The identifier of the user account.
         * </p>
         * 
         * @param userId
         *        The identifier of the user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private UserPhoneConfig phoneConfig;

        private String userId;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserPhoneConfigRequest model) {
            super(model);
            phoneConfig(model.phoneConfig);
            userId(model.userId);
            instanceId(model.instanceId);
        }

        public final UserPhoneConfig.Builder getPhoneConfig() {
            return phoneConfig != null ? phoneConfig.toBuilder() : null;
        }

        public final void setPhoneConfig(UserPhoneConfig.BuilderImpl phoneConfig) {
            this.phoneConfig = phoneConfig != null ? phoneConfig.build() : null;
        }

        @Override
        public final Builder phoneConfig(UserPhoneConfig phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserPhoneConfigRequest build() {
            return new UpdateUserPhoneConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
