/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ContactFilter;
import software.amazon.awssdk.services.connect.model.QueuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserDataFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserDataFilters> {
    private static final SdkField<List<String>> QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Queues").getter(UserDataFilters.getter(UserDataFilters::queues)).setter(UserDataFilters.setter(Builder::queues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ContactFilter> CONTACT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContactFilter").getter(UserDataFilters.getter(UserDataFilters::contactFilter)).setter(UserDataFilters.setter(Builder::contactFilter)).constructor(ContactFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUES_FIELD, CONTACT_FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> queues;
    private final ContactFilter contactFilter;

    private UserDataFilters(BuilderImpl builder) {
        this.queues = builder.queues;
        this.contactFilter = builder.contactFilter;
    }

    public final boolean hasQueues() {
        return this.queues != null && !(this.queues instanceof SdkAutoConstructList);
    }

    public final List<String> queues() {
        return this.queues;
    }

    public final ContactFilter contactFilter() {
        return this.contactFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueues() ? this.queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDataFilters)) {
            return false;
        }
        UserDataFilters other = (UserDataFilters)obj;
        return this.hasQueues() == other.hasQueues() && Objects.equals(this.queues(), other.queues()) && Objects.equals(this.contactFilter(), other.contactFilter());
    }

    public final String toString() {
        return ToString.builder((String)"UserDataFilters").add("Queues", this.hasQueues() ? this.queues() : null).add("ContactFilter", (Object)this.contactFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
            case "ContactFilter": {
                return Optional.ofNullable(clazz.cast(this.contactFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserDataFilters, T> g) {
        return obj -> g.apply((UserDataFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> queues = DefaultSdkAutoConstructList.getInstance();
        private ContactFilter contactFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(UserDataFilters model) {
            this.queues(model.queues);
            this.contactFilter(model.contactFilter);
        }

        public final Collection<String> getQueues() {
            if (this.queues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queues;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        public final ContactFilter.Builder getContactFilter() {
            return this.contactFilter != null ? this.contactFilter.toBuilder() : null;
        }

        public final void setContactFilter(ContactFilter.BuilderImpl contactFilter) {
            this.contactFilter = contactFilter != null ? contactFilter.build() : null;
        }

        @Override
        public final Builder contactFilter(ContactFilter contactFilter) {
            this.contactFilter = contactFilter;
            return this;
        }

        public UserDataFilters build() {
            return new UserDataFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserDataFilters> {
        public Builder queues(Collection<String> var1);

        public Builder queues(String ... var1);

        public Builder contactFilter(ContactFilter var1);

        default public Builder contactFilter(Consumer<ContactFilter.Builder> contactFilter) {
            return this.contactFilter((ContactFilter)((ContactFilter.Builder)ContactFilter.builder().applyMutation(contactFilter)).build());
        }
    }
}

