/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateLexBotRequest extends ConnectRequest implements
        ToCopyableBuilder<AssociateLexBotRequest.Builder, AssociateLexBotRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(AssociateLexBotRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<LexBot> LEX_BOT_FIELD = SdkField.<LexBot> builder(MarshallingType.SDK_POJO)
            .memberName("LexBot").getter(getter(AssociateLexBotRequest::lexBot)).setter(setter(Builder::lexBot))
            .constructor(LexBot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexBot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            LEX_BOT_FIELD));

    private final String instanceId;

    private final LexBot lexBot;

    private AssociateLexBotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.lexBot = builder.lexBot;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The Amazon Lex bot to associate with the instance.
     * </p>
     * 
     * @return The Amazon Lex bot to associate with the instance.
     */
    public final LexBot lexBot() {
        return lexBot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(lexBot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateLexBotRequest)) {
            return false;
        }
        AssociateLexBotRequest other = (AssociateLexBotRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(lexBot(), other.lexBot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateLexBotRequest").add("InstanceId", instanceId()).add("LexBot", lexBot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "LexBot":
            return Optional.ofNullable(clazz.cast(lexBot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateLexBotRequest, T> g) {
        return obj -> g.apply((AssociateLexBotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateLexBotRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The Amazon Lex bot to associate with the instance.
         * </p>
         * 
         * @param lexBot
         *        The Amazon Lex bot to associate with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexBot(LexBot lexBot);

        /**
         * <p>
         * The Amazon Lex bot to associate with the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link LexBot.Builder} avoiding the need to
         * create one manually via {@link LexBot#builder()}.
         *
         * When the {@link Consumer} completes, {@link LexBot.Builder#build()} is called immediately and its result is
         * passed to {@link #lexBot(LexBot)}.
         * 
         * @param lexBot
         *        a consumer that will call methods on {@link LexBot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lexBot(LexBot)
         */
        default Builder lexBot(Consumer<LexBot.Builder> lexBot) {
            return lexBot(LexBot.builder().applyMutation(lexBot).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private LexBot lexBot;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateLexBotRequest model) {
            super(model);
            instanceId(model.instanceId);
            lexBot(model.lexBot);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final LexBot.Builder getLexBot() {
            return lexBot != null ? lexBot.toBuilder() : null;
        }

        public final void setLexBot(LexBot.BuilderImpl lexBot) {
            this.lexBot = lexBot != null ? lexBot.build() : null;
        }

        @Override
        public final Builder lexBot(LexBot lexBot) {
            this.lexBot = lexBot;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateLexBotRequest build() {
            return new AssociateLexBotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
