/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
 * <code>OR</code> of <code>AND</code> (List of List) input where:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Top level list specifies conditions that need to be applied with <code>OR</code> operator
 * </p>
 * </li>
 * <li>
 * <p>
 * Inner list specifies conditions that need to be applied with <code>AND</code> operator.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlPlaneTagFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ControlPlaneTagFilter.Builder, ControlPlaneTagFilter> {
    private static final SdkField<List<List<TagCondition>>> OR_CONDITIONS_FIELD = SdkField
            .<List<List<TagCondition>>> builder(MarshallingType.LIST)
            .memberName("OrConditions")
            .getter(getter(ControlPlaneTagFilter::orConditions))
            .setter(setter(Builder::orConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<TagCondition>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<TagCondition> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(TagCondition::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<TagCondition>> AND_CONDITIONS_FIELD = SdkField
            .<List<TagCondition>> builder(MarshallingType.LIST)
            .memberName("AndConditions")
            .getter(getter(ControlPlaneTagFilter::andConditions))
            .setter(setter(Builder::andConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TagCondition> TAG_CONDITION_FIELD = SdkField.<TagCondition> builder(MarshallingType.SDK_POJO)
            .memberName("TagCondition").getter(getter(ControlPlaneTagFilter::tagCondition)).setter(setter(Builder::tagCondition))
            .constructor(TagCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD,
            AND_CONDITIONS_FIELD, TAG_CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<List<TagCondition>> orConditions;

    private final List<TagCondition> andConditions;

    private final TagCondition tagCondition;

    private ControlPlaneTagFilter(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.tagCondition = builder.tagCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrConditions() {
        return orConditions != null && !(orConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an <code>OR</code> condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an <code>OR</code> condition.
     */
    public final List<List<TagCondition>> orConditions() {
        return orConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndConditions() {
        return andConditions != null && !(andConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an <code>AND</code> condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an <code>AND</code> condition.
     */
    public final List<TagCondition> andConditions() {
        return andConditions;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a tag condition.
     * </p>
     * 
     * @return A leaf node condition which can be used to specify a tag condition.
     */
    public final TagCondition tagCondition() {
        return tagCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrConditions() ? orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAndConditions() ? andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tagCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlPlaneTagFilter)) {
            return false;
        }
        ControlPlaneTagFilter other = (ControlPlaneTagFilter) obj;
        return hasOrConditions() == other.hasOrConditions() && Objects.equals(orConditions(), other.orConditions())
                && hasAndConditions() == other.hasAndConditions() && Objects.equals(andConditions(), other.andConditions())
                && Objects.equals(tagCondition(), other.tagCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlPlaneTagFilter").add("OrConditions", hasOrConditions() ? orConditions() : null)
                .add("AndConditions", hasAndConditions() ? andConditions() : null).add("TagCondition", tagCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrConditions":
            return Optional.ofNullable(clazz.cast(orConditions()));
        case "AndConditions":
            return Optional.ofNullable(clazz.cast(andConditions()));
        case "TagCondition":
            return Optional.ofNullable(clazz.cast(tagCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlPlaneTagFilter, T> g) {
        return obj -> g.apply((ControlPlaneTagFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlPlaneTagFilter> {
        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an <code>OR</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<? extends Collection<TagCondition>> orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an <code>OR</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<TagCondition>... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an <code>AND</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(Collection<TagCondition> andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an <code>AND</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(TagCondition... andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TagCondition>.Builder} avoiding the
         * need to create one manually via {@link List<TagCondition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagCondition>.Builder#build()} is called immediately and its
         * result is passed to {@link #andConditions(List<TagCondition>)}.
         * 
         * @param andConditions
         *        a consumer that will call methods on {@link List<TagCondition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andConditions(List<TagCondition>)
         */
        Builder andConditions(Consumer<TagCondition.Builder>... andConditions);

        /**
         * <p>
         * A leaf node condition which can be used to specify a tag condition.
         * </p>
         * 
         * @param tagCondition
         *        A leaf node condition which can be used to specify a tag condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagCondition(TagCondition tagCondition);

        /**
         * <p>
         * A leaf node condition which can be used to specify a tag condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagCondition.Builder} avoiding the need
         * to create one manually via {@link TagCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link TagCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #tagCondition(TagCondition)}.
         * 
         * @param tagCondition
         *        a consumer that will call methods on {@link TagCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagCondition(TagCondition)
         */
        default Builder tagCondition(Consumer<TagCondition.Builder> tagCondition) {
            return tagCondition(TagCondition.builder().applyMutation(tagCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<List<TagCondition>> orConditions = DefaultSdkAutoConstructList.getInstance();

        private List<TagCondition> andConditions = DefaultSdkAutoConstructList.getInstance();

        private TagCondition tagCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlPlaneTagFilter model) {
            orConditions(model.orConditions);
            andConditions(model.andConditions);
            tagCondition(model.tagCondition);
        }

        public final List<List<TagCondition.Builder>> getOrConditions() {
            List<List<TagCondition.Builder>> result = TagOrConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<? extends Collection<TagCondition.BuilderImpl>> orConditions) {
            this.orConditions = TagOrConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<? extends Collection<TagCondition>> orConditions) {
            this.orConditions = TagOrConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Collection<TagCondition>... orConditions) {
            orConditions(Arrays.asList(orConditions));
            return this;
        }

        public final List<TagCondition.Builder> getAndConditions() {
            List<TagCondition.Builder> result = TagAndConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<TagCondition.BuilderImpl> andConditions) {
            this.andConditions = TagAndConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<TagCondition> andConditions) {
            this.andConditions = TagAndConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(TagCondition... andConditions) {
            andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<TagCondition.Builder>... andConditions) {
            andConditions(Stream.of(andConditions).map(c -> TagCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TagCondition.Builder getTagCondition() {
            return tagCondition != null ? tagCondition.toBuilder() : null;
        }

        public final void setTagCondition(TagCondition.BuilderImpl tagCondition) {
            this.tagCondition = tagCondition != null ? tagCondition.build() : null;
        }

        @Override
        public final Builder tagCondition(TagCondition tagCondition) {
            this.tagCondition = tagCondition;
            return this;
        }

        @Override
        public ControlPlaneTagFilter build() {
            return new ControlPlaneTagFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
