/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the returned users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserSearchSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<UserSearchSummary.Builder, UserSearchSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UserSearchSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DIRECTORY_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryUserId").getter(getter(UserSearchSummary::directoryUserId))
            .setter(setter(Builder::directoryUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryUserId").build()).build();

    private static final SdkField<String> HIERARCHY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HierarchyGroupId").getter(getter(UserSearchSummary::hierarchyGroupId))
            .setter(setter(Builder::hierarchyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UserSearchSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<UserIdentityInfoLite> IDENTITY_INFO_FIELD = SdkField
            .<UserIdentityInfoLite> builder(MarshallingType.SDK_POJO).memberName("IdentityInfo")
            .getter(getter(UserSearchSummary::identityInfo)).setter(setter(Builder::identityInfo))
            .constructor(UserIdentityInfoLite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityInfo").build()).build();

    private static final SdkField<UserPhoneConfig> PHONE_CONFIG_FIELD = SdkField
            .<UserPhoneConfig> builder(MarshallingType.SDK_POJO).memberName("PhoneConfig")
            .getter(getter(UserSearchSummary::phoneConfig)).setter(setter(Builder::phoneConfig))
            .constructor(UserPhoneConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneConfig").build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingProfileId").getter(getter(UserSearchSummary::routingProfileId))
            .setter(setter(Builder::routingProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()).build();

    private static final SdkField<List<String>> SECURITY_PROFILE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityProfileIds")
            .getter(getter(UserSearchSummary::securityProfileIds))
            .setter(setter(Builder::securityProfileIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(UserSearchSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(UserSearchSummary::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DIRECTORY_USER_ID_FIELD, HIERARCHY_GROUP_ID_FIELD, ID_FIELD, IDENTITY_INFO_FIELD, PHONE_CONFIG_FIELD,
            ROUTING_PROFILE_ID_FIELD, SECURITY_PROFILE_IDS_FIELD, TAGS_FIELD, USERNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String directoryUserId;

    private final String hierarchyGroupId;

    private final String id;

    private final UserIdentityInfoLite identityInfo;

    private final UserPhoneConfig phoneConfig;

    private final String routingProfileId;

    private final List<String> securityProfileIds;

    private final Map<String, String> tags;

    private final String username;

    private UserSearchSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.directoryUserId = builder.directoryUserId;
        this.hierarchyGroupId = builder.hierarchyGroupId;
        this.id = builder.id;
        this.identityInfo = builder.identityInfo;
        this.phoneConfig = builder.phoneConfig;
        this.routingProfileId = builder.routingProfileId;
        this.securityProfileIds = builder.securityProfileIds;
        this.tags = builder.tags;
        this.username = builder.username;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The directory identifier of the user.
     * </p>
     * 
     * @return The directory identifier of the user.
     */
    public final String directoryUserId() {
        return directoryUserId;
    }

    /**
     * <p>
     * The identifier of the user's hierarchy group.
     * </p>
     * 
     * @return The identifier of the user's hierarchy group.
     */
    public final String hierarchyGroupId() {
        return hierarchyGroupId;
    }

    /**
     * <p>
     * The identifier of the user's summary.
     * </p>
     * 
     * @return The identifier of the user's summary.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The user's first name and last name.
     * </p>
     * 
     * @return The user's first name and last name.
     */
    public final UserIdentityInfoLite identityInfo() {
        return identityInfo;
    }

    /**
     * Returns the value of the PhoneConfig property for this object.
     * 
     * @return The value of the PhoneConfig property for this object.
     */
    public final UserPhoneConfig phoneConfig() {
        return phoneConfig;
    }

    /**
     * <p>
     * The identifier of the user's routing profile.
     * </p>
     * 
     * @return The identifier of the user's routing profile.
     */
    public final String routingProfileId() {
        return routingProfileId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityProfileIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityProfileIds() {
        return securityProfileIds != null && !(securityProfileIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the user's security profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityProfileIds} method.
     * </p>
     * 
     * @return The identifiers of the user's security profiles.
     */
    public final List<String> securityProfileIds() {
        return securityProfileIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(directoryUserId());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(identityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(phoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityProfileIds() ? securityProfileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSearchSummary)) {
            return false;
        }
        UserSearchSummary other = (UserSearchSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(directoryUserId(), other.directoryUserId())
                && Objects.equals(hierarchyGroupId(), other.hierarchyGroupId()) && Objects.equals(id(), other.id())
                && Objects.equals(identityInfo(), other.identityInfo()) && Objects.equals(phoneConfig(), other.phoneConfig())
                && Objects.equals(routingProfileId(), other.routingProfileId())
                && hasSecurityProfileIds() == other.hasSecurityProfileIds()
                && Objects.equals(securityProfileIds(), other.securityProfileIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserSearchSummary").add("Arn", arn()).add("DirectoryUserId", directoryUserId())
                .add("HierarchyGroupId", hierarchyGroupId()).add("Id", id()).add("IdentityInfo", identityInfo())
                .add("PhoneConfig", phoneConfig()).add("RoutingProfileId", routingProfileId())
                .add("SecurityProfileIds", hasSecurityProfileIds() ? securityProfileIds() : null)
                .add("Tags", hasTags() ? tags() : null).add("Username", username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DirectoryUserId":
            return Optional.ofNullable(clazz.cast(directoryUserId()));
        case "HierarchyGroupId":
            return Optional.ofNullable(clazz.cast(hierarchyGroupId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IdentityInfo":
            return Optional.ofNullable(clazz.cast(identityInfo()));
        case "PhoneConfig":
            return Optional.ofNullable(clazz.cast(phoneConfig()));
        case "RoutingProfileId":
            return Optional.ofNullable(clazz.cast(routingProfileId()));
        case "SecurityProfileIds":
            return Optional.ofNullable(clazz.cast(securityProfileIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserSearchSummary, T> g) {
        return obj -> g.apply((UserSearchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserSearchSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The directory identifier of the user.
         * </p>
         * 
         * @param directoryUserId
         *        The directory identifier of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryUserId(String directoryUserId);

        /**
         * <p>
         * The identifier of the user's hierarchy group.
         * </p>
         * 
         * @param hierarchyGroupId
         *        The identifier of the user's hierarchy group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyGroupId(String hierarchyGroupId);

        /**
         * <p>
         * The identifier of the user's summary.
         * </p>
         * 
         * @param id
         *        The identifier of the user's summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The user's first name and last name.
         * </p>
         * 
         * @param identityInfo
         *        The user's first name and last name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityInfo(UserIdentityInfoLite identityInfo);

        /**
         * <p>
         * The user's first name and last name.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserIdentityInfoLite.Builder} avoiding
         * the need to create one manually via {@link UserIdentityInfoLite#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserIdentityInfoLite.Builder#build()} is called immediately and
         * its result is passed to {@link #identityInfo(UserIdentityInfoLite)}.
         * 
         * @param identityInfo
         *        a consumer that will call methods on {@link UserIdentityInfoLite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityInfo(UserIdentityInfoLite)
         */
        default Builder identityInfo(Consumer<UserIdentityInfoLite.Builder> identityInfo) {
            return identityInfo(UserIdentityInfoLite.builder().applyMutation(identityInfo).build());
        }

        /**
         * Sets the value of the PhoneConfig property for this object.
         *
         * @param phoneConfig
         *        The new value for the PhoneConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneConfig(UserPhoneConfig phoneConfig);

        /**
         * Sets the value of the PhoneConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserPhoneConfig.Builder} avoiding the
         * need to create one manually via {@link UserPhoneConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPhoneConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #phoneConfig(UserPhoneConfig)}.
         * 
         * @param phoneConfig
         *        a consumer that will call methods on {@link UserPhoneConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneConfig(UserPhoneConfig)
         */
        default Builder phoneConfig(Consumer<UserPhoneConfig.Builder> phoneConfig) {
            return phoneConfig(UserPhoneConfig.builder().applyMutation(phoneConfig).build());
        }

        /**
         * <p>
         * The identifier of the user's routing profile.
         * </p>
         * 
         * @param routingProfileId
         *        The identifier of the user's routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileId(String routingProfileId);

        /**
         * <p>
         * The identifiers of the user's security profiles.
         * </p>
         * 
         * @param securityProfileIds
         *        The identifiers of the user's security profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIds(Collection<String> securityProfileIds);

        /**
         * <p>
         * The identifiers of the user's security profiles.
         * </p>
         * 
         * @param securityProfileIds
         *        The identifiers of the user's security profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIds(String... securityProfileIds);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param username
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String directoryUserId;

        private String hierarchyGroupId;

        private String id;

        private UserIdentityInfoLite identityInfo;

        private UserPhoneConfig phoneConfig;

        private String routingProfileId;

        private List<String> securityProfileIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSearchSummary model) {
            arn(model.arn);
            directoryUserId(model.directoryUserId);
            hierarchyGroupId(model.hierarchyGroupId);
            id(model.id);
            identityInfo(model.identityInfo);
            phoneConfig(model.phoneConfig);
            routingProfileId(model.routingProfileId);
            securityProfileIds(model.securityProfileIds);
            tags(model.tags);
            username(model.username);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDirectoryUserId() {
            return directoryUserId;
        }

        public final void setDirectoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
        }

        @Override
        public final Builder directoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
            return this;
        }

        public final String getHierarchyGroupId() {
            return hierarchyGroupId;
        }

        public final void setHierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
        }

        @Override
        public final Builder hierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final UserIdentityInfoLite.Builder getIdentityInfo() {
            return identityInfo != null ? identityInfo.toBuilder() : null;
        }

        public final void setIdentityInfo(UserIdentityInfoLite.BuilderImpl identityInfo) {
            this.identityInfo = identityInfo != null ? identityInfo.build() : null;
        }

        @Override
        public final Builder identityInfo(UserIdentityInfoLite identityInfo) {
            this.identityInfo = identityInfo;
            return this;
        }

        public final UserPhoneConfig.Builder getPhoneConfig() {
            return phoneConfig != null ? phoneConfig.toBuilder() : null;
        }

        public final void setPhoneConfig(UserPhoneConfig.BuilderImpl phoneConfig) {
            this.phoneConfig = phoneConfig != null ? phoneConfig.build() : null;
        }

        @Override
        public final Builder phoneConfig(UserPhoneConfig phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        public final String getRoutingProfileId() {
            return routingProfileId;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final Collection<String> getSecurityProfileIds() {
            if (securityProfileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityProfileIds;
        }

        public final void setSecurityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
        }

        @Override
        public final Builder securityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIds(String... securityProfileIds) {
            securityProfileIds(Arrays.asList(securityProfileIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public UserSearchSummary build() {
            return new UserSearchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
