/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeInstanceResponse.Builder, DescribeInstanceResponse> {
    private static final SdkField<Instance> INSTANCE_FIELD = SdkField.<Instance> builder(MarshallingType.SDK_POJO)
            .memberName("Instance").getter(getter(DescribeInstanceResponse::instance)).setter(setter(Builder::instance))
            .constructor(Instance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FIELD));

    private final Instance instance;

    private DescribeInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instance = builder.instance;
    }

    /**
     * <p>
     * The name of the instance.
     * </p>
     * 
     * @return The name of the instance.
     */
    public final Instance instance() {
        return instance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceResponse)) {
            return false;
        }
        DescribeInstanceResponse other = (DescribeInstanceResponse) obj;
        return Objects.equals(instance(), other.instance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceResponse").add("Instance", instance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instance":
            return Optional.ofNullable(clazz.cast(instance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceResponse, T> g) {
        return obj -> g.apply((DescribeInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstanceResponse> {
        /**
         * <p>
         * The name of the instance.
         * </p>
         * 
         * @param instance
         *        The name of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(Instance instance);

        /**
         * <p>
         * The name of the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link Instance.Builder} avoiding the need to
         * create one manually via {@link Instance#builder()}.
         *
         * When the {@link Consumer} completes, {@link Instance.Builder#build()} is called immediately and its result is
         * passed to {@link #instance(Instance)}.
         * 
         * @param instance
         *        a consumer that will call methods on {@link Instance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instance(Instance)
         */
        default Builder instance(Consumer<Instance.Builder> instance) {
            return instance(Instance.builder().applyMutation(instance).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private Instance instance;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceResponse model) {
            super(model);
            instance(model.instance);
        }

        public final Instance.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        public final void setInstance(Instance.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        public final Builder instance(Instance instance) {
            this.instance = instance;
            return this;
        }

        @Override
        public DescribeInstanceResponse build() {
            return new DescribeInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
