/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCurrentUserDataResponse extends ConnectResponse implements
        ToCopyableBuilder<GetCurrentUserDataResponse.Builder, GetCurrentUserDataResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetCurrentUserDataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<UserData>> USER_DATA_LIST_FIELD = SdkField
            .<List<UserData>> builder(MarshallingType.LIST)
            .memberName("UserDataList")
            .getter(getter(GetCurrentUserDataResponse::userDataList))
            .setter(setter(Builder::userDataList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDataList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserData> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            USER_DATA_LIST_FIELD));

    private final String nextToken;

    private final List<UserData> userDataList;

    private GetCurrentUserDataResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.userDataList = builder.userDataList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserDataList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserDataList() {
        return userDataList != null && !(userDataList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the user data that is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserDataList} method.
     * </p>
     * 
     * @return A list of the user data that is returned.
     */
    public final List<UserData> userDataList() {
        return userDataList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserDataList() ? userDataList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCurrentUserDataResponse)) {
            return false;
        }
        GetCurrentUserDataResponse other = (GetCurrentUserDataResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasUserDataList() == other.hasUserDataList()
                && Objects.equals(userDataList(), other.userDataList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCurrentUserDataResponse").add("NextToken", nextToken())
                .add("UserDataList", hasUserDataList() ? userDataList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "UserDataList":
            return Optional.ofNullable(clazz.cast(userDataList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCurrentUserDataResponse, T> g) {
        return obj -> g.apply((GetCurrentUserDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCurrentUserDataResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of the user data that is returned.
         * </p>
         * 
         * @param userDataList
         *        A list of the user data that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDataList(Collection<UserData> userDataList);

        /**
         * <p>
         * A list of the user data that is returned.
         * </p>
         * 
         * @param userDataList
         *        A list of the user data that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDataList(UserData... userDataList);

        /**
         * <p>
         * A list of the user data that is returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UserData>.Builder} avoiding the need
         * to create one manually via {@link List<UserData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserData>.Builder#build()} is called immediately and its
         * result is passed to {@link #userDataList(List<UserData>)}.
         * 
         * @param userDataList
         *        a consumer that will call methods on {@link List<UserData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDataList(List<UserData>)
         */
        Builder userDataList(Consumer<UserData.Builder>... userDataList);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<UserData> userDataList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCurrentUserDataResponse model) {
            super(model);
            nextToken(model.nextToken);
            userDataList(model.userDataList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UserData.Builder> getUserDataList() {
            List<UserData.Builder> result = UserDataListCopier.copyToBuilder(this.userDataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserDataList(Collection<UserData.BuilderImpl> userDataList) {
            this.userDataList = UserDataListCopier.copyFromBuilder(userDataList);
        }

        @Override
        public final Builder userDataList(Collection<UserData> userDataList) {
            this.userDataList = UserDataListCopier.copy(userDataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDataList(UserData... userDataList) {
            userDataList(Arrays.asList(userDataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDataList(Consumer<UserData.Builder>... userDataList) {
            userDataList(Stream.of(userDataList).map(c -> UserData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCurrentUserDataResponse build() {
            return new GetCurrentUserDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
