/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A leaf node condition which can be used to specify a string condition, for example, <code>username = 'abc'</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringCondition implements SdkPojo, Serializable, ToCopyableBuilder<StringCondition.Builder, StringCondition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(StringCondition::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(StringCondition::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> COMPARISON_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonType").getter(getter(StringCondition::comparisonTypeAsString))
            .setter(setter(Builder::comparisonType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, VALUE_FIELD,
            COMPARISON_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String value;

    private final String comparisonType;

    private StringCondition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.value = builder.value;
        this.comparisonType = builder.comparisonType;
    }

    /**
     * <p>
     * The name of the field in the string condition.
     * </p>
     * 
     * @return The name of the field in the string condition.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * The value of the string.
     * </p>
     * 
     * @return The value of the string.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The type of comparison to be made when evaluating the string condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonType}
     * will return {@link StringComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonTypeAsString}.
     * </p>
     * 
     * @return The type of comparison to be made when evaluating the string condition.
     * @see StringComparisonType
     */
    public final StringComparisonType comparisonType() {
        return StringComparisonType.fromValue(comparisonType);
    }

    /**
     * <p>
     * The type of comparison to be made when evaluating the string condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonType}
     * will return {@link StringComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonTypeAsString}.
     * </p>
     * 
     * @return The type of comparison to be made when evaluating the string condition.
     * @see StringComparisonType
     */
    public final String comparisonTypeAsString() {
        return comparisonType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringCondition)) {
            return false;
        }
        StringCondition other = (StringCondition) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(value(), other.value())
                && Objects.equals(comparisonTypeAsString(), other.comparisonTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StringCondition").add("FieldName", fieldName()).add("Value", value())
                .add("ComparisonType", comparisonTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "ComparisonType":
            return Optional.ofNullable(clazz.cast(comparisonTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StringCondition, T> g) {
        return obj -> g.apply((StringCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringCondition> {
        /**
         * <p>
         * The name of the field in the string condition.
         * </p>
         * 
         * @param fieldName
         *        The name of the field in the string condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The value of the string.
         * </p>
         * 
         * @param value
         *        The value of the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The type of comparison to be made when evaluating the string condition.
         * </p>
         * 
         * @param comparisonType
         *        The type of comparison to be made when evaluating the string condition.
         * @see StringComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StringComparisonType
         */
        Builder comparisonType(String comparisonType);

        /**
         * <p>
         * The type of comparison to be made when evaluating the string condition.
         * </p>
         * 
         * @param comparisonType
         *        The type of comparison to be made when evaluating the string condition.
         * @see StringComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StringComparisonType
         */
        Builder comparisonType(StringComparisonType comparisonType);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String value;

        private String comparisonType;

        private BuilderImpl() {
        }

        private BuilderImpl(StringCondition model) {
            fieldName(model.fieldName);
            value(model.value);
            comparisonType(model.comparisonType);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getComparisonType() {
            return comparisonType;
        }

        public final void setComparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
        }

        @Override
        public final Builder comparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
            return this;
        }

        @Override
        public final Builder comparisonType(StringComparisonType comparisonType) {
            this.comparisonType(comparisonType == null ? null : comparisonType.toString());
            return this;
        }

        @Override
        public StringCondition build() {
            return new StringCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
