/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes constraints that apply to the template fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskTemplateConstraints implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskTemplateConstraints.Builder, TaskTemplateConstraints> {
    private static final SdkField<List<RequiredFieldInfo>> REQUIRED_FIELDS_FIELD = SdkField
            .<List<RequiredFieldInfo>> builder(MarshallingType.LIST)
            .memberName("RequiredFields")
            .getter(getter(TaskTemplateConstraints::requiredFields))
            .setter(setter(Builder::requiredFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequiredFieldInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequiredFieldInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReadOnlyFieldInfo>> READ_ONLY_FIELDS_FIELD = SdkField
            .<List<ReadOnlyFieldInfo>> builder(MarshallingType.LIST)
            .memberName("ReadOnlyFields")
            .getter(getter(TaskTemplateConstraints::readOnlyFields))
            .setter(setter(Builder::readOnlyFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnlyFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReadOnlyFieldInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReadOnlyFieldInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InvisibleFieldInfo>> INVISIBLE_FIELDS_FIELD = SdkField
            .<List<InvisibleFieldInfo>> builder(MarshallingType.LIST)
            .memberName("InvisibleFields")
            .getter(getter(TaskTemplateConstraints::invisibleFields))
            .setter(setter(Builder::invisibleFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvisibleFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvisibleFieldInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvisibleFieldInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRED_FIELDS_FIELD,
            READ_ONLY_FIELDS_FIELD, INVISIBLE_FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RequiredFieldInfo> requiredFields;

    private final List<ReadOnlyFieldInfo> readOnlyFields;

    private final List<InvisibleFieldInfo> invisibleFields;

    private TaskTemplateConstraints(BuilderImpl builder) {
        this.requiredFields = builder.requiredFields;
        this.readOnlyFields = builder.readOnlyFields;
        this.invisibleFields = builder.invisibleFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiredFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequiredFields() {
        return requiredFields != null && !(requiredFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the fields that are required to be filled by agents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredFields} method.
     * </p>
     * 
     * @return Lists the fields that are required to be filled by agents.
     */
    public final List<RequiredFieldInfo> requiredFields() {
        return requiredFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadOnlyFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReadOnlyFields() {
        return readOnlyFields != null && !(readOnlyFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the fields that are read-only to agents, and cannot be edited.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadOnlyFields} method.
     * </p>
     * 
     * @return Lists the fields that are read-only to agents, and cannot be edited.
     */
    public final List<ReadOnlyFieldInfo> readOnlyFields() {
        return readOnlyFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvisibleFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvisibleFields() {
        return invisibleFields != null && !(invisibleFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the fields that are invisible to agents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvisibleFields} method.
     * </p>
     * 
     * @return Lists the fields that are invisible to agents.
     */
    public final List<InvisibleFieldInfo> invisibleFields() {
        return invisibleFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRequiredFields() ? requiredFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReadOnlyFields() ? readOnlyFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInvisibleFields() ? invisibleFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskTemplateConstraints)) {
            return false;
        }
        TaskTemplateConstraints other = (TaskTemplateConstraints) obj;
        return hasRequiredFields() == other.hasRequiredFields() && Objects.equals(requiredFields(), other.requiredFields())
                && hasReadOnlyFields() == other.hasReadOnlyFields() && Objects.equals(readOnlyFields(), other.readOnlyFields())
                && hasInvisibleFields() == other.hasInvisibleFields()
                && Objects.equals(invisibleFields(), other.invisibleFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskTemplateConstraints").add("RequiredFields", hasRequiredFields() ? requiredFields() : null)
                .add("ReadOnlyFields", hasReadOnlyFields() ? readOnlyFields() : null)
                .add("InvisibleFields", hasInvisibleFields() ? invisibleFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequiredFields":
            return Optional.ofNullable(clazz.cast(requiredFields()));
        case "ReadOnlyFields":
            return Optional.ofNullable(clazz.cast(readOnlyFields()));
        case "InvisibleFields":
            return Optional.ofNullable(clazz.cast(invisibleFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskTemplateConstraints, T> g) {
        return obj -> g.apply((TaskTemplateConstraints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskTemplateConstraints> {
        /**
         * <p>
         * Lists the fields that are required to be filled by agents.
         * </p>
         * 
         * @param requiredFields
         *        Lists the fields that are required to be filled by agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredFields(Collection<RequiredFieldInfo> requiredFields);

        /**
         * <p>
         * Lists the fields that are required to be filled by agents.
         * </p>
         * 
         * @param requiredFields
         *        Lists the fields that are required to be filled by agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredFields(RequiredFieldInfo... requiredFields);

        /**
         * <p>
         * Lists the fields that are required to be filled by agents.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RequiredFieldInfo>.Builder} avoiding
         * the need to create one manually via {@link List<RequiredFieldInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RequiredFieldInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #requiredFields(List<RequiredFieldInfo>)}.
         * 
         * @param requiredFields
         *        a consumer that will call methods on {@link List<RequiredFieldInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requiredFields(List<RequiredFieldInfo>)
         */
        Builder requiredFields(Consumer<RequiredFieldInfo.Builder>... requiredFields);

        /**
         * <p>
         * Lists the fields that are read-only to agents, and cannot be edited.
         * </p>
         * 
         * @param readOnlyFields
         *        Lists the fields that are read-only to agents, and cannot be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnlyFields(Collection<ReadOnlyFieldInfo> readOnlyFields);

        /**
         * <p>
         * Lists the fields that are read-only to agents, and cannot be edited.
         * </p>
         * 
         * @param readOnlyFields
         *        Lists the fields that are read-only to agents, and cannot be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnlyFields(ReadOnlyFieldInfo... readOnlyFields);

        /**
         * <p>
         * Lists the fields that are read-only to agents, and cannot be edited.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ReadOnlyFieldInfo>.Builder} avoiding
         * the need to create one manually via {@link List<ReadOnlyFieldInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReadOnlyFieldInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #readOnlyFields(List<ReadOnlyFieldInfo>)}.
         * 
         * @param readOnlyFields
         *        a consumer that will call methods on {@link List<ReadOnlyFieldInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readOnlyFields(List<ReadOnlyFieldInfo>)
         */
        Builder readOnlyFields(Consumer<ReadOnlyFieldInfo.Builder>... readOnlyFields);

        /**
         * <p>
         * Lists the fields that are invisible to agents.
         * </p>
         * 
         * @param invisibleFields
         *        Lists the fields that are invisible to agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invisibleFields(Collection<InvisibleFieldInfo> invisibleFields);

        /**
         * <p>
         * Lists the fields that are invisible to agents.
         * </p>
         * 
         * @param invisibleFields
         *        Lists the fields that are invisible to agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invisibleFields(InvisibleFieldInfo... invisibleFields);

        /**
         * <p>
         * Lists the fields that are invisible to agents.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<InvisibleFieldInfo>.Builder}
         * avoiding the need to create one manually via {@link List<InvisibleFieldInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InvisibleFieldInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #invisibleFields(List<InvisibleFieldInfo>)}.
         * 
         * @param invisibleFields
         *        a consumer that will call methods on {@link List<InvisibleFieldInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invisibleFields(List<InvisibleFieldInfo>)
         */
        Builder invisibleFields(Consumer<InvisibleFieldInfo.Builder>... invisibleFields);
    }

    static final class BuilderImpl implements Builder {
        private List<RequiredFieldInfo> requiredFields = DefaultSdkAutoConstructList.getInstance();

        private List<ReadOnlyFieldInfo> readOnlyFields = DefaultSdkAutoConstructList.getInstance();

        private List<InvisibleFieldInfo> invisibleFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskTemplateConstraints model) {
            requiredFields(model.requiredFields);
            readOnlyFields(model.readOnlyFields);
            invisibleFields(model.invisibleFields);
        }

        public final List<RequiredFieldInfo.Builder> getRequiredFields() {
            List<RequiredFieldInfo.Builder> result = RequiredTaskTemplateFieldsCopier.copyToBuilder(this.requiredFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequiredFields(Collection<RequiredFieldInfo.BuilderImpl> requiredFields) {
            this.requiredFields = RequiredTaskTemplateFieldsCopier.copyFromBuilder(requiredFields);
        }

        @Override
        public final Builder requiredFields(Collection<RequiredFieldInfo> requiredFields) {
            this.requiredFields = RequiredTaskTemplateFieldsCopier.copy(requiredFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFields(RequiredFieldInfo... requiredFields) {
            requiredFields(Arrays.asList(requiredFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFields(Consumer<RequiredFieldInfo.Builder>... requiredFields) {
            requiredFields(Stream.of(requiredFields).map(c -> RequiredFieldInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReadOnlyFieldInfo.Builder> getReadOnlyFields() {
            List<ReadOnlyFieldInfo.Builder> result = ReadOnlyTaskTemplateFieldsCopier.copyToBuilder(this.readOnlyFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReadOnlyFields(Collection<ReadOnlyFieldInfo.BuilderImpl> readOnlyFields) {
            this.readOnlyFields = ReadOnlyTaskTemplateFieldsCopier.copyFromBuilder(readOnlyFields);
        }

        @Override
        public final Builder readOnlyFields(Collection<ReadOnlyFieldInfo> readOnlyFields) {
            this.readOnlyFields = ReadOnlyTaskTemplateFieldsCopier.copy(readOnlyFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFields(ReadOnlyFieldInfo... readOnlyFields) {
            readOnlyFields(Arrays.asList(readOnlyFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFields(Consumer<ReadOnlyFieldInfo.Builder>... readOnlyFields) {
            readOnlyFields(Stream.of(readOnlyFields).map(c -> ReadOnlyFieldInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<InvisibleFieldInfo.Builder> getInvisibleFields() {
            List<InvisibleFieldInfo.Builder> result = InvisibleTaskTemplateFieldsCopier.copyToBuilder(this.invisibleFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvisibleFields(Collection<InvisibleFieldInfo.BuilderImpl> invisibleFields) {
            this.invisibleFields = InvisibleTaskTemplateFieldsCopier.copyFromBuilder(invisibleFields);
        }

        @Override
        public final Builder invisibleFields(Collection<InvisibleFieldInfo> invisibleFields) {
            this.invisibleFields = InvisibleTaskTemplateFieldsCopier.copy(invisibleFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invisibleFields(InvisibleFieldInfo... invisibleFields) {
            invisibleFields(Arrays.asList(invisibleFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invisibleFields(Consumer<InvisibleFieldInfo.Builder>... invisibleFields) {
            invisibleFields(Stream.of(invisibleFields).map(c -> InvisibleFieldInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TaskTemplateConstraints build() {
            return new TaskTemplateConstraints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
