/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAgentStatusRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateAgentStatusRequest.Builder, UpdateAgentStatusRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateAgentStatusRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> AGENT_STATUS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentStatusId").getter(getter(UpdateAgentStatusRequest::agentStatusId))
            .setter(setter(Builder::agentStatusId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AgentStatusId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAgentStatusRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateAgentStatusRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateAgentStatusRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Integer> DISPLAY_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DisplayOrder").getter(getter(UpdateAgentStatusRequest::displayOrder))
            .setter(setter(Builder::displayOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOrder").build()).build();

    private static final SdkField<Boolean> RESET_ORDER_NUMBER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ResetOrderNumber").getter(getter(UpdateAgentStatusRequest::resetOrderNumber))
            .setter(setter(Builder::resetOrderNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetOrderNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            AGENT_STATUS_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATE_FIELD, DISPLAY_ORDER_FIELD, RESET_ORDER_NUMBER_FIELD));

    private final String instanceId;

    private final String agentStatusId;

    private final String name;

    private final String description;

    private final String state;

    private final Integer displayOrder;

    private final Boolean resetOrderNumber;

    private UpdateAgentStatusRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.agentStatusId = builder.agentStatusId;
        this.name = builder.name;
        this.description = builder.description;
        this.state = builder.state;
        this.displayOrder = builder.displayOrder;
        this.resetOrderNumber = builder.resetOrderNumber;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the agent status.
     * </p>
     * 
     * @return The identifier of the agent status.
     */
    public final String agentStatusId() {
        return agentStatusId;
    }

    /**
     * <p>
     * The name of the agent status.
     * </p>
     * 
     * @return The name of the agent status.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the agent status.
     * </p>
     * 
     * @return The description of the agent status.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The state of the agent status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AgentStatusState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the agent status.
     * @see AgentStatusState
     */
    public final AgentStatusState state() {
        return AgentStatusState.fromValue(state);
    }

    /**
     * <p>
     * The state of the agent status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AgentStatusState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the agent status.
     * @see AgentStatusState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The display order of the agent status.
     * </p>
     * 
     * @return The display order of the agent status.
     */
    public final Integer displayOrder() {
        return displayOrder;
    }

    /**
     * <p>
     * A number indicating the reset order of the agent status.
     * </p>
     * 
     * @return A number indicating the reset order of the agent status.
     */
    public final Boolean resetOrderNumber() {
        return resetOrderNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(agentStatusId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayOrder());
        hashCode = 31 * hashCode + Objects.hashCode(resetOrderNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentStatusRequest)) {
            return false;
        }
        UpdateAgentStatusRequest other = (UpdateAgentStatusRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(agentStatusId(), other.agentStatusId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(displayOrder(), other.displayOrder())
                && Objects.equals(resetOrderNumber(), other.resetOrderNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAgentStatusRequest").add("InstanceId", instanceId()).add("AgentStatusId", agentStatusId())
                .add("Name", name()).add("Description", description()).add("State", stateAsString())
                .add("DisplayOrder", displayOrder()).add("ResetOrderNumber", resetOrderNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AgentStatusId":
            return Optional.ofNullable(clazz.cast(agentStatusId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "DisplayOrder":
            return Optional.ofNullable(clazz.cast(displayOrder()));
        case "ResetOrderNumber":
            return Optional.ofNullable(clazz.cast(resetOrderNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentStatusRequest, T> g) {
        return obj -> g.apply((UpdateAgentStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAgentStatusRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the agent status.
         * </p>
         * 
         * @param agentStatusId
         *        The identifier of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentStatusId(String agentStatusId);

        /**
         * <p>
         * The name of the agent status.
         * </p>
         * 
         * @param name
         *        The name of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the agent status.
         * </p>
         * 
         * @param description
         *        The description of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The state of the agent status.
         * </p>
         * 
         * @param state
         *        The state of the agent status.
         * @see AgentStatusState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatusState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the agent status.
         * </p>
         * 
         * @param state
         *        The state of the agent status.
         * @see AgentStatusState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatusState
         */
        Builder state(AgentStatusState state);

        /**
         * <p>
         * The display order of the agent status.
         * </p>
         * 
         * @param displayOrder
         *        The display order of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOrder(Integer displayOrder);

        /**
         * <p>
         * A number indicating the reset order of the agent status.
         * </p>
         * 
         * @param resetOrderNumber
         *        A number indicating the reset order of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetOrderNumber(Boolean resetOrderNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String agentStatusId;

        private String name;

        private String description;

        private String state;

        private Integer displayOrder;

        private Boolean resetOrderNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentStatusRequest model) {
            super(model);
            instanceId(model.instanceId);
            agentStatusId(model.agentStatusId);
            name(model.name);
            description(model.description);
            state(model.state);
            displayOrder(model.displayOrder);
            resetOrderNumber(model.resetOrderNumber);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAgentStatusId() {
            return agentStatusId;
        }

        public final void setAgentStatusId(String agentStatusId) {
            this.agentStatusId = agentStatusId;
        }

        @Override
        @Transient
        public final Builder agentStatusId(String agentStatusId) {
            this.agentStatusId = agentStatusId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(AgentStatusState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getDisplayOrder() {
            return displayOrder;
        }

        public final void setDisplayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
        }

        @Override
        @Transient
        public final Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public final Boolean getResetOrderNumber() {
            return resetOrderNumber;
        }

        public final void setResetOrderNumber(Boolean resetOrderNumber) {
            this.resetOrderNumber = resetOrderNumber;
        }

        @Override
        @Transient
        public final Builder resetOrderNumber(Boolean resetOrderNumber) {
            this.resetOrderNumber = resetOrderNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentStatusRequest build() {
            return new UpdateAgentStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
