/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactFlowResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateContactFlowResponse.Builder, CreateContactFlowResponse> {
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(CreateContactFlowResponse::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final SdkField<String> CONTACT_FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowArn").getter(getter(CreateContactFlowResponse::contactFlowArn))
            .setter(setter(Builder::contactFlowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FLOW_ID_FIELD,
            CONTACT_FLOW_ARN_FIELD));

    private final String contactFlowId;

    private final String contactFlowArn;

    private CreateContactFlowResponse(BuilderImpl builder) {
        super(builder);
        this.contactFlowId = builder.contactFlowId;
        this.contactFlowArn = builder.contactFlowArn;
    }

    /**
     * <p>
     * The identifier of the contact flow.
     * </p>
     * 
     * @return The identifier of the contact flow.
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact flow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact flow.
     */
    public final String contactFlowArn() {
        return contactFlowArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactFlowResponse)) {
            return false;
        }
        CreateContactFlowResponse other = (CreateContactFlowResponse) obj;
        return Objects.equals(contactFlowId(), other.contactFlowId()) && Objects.equals(contactFlowArn(), other.contactFlowArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactFlowResponse").add("ContactFlowId", contactFlowId())
                .add("ContactFlowArn", contactFlowArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "ContactFlowArn":
            return Optional.ofNullable(clazz.cast(contactFlowArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactFlowResponse, T> g) {
        return obj -> g.apply((CreateContactFlowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateContactFlowResponse> {
        /**
         * <p>
         * The identifier of the contact flow.
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the contact flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact flow.
         * </p>
         * 
         * @param contactFlowArn
         *        The Amazon Resource Name (ARN) of the contact flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowArn(String contactFlowArn);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String contactFlowId;

        private String contactFlowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactFlowResponse model) {
            super(model);
            contactFlowId(model.contactFlowId);
            contactFlowArn(model.contactFlowArn);
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        @Transient
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getContactFlowArn() {
            return contactFlowArn;
        }

        public final void setContactFlowArn(String contactFlowArn) {
            this.contactFlowArn = contactFlowArn;
        }

        @Override
        @Transient
        public final Builder contactFlowArn(String contactFlowArn) {
            this.contactFlowArn = contactFlowArn;
            return this;
        }

        @Override
        public CreateContactFlowResponse build() {
            return new CreateContactFlowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
