/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHoursOfOperationResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateHoursOfOperationResponse.Builder, CreateHoursOfOperationResponse> {
    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationId").getter(getter(CreateHoursOfOperationResponse::hoursOfOperationId))
            .setter(setter(Builder::hoursOfOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationId").build())
            .build();

    private static final SdkField<String> HOURS_OF_OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationArn").getter(getter(CreateHoursOfOperationResponse::hoursOfOperationArn))
            .setter(setter(Builder::hoursOfOperationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOURS_OF_OPERATION_ID_FIELD,
            HOURS_OF_OPERATION_ARN_FIELD));

    private final String hoursOfOperationId;

    private final String hoursOfOperationArn;

    private CreateHoursOfOperationResponse(BuilderImpl builder) {
        super(builder);
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.hoursOfOperationArn = builder.hoursOfOperationArn;
    }

    /**
     * <p>
     * The identifier for the hours of operation.
     * </p>
     * 
     * @return The identifier for the hours of operation.
     */
    public final String hoursOfOperationId() {
        return hoursOfOperationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the hours of operation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the hours of operation.
     */
    public final String hoursOfOperationArn() {
        return hoursOfOperationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHoursOfOperationResponse)) {
            return false;
        }
        CreateHoursOfOperationResponse other = (CreateHoursOfOperationResponse) obj;
        return Objects.equals(hoursOfOperationId(), other.hoursOfOperationId())
                && Objects.equals(hoursOfOperationArn(), other.hoursOfOperationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHoursOfOperationResponse").add("HoursOfOperationId", hoursOfOperationId())
                .add("HoursOfOperationArn", hoursOfOperationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HoursOfOperationId":
            return Optional.ofNullable(clazz.cast(hoursOfOperationId()));
        case "HoursOfOperationArn":
            return Optional.ofNullable(clazz.cast(hoursOfOperationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHoursOfOperationResponse, T> g) {
        return obj -> g.apply((CreateHoursOfOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateHoursOfOperationResponse> {
        /**
         * <p>
         * The identifier for the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationId
         *        The identifier for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationId(String hoursOfOperationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationArn
         *        The Amazon Resource Name (ARN) for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationArn(String hoursOfOperationArn);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String hoursOfOperationId;

        private String hoursOfOperationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHoursOfOperationResponse model) {
            super(model);
            hoursOfOperationId(model.hoursOfOperationId);
            hoursOfOperationArn(model.hoursOfOperationArn);
        }

        public final String getHoursOfOperationId() {
            return hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        @Transient
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final String getHoursOfOperationArn() {
            return hoursOfOperationArn;
        }

        public final void setHoursOfOperationArn(String hoursOfOperationArn) {
            this.hoursOfOperationArn = hoursOfOperationArn;
        }

        @Override
        @Transient
        public final Builder hoursOfOperationArn(String hoursOfOperationArn) {
            this.hoursOfOperationArn = hoursOfOperationArn;
            return this;
        }

        @Override
        public CreateHoursOfOperationResponse build() {
            return new CreateHoursOfOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
