/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIntegrationAssociationRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateIntegrationAssociationRequest.Builder, CreateIntegrationAssociationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateIntegrationAssociationRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationType").getter(getter(CreateIntegrationAssociationRequest::integrationTypeAsString))
            .setter(setter(Builder::integrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationType").build()).build();

    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationArn").getter(getter(CreateIntegrationAssociationRequest::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()).build();

    private static final SdkField<String> SOURCE_APPLICATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceApplicationUrl").getter(getter(CreateIntegrationAssociationRequest::sourceApplicationUrl))
            .setter(setter(Builder::sourceApplicationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceApplicationUrl").build())
            .build();

    private static final SdkField<String> SOURCE_APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceApplicationName").getter(getter(CreateIntegrationAssociationRequest::sourceApplicationName))
            .setter(setter(Builder::sourceApplicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceApplicationName").build())
            .build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(CreateIntegrationAssociationRequest::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateIntegrationAssociationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INTEGRATION_TYPE_FIELD, INTEGRATION_ARN_FIELD, SOURCE_APPLICATION_URL_FIELD, SOURCE_APPLICATION_NAME_FIELD,
            SOURCE_TYPE_FIELD, TAGS_FIELD));

    private final String instanceId;

    private final String integrationType;

    private final String integrationArn;

    private final String sourceApplicationUrl;

    private final String sourceApplicationName;

    private final String sourceType;

    private final Map<String, String> tags;

    private CreateIntegrationAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.integrationType = builder.integrationType;
        this.integrationArn = builder.integrationArn;
        this.sourceApplicationUrl = builder.sourceApplicationUrl;
        this.sourceApplicationName = builder.sourceApplicationName;
        this.sourceType = builder.sourceType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The type of information to be ingested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The type of information to be ingested.
     * @see IntegrationType
     */
    public final IntegrationType integrationType() {
        return IntegrationType.fromValue(integrationType);
    }

    /**
     * <p>
     * The type of information to be ingested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The type of information to be ingested.
     * @see IntegrationType
     */
    public final String integrationTypeAsString() {
        return integrationType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the integration.
     */
    public final String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The URL for the external application.
     * </p>
     * 
     * @return The URL for the external application.
     */
    public final String sourceApplicationUrl() {
        return sourceApplicationUrl;
    }

    /**
     * <p>
     * The name of the external application.
     * </p>
     * 
     * @return The name of the external application.
     */
    public final String sourceApplicationName() {
        return sourceApplicationName;
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of the data source.
     * @see SourceType
     */
    public final SourceType sourceType() {
        return SourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of the data source.
     * @see SourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceApplicationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceApplicationName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationAssociationRequest)) {
            return false;
        }
        CreateIntegrationAssociationRequest other = (CreateIntegrationAssociationRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(integrationTypeAsString(), other.integrationTypeAsString())
                && Objects.equals(integrationArn(), other.integrationArn())
                && Objects.equals(sourceApplicationUrl(), other.sourceApplicationUrl())
                && Objects.equals(sourceApplicationName(), other.sourceApplicationName())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIntegrationAssociationRequest").add("InstanceId", instanceId())
                .add("IntegrationType", integrationTypeAsString()).add("IntegrationArn", integrationArn())
                .add("SourceApplicationUrl", sourceApplicationUrl()).add("SourceApplicationName", sourceApplicationName())
                .add("SourceType", sourceTypeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "IntegrationType":
            return Optional.ofNullable(clazz.cast(integrationTypeAsString()));
        case "IntegrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "SourceApplicationUrl":
            return Optional.ofNullable(clazz.cast(sourceApplicationUrl()));
        case "SourceApplicationName":
            return Optional.ofNullable(clazz.cast(sourceApplicationName()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationAssociationRequest, T> g) {
        return obj -> g.apply((CreateIntegrationAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIntegrationAssociationRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The type of information to be ingested.
         * </p>
         * 
         * @param integrationType
         *        The type of information to be ingested.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(String integrationType);

        /**
         * <p>
         * The type of information to be ingested.
         * </p>
         * 
         * @param integrationType
         *        The type of information to be ingested.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(IntegrationType integrationType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the integration.
         * </p>
         * 
         * @param integrationArn
         *        The Amazon Resource Name (ARN) of the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The URL for the external application.
         * </p>
         * 
         * @param sourceApplicationUrl
         *        The URL for the external application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApplicationUrl(String sourceApplicationUrl);

        /**
         * <p>
         * The name of the external application.
         * </p>
         * 
         * @param sourceApplicationName
         *        The name of the external application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApplicationName(String sourceApplicationName);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param sourceType
         *        The type of the data source.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param sourceType
         *        The type of the data source.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(SourceType sourceType);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String integrationType;

        private String integrationArn;

        private String sourceApplicationUrl;

        private String sourceApplicationName;

        private String sourceType;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationAssociationRequest model) {
            super(model);
            instanceId(model.instanceId);
            integrationType(model.integrationType);
            integrationArn(model.integrationArn);
            sourceApplicationUrl(model.sourceApplicationUrl);
            sourceApplicationName(model.sourceApplicationName);
            sourceType(model.sourceType);
            tags(model.tags);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getIntegrationType() {
            return integrationType;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        @Override
        @Transient
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        @Transient
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        @Transient
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getSourceApplicationUrl() {
            return sourceApplicationUrl;
        }

        public final void setSourceApplicationUrl(String sourceApplicationUrl) {
            this.sourceApplicationUrl = sourceApplicationUrl;
        }

        @Override
        @Transient
        public final Builder sourceApplicationUrl(String sourceApplicationUrl) {
            this.sourceApplicationUrl = sourceApplicationUrl;
            return this;
        }

        public final String getSourceApplicationName() {
            return sourceApplicationName;
        }

        public final void setSourceApplicationName(String sourceApplicationName) {
            this.sourceApplicationName = sourceApplicationName;
        }

        @Override
        @Transient
        public final Builder sourceApplicationName(String sourceApplicationName) {
            this.sourceApplicationName = sourceApplicationName;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        @Transient
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationAssociationRequest build() {
            return new CreateIntegrationAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
