/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the use case.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UseCase implements SdkPojo, Serializable, ToCopyableBuilder<UseCase.Builder, UseCase> {
    private static final SdkField<String> USE_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseCaseId").getter(getter(UseCase::useCaseId)).setter(setter(Builder::useCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseId").build()).build();

    private static final SdkField<String> USE_CASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseCaseArn").getter(getter(UseCase::useCaseArn)).setter(setter(Builder::useCaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseArn").build()).build();

    private static final SdkField<String> USE_CASE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseCaseType").getter(getter(UseCase::useCaseTypeAsString)).setter(setter(Builder::useCaseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_CASE_ID_FIELD,
            USE_CASE_ARN_FIELD, USE_CASE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String useCaseId;

    private final String useCaseArn;

    private final String useCaseType;

    private UseCase(BuilderImpl builder) {
        this.useCaseId = builder.useCaseId;
        this.useCaseArn = builder.useCaseArn;
        this.useCaseType = builder.useCaseType;
    }

    /**
     * <p>
     * The identifier for the use case.
     * </p>
     * 
     * @return The identifier for the use case.
     */
    public final String useCaseId() {
        return useCaseId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the use case.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the use case.
     */
    public final String useCaseArn() {
        return useCaseArn;
    }

    /**
     * <p>
     * The type of use case to associate to the AppIntegration association. Each AppIntegration association can have
     * only one of each use case type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useCaseType} will
     * return {@link UseCaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #useCaseTypeAsString}.
     * </p>
     * 
     * @return The type of use case to associate to the AppIntegration association. Each AppIntegration association can
     *         have only one of each use case type.
     * @see UseCaseType
     */
    public final UseCaseType useCaseType() {
        return UseCaseType.fromValue(useCaseType);
    }

    /**
     * <p>
     * The type of use case to associate to the AppIntegration association. Each AppIntegration association can have
     * only one of each use case type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useCaseType} will
     * return {@link UseCaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #useCaseTypeAsString}.
     * </p>
     * 
     * @return The type of use case to associate to the AppIntegration association. Each AppIntegration association can
     *         have only one of each use case type.
     * @see UseCaseType
     */
    public final String useCaseTypeAsString() {
        return useCaseType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(useCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(useCaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(useCaseTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UseCase)) {
            return false;
        }
        UseCase other = (UseCase) obj;
        return Objects.equals(useCaseId(), other.useCaseId()) && Objects.equals(useCaseArn(), other.useCaseArn())
                && Objects.equals(useCaseTypeAsString(), other.useCaseTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UseCase").add("UseCaseId", useCaseId()).add("UseCaseArn", useCaseArn())
                .add("UseCaseType", useCaseTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UseCaseId":
            return Optional.ofNullable(clazz.cast(useCaseId()));
        case "UseCaseArn":
            return Optional.ofNullable(clazz.cast(useCaseArn()));
        case "UseCaseType":
            return Optional.ofNullable(clazz.cast(useCaseTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UseCase, T> g) {
        return obj -> g.apply((UseCase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UseCase> {
        /**
         * <p>
         * The identifier for the use case.
         * </p>
         * 
         * @param useCaseId
         *        The identifier for the use case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCaseId(String useCaseId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the use case.
         * </p>
         * 
         * @param useCaseArn
         *        The Amazon Resource Name (ARN) for the use case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCaseArn(String useCaseArn);

        /**
         * <p>
         * The type of use case to associate to the AppIntegration association. Each AppIntegration association can have
         * only one of each use case type.
         * </p>
         * 
         * @param useCaseType
         *        The type of use case to associate to the AppIntegration association. Each AppIntegration association
         *        can have only one of each use case type.
         * @see UseCaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UseCaseType
         */
        Builder useCaseType(String useCaseType);

        /**
         * <p>
         * The type of use case to associate to the AppIntegration association. Each AppIntegration association can have
         * only one of each use case type.
         * </p>
         * 
         * @param useCaseType
         *        The type of use case to associate to the AppIntegration association. Each AppIntegration association
         *        can have only one of each use case type.
         * @see UseCaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UseCaseType
         */
        Builder useCaseType(UseCaseType useCaseType);
    }

    static final class BuilderImpl implements Builder {
        private String useCaseId;

        private String useCaseArn;

        private String useCaseType;

        private BuilderImpl() {
        }

        private BuilderImpl(UseCase model) {
            useCaseId(model.useCaseId);
            useCaseArn(model.useCaseArn);
            useCaseType(model.useCaseType);
        }

        public final String getUseCaseId() {
            return useCaseId;
        }

        public final void setUseCaseId(String useCaseId) {
            this.useCaseId = useCaseId;
        }

        @Override
        @Transient
        public final Builder useCaseId(String useCaseId) {
            this.useCaseId = useCaseId;
            return this;
        }

        public final String getUseCaseArn() {
            return useCaseArn;
        }

        public final void setUseCaseArn(String useCaseArn) {
            this.useCaseArn = useCaseArn;
        }

        @Override
        @Transient
        public final Builder useCaseArn(String useCaseArn) {
            this.useCaseArn = useCaseArn;
            return this;
        }

        public final String getUseCaseType() {
            return useCaseType;
        }

        public final void setUseCaseType(String useCaseType) {
            this.useCaseType = useCaseType;
        }

        @Override
        @Transient
        public final Builder useCaseType(String useCaseType) {
            this.useCaseType = useCaseType;
            return this;
        }

        @Override
        @Transient
        public final Builder useCaseType(UseCaseType useCaseType) {
            this.useCaseType(useCaseType == null ? null : useCaseType.toString());
            return this;
        }

        @Override
        public UseCase build() {
            return new UseCase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
