/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the agent who accepted the contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentInfo implements SdkPojo, Serializable, ToCopyableBuilder<AgentInfo.Builder, AgentInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AgentInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> CONNECTED_TO_AGENT_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("ConnectedToAgentTimestamp")
            .getter(getter(AgentInfo::connectedToAgentTimestamp)).setter(setter(Builder::connectedToAgentTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedToAgentTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CONNECTED_TO_AGENT_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant connectedToAgentTimestamp;

    private AgentInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.connectedToAgentTimestamp = builder.connectedToAgentTimestamp;
    }

    /**
     * <p>
     * The identifier of the agent who accepted the contact.
     * </p>
     * 
     * @return The identifier of the agent who accepted the contact.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The timestamp when the contact was connected to the agent.
     * </p>
     * 
     * @return The timestamp when the contact was connected to the agent.
     */
    public final Instant connectedToAgentTimestamp() {
        return connectedToAgentTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(connectedToAgentTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentInfo)) {
            return false;
        }
        AgentInfo other = (AgentInfo) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(connectedToAgentTimestamp(), other.connectedToAgentTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentInfo").add("Id", id()).add("ConnectedToAgentTimestamp", connectedToAgentTimestamp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ConnectedToAgentTimestamp":
            return Optional.ofNullable(clazz.cast(connectedToAgentTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentInfo, T> g) {
        return obj -> g.apply((AgentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentInfo> {
        /**
         * <p>
         * The identifier of the agent who accepted the contact.
         * </p>
         * 
         * @param id
         *        The identifier of the agent who accepted the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The timestamp when the contact was connected to the agent.
         * </p>
         * 
         * @param connectedToAgentTimestamp
         *        The timestamp when the contact was connected to the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedToAgentTimestamp(Instant connectedToAgentTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant connectedToAgentTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentInfo model) {
            id(model.id);
            connectedToAgentTimestamp(model.connectedToAgentTimestamp);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getConnectedToAgentTimestamp() {
            return connectedToAgentTimestamp;
        }

        public final void setConnectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
        }

        @Override
        @Transient
        public final Builder connectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
            return this;
        }

        @Override
        public AgentInfo build() {
            return new AgentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
