/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an agent status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentStatus implements SdkPojo, Serializable, ToCopyableBuilder<AgentStatus.Builder, AgentStatus> {
    private static final SdkField<String> AGENT_STATUS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentStatusARN").getter(getter(AgentStatus::agentStatusARN)).setter(setter(Builder::agentStatusARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatusARN").build()).build();

    private static final SdkField<String> AGENT_STATUS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentStatusId").getter(getter(AgentStatus::agentStatusId)).setter(setter(Builder::agentStatusId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatusId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AgentStatus::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AgentStatus::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AgentStatus::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> DISPLAY_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DisplayOrder").getter(getter(AgentStatus::displayOrder)).setter(setter(Builder::displayOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOrder").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(AgentStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(AgentStatus::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_STATUS_ARN_FIELD,
            AGENT_STATUS_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, DISPLAY_ORDER_FIELD, STATE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentStatusARN;

    private final String agentStatusId;

    private final String name;

    private final String description;

    private final String type;

    private final Integer displayOrder;

    private final String state;

    private final Map<String, String> tags;

    private AgentStatus(BuilderImpl builder) {
        this.agentStatusARN = builder.agentStatusARN;
        this.agentStatusId = builder.agentStatusId;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.displayOrder = builder.displayOrder;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent status.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent status.
     */
    public final String agentStatusARN() {
        return agentStatusARN;
    }

    /**
     * <p>
     * The identifier of the agent status.
     * </p>
     * 
     * @return The identifier of the agent status.
     */
    public final String agentStatusId() {
        return agentStatusId;
    }

    /**
     * <p>
     * The name of the agent status.
     * </p>
     * 
     * @return The name of the agent status.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the agent status.
     * </p>
     * 
     * @return The description of the agent status.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of agent status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AgentStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of agent status.
     * @see AgentStatusType
     */
    public final AgentStatusType type() {
        return AgentStatusType.fromValue(type);
    }

    /**
     * <p>
     * The type of agent status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AgentStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of agent status.
     * @see AgentStatusType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The display order of the agent status.
     * </p>
     * 
     * @return The display order of the agent status.
     */
    public final Integer displayOrder() {
        return displayOrder;
    }

    /**
     * <p>
     * The state of the agent status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AgentStatusState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the agent status.
     * @see AgentStatusState
     */
    public final AgentStatusState state() {
        return AgentStatusState.fromValue(state);
    }

    /**
     * <p>
     * The state of the agent status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AgentStatusState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the agent status.
     * @see AgentStatusState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentStatusARN());
        hashCode = 31 * hashCode + Objects.hashCode(agentStatusId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayOrder());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentStatus)) {
            return false;
        }
        AgentStatus other = (AgentStatus) obj;
        return Objects.equals(agentStatusARN(), other.agentStatusARN()) && Objects.equals(agentStatusId(), other.agentStatusId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(displayOrder(), other.displayOrder())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentStatus").add("AgentStatusARN", agentStatusARN()).add("AgentStatusId", agentStatusId())
                .add("Name", name()).add("Description", description()).add("Type", typeAsString())
                .add("DisplayOrder", displayOrder()).add("State", stateAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentStatusARN":
            return Optional.ofNullable(clazz.cast(agentStatusARN()));
        case "AgentStatusId":
            return Optional.ofNullable(clazz.cast(agentStatusId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DisplayOrder":
            return Optional.ofNullable(clazz.cast(displayOrder()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentStatus, T> g) {
        return obj -> g.apply((AgentStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentStatus> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent status.
         * </p>
         * 
         * @param agentStatusARN
         *        The Amazon Resource Name (ARN) of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentStatusARN(String agentStatusARN);

        /**
         * <p>
         * The identifier of the agent status.
         * </p>
         * 
         * @param agentStatusId
         *        The identifier of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentStatusId(String agentStatusId);

        /**
         * <p>
         * The name of the agent status.
         * </p>
         * 
         * @param name
         *        The name of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the agent status.
         * </p>
         * 
         * @param description
         *        The description of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of agent status.
         * </p>
         * 
         * @param type
         *        The type of agent status.
         * @see AgentStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatusType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of agent status.
         * </p>
         * 
         * @param type
         *        The type of agent status.
         * @see AgentStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatusType
         */
        Builder type(AgentStatusType type);

        /**
         * <p>
         * The display order of the agent status.
         * </p>
         * 
         * @param displayOrder
         *        The display order of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOrder(Integer displayOrder);

        /**
         * <p>
         * The state of the agent status.
         * </p>
         * 
         * @param state
         *        The state of the agent status.
         * @see AgentStatusState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatusState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the agent status.
         * </p>
         * 
         * @param state
         *        The state of the agent status.
         * @see AgentStatusState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatusState
         */
        Builder state(AgentStatusState state);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String agentStatusARN;

        private String agentStatusId;

        private String name;

        private String description;

        private String type;

        private Integer displayOrder;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentStatus model) {
            agentStatusARN(model.agentStatusARN);
            agentStatusId(model.agentStatusId);
            name(model.name);
            description(model.description);
            type(model.type);
            displayOrder(model.displayOrder);
            state(model.state);
            tags(model.tags);
        }

        public final String getAgentStatusARN() {
            return agentStatusARN;
        }

        public final void setAgentStatusARN(String agentStatusARN) {
            this.agentStatusARN = agentStatusARN;
        }

        @Override
        @Transient
        public final Builder agentStatusARN(String agentStatusARN) {
            this.agentStatusARN = agentStatusARN;
            return this;
        }

        public final String getAgentStatusId() {
            return agentStatusId;
        }

        public final void setAgentStatusId(String agentStatusId) {
            this.agentStatusId = agentStatusId;
        }

        @Override
        @Transient
        public final Builder agentStatusId(String agentStatusId) {
            this.agentStatusId = agentStatusId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(AgentStatusType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getDisplayOrder() {
            return displayOrder;
        }

        public final void setDisplayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
        }

        @Override
        @Transient
        public final Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(AgentStatusState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public AgentStatus build() {
            return new AgentStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
