/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data for a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserData implements SdkPojo, Serializable, ToCopyableBuilder<UserData.Builder, UserData> {
    private static final SdkField<UserReference> USER_FIELD = SdkField.<UserReference> builder(MarshallingType.SDK_POJO)
            .memberName("User").getter(getter(UserData::user)).setter(setter(Builder::user)).constructor(UserReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final SdkField<RoutingProfileReference> ROUTING_PROFILE_FIELD = SdkField
            .<RoutingProfileReference> builder(MarshallingType.SDK_POJO).memberName("RoutingProfile")
            .getter(getter(UserData::routingProfile)).setter(setter(Builder::routingProfile))
            .constructor(RoutingProfileReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfile").build()).build();

    private static final SdkField<HierarchyPathReference> HIERARCHY_PATH_FIELD = SdkField
            .<HierarchyPathReference> builder(MarshallingType.SDK_POJO).memberName("HierarchyPath")
            .getter(getter(UserData::hierarchyPath)).setter(setter(Builder::hierarchyPath))
            .constructor(HierarchyPathReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyPath").build()).build();

    private static final SdkField<AgentStatusReference> STATUS_FIELD = SdkField
            .<AgentStatusReference> builder(MarshallingType.SDK_POJO).memberName("Status").getter(getter(UserData::status))
            .setter(setter(Builder::status)).constructor(AgentStatusReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, Integer>> AVAILABLE_SLOTS_BY_CHANNEL_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("AvailableSlotsByChannel")
            .getter(getter(UserData::availableSlotsByChannelAsStrings))
            .setter(setter(Builder::availableSlotsByChannelWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableSlotsByChannel").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> MAX_SLOTS_BY_CHANNEL_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("MaxSlotsByChannel")
            .getter(getter(UserData::maxSlotsByChannelAsStrings))
            .setter(setter(Builder::maxSlotsByChannelWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSlotsByChannel").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> ACTIVE_SLOTS_BY_CHANNEL_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("ActiveSlotsByChannel")
            .getter(getter(UserData::activeSlotsByChannelAsStrings))
            .setter(setter(Builder::activeSlotsByChannelWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveSlotsByChannel").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AgentContactReference>> CONTACTS_FIELD = SdkField
            .<List<AgentContactReference>> builder(MarshallingType.LIST)
            .memberName("Contacts")
            .getter(getter(UserData::contacts))
            .setter(setter(Builder::contacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentContactReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentContactReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD,
            ROUTING_PROFILE_FIELD, HIERARCHY_PATH_FIELD, STATUS_FIELD, AVAILABLE_SLOTS_BY_CHANNEL_FIELD,
            MAX_SLOTS_BY_CHANNEL_FIELD, ACTIVE_SLOTS_BY_CHANNEL_FIELD, CONTACTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final UserReference user;

    private final RoutingProfileReference routingProfile;

    private final HierarchyPathReference hierarchyPath;

    private final AgentStatusReference status;

    private final Map<String, Integer> availableSlotsByChannel;

    private final Map<String, Integer> maxSlotsByChannel;

    private final Map<String, Integer> activeSlotsByChannel;

    private final List<AgentContactReference> contacts;

    private UserData(BuilderImpl builder) {
        this.user = builder.user;
        this.routingProfile = builder.routingProfile;
        this.hierarchyPath = builder.hierarchyPath;
        this.status = builder.status;
        this.availableSlotsByChannel = builder.availableSlotsByChannel;
        this.maxSlotsByChannel = builder.maxSlotsByChannel;
        this.activeSlotsByChannel = builder.activeSlotsByChannel;
        this.contacts = builder.contacts;
    }

    /**
     * <p>
     * Information about the user for the data that is returned. It contains the <code>resourceId</code> and ARN of the
     * user.
     * </p>
     * 
     * @return Information about the user for the data that is returned. It contains the <code>resourceId</code> and ARN
     *         of the user.
     */
    public final UserReference user() {
        return user;
    }

    /**
     * <p>
     * Information about the routing profile that is assigned to the user.
     * </p>
     * 
     * @return Information about the routing profile that is assigned to the user.
     */
    public final RoutingProfileReference routingProfile() {
        return routingProfile;
    }

    /**
     * <p>
     * Contains information about the levels of a hierarchy group assigned to a user.
     * </p>
     * 
     * @return Contains information about the levels of a hierarchy group assigned to a user.
     */
    public final HierarchyPathReference hierarchyPath() {
        return hierarchyPath;
    }

    /**
     * <p>
     * The status of the agent that they manually set in their Contact Control Panel (CCP), or that the supervisor
     * manually changes in the real-time metrics report.
     * </p>
     * 
     * @return The status of the agent that they manually set in their Contact Control Panel (CCP), or that the
     *         supervisor manually changes in the real-time metrics report.
     */
    public final AgentStatusReference status() {
        return status;
    }

    /**
     * <p>
     * A map of available slots by channel. The key is a channel name. The value is an integer: the available number of
     * slots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailableSlotsByChannel} method.
     * </p>
     * 
     * @return A map of available slots by channel. The key is a channel name. The value is an integer: the available
     *         number of slots.
     */
    public final Map<Channel, Integer> availableSlotsByChannel() {
        return ChannelToCountMapCopier.copyStringToEnum(availableSlotsByChannel);
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailableSlotsByChannel property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAvailableSlotsByChannel() {
        return availableSlotsByChannel != null && !(availableSlotsByChannel instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of available slots by channel. The key is a channel name. The value is an integer: the available number of
     * slots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailableSlotsByChannel} method.
     * </p>
     * 
     * @return A map of available slots by channel. The key is a channel name. The value is an integer: the available
     *         number of slots.
     */
    public final Map<String, Integer> availableSlotsByChannelAsStrings() {
        return availableSlotsByChannel;
    }

    /**
     * <p>
     * A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number of
     * slots. This is calculated from <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html">MediaConcurrency</a> of
     * the <code>RoutingProfile</code> assigned to the agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMaxSlotsByChannel} method.
     * </p>
     * 
     * @return A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number
     *         of slots. This is calculated from <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html"
     *         >MediaConcurrency</a> of the <code>RoutingProfile</code> assigned to the agent.
     */
    public final Map<Channel, Integer> maxSlotsByChannel() {
        return ChannelToCountMapCopier.copyStringToEnum(maxSlotsByChannel);
    }

    /**
     * For responses, this returns true if the service returned a value for the MaxSlotsByChannel property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMaxSlotsByChannel() {
        return maxSlotsByChannel != null && !(maxSlotsByChannel instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number of
     * slots. This is calculated from <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html">MediaConcurrency</a> of
     * the <code>RoutingProfile</code> assigned to the agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMaxSlotsByChannel} method.
     * </p>
     * 
     * @return A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number
     *         of slots. This is calculated from <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html"
     *         >MediaConcurrency</a> of the <code>RoutingProfile</code> assigned to the agent.
     */
    public final Map<String, Integer> maxSlotsByChannelAsStrings() {
        return maxSlotsByChannel;
    }

    /**
     * <p>
     * A map of active slots by channel. The key is a channel name. The value is an integer: the number of active slots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActiveSlotsByChannel} method.
     * </p>
     * 
     * @return A map of active slots by channel. The key is a channel name. The value is an integer: the number of
     *         active slots.
     */
    public final Map<Channel, Integer> activeSlotsByChannel() {
        return ChannelToCountMapCopier.copyStringToEnum(activeSlotsByChannel);
    }

    /**
     * For responses, this returns true if the service returned a value for the ActiveSlotsByChannel property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActiveSlotsByChannel() {
        return activeSlotsByChannel != null && !(activeSlotsByChannel instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of active slots by channel. The key is a channel name. The value is an integer: the number of active slots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActiveSlotsByChannel} method.
     * </p>
     * 
     * @return A map of active slots by channel. The key is a channel name. The value is an integer: the number of
     *         active slots.
     */
    public final Map<String, Integer> activeSlotsByChannelAsStrings() {
        return activeSlotsByChannel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contacts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContacts() {
        return contacts != null && !(contacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of contact reference information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContacts} method.
     * </p>
     * 
     * @return A list of contact reference information.
     */
    public final List<AgentContactReference> contacts() {
        return contacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfile());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyPath());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailableSlotsByChannel() ? availableSlotsByChannelAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMaxSlotsByChannel() ? maxSlotsByChannelAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActiveSlotsByChannel() ? activeSlotsByChannelAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContacts() ? contacts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserData)) {
            return false;
        }
        UserData other = (UserData) obj;
        return Objects.equals(user(), other.user()) && Objects.equals(routingProfile(), other.routingProfile())
                && Objects.equals(hierarchyPath(), other.hierarchyPath()) && Objects.equals(status(), other.status())
                && hasAvailableSlotsByChannel() == other.hasAvailableSlotsByChannel()
                && Objects.equals(availableSlotsByChannelAsStrings(), other.availableSlotsByChannelAsStrings())
                && hasMaxSlotsByChannel() == other.hasMaxSlotsByChannel()
                && Objects.equals(maxSlotsByChannelAsStrings(), other.maxSlotsByChannelAsStrings())
                && hasActiveSlotsByChannel() == other.hasActiveSlotsByChannel()
                && Objects.equals(activeSlotsByChannelAsStrings(), other.activeSlotsByChannelAsStrings())
                && hasContacts() == other.hasContacts() && Objects.equals(contacts(), other.contacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserData").add("User", user()).add("RoutingProfile", routingProfile())
                .add("HierarchyPath", hierarchyPath()).add("Status", status())
                .add("AvailableSlotsByChannel", hasAvailableSlotsByChannel() ? availableSlotsByChannelAsStrings() : null)
                .add("MaxSlotsByChannel", hasMaxSlotsByChannel() ? maxSlotsByChannelAsStrings() : null)
                .add("ActiveSlotsByChannel", hasActiveSlotsByChannel() ? activeSlotsByChannelAsStrings() : null)
                .add("Contacts", hasContacts() ? contacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "RoutingProfile":
            return Optional.ofNullable(clazz.cast(routingProfile()));
        case "HierarchyPath":
            return Optional.ofNullable(clazz.cast(hierarchyPath()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "AvailableSlotsByChannel":
            return Optional.ofNullable(clazz.cast(availableSlotsByChannelAsStrings()));
        case "MaxSlotsByChannel":
            return Optional.ofNullable(clazz.cast(maxSlotsByChannelAsStrings()));
        case "ActiveSlotsByChannel":
            return Optional.ofNullable(clazz.cast(activeSlotsByChannelAsStrings()));
        case "Contacts":
            return Optional.ofNullable(clazz.cast(contacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserData, T> g) {
        return obj -> g.apply((UserData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserData> {
        /**
         * <p>
         * Information about the user for the data that is returned. It contains the <code>resourceId</code> and ARN of
         * the user.
         * </p>
         * 
         * @param user
         *        Information about the user for the data that is returned. It contains the <code>resourceId</code> and
         *        ARN of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(UserReference user);

        /**
         * <p>
         * Information about the user for the data that is returned. It contains the <code>resourceId</code> and ARN of
         * the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserReference.Builder} avoiding the need
         * to create one manually via {@link UserReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserReference.Builder#build()} is called immediately and its
         * result is passed to {@link #user(UserReference)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link UserReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(UserReference)
         */
        default Builder user(Consumer<UserReference.Builder> user) {
            return user(UserReference.builder().applyMutation(user).build());
        }

        /**
         * <p>
         * Information about the routing profile that is assigned to the user.
         * </p>
         * 
         * @param routingProfile
         *        Information about the routing profile that is assigned to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfile(RoutingProfileReference routingProfile);

        /**
         * <p>
         * Information about the routing profile that is assigned to the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutingProfileReference.Builder} avoiding
         * the need to create one manually via {@link RoutingProfileReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingProfileReference.Builder#build()} is called immediately
         * and its result is passed to {@link #routingProfile(RoutingProfileReference)}.
         * 
         * @param routingProfile
         *        a consumer that will call methods on {@link RoutingProfileReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingProfile(RoutingProfileReference)
         */
        default Builder routingProfile(Consumer<RoutingProfileReference.Builder> routingProfile) {
            return routingProfile(RoutingProfileReference.builder().applyMutation(routingProfile).build());
        }

        /**
         * <p>
         * Contains information about the levels of a hierarchy group assigned to a user.
         * </p>
         * 
         * @param hierarchyPath
         *        Contains information about the levels of a hierarchy group assigned to a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyPath(HierarchyPathReference hierarchyPath);

        /**
         * <p>
         * Contains information about the levels of a hierarchy group assigned to a user.
         * </p>
         * This is a convenience method that creates an instance of the {@link HierarchyPathReference.Builder} avoiding
         * the need to create one manually via {@link HierarchyPathReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HierarchyPathReference.Builder#build()} is called immediately and
         * its result is passed to {@link #hierarchyPath(HierarchyPathReference)}.
         * 
         * @param hierarchyPath
         *        a consumer that will call methods on {@link HierarchyPathReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchyPath(HierarchyPathReference)
         */
        default Builder hierarchyPath(Consumer<HierarchyPathReference.Builder> hierarchyPath) {
            return hierarchyPath(HierarchyPathReference.builder().applyMutation(hierarchyPath).build());
        }

        /**
         * <p>
         * The status of the agent that they manually set in their Contact Control Panel (CCP), or that the supervisor
         * manually changes in the real-time metrics report.
         * </p>
         * 
         * @param status
         *        The status of the agent that they manually set in their Contact Control Panel (CCP), or that the
         *        supervisor manually changes in the real-time metrics report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(AgentStatusReference status);

        /**
         * <p>
         * The status of the agent that they manually set in their Contact Control Panel (CCP), or that the supervisor
         * manually changes in the real-time metrics report.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentStatusReference.Builder} avoiding
         * the need to create one manually via {@link AgentStatusReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentStatusReference.Builder#build()} is called immediately and
         * its result is passed to {@link #status(AgentStatusReference)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link AgentStatusReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(AgentStatusReference)
         */
        default Builder status(Consumer<AgentStatusReference.Builder> status) {
            return status(AgentStatusReference.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * A map of available slots by channel. The key is a channel name. The value is an integer: the available number
         * of slots.
         * </p>
         * 
         * @param availableSlotsByChannel
         *        A map of available slots by channel. The key is a channel name. The value is an integer: the available
         *        number of slots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableSlotsByChannelWithStrings(Map<String, Integer> availableSlotsByChannel);

        /**
         * <p>
         * A map of available slots by channel. The key is a channel name. The value is an integer: the available number
         * of slots.
         * </p>
         * 
         * @param availableSlotsByChannel
         *        A map of available slots by channel. The key is a channel name. The value is an integer: the available
         *        number of slots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableSlotsByChannel(Map<Channel, Integer> availableSlotsByChannel);

        /**
         * <p>
         * A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number of
         * slots. This is calculated from <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html">MediaConcurrency</a>
         * of the <code>RoutingProfile</code> assigned to the agent.
         * </p>
         * 
         * @param maxSlotsByChannel
         *        A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum
         *        number of slots. This is calculated from <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html"
         *        >MediaConcurrency</a> of the <code>RoutingProfile</code> assigned to the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSlotsByChannelWithStrings(Map<String, Integer> maxSlotsByChannel);

        /**
         * <p>
         * A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number of
         * slots. This is calculated from <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html">MediaConcurrency</a>
         * of the <code>RoutingProfile</code> assigned to the agent.
         * </p>
         * 
         * @param maxSlotsByChannel
         *        A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum
         *        number of slots. This is calculated from <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html"
         *        >MediaConcurrency</a> of the <code>RoutingProfile</code> assigned to the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSlotsByChannel(Map<Channel, Integer> maxSlotsByChannel);

        /**
         * <p>
         * A map of active slots by channel. The key is a channel name. The value is an integer: the number of active
         * slots.
         * </p>
         * 
         * @param activeSlotsByChannel
         *        A map of active slots by channel. The key is a channel name. The value is an integer: the number of
         *        active slots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeSlotsByChannelWithStrings(Map<String, Integer> activeSlotsByChannel);

        /**
         * <p>
         * A map of active slots by channel. The key is a channel name. The value is an integer: the number of active
         * slots.
         * </p>
         * 
         * @param activeSlotsByChannel
         *        A map of active slots by channel. The key is a channel name. The value is an integer: the number of
         *        active slots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeSlotsByChannel(Map<Channel, Integer> activeSlotsByChannel);

        /**
         * <p>
         * A list of contact reference information.
         * </p>
         * 
         * @param contacts
         *        A list of contact reference information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Collection<AgentContactReference> contacts);

        /**
         * <p>
         * A list of contact reference information.
         * </p>
         * 
         * @param contacts
         *        A list of contact reference information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(AgentContactReference... contacts);

        /**
         * <p>
         * A list of contact reference information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.AgentContactReference.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connect.model.AgentContactReference#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.AgentContactReference.Builder#build()} is called
         * immediately and its result is passed to {@link #contacts(List<AgentContactReference>)}.
         * 
         * @param contacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.AgentContactReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contacts(java.util.Collection<AgentContactReference>)
         */
        Builder contacts(Consumer<AgentContactReference.Builder>... contacts);
    }

    static final class BuilderImpl implements Builder {
        private UserReference user;

        private RoutingProfileReference routingProfile;

        private HierarchyPathReference hierarchyPath;

        private AgentStatusReference status;

        private Map<String, Integer> availableSlotsByChannel = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Integer> maxSlotsByChannel = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Integer> activeSlotsByChannel = DefaultSdkAutoConstructMap.getInstance();

        private List<AgentContactReference> contacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserData model) {
            user(model.user);
            routingProfile(model.routingProfile);
            hierarchyPath(model.hierarchyPath);
            status(model.status);
            availableSlotsByChannelWithStrings(model.availableSlotsByChannel);
            maxSlotsByChannelWithStrings(model.maxSlotsByChannel);
            activeSlotsByChannelWithStrings(model.activeSlotsByChannel);
            contacts(model.contacts);
        }

        public final UserReference.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(UserReference.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(UserReference user) {
            this.user = user;
            return this;
        }

        public final RoutingProfileReference.Builder getRoutingProfile() {
            return routingProfile != null ? routingProfile.toBuilder() : null;
        }

        public final void setRoutingProfile(RoutingProfileReference.BuilderImpl routingProfile) {
            this.routingProfile = routingProfile != null ? routingProfile.build() : null;
        }

        @Override
        public final Builder routingProfile(RoutingProfileReference routingProfile) {
            this.routingProfile = routingProfile;
            return this;
        }

        public final HierarchyPathReference.Builder getHierarchyPath() {
            return hierarchyPath != null ? hierarchyPath.toBuilder() : null;
        }

        public final void setHierarchyPath(HierarchyPathReference.BuilderImpl hierarchyPath) {
            this.hierarchyPath = hierarchyPath != null ? hierarchyPath.build() : null;
        }

        @Override
        public final Builder hierarchyPath(HierarchyPathReference hierarchyPath) {
            this.hierarchyPath = hierarchyPath;
            return this;
        }

        public final AgentStatusReference.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(AgentStatusReference.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(AgentStatusReference status) {
            this.status = status;
            return this;
        }

        public final Map<String, Integer> getAvailableSlotsByChannel() {
            if (availableSlotsByChannel instanceof SdkAutoConstructMap) {
                return null;
            }
            return availableSlotsByChannel;
        }

        public final void setAvailableSlotsByChannel(Map<String, Integer> availableSlotsByChannel) {
            this.availableSlotsByChannel = ChannelToCountMapCopier.copy(availableSlotsByChannel);
        }

        @Override
        public final Builder availableSlotsByChannelWithStrings(Map<String, Integer> availableSlotsByChannel) {
            this.availableSlotsByChannel = ChannelToCountMapCopier.copy(availableSlotsByChannel);
            return this;
        }

        @Override
        public final Builder availableSlotsByChannel(Map<Channel, Integer> availableSlotsByChannel) {
            this.availableSlotsByChannel = ChannelToCountMapCopier.copyEnumToString(availableSlotsByChannel);
            return this;
        }

        public final Map<String, Integer> getMaxSlotsByChannel() {
            if (maxSlotsByChannel instanceof SdkAutoConstructMap) {
                return null;
            }
            return maxSlotsByChannel;
        }

        public final void setMaxSlotsByChannel(Map<String, Integer> maxSlotsByChannel) {
            this.maxSlotsByChannel = ChannelToCountMapCopier.copy(maxSlotsByChannel);
        }

        @Override
        public final Builder maxSlotsByChannelWithStrings(Map<String, Integer> maxSlotsByChannel) {
            this.maxSlotsByChannel = ChannelToCountMapCopier.copy(maxSlotsByChannel);
            return this;
        }

        @Override
        public final Builder maxSlotsByChannel(Map<Channel, Integer> maxSlotsByChannel) {
            this.maxSlotsByChannel = ChannelToCountMapCopier.copyEnumToString(maxSlotsByChannel);
            return this;
        }

        public final Map<String, Integer> getActiveSlotsByChannel() {
            if (activeSlotsByChannel instanceof SdkAutoConstructMap) {
                return null;
            }
            return activeSlotsByChannel;
        }

        public final void setActiveSlotsByChannel(Map<String, Integer> activeSlotsByChannel) {
            this.activeSlotsByChannel = ChannelToCountMapCopier.copy(activeSlotsByChannel);
        }

        @Override
        public final Builder activeSlotsByChannelWithStrings(Map<String, Integer> activeSlotsByChannel) {
            this.activeSlotsByChannel = ChannelToCountMapCopier.copy(activeSlotsByChannel);
            return this;
        }

        @Override
        public final Builder activeSlotsByChannel(Map<Channel, Integer> activeSlotsByChannel) {
            this.activeSlotsByChannel = ChannelToCountMapCopier.copyEnumToString(activeSlotsByChannel);
            return this;
        }

        public final List<AgentContactReference.Builder> getContacts() {
            List<AgentContactReference.Builder> result = AgentContactReferenceListCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<AgentContactReference.BuilderImpl> contacts) {
            this.contacts = AgentContactReferenceListCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<AgentContactReference> contacts) {
            this.contacts = AgentContactReferenceListCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(AgentContactReference... contacts) {
            contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<AgentContactReference.Builder>... contacts) {
            contacts(Stream.of(contacts).map(c -> AgentContactReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UserData build() {
            return new UserData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
