/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about available phone numbers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailableNumberSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailableNumberSummary.Builder, AvailableNumberSummary> {
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(AvailableNumberSummary::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> PHONE_NUMBER_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberCountryCode").getter(getter(AvailableNumberSummary::phoneNumberCountryCodeAsString))
            .setter(setter(Builder::phoneNumberCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountryCode").build())
            .build();

    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberType").getter(getter(AvailableNumberSummary::phoneNumberTypeAsString))
            .setter(setter(Builder::phoneNumberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD,
            PHONE_NUMBER_COUNTRY_CODE_FIELD, PHONE_NUMBER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String phoneNumber;

    private final String phoneNumberCountryCode;

    private final String phoneNumberType;

    private AvailableNumberSummary(BuilderImpl builder) {
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumberCountryCode = builder.phoneNumberCountryCode;
        this.phoneNumberType = builder.phoneNumberType;
    }

    /**
     * <p>
     * The phone number. Phone numbers are formatted
     * <code>[+] [country code] [subscriber number including area code]</code>.
     * </p>
     * 
     * @return The phone number. Phone numbers are formatted
     *         <code>[+] [country code] [subscriber number including area code]</code>.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The ISO country code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #phoneNumberCountryCode} will return {@link PhoneNumberCountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #phoneNumberCountryCodeAsString}.
     * </p>
     * 
     * @return The ISO country code.
     * @see PhoneNumberCountryCode
     */
    public final PhoneNumberCountryCode phoneNumberCountryCode() {
        return PhoneNumberCountryCode.fromValue(phoneNumberCountryCode);
    }

    /**
     * <p>
     * The ISO country code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #phoneNumberCountryCode} will return {@link PhoneNumberCountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #phoneNumberCountryCodeAsString}.
     * </p>
     * 
     * @return The ISO country code.
     * @see PhoneNumberCountryCode
     */
    public final String phoneNumberCountryCodeAsString() {
        return phoneNumberCountryCode;
    }

    /**
     * <p>
     * The type of phone number.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return The type of phone number.
     * @see PhoneNumberType
     */
    public final PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(phoneNumberType);
    }

    /**
     * <p>
     * The type of phone number.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return The type of phone number.
     * @see PhoneNumberType
     */
    public final String phoneNumberTypeAsString() {
        return phoneNumberType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberCountryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableNumberSummary)) {
            return false;
        }
        AvailableNumberSummary other = (AvailableNumberSummary) obj;
        return Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(phoneNumberCountryCodeAsString(), other.phoneNumberCountryCodeAsString())
                && Objects.equals(phoneNumberTypeAsString(), other.phoneNumberTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailableNumberSummary").add("PhoneNumber", phoneNumber())
                .add("PhoneNumberCountryCode", phoneNumberCountryCodeAsString())
                .add("PhoneNumberType", phoneNumberTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "PhoneNumberCountryCode":
            return Optional.ofNullable(clazz.cast(phoneNumberCountryCodeAsString()));
        case "PhoneNumberType":
            return Optional.ofNullable(clazz.cast(phoneNumberTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailableNumberSummary, T> g) {
        return obj -> g.apply((AvailableNumberSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailableNumberSummary> {
        /**
         * <p>
         * The phone number. Phone numbers are formatted
         * <code>[+] [country code] [subscriber number including area code]</code>.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number. Phone numbers are formatted
         *        <code>[+] [country code] [subscriber number including area code]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCode
         *        The ISO country code.
         * @see PhoneNumberCountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberCountryCode
         */
        Builder phoneNumberCountryCode(String phoneNumberCountryCode);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCode
         *        The ISO country code.
         * @see PhoneNumberCountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberCountryCode
         */
        Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberType
         *        The type of phone number.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(String phoneNumberType);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberType
         *        The type of phone number.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(PhoneNumberType phoneNumberType);
    }

    static final class BuilderImpl implements Builder {
        private String phoneNumber;

        private String phoneNumberCountryCode;

        private String phoneNumberType;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailableNumberSummary model) {
            phoneNumber(model.phoneNumber);
            phoneNumberCountryCode(model.phoneNumberCountryCode);
            phoneNumberType(model.phoneNumberType);
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getPhoneNumberCountryCode() {
            return phoneNumberCountryCode;
        }

        public final void setPhoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
        }

        @Override
        public final Builder phoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
            return this;
        }

        @Override
        public final Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode) {
            this.phoneNumberCountryCode(phoneNumberCountryCode == null ? null : phoneNumberCountryCode.toString());
            return this;
        }

        public final String getPhoneNumberType() {
            return phoneNumberType;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        @Override
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        @Override
        public AvailableNumberSummary build() {
            return new AvailableNumberSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
