/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCurrentMetricDataRequest extends ConnectRequest implements
        ToCopyableBuilder<GetCurrentMetricDataRequest.Builder, GetCurrentMetricDataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GetCurrentMetricDataRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<Filters> FILTERS_FIELD = SdkField.<Filters> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(GetCurrentMetricDataRequest::filters)).setter(setter(Builder::filters))
            .constructor(Filters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<List<String>> GROUPINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groupings")
            .getter(getter(GetCurrentMetricDataRequest::groupingsAsStrings))
            .setter(setter(Builder::groupingsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groupings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CurrentMetric>> CURRENT_METRICS_FIELD = SdkField
            .<List<CurrentMetric>> builder(MarshallingType.LIST)
            .memberName("CurrentMetrics")
            .getter(getter(GetCurrentMetricDataRequest::currentMetrics))
            .setter(setter(Builder::currentMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CurrentMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(CurrentMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetCurrentMetricDataRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetCurrentMetricDataRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<CurrentMetricSortCriteria>> SORT_CRITERIA_FIELD = SdkField
            .<List<CurrentMetricSortCriteria>> builder(MarshallingType.LIST)
            .memberName("SortCriteria")
            .getter(getter(GetCurrentMetricDataRequest::sortCriteria))
            .setter(setter(Builder::sortCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CurrentMetricSortCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(CurrentMetricSortCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            FILTERS_FIELD, GROUPINGS_FIELD, CURRENT_METRICS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_CRITERIA_FIELD));

    private final String instanceId;

    private final Filters filters;

    private final List<String> groupings;

    private final List<CurrentMetric> currentMetrics;

    private final String nextToken;

    private final Integer maxResults;

    private final List<CurrentMetricSortCriteria> sortCriteria;

    private GetCurrentMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.filters = builder.filters;
        this.groupings = builder.groupings;
        this.currentMetrics = builder.currentMetrics;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortCriteria = builder.sortCriteria;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The filters to apply to returned metrics. You can filter up to the following limits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queues: 100
     * </p>
     * </li>
     * <li>
     * <p>
     * Routing profiles: 100
     * </p>
     * </li>
     * <li>
     * <p>
     * Channels: 3 (VOICE, CHAT, and TASK channels are supported.)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Metric data is retrieved only for the resources associated with the queues or routing profiles, and by any
     * channels included in the filter. (You cannot filter by both queue AND routing profile.) You can include both
     * resource IDs and resource ARNs in the same request.
     * </p>
     * <p>
     * Currently tagging is only supported on the resources that are passed in the filter.
     * </p>
     * 
     * @return The filters to apply to returned metrics. You can filter up to the following limits:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Queues: 100
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Routing profiles: 100
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Channels: 3 (VOICE, CHAT, and TASK channels are supported.)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Metric data is retrieved only for the resources associated with the queues or routing profiles, and by
     *         any channels included in the filter. (You cannot filter by both queue AND routing profile.) You can
     *         include both resource IDs and resource ARNs in the same request.
     *         </p>
     *         <p>
     *         Currently tagging is only supported on the resources that are passed in the filter.
     */
    public final Filters filters() {
        return filters;
    }

    /**
     * <p>
     * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
     * returned apply to each queue rather than aggregated for all queues.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels are
     * supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile filter. In
     * addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
     * <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupings} method.
     * </p>
     * 
     * @return The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
     *         metrics returned apply to each queue rather than aggregated for all queues. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK
     *         channels are supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile filter.
     *         In addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
     *         <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
     *         </p>
     *         </li>
     */
    public final List<Grouping> groupings() {
        return GroupingsCopier.copyStringToEnum(groupings);
    }

    /**
     * For responses, this returns true if the service returned a value for the Groupings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupings() {
        return groupings != null && !(groupings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
     * returned apply to each queue rather than aggregated for all queues.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels are
     * supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile filter. In
     * addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
     * <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupings} method.
     * </p>
     * 
     * @return The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
     *         metrics returned apply to each queue rather than aggregated for all queues. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK
     *         channels are supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile filter.
     *         In addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
     *         <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
     *         </p>
     *         </li>
     */
    public final List<String> groupingsAsStrings() {
        return groupings;
    }

    /**
     * For responses, this returns true if the service returned a value for the CurrentMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCurrentMetrics() {
        return currentMetrics != null && !(currentMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a
     * description of all the metrics, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
     * Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <dl>
     * <dt>AGENTS_AFTER_CONTACT_WORK</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time"
     * >ACW</a>
     * </p>
     * </dd>
     * <dt>AGENTS_AVAILABLE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time"
     * >Available</a>
     * </p>
     * </dd>
     * <dt>AGENTS_ERROR</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time"
     * >Error</a>
     * </p>
     * </dd>
     * <dt>AGENTS_NON_PRODUCTIVE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time"
     * >NPT (Non-Productive Time)</a>
     * </p>
     * </dd>
     * <dt>AGENTS_ON_CALL</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On
     * contact</a>
     * </p>
     * </dd>
     * <dt>AGENTS_ON_CONTACT</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On
     * contact</a>
     * </p>
     * </dd>
     * <dt>AGENTS_ONLINE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time"
     * >Online</a>
     * </p>
     * </dd>
     * <dt>AGENTS_STAFFED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time"
     * >Staffed</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_IN_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time">In
     * queue</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_SCHEDULED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time"
     * >Scheduled</a>
     * </p>
     * </dd>
     * <dt>OLDEST_CONTACT_AGE</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * When you use groupings, Unit says SECONDS and the Value is returned in SECONDS.
     * </p>
     * <p>
     * When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if you
     * get a response like this:
     * </p>
     * <p>
     * <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>
     * </p>
     * <p>
     * The actual OLDEST_CONTACT_AGE is 24 seconds.
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time"
     * >Oldest</a>
     * </p>
     * </dd>
     * <dt>SLOTS_ACTIVE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time"
     * >Active</a>
     * </p>
     * </dd>
     * <dt>SLOTS_AVAILABLE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Name in real-time metrics report: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time"
     * >Availability</a>
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCurrentMetrics} method.
     * </p>
     * 
     * @return The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available.
     *         For a description of all the metrics, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time
     *         Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
     *         <dl>
     *         <dt>AGENTS_AFTER_CONTACT_WORK</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time"
     *         >ACW</a>
     *         </p>
     *         </dd>
     *         <dt>AGENTS_AVAILABLE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time"
     *         >Available</a>
     *         </p>
     *         </dd>
     *         <dt>AGENTS_ERROR</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time"
     *         >Error</a>
     *         </p>
     *         </dd>
     *         <dt>AGENTS_NON_PRODUCTIVE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time"
     *         >NPT (Non-Productive Time)</a>
     *         </p>
     *         </dd>
     *         <dt>AGENTS_ON_CALL</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
     *         >On contact</a>
     *         </p>
     *         </dd>
     *         <dt>AGENTS_ON_CONTACT</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
     *         >On contact</a>
     *         </p>
     *         </dd>
     *         <dt>AGENTS_ONLINE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time"
     *         >Online</a>
     *         </p>
     *         </dd>
     *         <dt>AGENTS_STAFFED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time"
     *         >Staffed</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_IN_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time"
     *         >In queue</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_SCHEDULED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time"
     *         >Scheduled</a>
     *         </p>
     *         </dd>
     *         <dt>OLDEST_CONTACT_AGE</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         When you use groupings, Unit says SECONDS and the Value is returned in SECONDS.
     *         </p>
     *         <p>
     *         When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example,
     *         if you get a response like this:
     *         </p>
     *         <p>
     *         <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>
     *         </p>
     *         <p>
     *         The actual OLDEST_CONTACT_AGE is 24 seconds.
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time"
     *         >Oldest</a>
     *         </p>
     *         </dd>
     *         <dt>SLOTS_ACTIVE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time"
     *         >Active</a>
     *         </p>
     *         </dd>
     *         <dt>SLOTS_AVAILABLE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Name in real-time metrics report: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time"
     *         >Availability</a>
     *         </p>
     *         </dd>
     */
    public final List<CurrentMetric> currentMetrics() {
        return currentMetrics;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * <p>
     * The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use
     * the same request parameters as the request that generated the token.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.</p>
     *         <p>
     *         The token expires after 5 minutes from the time it is created. Subsequent requests that use the token
     *         must use the same request parameters as the request that generated the token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortCriteria property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSortCriteria() {
        return sortCriteria != null && !(sortCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The way to sort the resulting response based on metrics. You can enter one sort criteria. By default resources
     * are sorted based on <code>AGENTS_ONLINE</code>, <code>DESCENDING</code>. The metric collection is sorted based on
     * the input metrics.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sorting on <code>SLOTS_ACTIVE</code> and <code>SLOTS_AVAILABLE</code> is not supported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortCriteria} method.
     * </p>
     * 
     * @return The way to sort the resulting response based on metrics. You can enter one sort criteria. By default
     *         resources are sorted based on <code>AGENTS_ONLINE</code>, <code>DESCENDING</code>. The metric collection
     *         is sorted based on the input metrics.</p>
     *         <p>
     *         Note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Sorting on <code>SLOTS_ACTIVE</code> and <code>SLOTS_AVAILABLE</code> is not supported.
     *         </p>
     *         </li>
     */
    public final List<CurrentMetricSortCriteria> sortCriteria() {
        return sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupings() ? groupingsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCurrentMetrics() ? currentMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortCriteria() ? sortCriteria() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCurrentMetricDataRequest)) {
            return false;
        }
        GetCurrentMetricDataRequest other = (GetCurrentMetricDataRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(filters(), other.filters())
                && hasGroupings() == other.hasGroupings() && Objects.equals(groupingsAsStrings(), other.groupingsAsStrings())
                && hasCurrentMetrics() == other.hasCurrentMetrics() && Objects.equals(currentMetrics(), other.currentMetrics())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasSortCriteria() == other.hasSortCriteria() && Objects.equals(sortCriteria(), other.sortCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCurrentMetricDataRequest").add("InstanceId", instanceId()).add("Filters", filters())
                .add("Groupings", hasGroupings() ? groupingsAsStrings() : null)
                .add("CurrentMetrics", hasCurrentMetrics() ? currentMetrics() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("SortCriteria", hasSortCriteria() ? sortCriteria() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Groupings":
            return Optional.ofNullable(clazz.cast(groupingsAsStrings()));
        case "CurrentMetrics":
            return Optional.ofNullable(clazz.cast(currentMetrics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCurrentMetricDataRequest, T> g) {
        return obj -> g.apply((GetCurrentMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCurrentMetricDataRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The filters to apply to returned metrics. You can filter up to the following limits:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Queues: 100
         * </p>
         * </li>
         * <li>
         * <p>
         * Routing profiles: 100
         * </p>
         * </li>
         * <li>
         * <p>
         * Channels: 3 (VOICE, CHAT, and TASK channels are supported.)
         * </p>
         * </li>
         * </ul>
         * <p>
         * Metric data is retrieved only for the resources associated with the queues or routing profiles, and by any
         * channels included in the filter. (You cannot filter by both queue AND routing profile.) You can include both
         * resource IDs and resource ARNs in the same request.
         * </p>
         * <p>
         * Currently tagging is only supported on the resources that are passed in the filter.
         * </p>
         * 
         * @param filters
         *        The filters to apply to returned metrics. You can filter up to the following limits:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Queues: 100
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Routing profiles: 100
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Channels: 3 (VOICE, CHAT, and TASK channels are supported.)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Metric data is retrieved only for the resources associated with the queues or routing profiles, and by
         *        any channels included in the filter. (You cannot filter by both queue AND routing profile.) You can
         *        include both resource IDs and resource ARNs in the same request.
         *        </p>
         *        <p>
         *        Currently tagging is only supported on the resources that are passed in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filters filters);

        /**
         * <p>
         * The filters to apply to returned metrics. You can filter up to the following limits:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Queues: 100
         * </p>
         * </li>
         * <li>
         * <p>
         * Routing profiles: 100
         * </p>
         * </li>
         * <li>
         * <p>
         * Channels: 3 (VOICE, CHAT, and TASK channels are supported.)
         * </p>
         * </li>
         * </ul>
         * <p>
         * Metric data is retrieved only for the resources associated with the queues or routing profiles, and by any
         * channels included in the filter. (You cannot filter by both queue AND routing profile.) You can include both
         * resource IDs and resource ARNs in the same request.
         * </p>
         * <p>
         * Currently tagging is only supported on the resources that are passed in the filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link Filters.Builder} avoiding the need to
         * create one manually via {@link Filters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Filters.Builder#build()} is called immediately and its result is
         * passed to {@link #filters(Filters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link Filters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(Filters)
         */
        default Builder filters(Consumer<Filters.Builder> filters) {
            return filters(Filters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
         * returned apply to each queue rather than aggregated for all queues.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels
         * are supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile filter. In
         * addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
         * <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
         *        metrics returned apply to each queue rather than aggregated for all queues. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK
         *        channels are supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile
         *        filter. In addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
         *        <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingsWithStrings(Collection<String> groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
         * returned apply to each queue rather than aggregated for all queues.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels
         * are supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile filter. In
         * addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
         * <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
         *        metrics returned apply to each queue rather than aggregated for all queues. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK
         *        channels are supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile
         *        filter. In addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
         *        <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingsWithStrings(String... groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
         * returned apply to each queue rather than aggregated for all queues.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels
         * are supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile filter. In
         * addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
         * <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
         *        metrics returned apply to each queue rather than aggregated for all queues. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK
         *        channels are supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile
         *        filter. In addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
         *        <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupings(Collection<Grouping> groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics
         * returned apply to each queue rather than aggregated for all queues.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels
         * are supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile filter. In
         * addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
         * <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the
         *        metrics returned apply to each queue rather than aggregated for all queues. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK
         *        channels are supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile
         *        filter. In addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>,
         *        <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If no <code>Grouping</code> is included in the request, a summary of metrics is returned.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupings(Grouping... groupings);

        /**
         * <p>
         * The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For
         * a description of all the metrics, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time
         * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>AGENTS_AFTER_CONTACT_WORK</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time"
         * >ACW</a>
         * </p>
         * </dd>
         * <dt>AGENTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time"
         * >Available</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ERROR</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time"
         * >Error</a>
         * </p>
         * </dd>
         * <dt>AGENTS_NON_PRODUCTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time"
         * >NPT (Non-Productive Time)</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CALL</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
         * >On contact</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CONTACT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
         * >On contact</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ONLINE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time"
         * >Online</a>
         * </p>
         * </dd>
         * <dt>AGENTS_STAFFED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time"
         * >Staffed</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_IN_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time"
         * >In queue</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_SCHEDULED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time"
         * >Scheduled</a>
         * </p>
         * </dd>
         * <dt>OLDEST_CONTACT_AGE</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * When you use groupings, Unit says SECONDS and the Value is returned in SECONDS.
         * </p>
         * <p>
         * When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if
         * you get a response like this:
         * </p>
         * <p>
         * <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>
         * </p>
         * <p>
         * The actual OLDEST_CONTACT_AGE is 24 seconds.
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time"
         * >Oldest</a>
         * </p>
         * </dd>
         * <dt>SLOTS_ACTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time"
         * >Active</a>
         * </p>
         * </dd>
         * <dt>SLOTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time"
         * >Availability</a>
         * </p>
         * </dd>
         * </dl>
         * 
         * @param currentMetrics
         *        The metrics to retrieve. Specify the name and unit for each metric. The following metrics are
         *        available. For a description of all the metrics, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html"
         *        >Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
         *        <dl>
         *        <dt>AGENTS_AFTER_CONTACT_WORK</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time"
         *        >ACW</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time"
         *        >Available</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ERROR</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time"
         *        >Error</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_NON_PRODUCTIVE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time"
         *        >NPT (Non-Productive Time)</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ON_CALL</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
         *        >On contact</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ON_CONTACT</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
         *        >On contact</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ONLINE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time"
         *        >Online</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_STAFFED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time"
         *        >Staffed</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_IN_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time"
         *        >In queue</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_SCHEDULED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time"
         *        >Scheduled</a>
         *        </p>
         *        </dd>
         *        <dt>OLDEST_CONTACT_AGE</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        When you use groupings, Unit says SECONDS and the Value is returned in SECONDS.
         *        </p>
         *        <p>
         *        When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For
         *        example, if you get a response like this:
         *        </p>
         *        <p>
         *        <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>
         *        </p>
         *        <p>
         *        The actual OLDEST_CONTACT_AGE is 24 seconds.
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time"
         *        >Oldest</a>
         *        </p>
         *        </dd>
         *        <dt>SLOTS_ACTIVE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time"
         *        >Active</a>
         *        </p>
         *        </dd>
         *        <dt>SLOTS_AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time"
         *        >Availability</a>
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMetrics(Collection<CurrentMetric> currentMetrics);

        /**
         * <p>
         * The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For
         * a description of all the metrics, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time
         * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>AGENTS_AFTER_CONTACT_WORK</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time"
         * >ACW</a>
         * </p>
         * </dd>
         * <dt>AGENTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time"
         * >Available</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ERROR</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time"
         * >Error</a>
         * </p>
         * </dd>
         * <dt>AGENTS_NON_PRODUCTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time"
         * >NPT (Non-Productive Time)</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CALL</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
         * >On contact</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CONTACT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
         * >On contact</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ONLINE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time"
         * >Online</a>
         * </p>
         * </dd>
         * <dt>AGENTS_STAFFED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time"
         * >Staffed</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_IN_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time"
         * >In queue</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_SCHEDULED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time"
         * >Scheduled</a>
         * </p>
         * </dd>
         * <dt>OLDEST_CONTACT_AGE</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * When you use groupings, Unit says SECONDS and the Value is returned in SECONDS.
         * </p>
         * <p>
         * When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if
         * you get a response like this:
         * </p>
         * <p>
         * <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>
         * </p>
         * <p>
         * The actual OLDEST_CONTACT_AGE is 24 seconds.
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time"
         * >Oldest</a>
         * </p>
         * </dd>
         * <dt>SLOTS_ACTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time"
         * >Active</a>
         * </p>
         * </dd>
         * <dt>SLOTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time"
         * >Availability</a>
         * </p>
         * </dd>
         * </dl>
         * 
         * @param currentMetrics
         *        The metrics to retrieve. Specify the name and unit for each metric. The following metrics are
         *        available. For a description of all the metrics, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html"
         *        >Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
         *        <dl>
         *        <dt>AGENTS_AFTER_CONTACT_WORK</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time"
         *        >ACW</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time"
         *        >Available</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ERROR</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time"
         *        >Error</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_NON_PRODUCTIVE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time"
         *        >NPT (Non-Productive Time)</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ON_CALL</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
         *        >On contact</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ON_CONTACT</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
         *        >On contact</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_ONLINE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time"
         *        >Online</a>
         *        </p>
         *        </dd>
         *        <dt>AGENTS_STAFFED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time"
         *        >Staffed</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_IN_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time"
         *        >In queue</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_SCHEDULED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time"
         *        >Scheduled</a>
         *        </p>
         *        </dd>
         *        <dt>OLDEST_CONTACT_AGE</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        When you use groupings, Unit says SECONDS and the Value is returned in SECONDS.
         *        </p>
         *        <p>
         *        When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For
         *        example, if you get a response like this:
         *        </p>
         *        <p>
         *        <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>
         *        </p>
         *        <p>
         *        The actual OLDEST_CONTACT_AGE is 24 seconds.
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time"
         *        >Oldest</a>
         *        </p>
         *        </dd>
         *        <dt>SLOTS_ACTIVE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time"
         *        >Active</a>
         *        </p>
         *        </dd>
         *        <dt>SLOTS_AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Name in real-time metrics report: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time"
         *        >Availability</a>
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMetrics(CurrentMetric... currentMetrics);

        /**
         * <p>
         * The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For
         * a description of all the metrics, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time
         * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>AGENTS_AFTER_CONTACT_WORK</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time"
         * >ACW</a>
         * </p>
         * </dd>
         * <dt>AGENTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time"
         * >Available</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ERROR</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time"
         * >Error</a>
         * </p>
         * </dd>
         * <dt>AGENTS_NON_PRODUCTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time"
         * >NPT (Non-Productive Time)</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CALL</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
         * >On contact</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ON_CONTACT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time"
         * >On contact</a>
         * </p>
         * </dd>
         * <dt>AGENTS_ONLINE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time"
         * >Online</a>
         * </p>
         * </dd>
         * <dt>AGENTS_STAFFED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time"
         * >Staffed</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_IN_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time"
         * >In queue</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_SCHEDULED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time"
         * >Scheduled</a>
         * </p>
         * </dd>
         * <dt>OLDEST_CONTACT_AGE</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * When you use groupings, Unit says SECONDS and the Value is returned in SECONDS.
         * </p>
         * <p>
         * When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if
         * you get a response like this:
         * </p>
         * <p>
         * <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>
         * </p>
         * <p>
         * The actual OLDEST_CONTACT_AGE is 24 seconds.
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time"
         * >Oldest</a>
         * </p>
         * </dd>
         * <dt>SLOTS_ACTIVE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time"
         * >Active</a>
         * </p>
         * </dd>
         * <dt>SLOTS_AVAILABLE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Name in real-time metrics report: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time"
         * >Availability</a>
         * </p>
         * </dd>
         * </dl>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.CurrentMetric.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.CurrentMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.CurrentMetric.Builder#build()} is called immediately and
         * its result is passed to {@link #currentMetrics(List<CurrentMetric>)}.
         * 
         * @param currentMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.CurrentMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentMetrics(java.util.Collection<CurrentMetric>)
         */
        Builder currentMetrics(Consumer<CurrentMetric.Builder>... currentMetrics);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * <p>
         * The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must
         * use the same request parameters as the request that generated the token.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.</p>
         *        <p>
         *        The token expires after 5 minutes from the time it is created. Subsequent requests that use the token
         *        must use the same request parameters as the request that generated the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The way to sort the resulting response based on metrics. You can enter one sort criteria. By default
         * resources are sorted based on <code>AGENTS_ONLINE</code>, <code>DESCENDING</code>. The metric collection is
         * sorted based on the input metrics.
         * </p>
         * <p>
         * Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sorting on <code>SLOTS_ACTIVE</code> and <code>SLOTS_AVAILABLE</code> is not supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sortCriteria
         *        The way to sort the resulting response based on metrics. You can enter one sort criteria. By default
         *        resources are sorted based on <code>AGENTS_ONLINE</code>, <code>DESCENDING</code>. The metric
         *        collection is sorted based on the input metrics.</p>
         *        <p>
         *        Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Sorting on <code>SLOTS_ACTIVE</code> and <code>SLOTS_AVAILABLE</code> is not supported.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(Collection<CurrentMetricSortCriteria> sortCriteria);

        /**
         * <p>
         * The way to sort the resulting response based on metrics. You can enter one sort criteria. By default
         * resources are sorted based on <code>AGENTS_ONLINE</code>, <code>DESCENDING</code>. The metric collection is
         * sorted based on the input metrics.
         * </p>
         * <p>
         * Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sorting on <code>SLOTS_ACTIVE</code> and <code>SLOTS_AVAILABLE</code> is not supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sortCriteria
         *        The way to sort the resulting response based on metrics. You can enter one sort criteria. By default
         *        resources are sorted based on <code>AGENTS_ONLINE</code>, <code>DESCENDING</code>. The metric
         *        collection is sorted based on the input metrics.</p>
         *        <p>
         *        Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Sorting on <code>SLOTS_ACTIVE</code> and <code>SLOTS_AVAILABLE</code> is not supported.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(CurrentMetricSortCriteria... sortCriteria);

        /**
         * <p>
         * The way to sort the resulting response based on metrics. You can enter one sort criteria. By default
         * resources are sorted based on <code>AGENTS_ONLINE</code>, <code>DESCENDING</code>. The metric collection is
         * sorted based on the input metrics.
         * </p>
         * <p>
         * Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sorting on <code>SLOTS_ACTIVE</code> and <code>SLOTS_AVAILABLE</code> is not supported.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.CurrentMetricSortCriteria.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.CurrentMetricSortCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.CurrentMetricSortCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #sortCriteria(List<CurrentMetricSortCriteria>)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.CurrentMetricSortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(java.util.Collection<CurrentMetricSortCriteria>)
         */
        Builder sortCriteria(Consumer<CurrentMetricSortCriteria.Builder>... sortCriteria);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private Filters filters;

        private List<String> groupings = DefaultSdkAutoConstructList.getInstance();

        private List<CurrentMetric> currentMetrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private List<CurrentMetricSortCriteria> sortCriteria = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCurrentMetricDataRequest model) {
            super(model);
            instanceId(model.instanceId);
            filters(model.filters);
            groupingsWithStrings(model.groupings);
            currentMetrics(model.currentMetrics);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            sortCriteria(model.sortCriteria);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Filters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(Filters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(Filters filters) {
            this.filters = filters;
            return this;
        }

        public final Collection<String> getGroupings() {
            if (groupings instanceof SdkAutoConstructList) {
                return null;
            }
            return groupings;
        }

        public final void setGroupings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
        }

        @Override
        public final Builder groupingsWithStrings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingsWithStrings(String... groupings) {
            groupingsWithStrings(Arrays.asList(groupings));
            return this;
        }

        @Override
        public final Builder groupings(Collection<Grouping> groupings) {
            this.groupings = GroupingsCopier.copyEnumToString(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupings(Grouping... groupings) {
            groupings(Arrays.asList(groupings));
            return this;
        }

        public final List<CurrentMetric.Builder> getCurrentMetrics() {
            List<CurrentMetric.Builder> result = CurrentMetricsCopier.copyToBuilder(this.currentMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCurrentMetrics(Collection<CurrentMetric.BuilderImpl> currentMetrics) {
            this.currentMetrics = CurrentMetricsCopier.copyFromBuilder(currentMetrics);
        }

        @Override
        public final Builder currentMetrics(Collection<CurrentMetric> currentMetrics) {
            this.currentMetrics = CurrentMetricsCopier.copy(currentMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentMetrics(CurrentMetric... currentMetrics) {
            currentMetrics(Arrays.asList(currentMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentMetrics(Consumer<CurrentMetric.Builder>... currentMetrics) {
            currentMetrics(Stream.of(currentMetrics).map(c -> CurrentMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<CurrentMetricSortCriteria.Builder> getSortCriteria() {
            List<CurrentMetricSortCriteria.Builder> result = CurrentMetricSortCriteriaMaxOneCopier
                    .copyToBuilder(this.sortCriteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortCriteria(Collection<CurrentMetricSortCriteria.BuilderImpl> sortCriteria) {
            this.sortCriteria = CurrentMetricSortCriteriaMaxOneCopier.copyFromBuilder(sortCriteria);
        }

        @Override
        public final Builder sortCriteria(Collection<CurrentMetricSortCriteria> sortCriteria) {
            this.sortCriteria = CurrentMetricSortCriteriaMaxOneCopier.copy(sortCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(CurrentMetricSortCriteria... sortCriteria) {
            sortCriteria(Arrays.asList(sortCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(Consumer<CurrentMetricSortCriteria.Builder>... sortCriteria) {
            sortCriteria(Stream.of(sortCriteria).map(c -> CurrentMetricSortCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCurrentMetricDataRequest build() {
            return new GetCurrentMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
