/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQuickConnectNameRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateQuickConnectNameRequest.Builder, UpdateQuickConnectNameRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateQuickConnectNameRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> QUICK_CONNECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuickConnectId").getter(getter(UpdateQuickConnectNameRequest::quickConnectId))
            .setter(setter(Builder::quickConnectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("QuickConnectId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateQuickConnectNameRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateQuickConnectNameRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            QUICK_CONNECT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD));

    private final String instanceId;

    private final String quickConnectId;

    private final String name;

    private final String description;

    private UpdateQuickConnectNameRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.quickConnectId = builder.quickConnectId;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier for the quick connect.
     * </p>
     * 
     * @return The identifier for the quick connect.
     */
    public final String quickConnectId() {
        return quickConnectId;
    }

    /**
     * <p>
     * The name of the quick connect.
     * </p>
     * 
     * @return The name of the quick connect.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the quick connect.
     * </p>
     * 
     * @return The description of the quick connect.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(quickConnectId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuickConnectNameRequest)) {
            return false;
        }
        UpdateQuickConnectNameRequest other = (UpdateQuickConnectNameRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(quickConnectId(), other.quickConnectId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQuickConnectNameRequest").add("InstanceId", instanceId())
                .add("QuickConnectId", quickConnectId()).add("Name", name()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "QuickConnectId":
            return Optional.ofNullable(clazz.cast(quickConnectId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuickConnectNameRequest, T> g) {
        return obj -> g.apply((UpdateQuickConnectNameRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateQuickConnectNameRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier for the quick connect.
         * </p>
         * 
         * @param quickConnectId
         *        The identifier for the quick connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectId(String quickConnectId);

        /**
         * <p>
         * The name of the quick connect.
         * </p>
         * 
         * @param name
         *        The name of the quick connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the quick connect.
         * </p>
         * 
         * @param description
         *        The description of the quick connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String quickConnectId;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuickConnectNameRequest model) {
            super(model);
            instanceId(model.instanceId);
            quickConnectId(model.quickConnectId);
            name(model.name);
            description(model.description);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getQuickConnectId() {
            return quickConnectId;
        }

        public final void setQuickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
        }

        @Override
        public final Builder quickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuickConnectNameRequest build() {
            return new UpdateQuickConnectNameRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
