/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.PhoneNumberCountryCode;
import software.amazon.awssdk.services.connect.model.PhoneNumberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAvailablePhoneNumbersRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, SearchAvailablePhoneNumbersRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArn").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::targetArn)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberCountryCode").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::phoneNumberCountryCodeAsString)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::phoneNumberCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountryCode").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberType").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::phoneNumberTypeAsString)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::phoneNumberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberType").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberPrefix").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::phoneNumberPrefix)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::phoneNumberPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberPrefix").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::maxResults)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::nextToken)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, PHONE_NUMBER_COUNTRY_CODE_FIELD, PHONE_NUMBER_TYPE_FIELD, PHONE_NUMBER_PREFIX_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String targetArn;
    private final String phoneNumberCountryCode;
    private final String phoneNumberType;
    private final String phoneNumberPrefix;
    private final Integer maxResults;
    private final String nextToken;

    private SearchAvailablePhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.phoneNumberCountryCode = builder.phoneNumberCountryCode;
        this.phoneNumberType = builder.phoneNumberType;
        this.phoneNumberPrefix = builder.phoneNumberPrefix;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final PhoneNumberCountryCode phoneNumberCountryCode() {
        return PhoneNumberCountryCode.fromValue(this.phoneNumberCountryCode);
    }

    public final String phoneNumberCountryCodeAsString() {
        return this.phoneNumberCountryCode;
    }

    public final PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(this.phoneNumberType);
    }

    public final String phoneNumberTypeAsString() {
        return this.phoneNumberType;
    }

    public final String phoneNumberPrefix() {
        return this.phoneNumberPrefix;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberCountryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAvailablePhoneNumbersRequest)) {
            return false;
        }
        SearchAvailablePhoneNumbersRequest other = (SearchAvailablePhoneNumbersRequest)((Object)obj);
        return Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.phoneNumberCountryCodeAsString(), other.phoneNumberCountryCodeAsString()) && Objects.equals(this.phoneNumberTypeAsString(), other.phoneNumberTypeAsString()) && Objects.equals(this.phoneNumberPrefix(), other.phoneNumberPrefix()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchAvailablePhoneNumbersRequest").add("TargetArn", (Object)this.targetArn()).add("PhoneNumberCountryCode", (Object)this.phoneNumberCountryCodeAsString()).add("PhoneNumberType", (Object)this.phoneNumberTypeAsString()).add("PhoneNumberPrefix", (Object)this.phoneNumberPrefix()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "PhoneNumberCountryCode": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberCountryCodeAsString()));
            }
            case "PhoneNumberType": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberTypeAsString()));
            }
            case "PhoneNumberPrefix": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberPrefix()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAvailablePhoneNumbersRequest, T> g) {
        return obj -> g.apply((SearchAvailablePhoneNumbersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String targetArn;
        private String phoneNumberCountryCode;
        private String phoneNumberType;
        private String phoneNumberPrefix;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAvailablePhoneNumbersRequest model) {
            super(model);
            this.targetArn(model.targetArn);
            this.phoneNumberCountryCode(model.phoneNumberCountryCode);
            this.phoneNumberType(model.phoneNumberType);
            this.phoneNumberPrefix(model.phoneNumberPrefix);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getPhoneNumberCountryCode() {
            return this.phoneNumberCountryCode;
        }

        public final void setPhoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
        }

        @Override
        public final Builder phoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
            return this;
        }

        @Override
        public final Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode) {
            this.phoneNumberCountryCode(phoneNumberCountryCode == null ? null : phoneNumberCountryCode.toString());
            return this;
        }

        public final String getPhoneNumberType() {
            return this.phoneNumberType;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        @Override
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        public final String getPhoneNumberPrefix() {
            return this.phoneNumberPrefix;
        }

        public final void setPhoneNumberPrefix(String phoneNumberPrefix) {
            this.phoneNumberPrefix = phoneNumberPrefix;
        }

        @Override
        public final Builder phoneNumberPrefix(String phoneNumberPrefix) {
            this.phoneNumberPrefix = phoneNumberPrefix;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchAvailablePhoneNumbersRequest build() {
            return new SearchAvailablePhoneNumbersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAvailablePhoneNumbersRequest> {
        public Builder targetArn(String var1);

        public Builder phoneNumberCountryCode(String var1);

        public Builder phoneNumberCountryCode(PhoneNumberCountryCode var1);

        public Builder phoneNumberType(String var1);

        public Builder phoneNumberType(PhoneNumberType var1);

        public Builder phoneNumberPrefix(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

