/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContactFlowResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeContactFlowResponse.Builder, DescribeContactFlowResponse> {
    private static final SdkField<ContactFlow> CONTACT_FLOW_FIELD = SdkField.<ContactFlow> builder(MarshallingType.SDK_POJO)
            .memberName("ContactFlow").getter(getter(DescribeContactFlowResponse::contactFlow))
            .setter(setter(Builder::contactFlow)).constructor(ContactFlow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FLOW_FIELD));

    private final ContactFlow contactFlow;

    private DescribeContactFlowResponse(BuilderImpl builder) {
        super(builder);
        this.contactFlow = builder.contactFlow;
    }

    /**
     * <p>
     * Information about the flow.
     * </p>
     * 
     * @return Information about the flow.
     */
    public final ContactFlow contactFlow() {
        return contactFlow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactFlow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContactFlowResponse)) {
            return false;
        }
        DescribeContactFlowResponse other = (DescribeContactFlowResponse) obj;
        return Objects.equals(contactFlow(), other.contactFlow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeContactFlowResponse").add("ContactFlow", contactFlow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactFlow":
            return Optional.ofNullable(clazz.cast(contactFlow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeContactFlowResponse, T> g) {
        return obj -> g.apply((DescribeContactFlowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeContactFlowResponse> {
        /**
         * <p>
         * Information about the flow.
         * </p>
         * 
         * @param contactFlow
         *        Information about the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlow(ContactFlow contactFlow);

        /**
         * <p>
         * Information about the flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactFlow.Builder} avoiding the need to
         * create one manually via {@link ContactFlow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactFlow.Builder#build()} is called immediately and its result
         * is passed to {@link #contactFlow(ContactFlow)}.
         * 
         * @param contactFlow
         *        a consumer that will call methods on {@link ContactFlow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactFlow(ContactFlow)
         */
        default Builder contactFlow(Consumer<ContactFlow.Builder> contactFlow) {
            return contactFlow(ContactFlow.builder().applyMutation(contactFlow).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private ContactFlow contactFlow;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContactFlowResponse model) {
            super(model);
            contactFlow(model.contactFlow);
        }

        public final ContactFlow.Builder getContactFlow() {
            return contactFlow != null ? contactFlow.toBuilder() : null;
        }

        public final void setContactFlow(ContactFlow.BuilderImpl contactFlow) {
            this.contactFlow = contactFlow != null ? contactFlow.build() : null;
        }

        @Override
        public final Builder contactFlow(ContactFlow contactFlow) {
            this.contactFlow = contactFlow;
            return this;
        }

        @Override
        public DescribeContactFlowResponse build() {
            return new DescribeContactFlowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
