/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRoutingProfileResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeRoutingProfileResponse.Builder, DescribeRoutingProfileResponse> {
    private static final SdkField<RoutingProfile> ROUTING_PROFILE_FIELD = SdkField
            .<RoutingProfile> builder(MarshallingType.SDK_POJO).memberName("RoutingProfile")
            .getter(getter(DescribeRoutingProfileResponse::routingProfile)).setter(setter(Builder::routingProfile))
            .constructor(RoutingProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_PROFILE_FIELD));

    private final RoutingProfile routingProfile;

    private DescribeRoutingProfileResponse(BuilderImpl builder) {
        super(builder);
        this.routingProfile = builder.routingProfile;
    }

    /**
     * <p>
     * The routing profile.
     * </p>
     * 
     * @return The routing profile.
     */
    public final RoutingProfile routingProfile() {
        return routingProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routingProfile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRoutingProfileResponse)) {
            return false;
        }
        DescribeRoutingProfileResponse other = (DescribeRoutingProfileResponse) obj;
        return Objects.equals(routingProfile(), other.routingProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRoutingProfileResponse").add("RoutingProfile", routingProfile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutingProfile":
            return Optional.ofNullable(clazz.cast(routingProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRoutingProfileResponse, T> g) {
        return obj -> g.apply((DescribeRoutingProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRoutingProfileResponse> {
        /**
         * <p>
         * The routing profile.
         * </p>
         * 
         * @param routingProfile
         *        The routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfile(RoutingProfile routingProfile);

        /**
         * <p>
         * The routing profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutingProfile.Builder} avoiding the need
         * to create one manually via {@link RoutingProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #routingProfile(RoutingProfile)}.
         * 
         * @param routingProfile
         *        a consumer that will call methods on {@link RoutingProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingProfile(RoutingProfile)
         */
        default Builder routingProfile(Consumer<RoutingProfile.Builder> routingProfile) {
            return routingProfile(RoutingProfile.builder().applyMutation(routingProfile).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private RoutingProfile routingProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRoutingProfileResponse model) {
            super(model);
            routingProfile(model.routingProfile);
        }

        public final RoutingProfile.Builder getRoutingProfile() {
            return routingProfile != null ? routingProfile.toBuilder() : null;
        }

        public final void setRoutingProfile(RoutingProfile.BuilderImpl routingProfile) {
            this.routingProfile = routingProfile != null ? routingProfile.build() : null;
        }

        @Override
        public final Builder routingProfile(RoutingProfile routingProfile) {
            this.routingProfile = routingProfile;
            return this;
        }

        @Override
        public DescribeRoutingProfileResponse build() {
            return new DescribeRoutingProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
