/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateParticipantRoleConfigRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateParticipantRoleConfigRequest.Builder, UpdateParticipantRoleConfigRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateParticipantRoleConfigRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(UpdateParticipantRoleConfigRequest::contactId))
            .setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactId").build()).build();

    private static final SdkField<UpdateParticipantRoleConfigChannelInfo> CHANNEL_CONFIGURATION_FIELD = SdkField
            .<UpdateParticipantRoleConfigChannelInfo> builder(MarshallingType.SDK_POJO).memberName("ChannelConfiguration")
            .getter(getter(UpdateParticipantRoleConfigRequest::channelConfiguration))
            .setter(setter(Builder::channelConfiguration)).constructor(UpdateParticipantRoleConfigChannelInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_ID_FIELD, CHANNEL_CONFIGURATION_FIELD));

    private final String instanceId;

    private final String contactId;

    private final UpdateParticipantRoleConfigChannelInfo channelConfiguration;

    private UpdateParticipantRoleConfigRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.channelConfiguration = builder.channelConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the contact in this instance of Amazon Connect.
     * </p>
     * 
     * @return The identifier of the contact in this instance of Amazon Connect.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The Amazon Connect channel you want to configure.
     * </p>
     * 
     * @return The Amazon Connect channel you want to configure.
     */
    public final UpdateParticipantRoleConfigChannelInfo channelConfiguration() {
        return channelConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(channelConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParticipantRoleConfigRequest)) {
            return false;
        }
        UpdateParticipantRoleConfigRequest other = (UpdateParticipantRoleConfigRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(contactId(), other.contactId())
                && Objects.equals(channelConfiguration(), other.channelConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateParticipantRoleConfigRequest").add("InstanceId", instanceId())
                .add("ContactId", contactId()).add("ChannelConfiguration", channelConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "ChannelConfiguration":
            return Optional.ofNullable(clazz.cast(channelConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateParticipantRoleConfigRequest, T> g) {
        return obj -> g.apply((UpdateParticipantRoleConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateParticipantRoleConfigRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the contact in this instance of Amazon Connect.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact in this instance of Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The Amazon Connect channel you want to configure.
         * </p>
         * 
         * @param channelConfiguration
         *        The Amazon Connect channel you want to configure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelConfiguration(UpdateParticipantRoleConfigChannelInfo channelConfiguration);

        /**
         * <p>
         * The Amazon Connect channel you want to configure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateParticipantRoleConfigChannelInfo.Builder} avoiding the need to create one manually via
         * {@link UpdateParticipantRoleConfigChannelInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateParticipantRoleConfigChannelInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #channelConfiguration(UpdateParticipantRoleConfigChannelInfo)}.
         * 
         * @param channelConfiguration
         *        a consumer that will call methods on {@link UpdateParticipantRoleConfigChannelInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelConfiguration(UpdateParticipantRoleConfigChannelInfo)
         */
        default Builder channelConfiguration(Consumer<UpdateParticipantRoleConfigChannelInfo.Builder> channelConfiguration) {
            return channelConfiguration(UpdateParticipantRoleConfigChannelInfo.builder().applyMutation(channelConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactId;

        private UpdateParticipantRoleConfigChannelInfo channelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParticipantRoleConfigRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactId(model.contactId);
            channelConfiguration(model.channelConfiguration);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final UpdateParticipantRoleConfigChannelInfo.Builder getChannelConfiguration() {
            return channelConfiguration != null ? channelConfiguration.toBuilder() : null;
        }

        public final void setChannelConfiguration(UpdateParticipantRoleConfigChannelInfo.BuilderImpl channelConfiguration) {
            this.channelConfiguration = channelConfiguration != null ? channelConfiguration.build() : null;
        }

        @Override
        public final Builder channelConfiguration(UpdateParticipantRoleConfigChannelInfo channelConfiguration) {
            this.channelConfiguration = channelConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateParticipantRoleConfigRequest build() {
            return new UpdateParticipantRoleConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
