/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a contact evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationSummary.Builder, EvaluationSummary> {
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationId").getter(getter(EvaluationSummary::evaluationId)).setter(setter(Builder::evaluationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationId").build()).build();

    private static final SdkField<String> EVALUATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationArn").getter(getter(EvaluationSummary::evaluationArn)).setter(setter(Builder::evaluationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationArn").build()).build();

    private static final SdkField<String> EVALUATION_FORM_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormTitle").getter(getter(EvaluationSummary::evaluationFormTitle))
            .setter(setter(Builder::evaluationFormTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormTitle").build())
            .build();

    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormId").getter(getter(EvaluationSummary::evaluationFormId))
            .setter(setter(Builder::evaluationFormId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EvaluationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluatorArn").getter(getter(EvaluationSummary::evaluatorArn)).setter(setter(Builder::evaluatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatorArn").build()).build();

    private static final SdkField<EvaluationScore> SCORE_FIELD = SdkField.<EvaluationScore> builder(MarshallingType.SDK_POJO)
            .memberName("Score").getter(getter(EvaluationSummary::score)).setter(setter(Builder::score))
            .constructor(EvaluationScore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(EvaluationSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(EvaluationSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ID_FIELD,
            EVALUATION_ARN_FIELD, EVALUATION_FORM_TITLE_FIELD, EVALUATION_FORM_ID_FIELD, STATUS_FIELD, EVALUATOR_ARN_FIELD,
            SCORE_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String evaluationId;

    private final String evaluationArn;

    private final String evaluationFormTitle;

    private final String evaluationFormId;

    private final String status;

    private final String evaluatorArn;

    private final EvaluationScore score;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private EvaluationSummary(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
        this.evaluationArn = builder.evaluationArn;
        this.evaluationFormTitle = builder.evaluationFormTitle;
        this.evaluationFormId = builder.evaluationFormId;
        this.status = builder.status;
        this.evaluatorArn = builder.evaluatorArn;
        this.score = builder.score;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * A unique identifier for the contact evaluation.
     * </p>
     * 
     * @return A unique identifier for the contact evaluation.
     */
    public final String evaluationId() {
        return evaluationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the contact evaluation resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the contact evaluation resource.
     */
    public final String evaluationArn() {
        return evaluationArn;
    }

    /**
     * <p>
     * A unique title of the evaluation form.
     * </p>
     * 
     * @return A unique title of the evaluation form.
     */
    public final String evaluationFormTitle() {
        return evaluationFormTitle;
    }

    /**
     * <p>
     * The unique identifier for the evaluation form.
     * </p>
     * 
     * @return The unique identifier for the evaluation form.
     */
    public final String evaluationFormId() {
        return evaluationFormId;
    }

    /**
     * <p>
     * The status of the contact evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the contact evaluation.
     * @see EvaluationStatus
     */
    public final EvaluationStatus status() {
        return EvaluationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the contact evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the contact evaluation.
     * @see EvaluationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last updated the evaluation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last updated the evaluation.
     */
    public final String evaluatorArn() {
        return evaluatorArn;
    }

    /**
     * <p>
     * The overall score of the contact evaluation.
     * </p>
     * 
     * @return The overall score of the contact evaluation.
     */
    public final EvaluationScore score() {
        return score;
    }

    /**
     * <p>
     * The timestamp for when the evaluation was created.
     * </p>
     * 
     * @return The timestamp for when the evaluation was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The timestamp for when the evaluation was last updated.
     * </p>
     * 
     * @return The timestamp for when the evaluation was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationArn());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormTitle());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSummary)) {
            return false;
        }
        EvaluationSummary other = (EvaluationSummary) obj;
        return Objects.equals(evaluationId(), other.evaluationId()) && Objects.equals(evaluationArn(), other.evaluationArn())
                && Objects.equals(evaluationFormTitle(), other.evaluationFormTitle())
                && Objects.equals(evaluationFormId(), other.evaluationFormId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(evaluatorArn(), other.evaluatorArn()) && Objects.equals(score(), other.score())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationSummary").add("EvaluationId", evaluationId()).add("EvaluationArn", evaluationArn())
                .add("EvaluationFormTitle", evaluationFormTitle()).add("EvaluationFormId", evaluationFormId())
                .add("Status", statusAsString()).add("EvaluatorArn", evaluatorArn()).add("Score", score())
                .add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.ofNullable(clazz.cast(evaluationId()));
        case "EvaluationArn":
            return Optional.ofNullable(clazz.cast(evaluationArn()));
        case "EvaluationFormTitle":
            return Optional.ofNullable(clazz.cast(evaluationFormTitle()));
        case "EvaluationFormId":
            return Optional.ofNullable(clazz.cast(evaluationFormId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "EvaluatorArn":
            return Optional.ofNullable(clazz.cast(evaluatorArn()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSummary, T> g) {
        return obj -> g.apply((EvaluationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationSummary> {
        /**
         * <p>
         * A unique identifier for the contact evaluation.
         * </p>
         * 
         * @param evaluationId
         *        A unique identifier for the contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the contact evaluation resource.
         * </p>
         * 
         * @param evaluationArn
         *        The Amazon Resource Name (ARN) for the contact evaluation resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationArn(String evaluationArn);

        /**
         * <p>
         * A unique title of the evaluation form.
         * </p>
         * 
         * @param evaluationFormTitle
         *        A unique title of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormTitle(String evaluationFormTitle);

        /**
         * <p>
         * The unique identifier for the evaluation form.
         * </p>
         * 
         * @param evaluationFormId
         *        The unique identifier for the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormId(String evaluationFormId);

        /**
         * <p>
         * The status of the contact evaluation.
         * </p>
         * 
         * @param status
         *        The status of the contact evaluation.
         * @see EvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the contact evaluation.
         * </p>
         * 
         * @param status
         *        The status of the contact evaluation.
         * @see EvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationStatus
         */
        Builder status(EvaluationStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last updated the evaluation.
         * </p>
         * 
         * @param evaluatorArn
         *        The Amazon Resource Name (ARN) of the user who last updated the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatorArn(String evaluatorArn);

        /**
         * <p>
         * The overall score of the contact evaluation.
         * </p>
         * 
         * @param score
         *        The overall score of the contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(EvaluationScore score);

        /**
         * <p>
         * The overall score of the contact evaluation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationScore.Builder} avoiding the
         * need to create one manually via {@link EvaluationScore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationScore.Builder#build()} is called immediately and its
         * result is passed to {@link #score(EvaluationScore)}.
         * 
         * @param score
         *        a consumer that will call methods on {@link EvaluationScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #score(EvaluationScore)
         */
        default Builder score(Consumer<EvaluationScore.Builder> score) {
            return score(EvaluationScore.builder().applyMutation(score).build());
        }

        /**
         * <p>
         * The timestamp for when the evaluation was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp for when the evaluation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The timestamp for when the evaluation was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp for when the evaluation was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationId;

        private String evaluationArn;

        private String evaluationFormTitle;

        private String evaluationFormId;

        private String status;

        private String evaluatorArn;

        private EvaluationScore score;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSummary model) {
            evaluationId(model.evaluationId);
            evaluationArn(model.evaluationArn);
            evaluationFormTitle(model.evaluationFormTitle);
            evaluationFormId(model.evaluationFormId);
            status(model.status);
            evaluatorArn(model.evaluatorArn);
            score(model.score);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final String getEvaluationArn() {
            return evaluationArn;
        }

        public final void setEvaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
        }

        @Override
        public final Builder evaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
            return this;
        }

        public final String getEvaluationFormTitle() {
            return evaluationFormTitle;
        }

        public final void setEvaluationFormTitle(String evaluationFormTitle) {
            this.evaluationFormTitle = evaluationFormTitle;
        }

        @Override
        public final Builder evaluationFormTitle(String evaluationFormTitle) {
            this.evaluationFormTitle = evaluationFormTitle;
            return this;
        }

        public final String getEvaluationFormId() {
            return evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEvaluatorArn() {
            return evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public final EvaluationScore.Builder getScore() {
            return score != null ? score.toBuilder() : null;
        }

        public final void setScore(EvaluationScore.BuilderImpl score) {
            this.score = score != null ? score.build() : null;
        }

        @Override
        public final Builder score(EvaluationScore score) {
            this.score = score;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public EvaluationSummary build() {
            return new EvaluationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
