/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an evaluation form used in a contact evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormContent implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormContent.Builder, EvaluationFormContent> {
    private static final SdkField<Integer> EVALUATION_FORM_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationFormVersion").getter(getter(EvaluationFormContent::evaluationFormVersion))
            .setter(setter(Builder::evaluationFormVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormVersion").build())
            .build();

    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormId").getter(getter(EvaluationFormContent::evaluationFormId))
            .setter(setter(Builder::evaluationFormId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()).build();

    private static final SdkField<String> EVALUATION_FORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormArn").getter(getter(EvaluationFormContent::evaluationFormArn))
            .setter(setter(Builder::evaluationFormArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormArn").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(EvaluationFormContent::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EvaluationFormContent::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<EvaluationFormItem>> ITEMS_FIELD = SdkField
            .<List<EvaluationFormItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(EvaluationFormContent::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EvaluationFormScoringStrategy> SCORING_STRATEGY_FIELD = SdkField
            .<EvaluationFormScoringStrategy> builder(MarshallingType.SDK_POJO).memberName("ScoringStrategy")
            .getter(getter(EvaluationFormContent::scoringStrategy)).setter(setter(Builder::scoringStrategy))
            .constructor(EvaluationFormScoringStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoringStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FORM_VERSION_FIELD,
            EVALUATION_FORM_ID_FIELD, EVALUATION_FORM_ARN_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, ITEMS_FIELD,
            SCORING_STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer evaluationFormVersion;

    private final String evaluationFormId;

    private final String evaluationFormArn;

    private final String title;

    private final String description;

    private final List<EvaluationFormItem> items;

    private final EvaluationFormScoringStrategy scoringStrategy;

    private EvaluationFormContent(BuilderImpl builder) {
        this.evaluationFormVersion = builder.evaluationFormVersion;
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormArn = builder.evaluationFormArn;
        this.title = builder.title;
        this.description = builder.description;
        this.items = builder.items;
        this.scoringStrategy = builder.scoringStrategy;
    }

    /**
     * <p>
     * A version of the evaluation form.
     * </p>
     * 
     * @return A version of the evaluation form.
     */
    public final Integer evaluationFormVersion() {
        return evaluationFormVersion;
    }

    /**
     * <p>
     * The unique identifier for the evaluation form.
     * </p>
     * 
     * @return The unique identifier for the evaluation form.
     */
    public final String evaluationFormId() {
        return evaluationFormId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the evaluation form resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the evaluation form resource.
     */
    public final String evaluationFormArn() {
        return evaluationFormArn;
    }

    /**
     * <p>
     * A unique title of the evaluation form.
     * </p>
     * 
     * @return A unique title of the evaluation form.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The description of the evaluation form.
     * </p>
     * 
     * @return The description of the evaluation form.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each.
     * Questions must be contained in a section.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Items that are part of the evaluation form. The total number of sections and questions must not exceed
     *         100 each. Questions must be contained in a section.
     */
    public final List<EvaluationFormItem> items() {
        return items;
    }

    /**
     * <p>
     * A scoring strategy of the evaluation form.
     * </p>
     * 
     * @return A scoring strategy of the evaluation form.
     */
    public final EvaluationFormScoringStrategy scoringStrategy() {
        return scoringStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormVersion());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormArn());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scoringStrategy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormContent)) {
            return false;
        }
        EvaluationFormContent other = (EvaluationFormContent) obj;
        return Objects.equals(evaluationFormVersion(), other.evaluationFormVersion())
                && Objects.equals(evaluationFormId(), other.evaluationFormId())
                && Objects.equals(evaluationFormArn(), other.evaluationFormArn()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(scoringStrategy(), other.scoringStrategy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormContent").add("EvaluationFormVersion", evaluationFormVersion())
                .add("EvaluationFormId", evaluationFormId()).add("EvaluationFormArn", evaluationFormArn()).add("Title", title())
                .add("Description", description()).add("Items", hasItems() ? items() : null)
                .add("ScoringStrategy", scoringStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationFormVersion":
            return Optional.ofNullable(clazz.cast(evaluationFormVersion()));
        case "EvaluationFormId":
            return Optional.ofNullable(clazz.cast(evaluationFormId()));
        case "EvaluationFormArn":
            return Optional.ofNullable(clazz.cast(evaluationFormArn()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "ScoringStrategy":
            return Optional.ofNullable(clazz.cast(scoringStrategy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormContent, T> g) {
        return obj -> g.apply((EvaluationFormContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormContent> {
        /**
         * <p>
         * A version of the evaluation form.
         * </p>
         * 
         * @param evaluationFormVersion
         *        A version of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormVersion(Integer evaluationFormVersion);

        /**
         * <p>
         * The unique identifier for the evaluation form.
         * </p>
         * 
         * @param evaluationFormId
         *        The unique identifier for the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormId(String evaluationFormId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the evaluation form resource.
         * </p>
         * 
         * @param evaluationFormArn
         *        The Amazon Resource Name (ARN) for the evaluation form resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormArn(String evaluationFormArn);

        /**
         * <p>
         * A unique title of the evaluation form.
         * </p>
         * 
         * @param title
         *        A unique title of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the evaluation form.
         * </p>
         * 
         * @param description
         *        The description of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100
         * each. Questions must be contained in a section.
         * </p>
         * 
         * @param items
         *        Items that are part of the evaluation form. The total number of sections and questions must not exceed
         *        100 each. Questions must be contained in a section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<EvaluationFormItem> items);

        /**
         * <p>
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100
         * each. Questions must be contained in a section.
         * </p>
         * 
         * @param items
         *        Items that are part of the evaluation form. The total number of sections and questions must not exceed
         *        100 each. Questions must be contained in a section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(EvaluationFormItem... items);

        /**
         * <p>
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100
         * each. Questions must be contained in a section.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<EvaluationFormItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<EvaluationFormItem>)
         */
        Builder items(Consumer<EvaluationFormItem.Builder>... items);

        /**
         * <p>
         * A scoring strategy of the evaluation form.
         * </p>
         * 
         * @param scoringStrategy
         *        A scoring strategy of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoringStrategy(EvaluationFormScoringStrategy scoringStrategy);

        /**
         * <p>
         * A scoring strategy of the evaluation form.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationFormScoringStrategy.Builder}
         * avoiding the need to create one manually via {@link EvaluationFormScoringStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormScoringStrategy.Builder#build()} is called
         * immediately and its result is passed to {@link #scoringStrategy(EvaluationFormScoringStrategy)}.
         * 
         * @param scoringStrategy
         *        a consumer that will call methods on {@link EvaluationFormScoringStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scoringStrategy(EvaluationFormScoringStrategy)
         */
        default Builder scoringStrategy(Consumer<EvaluationFormScoringStrategy.Builder> scoringStrategy) {
            return scoringStrategy(EvaluationFormScoringStrategy.builder().applyMutation(scoringStrategy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer evaluationFormVersion;

        private String evaluationFormId;

        private String evaluationFormArn;

        private String title;

        private String description;

        private List<EvaluationFormItem> items = DefaultSdkAutoConstructList.getInstance();

        private EvaluationFormScoringStrategy scoringStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormContent model) {
            evaluationFormVersion(model.evaluationFormVersion);
            evaluationFormId(model.evaluationFormId);
            evaluationFormArn(model.evaluationFormArn);
            title(model.title);
            description(model.description);
            items(model.items);
            scoringStrategy(model.scoringStrategy);
        }

        public final Integer getEvaluationFormVersion() {
            return evaluationFormVersion;
        }

        public final void setEvaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
        }

        @Override
        public final Builder evaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
            return this;
        }

        public final String getEvaluationFormId() {
            return evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final String getEvaluationFormArn() {
            return evaluationFormArn;
        }

        public final void setEvaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
        }

        @Override
        public final Builder evaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EvaluationFormItem.Builder> getItems() {
            List<EvaluationFormItem.Builder> result = EvaluationFormItemsListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<EvaluationFormItem.BuilderImpl> items) {
            this.items = EvaluationFormItemsListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<EvaluationFormItem> items) {
            this.items = EvaluationFormItemsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(EvaluationFormItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<EvaluationFormItem.Builder>... items) {
            items(Stream.of(items).map(c -> EvaluationFormItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EvaluationFormScoringStrategy.Builder getScoringStrategy() {
            return scoringStrategy != null ? scoringStrategy.toBuilder() : null;
        }

        public final void setScoringStrategy(EvaluationFormScoringStrategy.BuilderImpl scoringStrategy) {
            this.scoringStrategy = scoringStrategy != null ? scoringStrategy.build() : null;
        }

        @Override
        public final Builder scoringStrategy(EvaluationFormScoringStrategy scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
            return this;
        }

        @Override
        public EvaluationFormContent build() {
            return new EvaluationFormContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
