/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains credentials to use for federation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Credentials implements SdkPojo, Serializable, ToCopyableBuilder<Credentials.Builder, Credentials> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessToken").getter(getter(Credentials::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<Instant> ACCESS_TOKEN_EXPIRATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AccessTokenExpiration").getter(getter(Credentials::accessTokenExpiration))
            .setter(setter(Builder::accessTokenExpiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessTokenExpiration").build())
            .build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshToken").getter(getter(Credentials::refreshToken)).setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshToken").build()).build();

    private static final SdkField<Instant> REFRESH_TOKEN_EXPIRATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RefreshTokenExpiration").getter(getter(Credentials::refreshTokenExpiration))
            .setter(setter(Builder::refreshTokenExpiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshTokenExpiration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            ACCESS_TOKEN_EXPIRATION_FIELD, REFRESH_TOKEN_FIELD, REFRESH_TOKEN_EXPIRATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessToken;

    private final Instant accessTokenExpiration;

    private final String refreshToken;

    private final Instant refreshTokenExpiration;

    private Credentials(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.accessTokenExpiration = builder.accessTokenExpiration;
        this.refreshToken = builder.refreshToken;
        this.refreshTokenExpiration = builder.refreshTokenExpiration;
    }

    /**
     * <p>
     * An access token generated for a federated user to access Amazon Connect.
     * </p>
     * 
     * @return An access token generated for a federated user to access Amazon Connect.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * A token generated with an expiration time for the session a user is logged in to Amazon Connect.
     * </p>
     * 
     * @return A token generated with an expiration time for the session a user is logged in to Amazon Connect.
     */
    public final Instant accessTokenExpiration() {
        return accessTokenExpiration;
    }

    /**
     * <p>
     * Renews a token generated for a user to access the Amazon Connect instance.
     * </p>
     * 
     * @return Renews a token generated for a user to access the Amazon Connect instance.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * Renews the expiration timer for a generated token.
     * </p>
     * 
     * @return Renews the expiration timer for a generated token.
     */
    public final Instant refreshTokenExpiration() {
        return refreshTokenExpiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(accessTokenExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(refreshTokenExpiration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials) obj;
        return Objects.equals(accessToken(), other.accessToken())
                && Objects.equals(accessTokenExpiration(), other.accessTokenExpiration())
                && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(refreshTokenExpiration(), other.refreshTokenExpiration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Credentials")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccessTokenExpiration", accessTokenExpiration())
                .add("RefreshToken", refreshToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RefreshTokenExpiration", refreshTokenExpiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "AccessTokenExpiration":
            return Optional.ofNullable(clazz.cast(accessTokenExpiration()));
        case "RefreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "RefreshTokenExpiration":
            return Optional.ofNullable(clazz.cast(refreshTokenExpiration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Credentials, T> g) {
        return obj -> g.apply((Credentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Credentials> {
        /**
         * <p>
         * An access token generated for a federated user to access Amazon Connect.
         * </p>
         * 
         * @param accessToken
         *        An access token generated for a federated user to access Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * A token generated with an expiration time for the session a user is logged in to Amazon Connect.
         * </p>
         * 
         * @param accessTokenExpiration
         *        A token generated with an expiration time for the session a user is logged in to Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTokenExpiration(Instant accessTokenExpiration);

        /**
         * <p>
         * Renews a token generated for a user to access the Amazon Connect instance.
         * </p>
         * 
         * @param refreshToken
         *        Renews a token generated for a user to access the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * Renews the expiration timer for a generated token.
         * </p>
         * 
         * @param refreshTokenExpiration
         *        Renews the expiration timer for a generated token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshTokenExpiration(Instant refreshTokenExpiration);
    }

    static final class BuilderImpl implements Builder {
        private String accessToken;

        private Instant accessTokenExpiration;

        private String refreshToken;

        private Instant refreshTokenExpiration;

        private BuilderImpl() {
        }

        private BuilderImpl(Credentials model) {
            accessToken(model.accessToken);
            accessTokenExpiration(model.accessTokenExpiration);
            refreshToken(model.refreshToken);
            refreshTokenExpiration(model.refreshTokenExpiration);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final Instant getAccessTokenExpiration() {
            return accessTokenExpiration;
        }

        public final void setAccessTokenExpiration(Instant accessTokenExpiration) {
            this.accessTokenExpiration = accessTokenExpiration;
        }

        @Override
        public final Builder accessTokenExpiration(Instant accessTokenExpiration) {
            this.accessTokenExpiration = accessTokenExpiration;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final Instant getRefreshTokenExpiration() {
            return refreshTokenExpiration;
        }

        public final void setRefreshTokenExpiration(Instant refreshTokenExpiration) {
            this.refreshTokenExpiration = refreshTokenExpiration;
        }

        @Override
        public final Builder refreshTokenExpiration(Instant refreshTokenExpiration) {
            this.refreshTokenExpiration = refreshTokenExpiration;
            return this;
        }

        @Override
        public Credentials build() {
            return new Credentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
