/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPromptFileResponse extends ConnectResponse implements
        ToCopyableBuilder<GetPromptFileResponse.Builder, GetPromptFileResponse> {
    private static final SdkField<String> PROMPT_PRESIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PromptPresignedUrl").getter(getter(GetPromptFileResponse::promptPresignedUrl))
            .setter(setter(Builder::promptPresignedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptPresignedUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_PRESIGNED_URL_FIELD));

    private final String promptPresignedUrl;

    private GetPromptFileResponse(BuilderImpl builder) {
        super(builder);
        this.promptPresignedUrl = builder.promptPresignedUrl;
    }

    /**
     * <p>
     * A generated URL to the prompt that can be given to an unauthorized user so they can access the prompt in S3.
     * </p>
     * 
     * @return A generated URL to the prompt that can be given to an unauthorized user so they can access the prompt in
     *         S3.
     */
    public final String promptPresignedUrl() {
        return promptPresignedUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(promptPresignedUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPromptFileResponse)) {
            return false;
        }
        GetPromptFileResponse other = (GetPromptFileResponse) obj;
        return Objects.equals(promptPresignedUrl(), other.promptPresignedUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPromptFileResponse").add("PromptPresignedUrl", promptPresignedUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PromptPresignedUrl":
            return Optional.ofNullable(clazz.cast(promptPresignedUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPromptFileResponse, T> g) {
        return obj -> g.apply((GetPromptFileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPromptFileResponse> {
        /**
         * <p>
         * A generated URL to the prompt that can be given to an unauthorized user so they can access the prompt in S3.
         * </p>
         * 
         * @param promptPresignedUrl
         *        A generated URL to the prompt that can be given to an unauthorized user so they can access the prompt
         *        in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptPresignedUrl(String promptPresignedUrl);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String promptPresignedUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPromptFileResponse model) {
            super(model);
            promptPresignedUrl(model.promptPresignedUrl);
        }

        public final String getPromptPresignedUrl() {
            return promptPresignedUrl;
        }

        public final void setPromptPresignedUrl(String promptPresignedUrl) {
            this.promptPresignedUrl = promptPresignedUrl;
        }

        @Override
        public final Builder promptPresignedUrl(String promptPresignedUrl) {
            this.promptPresignedUrl = promptPresignedUrl;
            return this;
        }

        @Override
        public GetPromptFileResponse build() {
            return new GetPromptFileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
