/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsResponse;
import software.amazon.awssdk.services.connect.model.TrafficDistributionGroupSummary;

public class ListTrafficDistributionGroupsPublisher
implements SdkPublisher<ListTrafficDistributionGroupsResponse> {
    private final ConnectAsyncClient client;
    private final ListTrafficDistributionGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrafficDistributionGroupsPublisher(ConnectAsyncClient client, ListTrafficDistributionGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrafficDistributionGroupsPublisher(ConnectAsyncClient client, ListTrafficDistributionGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrafficDistributionGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrafficDistributionGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrafficDistributionGroupSummary> trafficDistributionGroupSummaryList() {
        Function<ListTrafficDistributionGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficDistributionGroupSummaryList() != null) {
                return response.trafficDistributionGroupSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrafficDistributionGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrafficDistributionGroupsResponseFetcher
    implements AsyncPageFetcher<ListTrafficDistributionGroupsResponse> {
        private ListTrafficDistributionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrafficDistributionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrafficDistributionGroupsResponse> nextPage(ListTrafficDistributionGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListTrafficDistributionGroupsPublisher.this.client.listTrafficDistributionGroups(ListTrafficDistributionGroupsPublisher.this.firstRequest);
            }
            return ListTrafficDistributionGroupsPublisher.this.client.listTrafficDistributionGroups((ListTrafficDistributionGroupsRequest)((Object)ListTrafficDistributionGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

