/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a prompt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Prompt implements SdkPojo, Serializable, ToCopyableBuilder<Prompt.Builder, Prompt> {
    private static final SdkField<String> PROMPT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PromptARN").getter(getter(Prompt::promptARN)).setter(setter(Builder::promptARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptARN").build()).build();

    private static final SdkField<String> PROMPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PromptId").getter(getter(Prompt::promptId)).setter(setter(Builder::promptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Prompt::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Prompt::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Prompt::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(Prompt::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(Prompt::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_ARN_FIELD,
            PROMPT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String promptARN;

    private final String promptId;

    private final String name;

    private final String description;

    private final Map<String, String> tags;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private Prompt(BuilderImpl builder) {
        this.promptARN = builder.promptARN;
        this.promptId = builder.promptId;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the prompt.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the prompt.
     */
    public final String promptARN() {
        return promptARN;
    }

    /**
     * <p>
     * A unique identifier for the prompt.
     * </p>
     * 
     * @return A unique identifier for the prompt.
     */
    public final String promptId() {
        return promptId;
    }

    /**
     * <p>
     * The name of the prompt.
     * </p>
     * 
     * @return The name of the prompt.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the prompt.
     * </p>
     * 
     * @return The description of the prompt.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The timestamp when this resource was last modified.
     * </p>
     * 
     * @return The timestamp when this resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Web Services Region where this resource was last modified.
     * </p>
     * 
     * @return The Amazon Web Services Region where this resource was last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(promptARN());
        hashCode = 31 * hashCode + Objects.hashCode(promptId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prompt)) {
            return false;
        }
        Prompt other = (Prompt) obj;
        return Objects.equals(promptARN(), other.promptARN()) && Objects.equals(promptId(), other.promptId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Prompt").add("PromptARN", promptARN()).add("PromptId", promptId()).add("Name", name())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null)
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedRegion", lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PromptARN":
            return Optional.ofNullable(clazz.cast(promptARN()));
        case "PromptId":
            return Optional.ofNullable(clazz.cast(promptId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Prompt, T> g) {
        return obj -> g.apply((Prompt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Prompt> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the prompt.
         * </p>
         * 
         * @param promptARN
         *        The Amazon Resource Name (ARN) of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptARN(String promptARN);

        /**
         * <p>
         * A unique identifier for the prompt.
         * </p>
         * 
         * @param promptId
         *        A unique identifier for the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptId(String promptId);

        /**
         * <p>
         * The name of the prompt.
         * </p>
         * 
         * @param name
         *        The name of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the prompt.
         * </p>
         * 
         * @param description
         *        The description of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The timestamp when this resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Web Services Region where this resource was last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The Amazon Web Services Region where this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);
    }

    static final class BuilderImpl implements Builder {
        private String promptARN;

        private String promptId;

        private String name;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Prompt model) {
            promptARN(model.promptARN);
            promptId(model.promptId);
            name(model.name);
            description(model.description);
            tags(model.tags);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getPromptARN() {
            return promptARN;
        }

        public final void setPromptARN(String promptARN) {
            this.promptARN = promptARN;
        }

        @Override
        public final Builder promptARN(String promptARN) {
            this.promptARN = promptARN;
            return this;
        }

        public final String getPromptId() {
            return promptId;
        }

        public final void setPromptId(String promptId) {
            this.promptId = promptId;
        }

        @Override
        public final Builder promptId(String promptId) {
            this.promptId = promptId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public Prompt build() {
            return new Prompt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
