/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This API is in preview release for Amazon Connect and is subject to change.
 * </p>
 * <p>
 * A third party application's metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Application implements SdkPojo, Serializable, ToCopyableBuilder<Application.Builder, Application> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(Application::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<List<String>> APPLICATION_PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApplicationPermissions")
            .getter(getter(Application::applicationPermissions))
            .setter(setter(Builder::applicationPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD,
            APPLICATION_PERMISSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private final List<String> applicationPermissions;

    private Application(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.applicationPermissions = builder.applicationPermissions;
    }

    /**
     * <p>
     * Namespace of the application that you want to give access to.
     * </p>
     * 
     * @return Namespace of the application that you want to give access to.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationPermissions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApplicationPermissions() {
        return applicationPermissions != null && !(applicationPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions that the agent is granted on the application. Only the <code>ACCESS</code> permission is
     * supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationPermissions} method.
     * </p>
     * 
     * @return The permissions that the agent is granted on the application. Only the <code>ACCESS</code> permission is
     *         supported.
     */
    public final List<String> applicationPermissions() {
        return applicationPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationPermissions() ? applicationPermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application) obj;
        return Objects.equals(namespace(), other.namespace()) && hasApplicationPermissions() == other.hasApplicationPermissions()
                && Objects.equals(applicationPermissions(), other.applicationPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Application").add("Namespace", namespace())
                .add("ApplicationPermissions", hasApplicationPermissions() ? applicationPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "ApplicationPermissions":
            return Optional.ofNullable(clazz.cast(applicationPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Application, T> g) {
        return obj -> g.apply((Application) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Application> {
        /**
         * <p>
         * Namespace of the application that you want to give access to.
         * </p>
         * 
         * @param namespace
         *        Namespace of the application that you want to give access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The permissions that the agent is granted on the application. Only the <code>ACCESS</code> permission is
         * supported.
         * </p>
         * 
         * @param applicationPermissions
         *        The permissions that the agent is granted on the application. Only the <code>ACCESS</code> permission
         *        is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationPermissions(Collection<String> applicationPermissions);

        /**
         * <p>
         * The permissions that the agent is granted on the application. Only the <code>ACCESS</code> permission is
         * supported.
         * </p>
         * 
         * @param applicationPermissions
         *        The permissions that the agent is granted on the application. Only the <code>ACCESS</code> permission
         *        is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationPermissions(String... applicationPermissions);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private List<String> applicationPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            namespace(model.namespace);
            applicationPermissions(model.applicationPermissions);
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Collection<String> getApplicationPermissions() {
            if (applicationPermissions instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationPermissions;
        }

        public final void setApplicationPermissions(Collection<String> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionsCopier.copy(applicationPermissions);
        }

        @Override
        public final Builder applicationPermissions(Collection<String> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionsCopier.copy(applicationPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationPermissions(String... applicationPermissions) {
            applicationPermissions(Arrays.asList(applicationPermissions));
            return this;
        }

        @Override
        public Application build() {
            return new Application(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
