/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines searchable contact attributes which can be used to filter search results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchableContactAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchableContactAttributes.Builder, SearchableContactAttributes> {
    private static final SdkField<List<SearchableContactAttributesCriteria>> CRITERIA_FIELD = SdkField
            .<List<SearchableContactAttributesCriteria>> builder(MarshallingType.LIST)
            .memberName("Criteria")
            .getter(getter(SearchableContactAttributes::criteria))
            .setter(setter(Builder::criteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchableContactAttributesCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchableContactAttributesCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchType").getter(getter(SearchableContactAttributes::matchTypeAsString))
            .setter(setter(Builder::matchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERIA_FIELD,
            MATCH_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SearchableContactAttributesCriteria> criteria;

    private final String matchType;

    private SearchableContactAttributes(BuilderImpl builder) {
        this.criteria = builder.criteria;
        this.matchType = builder.matchType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Criteria property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCriteria() {
        return criteria != null && !(criteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of searhale contact attribute criteria
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCriteria} method.
     * </p>
     * 
     * @return The array of searhale contact attribute criteria
     */
    public final List<SearchableContactAttributesCriteria> criteria() {
        return criteria;
    }

    /**
     * <p>
     * The match type of multiple searchable contact attributes criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link SearchContactsMatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchTypeAsString}.
     * </p>
     * 
     * @return The match type of multiple searchable contact attributes criteria.
     * @see SearchContactsMatchType
     */
    public final SearchContactsMatchType matchType() {
        return SearchContactsMatchType.fromValue(matchType);
    }

    /**
     * <p>
     * The match type of multiple searchable contact attributes criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link SearchContactsMatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchTypeAsString}.
     * </p>
     * 
     * @return The match type of multiple searchable contact attributes criteria.
     * @see SearchContactsMatchType
     */
    public final String matchTypeAsString() {
        return matchType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCriteria() ? criteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(matchTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchableContactAttributes)) {
            return false;
        }
        SearchableContactAttributes other = (SearchableContactAttributes) obj;
        return hasCriteria() == other.hasCriteria() && Objects.equals(criteria(), other.criteria())
                && Objects.equals(matchTypeAsString(), other.matchTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchableContactAttributes").add("Criteria", hasCriteria() ? criteria() : null)
                .add("MatchType", matchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Criteria":
            return Optional.ofNullable(clazz.cast(criteria()));
        case "MatchType":
            return Optional.ofNullable(clazz.cast(matchTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchableContactAttributes, T> g) {
        return obj -> g.apply((SearchableContactAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchableContactAttributes> {
        /**
         * <p>
         * The array of searhale contact attribute criteria
         * </p>
         * 
         * @param criteria
         *        The array of searhale contact attribute criteria
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(Collection<SearchableContactAttributesCriteria> criteria);

        /**
         * <p>
         * The array of searhale contact attribute criteria
         * </p>
         * 
         * @param criteria
         *        The array of searhale contact attribute criteria
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(SearchableContactAttributesCriteria... criteria);

        /**
         * <p>
         * The array of searhale contact attribute criteria
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.SearchableContactAttributesCriteria.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.SearchableContactAttributesCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.SearchableContactAttributesCriteria.Builder#build()} is
         * called immediately and its result is passed to {@link #criteria(List<SearchableContactAttributesCriteria>)}.
         * 
         * @param criteria
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.SearchableContactAttributesCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criteria(java.util.Collection<SearchableContactAttributesCriteria>)
         */
        Builder criteria(Consumer<SearchableContactAttributesCriteria.Builder>... criteria);

        /**
         * <p>
         * The match type of multiple searchable contact attributes criteria.
         * </p>
         * 
         * @param matchType
         *        The match type of multiple searchable contact attributes criteria.
         * @see SearchContactsMatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchContactsMatchType
         */
        Builder matchType(String matchType);

        /**
         * <p>
         * The match type of multiple searchable contact attributes criteria.
         * </p>
         * 
         * @param matchType
         *        The match type of multiple searchable contact attributes criteria.
         * @see SearchContactsMatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchContactsMatchType
         */
        Builder matchType(SearchContactsMatchType matchType);
    }

    static final class BuilderImpl implements Builder {
        private List<SearchableContactAttributesCriteria> criteria = DefaultSdkAutoConstructList.getInstance();

        private String matchType;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchableContactAttributes model) {
            criteria(model.criteria);
            matchType(model.matchType);
        }

        public final List<SearchableContactAttributesCriteria.Builder> getCriteria() {
            List<SearchableContactAttributesCriteria.Builder> result = SearchableContactAttributesCriteriaListCopier
                    .copyToBuilder(this.criteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCriteria(Collection<SearchableContactAttributesCriteria.BuilderImpl> criteria) {
            this.criteria = SearchableContactAttributesCriteriaListCopier.copyFromBuilder(criteria);
        }

        @Override
        public final Builder criteria(Collection<SearchableContactAttributesCriteria> criteria) {
            this.criteria = SearchableContactAttributesCriteriaListCopier.copy(criteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criteria(SearchableContactAttributesCriteria... criteria) {
            criteria(Arrays.asList(criteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criteria(Consumer<SearchableContactAttributesCriteria.Builder>... criteria) {
            criteria(Stream.of(criteria).map(c -> SearchableContactAttributesCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMatchType() {
            return matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(SearchContactsMatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        @Override
        public SearchableContactAttributes build() {
            return new SearchableContactAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
