/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines the sort by and a sort order
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Sort implements SdkPojo, Serializable, ToCopyableBuilder<Sort.Builder, Sort> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(Sort::fieldNameAsString)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Order")
            .getter(getter(Sort::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String order;

    private Sort(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.order = builder.order;
    }

    /**
     * <p>
     * The name of the field on which to sort.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldName} will
     * return {@link SortableFieldName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldNameAsString}.
     * </p>
     * 
     * @return The name of the field on which to sort.
     * @see SortableFieldName
     */
    public final SortableFieldName fieldName() {
        return SortableFieldName.fromValue(fieldName);
    }

    /**
     * <p>
     * The name of the field on which to sort.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldName} will
     * return {@link SortableFieldName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldNameAsString}.
     * </p>
     * 
     * @return The name of the field on which to sort.
     * @see SortableFieldName
     */
    public final String fieldNameAsString() {
        return fieldName;
    }

    /**
     * <p>
     * An ascending or descending sort.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return An ascending or descending sort.
     * @see SortOrder
     */
    public final SortOrder order() {
        return SortOrder.fromValue(order);
    }

    /**
     * <p>
     * An ascending or descending sort.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return An ascending or descending sort.
     * @see SortOrder
     */
    public final String orderAsString() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort other = (Sort) obj;
        return Objects.equals(fieldNameAsString(), other.fieldNameAsString())
                && Objects.equals(orderAsString(), other.orderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Sort").add("FieldName", fieldNameAsString()).add("Order", orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldNameAsString()));
        case "Order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Sort, T> g) {
        return obj -> g.apply((Sort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Sort> {
        /**
         * <p>
         * The name of the field on which to sort.
         * </p>
         * 
         * @param fieldName
         *        The name of the field on which to sort.
         * @see SortableFieldName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortableFieldName
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The name of the field on which to sort.
         * </p>
         * 
         * @param fieldName
         *        The name of the field on which to sort.
         * @see SortableFieldName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortableFieldName
         */
        Builder fieldName(SortableFieldName fieldName);

        /**
         * <p>
         * An ascending or descending sort.
         * </p>
         * 
         * @param order
         *        An ascending or descending sort.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder order(String order);

        /**
         * <p>
         * An ascending or descending sort.
         * </p>
         * 
         * @param order
         *        An ascending or descending sort.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder order(SortOrder order);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(Sort model) {
            fieldName(model.fieldName);
            order(model.order);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public final Builder fieldName(SortableFieldName fieldName) {
            this.fieldName(fieldName == null ? null : fieldName.toString());
            return this;
        }

        public final String getOrder() {
            return order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(SortOrder order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        @Override
        public Sort build() {
            return new Sort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
