/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePersistentContactAssociationRequest extends ConnectRequest implements
        ToCopyableBuilder<CreatePersistentContactAssociationRequest.Builder, CreatePersistentContactAssociationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreatePersistentContactAssociationRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialContactId").getter(getter(CreatePersistentContactAssociationRequest::initialContactId))
            .setter(setter(Builder::initialContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InitialContactId").build()).build();

    private static final SdkField<String> REHYDRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RehydrationType").getter(getter(CreatePersistentContactAssociationRequest::rehydrationTypeAsString))
            .setter(setter(Builder::rehydrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RehydrationType").build()).build();

    private static final SdkField<String> SOURCE_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceContactId").getter(getter(CreatePersistentContactAssociationRequest::sourceContactId))
            .setter(setter(Builder::sourceContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceContactId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreatePersistentContactAssociationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INITIAL_CONTACT_ID_FIELD, REHYDRATION_TYPE_FIELD, SOURCE_CONTACT_ID_FIELD, CLIENT_TOKEN_FIELD));

    private final String instanceId;

    private final String initialContactId;

    private final String rehydrationType;

    private final String sourceContactId;

    private final String clientToken;

    private CreatePersistentContactAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.initialContactId = builder.initialContactId;
        this.rehydrationType = builder.rehydrationType;
        this.sourceContactId = builder.sourceContactId;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * This is the contactId of the current contact that the <code>CreatePersistentContactAssociation</code> API is
     * being called from.
     * </p>
     * 
     * @return This is the contactId of the current contact that the <code>CreatePersistentContactAssociation</code> API
     *         is being called from.
     */
    public final String initialContactId() {
        return initialContactId;
    }

    /**
     * <p>
     * The contactId chosen for rehydration depends on the type chosen.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact of the
     * specified past ended chat session. To use this type, provide the <code>initialContactId</code> of the past ended
     * chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect determines what the most
     * recent chat contact on the past ended chat session and uses it to start a persistent chat.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FROM_SEGMENT</code>: Rehydrates a chat from the specified past chat contact provided in the
     * <code>sourceContactId</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The actual contactId used for rehydration is provided in the response of this API.
     * </p>
     * <p>
     * To illustrate how to use rehydration type, consider the following example: A customer starts a chat session.
     * Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This first contact creates
     * a contact ID <b>C1</b>. Agent a1 then transfers the chat to Agent a2. This creates another contact ID <b>C2</b>.
     * At this point Agent a2 ends the chat. The customer is forwarded to the disconnect flow for a post chat survey
     * that creates another contact ID <b>C3</b>. After the chat survey, the chat session ends. Later, the customer
     * returns and wants to resume their past chat session. At this point, the customer can have following use cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Use Case 1</b>: The customer wants to continue the past chat session but they want to hide the post chat
     * survey. For this they will use the following configuration:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Configuration</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * SourceContactId = "C2"
     * </p>
     * </li>
     * <li>
     * <p>
     * RehydrationType = "FROM_SEGMENT"
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Expected behavior</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past chat
     * sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment C3 is dropped
     * from the persistent chat session.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Use Case 2</b>: The customer wants to continue the past chat session and see the transcript of the entire past
     * engagement, including the post chat survey. For this they will use the following configuration:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Configuration</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * SourceContactId = "C1"
     * </p>
     * </li>
     * <li>
     * <p>
     * RehydrationType = "ENTIRE_PAST_SESSION"
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Expected behavior</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of past chat
     * sessions C3, C2 and C1 are accessible in the current persistent chat session.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rehydrationType}
     * will return {@link RehydrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rehydrationTypeAsString}.
     * </p>
     * 
     * @return The contactId chosen for rehydration depends on the type chosen.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact
     *         of the specified past ended chat session. To use this type, provide the <code>initialContactId</code> of
     *         the past ended chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect
     *         determines what the most recent chat contact on the past ended chat session and uses it to start a
     *         persistent chat.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FROM_SEGMENT</code>: Rehydrates a chat from the specified past chat contact provided in the
     *         <code>sourceContactId</code> field.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The actual contactId used for rehydration is provided in the response of this API.
     *         </p>
     *         <p>
     *         To illustrate how to use rehydration type, consider the following example: A customer starts a chat
     *         session. Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This
     *         first contact creates a contact ID <b>C1</b>. Agent a1 then transfers the chat to Agent a2. This creates
     *         another contact ID <b>C2</b>. At this point Agent a2 ends the chat. The customer is forwarded to the
     *         disconnect flow for a post chat survey that creates another contact ID <b>C3</b>. After the chat survey,
     *         the chat session ends. Later, the customer returns and wants to resume their past chat session. At this
     *         point, the customer can have following use cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Use Case 1</b>: The customer wants to continue the past chat session but they want to hide the post
     *         chat survey. For this they will use the following configuration:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Configuration</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SourceContactId = "C2"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RehydrationType = "FROM_SEGMENT"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Expected behavior</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past
     *         chat sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment C3
     *         is dropped from the persistent chat session.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Use Case 2</b>: The customer wants to continue the past chat session and see the transcript of the
     *         entire past engagement, including the post chat survey. For this they will use the following
     *         configuration:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Configuration</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SourceContactId = "C1"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RehydrationType = "ENTIRE_PAST_SESSION"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Expected behavior</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of past
     *         chat sessions C3, C2 and C1 are accessible in the current persistent chat session.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see RehydrationType
     */
    public final RehydrationType rehydrationType() {
        return RehydrationType.fromValue(rehydrationType);
    }

    /**
     * <p>
     * The contactId chosen for rehydration depends on the type chosen.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact of the
     * specified past ended chat session. To use this type, provide the <code>initialContactId</code> of the past ended
     * chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect determines what the most
     * recent chat contact on the past ended chat session and uses it to start a persistent chat.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FROM_SEGMENT</code>: Rehydrates a chat from the specified past chat contact provided in the
     * <code>sourceContactId</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The actual contactId used for rehydration is provided in the response of this API.
     * </p>
     * <p>
     * To illustrate how to use rehydration type, consider the following example: A customer starts a chat session.
     * Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This first contact creates
     * a contact ID <b>C1</b>. Agent a1 then transfers the chat to Agent a2. This creates another contact ID <b>C2</b>.
     * At this point Agent a2 ends the chat. The customer is forwarded to the disconnect flow for a post chat survey
     * that creates another contact ID <b>C3</b>. After the chat survey, the chat session ends. Later, the customer
     * returns and wants to resume their past chat session. At this point, the customer can have following use cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Use Case 1</b>: The customer wants to continue the past chat session but they want to hide the post chat
     * survey. For this they will use the following configuration:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Configuration</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * SourceContactId = "C2"
     * </p>
     * </li>
     * <li>
     * <p>
     * RehydrationType = "FROM_SEGMENT"
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Expected behavior</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past chat
     * sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment C3 is dropped
     * from the persistent chat session.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Use Case 2</b>: The customer wants to continue the past chat session and see the transcript of the entire past
     * engagement, including the post chat survey. For this they will use the following configuration:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Configuration</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * SourceContactId = "C1"
     * </p>
     * </li>
     * <li>
     * <p>
     * RehydrationType = "ENTIRE_PAST_SESSION"
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Expected behavior</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of past chat
     * sessions C3, C2 and C1 are accessible in the current persistent chat session.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rehydrationType}
     * will return {@link RehydrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rehydrationTypeAsString}.
     * </p>
     * 
     * @return The contactId chosen for rehydration depends on the type chosen.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact
     *         of the specified past ended chat session. To use this type, provide the <code>initialContactId</code> of
     *         the past ended chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect
     *         determines what the most recent chat contact on the past ended chat session and uses it to start a
     *         persistent chat.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FROM_SEGMENT</code>: Rehydrates a chat from the specified past chat contact provided in the
     *         <code>sourceContactId</code> field.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The actual contactId used for rehydration is provided in the response of this API.
     *         </p>
     *         <p>
     *         To illustrate how to use rehydration type, consider the following example: A customer starts a chat
     *         session. Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This
     *         first contact creates a contact ID <b>C1</b>. Agent a1 then transfers the chat to Agent a2. This creates
     *         another contact ID <b>C2</b>. At this point Agent a2 ends the chat. The customer is forwarded to the
     *         disconnect flow for a post chat survey that creates another contact ID <b>C3</b>. After the chat survey,
     *         the chat session ends. Later, the customer returns and wants to resume their past chat session. At this
     *         point, the customer can have following use cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Use Case 1</b>: The customer wants to continue the past chat session but they want to hide the post
     *         chat survey. For this they will use the following configuration:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Configuration</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SourceContactId = "C2"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RehydrationType = "FROM_SEGMENT"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Expected behavior</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past
     *         chat sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment C3
     *         is dropped from the persistent chat session.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Use Case 2</b>: The customer wants to continue the past chat session and see the transcript of the
     *         entire past engagement, including the post chat survey. For this they will use the following
     *         configuration:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Configuration</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SourceContactId = "C1"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RehydrationType = "ENTIRE_PAST_SESSION"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Expected behavior</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of past
     *         chat sessions C3, C2 and C1 are accessible in the current persistent chat session.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see RehydrationType
     */
    public final String rehydrationTypeAsString() {
        return rehydrationType;
    }

    /**
     * <p>
     * The contactId from which a persistent chat session must be started.
     * </p>
     * 
     * @return The contactId from which a persistent chat session must be started.
     */
    public final String sourceContactId() {
        return sourceContactId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(rehydrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceContactId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePersistentContactAssociationRequest)) {
            return false;
        }
        CreatePersistentContactAssociationRequest other = (CreatePersistentContactAssociationRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(initialContactId(), other.initialContactId())
                && Objects.equals(rehydrationTypeAsString(), other.rehydrationTypeAsString())
                && Objects.equals(sourceContactId(), other.sourceContactId())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePersistentContactAssociationRequest").add("InstanceId", instanceId())
                .add("InitialContactId", initialContactId()).add("RehydrationType", rehydrationTypeAsString())
                .add("SourceContactId", sourceContactId()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InitialContactId":
            return Optional.ofNullable(clazz.cast(initialContactId()));
        case "RehydrationType":
            return Optional.ofNullable(clazz.cast(rehydrationTypeAsString()));
        case "SourceContactId":
            return Optional.ofNullable(clazz.cast(sourceContactId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePersistentContactAssociationRequest, T> g) {
        return obj -> g.apply((CreatePersistentContactAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePersistentContactAssociationRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * This is the contactId of the current contact that the <code>CreatePersistentContactAssociation</code> API is
         * being called from.
         * </p>
         * 
         * @param initialContactId
         *        This is the contactId of the current contact that the <code>CreatePersistentContactAssociation</code>
         *        API is being called from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialContactId(String initialContactId);

        /**
         * <p>
         * The contactId chosen for rehydration depends on the type chosen.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact of
         * the specified past ended chat session. To use this type, provide the <code>initialContactId</code> of the
         * past ended chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect determines
         * what the most recent chat contact on the past ended chat session and uses it to start a persistent chat.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FROM_SEGMENT</code>: Rehydrates a chat from the specified past chat contact provided in the
         * <code>sourceContactId</code> field.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The actual contactId used for rehydration is provided in the response of this API.
         * </p>
         * <p>
         * To illustrate how to use rehydration type, consider the following example: A customer starts a chat session.
         * Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This first contact
         * creates a contact ID <b>C1</b>. Agent a1 then transfers the chat to Agent a2. This creates another contact ID
         * <b>C2</b>. At this point Agent a2 ends the chat. The customer is forwarded to the disconnect flow for a post
         * chat survey that creates another contact ID <b>C3</b>. After the chat survey, the chat session ends. Later,
         * the customer returns and wants to resume their past chat session. At this point, the customer can have
         * following use cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Use Case 1</b>: The customer wants to continue the past chat session but they want to hide the post chat
         * survey. For this they will use the following configuration:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Configuration</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * SourceContactId = "C2"
         * </p>
         * </li>
         * <li>
         * <p>
         * RehydrationType = "FROM_SEGMENT"
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Expected behavior</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past chat
         * sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment C3 is
         * dropped from the persistent chat session.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Use Case 2</b>: The customer wants to continue the past chat session and see the transcript of the entire
         * past engagement, including the post chat survey. For this they will use the following configuration:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Configuration</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * SourceContactId = "C1"
         * </p>
         * </li>
         * <li>
         * <p>
         * RehydrationType = "ENTIRE_PAST_SESSION"
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Expected behavior</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of past
         * chat sessions C3, C2 and C1 are accessible in the current persistent chat session.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param rehydrationType
         *        The contactId chosen for rehydration depends on the type chosen.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat
         *        contact of the specified past ended chat session. To use this type, provide the
         *        <code>initialContactId</code> of the past ended chat session in the <code>sourceContactId</code>
         *        field. In this type, Amazon Connect determines what the most recent chat contact on the past ended
         *        chat session and uses it to start a persistent chat.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FROM_SEGMENT</code>: Rehydrates a chat from the specified past chat contact provided in the
         *        <code>sourceContactId</code> field.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The actual contactId used for rehydration is provided in the response of this API.
         *        </p>
         *        <p>
         *        To illustrate how to use rehydration type, consider the following example: A customer starts a chat
         *        session. Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This
         *        first contact creates a contact ID <b>C1</b>. Agent a1 then transfers the chat to Agent a2. This
         *        creates another contact ID <b>C2</b>. At this point Agent a2 ends the chat. The customer is forwarded
         *        to the disconnect flow for a post chat survey that creates another contact ID <b>C3</b>. After the
         *        chat survey, the chat session ends. Later, the customer returns and wants to resume their past chat
         *        session. At this point, the customer can have following use cases:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Use Case 1</b>: The customer wants to continue the past chat session but they want to hide the post
         *        chat survey. For this they will use the following configuration:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Configuration</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SourceContactId = "C2"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RehydrationType = "FROM_SEGMENT"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Expected behavior</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past
         *        chat sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment
         *        C3 is dropped from the persistent chat session.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Use Case 2</b>: The customer wants to continue the past chat session and see the transcript of the
         *        entire past engagement, including the post chat survey. For this they will use the following
         *        configuration:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Configuration</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SourceContactId = "C1"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RehydrationType = "ENTIRE_PAST_SESSION"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Expected behavior</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of
         *        past chat sessions C3, C2 and C1 are accessible in the current persistent chat session.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see RehydrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RehydrationType
         */
        Builder rehydrationType(String rehydrationType);

        /**
         * <p>
         * The contactId chosen for rehydration depends on the type chosen.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact of
         * the specified past ended chat session. To use this type, provide the <code>initialContactId</code> of the
         * past ended chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect determines
         * what the most recent chat contact on the past ended chat session and uses it to start a persistent chat.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FROM_SEGMENT</code>: Rehydrates a chat from the specified past chat contact provided in the
         * <code>sourceContactId</code> field.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The actual contactId used for rehydration is provided in the response of this API.
         * </p>
         * <p>
         * To illustrate how to use rehydration type, consider the following example: A customer starts a chat session.
         * Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This first contact
         * creates a contact ID <b>C1</b>. Agent a1 then transfers the chat to Agent a2. This creates another contact ID
         * <b>C2</b>. At this point Agent a2 ends the chat. The customer is forwarded to the disconnect flow for a post
         * chat survey that creates another contact ID <b>C3</b>. After the chat survey, the chat session ends. Later,
         * the customer returns and wants to resume their past chat session. At this point, the customer can have
         * following use cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Use Case 1</b>: The customer wants to continue the past chat session but they want to hide the post chat
         * survey. For this they will use the following configuration:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Configuration</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * SourceContactId = "C2"
         * </p>
         * </li>
         * <li>
         * <p>
         * RehydrationType = "FROM_SEGMENT"
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Expected behavior</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past chat
         * sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment C3 is
         * dropped from the persistent chat session.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Use Case 2</b>: The customer wants to continue the past chat session and see the transcript of the entire
         * past engagement, including the post chat survey. For this they will use the following configuration:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Configuration</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * SourceContactId = "C1"
         * </p>
         * </li>
         * <li>
         * <p>
         * RehydrationType = "ENTIRE_PAST_SESSION"
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Expected behavior</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of past
         * chat sessions C3, C2 and C1 are accessible in the current persistent chat session.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param rehydrationType
         *        The contactId chosen for rehydration depends on the type chosen.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat
         *        contact of the specified past ended chat session. To use this type, provide the
         *        <code>initialContactId</code> of the past ended chat session in the <code>sourceContactId</code>
         *        field. In this type, Amazon Connect determines what the most recent chat contact on the past ended
         *        chat session and uses it to start a persistent chat.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FROM_SEGMENT</code>: Rehydrates a chat from the specified past chat contact provided in the
         *        <code>sourceContactId</code> field.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The actual contactId used for rehydration is provided in the response of this API.
         *        </p>
         *        <p>
         *        To illustrate how to use rehydration type, consider the following example: A customer starts a chat
         *        session. Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This
         *        first contact creates a contact ID <b>C1</b>. Agent a1 then transfers the chat to Agent a2. This
         *        creates another contact ID <b>C2</b>. At this point Agent a2 ends the chat. The customer is forwarded
         *        to the disconnect flow for a post chat survey that creates another contact ID <b>C3</b>. After the
         *        chat survey, the chat session ends. Later, the customer returns and wants to resume their past chat
         *        session. At this point, the customer can have following use cases:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Use Case 1</b>: The customer wants to continue the past chat session but they want to hide the post
         *        chat survey. For this they will use the following configuration:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Configuration</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SourceContactId = "C2"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RehydrationType = "FROM_SEGMENT"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Expected behavior</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past
         *        chat sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment
         *        C3 is dropped from the persistent chat session.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Use Case 2</b>: The customer wants to continue the past chat session and see the transcript of the
         *        entire past engagement, including the post chat survey. For this they will use the following
         *        configuration:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Configuration</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SourceContactId = "C1"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RehydrationType = "ENTIRE_PAST_SESSION"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Expected behavior</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of
         *        past chat sessions C3, C2 and C1 are accessible in the current persistent chat session.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see RehydrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RehydrationType
         */
        Builder rehydrationType(RehydrationType rehydrationType);

        /**
         * <p>
         * The contactId from which a persistent chat session must be started.
         * </p>
         * 
         * @param sourceContactId
         *        The contactId from which a persistent chat session must be started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceContactId(String sourceContactId);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String initialContactId;

        private String rehydrationType;

        private String sourceContactId;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePersistentContactAssociationRequest model) {
            super(model);
            instanceId(model.instanceId);
            initialContactId(model.initialContactId);
            rehydrationType(model.rehydrationType);
            sourceContactId(model.sourceContactId);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInitialContactId() {
            return initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getRehydrationType() {
            return rehydrationType;
        }

        public final void setRehydrationType(String rehydrationType) {
            this.rehydrationType = rehydrationType;
        }

        @Override
        public final Builder rehydrationType(String rehydrationType) {
            this.rehydrationType = rehydrationType;
            return this;
        }

        @Override
        public final Builder rehydrationType(RehydrationType rehydrationType) {
            this.rehydrationType(rehydrationType == null ? null : rehydrationType.toString());
            return this;
        }

        public final String getSourceContactId() {
            return sourceContactId;
        }

        public final void setSourceContactId(String sourceContactId) {
            this.sourceContactId = sourceContactId;
        }

        @Override
        public final Builder sourceContactId(String sourceContactId) {
            this.sourceContactId = sourceContactId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePersistentContactAssociationRequest build() {
            return new CreatePersistentContactAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
